/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.algorithm;

import com.vividsolutions.jts.algorithm.CGAlgorithms;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.Polygon;

public class CentroidArea {
    private Coordinate basePt = null;
    private Coordinate triangleCent3 = new Coordinate();
    private double areasum2 = 0.0;
    private Coordinate cg3 = new Coordinate();

    public void add(Geometry geom) {
        if (geom instanceof Polygon) {
            Polygon poly = (Polygon)geom;
            this.setBasePoint(poly.getExteriorRing().getCoordinateN(0));
            this.add(poly);
        } else if (geom instanceof GeometryCollection) {
            GeometryCollection gc = (GeometryCollection)geom;
            for (int i = 0; i < gc.getNumGeometries(); ++i) {
                this.add(gc.getGeometryN(i));
            }
        }
    }

    public void add(Coordinate[] ring) {
        this.setBasePoint(ring[0]);
        this.addShell(ring);
    }

    public Coordinate getCentroid() {
        Coordinate cent = new Coordinate();
        cent.x = this.cg3.x / 3.0 / this.areasum2;
        cent.y = this.cg3.y / 3.0 / this.areasum2;
        return cent;
    }

    private void setBasePoint(Coordinate basePt) {
        if (this.basePt == null) {
            this.basePt = basePt;
        }
    }

    private void add(Polygon poly) {
        this.addShell(poly.getExteriorRing().getCoordinates());
        for (int i = 0; i < poly.getNumInteriorRing(); ++i) {
            this.addHole(poly.getInteriorRingN(i).getCoordinates());
        }
    }

    private void addShell(Coordinate[] pts) {
        boolean isPositiveArea = !CGAlgorithms.isCCW(pts);
        for (int i = 0; i < pts.length - 1; ++i) {
            this.addTriangle(this.basePt, pts[i], pts[i + 1], isPositiveArea);
        }
    }

    private void addHole(Coordinate[] pts) {
        boolean isPositiveArea = CGAlgorithms.isCCW(pts);
        for (int i = 0; i < pts.length - 1; ++i) {
            this.addTriangle(this.basePt, pts[i], pts[i + 1], isPositiveArea);
        }
    }

    private void addTriangle(Coordinate p0, Coordinate p1, Coordinate p2, boolean isPositiveArea) {
        double sign = isPositiveArea ? 1.0 : -1.0;
        CentroidArea.centroid3(p0, p1, p2, this.triangleCent3);
        double area2 = CentroidArea.area2(p0, p1, p2);
        this.cg3.x += sign * area2 * this.triangleCent3.x;
        this.cg3.y += sign * area2 * this.triangleCent3.y;
        this.areasum2 += sign * area2;
    }

    private static void centroid3(Coordinate p1, Coordinate p2, Coordinate p3, Coordinate c) {
        c.x = p1.x + p2.x + p3.x;
        c.y = p1.y + p2.y + p3.y;
    }

    private static double area2(Coordinate p1, Coordinate p2, Coordinate p3) {
        return (p2.x - p1.x) * (p3.y - p1.y) - (p3.x - p1.x) * (p2.y - p1.y);
    }
}

