% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format_binance_withdrawals.R
\name{format_binance_withdrawals}
\alias{format_binance_withdrawals}
\title{Format Binance withdrawal file}
\usage{
format_binance_withdrawals(data, list.prices = NULL, force = FALSE)
}
\arguments{
\item{data}{The dataframe}

\item{list.prices}{A \code{list.prices} object from which to fetch coin prices.}

\item{force}{Whether to force recreating \code{list.prices} even though
it already exists (e.g., if you added new coins or new dates).}
}
\value{
A data frame of exchange transactions, formatted for further processing.
}
\description{
Format a .xlsx withdrawal history file from Binance for later
ACB processing.
}
\details{
To get this file, connect to your Binance account on
desktop, click "Wallet" (top right), "Transaction History", then in the
"Type" column, choose "Withdraw". Next, click on "Export Withdrawal History"
on the right and choose your time frame (you will probably need to choose
"Customized"). You are only allowed to choose up to 3 months, so you might
have to download more than one file and merge them before using this function.

Warning: This does NOT process TRADES See the \code{format_binance_trades()}
function for this purpose.
}
\examples{
format_binance_withdrawals(data_binance_withdrawals)
}
