% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report_revenues.R
\name{report_revenues}
\alias{report_revenues}
\title{Report all revenues}
\usage{
report_revenues(
  formatted.ACB,
  tax.year = "all",
  local.timezone = Sys.timezone()
)
}
\arguments{
\item{formatted.ACB}{The formatted ACB data.}

\item{tax.year}{Which tax year(s) to include.}

\item{local.timezone}{Which time zone to use for the date of the report.}
}
\value{
A data frame, with the following columns: exchange, date.last,
total.revenues, airdrops, referrals, staking, promos, interests, rebates,
rewards, forks, mining, currency.
}
\description{
Provides a summary of revenues from all sources.
}
\examples{
all.data <- format_shakepay(data_shakepay)
formatted.ACB <- format_ACB(all.data, verbose = FALSE)
report_revenues(formatted.ACB)
}
