% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BTC.R
\docType{data}
\name{BTC}
\alias{BTC}
\title{USDT Denominated Bitcoin (BTCUSDT) Weekly Intervals}
\format{
An \code{\link[xts:xts]{xts::xts()}}-object with 52 rows and 5 columns,

\describe{
\item{index}{<\link{POSIXct}> The time-index}
\item{open}{<\link{numeric}> Opening price}
\item{high}{<\link{numeric}> Highest price}
\item{low}{<\link{numeric}> Lowest price}
\item{close}{<\link{numeric}> Closing price}
\item{volume}{<\link{numeric}> Trading volume}
}
}
\usage{
BTC
}
\description{
This dataset contains time-series data for Bitcoin (BTC)
denominated in USDT (Tether), captured in weekly intervals.
The data spans from January 1, 2023, to December 31, 2023.
}
\examples{
# Load the dataset
data("BTC")

# chart
chart(
  ticker = BTC,
  main = kline(),
  sub = list(volume())
)
}
\keyword{datasets}
