% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/cube-query.R
\name{crtabs}
\alias{crtabs}
\title{Crunch xtabs: Crosstab and otherwise aggregate variables in a Crunch Dataset}
\usage{
crtabs(formula, data, weight = crunch::weight(data), useNA = c("no",
  "ifany", "always"))
}
\arguments{
\item{formula}{an object of class 'formula' object with the
cross-classifying variables, separated by '+', on the right hand side.
Compare to \code{\link[stats]{xtabs}}.}

\item{data}{an object of class \code{CrunchDataset}}

\item{weight}{a CrunchVariable that has been designated as a potential
weight variable for \code{data}, or \code{NULL} for unweighted results.
Default is the currently applied weight, \code{\link{weight}(data)}.}

\item{useNA}{whether to include missing values in tabular results. See
\code{\link[base]{table}}.}
}
\value{
an object of class \code{CrunchCube}
}
\description{
Create a contingency table or other aggregation from cross-classifying
variables in a CrunchDataset.
}

