% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dimension-transforms.R
\name{makeDimTransform}
\alias{makeDimTransform}
\title{Helper for creating slide dimension transformations for dashboards and exports}
\usage{
makeDimTransform(
  colors = NULL,
  hide = NULL,
  rename = NULL,
  order = NULL,
  name = NULL,
  description = NULL,
  ...
)
}
\arguments{
\item{colors}{A crunch \code{AnalyticPalettes} (\code{\link[=palettes]{palettes()}}) or a vector of color RGB hex color
codes that will be used for the color of graphs in the dashboard (used in the order of
appearance of categories/subvariables).}

\item{hide}{A vector of category names/ids or subvariable names/aliases to hide from display}

\item{rename}{A named vector of category names/ids or subvariable names/aliases to override
their default values}

\item{order}{A vector of category names/ids or subvariable names/aliases to override the
default ordering of the dimension.}

\item{name}{A name for the dimension, overrides the variable's name}

\item{description}{A description for the dimension, overrides the variable's description}

\item{...}{Other arguments, passed directly to the API for future expansion}
}
\description{
When displayed in a Crunch Dashboard or exported, crunch slides can have transformations
that customize their display. This is a helper to form the correct data structure for
the functions \code{\link[=newSlide]{newSlide()}} for setting the transformation directly. For more details see the
\href{https://crunch.io/api/reference/#post-/datasets/-dataset_id-/decks/-deck_id-/slides/}{API documentation}
}
\examples{
\dontrun{
# Hiding an element
transforms(slide) <- list(rows_dimension = makeDimTransform(hide = "Neutral"))

# Using an existing saved palette
transforms(slide) <- list(rows_dimension = makeDimTransform(
    colors = defaultPalette(ds)
))

# Setting specific colors
transform(slide) <- list(rows_dimension = makeDimTransform(
     colors = c("#af8dc3", "#f7f7f7", "#7fbf7b")
))

# Reordering & renaming elements
transforms(slide) <- list(
     rows_dimension = makeDimTransform(
         rename = c("V. Good" = "Very Good", "V. Bad" = "Very Bad"),
         order = 5:1
     ),
     columns_dimension = makeDimTransform(order = c("Brand X", "Brand A", "Brand B"))
)
}

}
