% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/delete.R
\docType{methods}
\name{delete}
\alias{delete}
\alias{delete,CrunchDataset-method}
\alias{delete,DatasetTuple-method}
\alias{delete,CrunchDeck-method}
\alias{delete,CrunchSlide-method}
\alias{delete,Multitable-method}
\alias{delete,CrunchTeam-method}
\alias{delete,CrunchVariable-method}
\alias{delete,VariableTuple-method}
\alias{delete,ShojiFolder-method}
\alias{delete,ShojiTuple-method}
\alias{delete,ShojiObject-method}
\alias{delete,ANY-method}
\title{Delete a Crunch object from the server}
\usage{
delete(x, ...)

\S4method{delete}{CrunchDataset}(x, ...)

\S4method{delete}{DatasetTuple}(x, ...)

\S4method{delete}{CrunchDeck}(x, ...)

\S4method{delete}{CrunchSlide}(x, ...)

\S4method{delete}{Multitable}(x, ...)

\S4method{delete}{CrunchTeam}(x, ...)

\S4method{delete}{CrunchVariable}(x, ...)

\S4method{delete}{VariableTuple}(x, ...)

\S4method{delete}{ShojiFolder}(x, ...)

\S4method{delete}{ShojiTuple}(x, ...)

\S4method{delete}{ShojiObject}(x, ...)

\S4method{delete}{ANY}(x, ...)
}
\arguments{
\item{x}{a Crunch object}

\item{...}{additional arguments, generally ignored}
}
\description{
These methods delete entities, notably Datasets and Variables within them,
from the server. This action is permanent and cannot be undone, so it
should not be done lightly. Consider instead using \code{archive}
for datasets and \code{hide} for variables.
}
\details{
Deleting requires confirmation. In an interactive session, you will be asked
to confirm. To avoid that prompt, or to delete objects from a
non-interactive session, wrap the call in \code{\link[=with_consent]{with_consent()}} to give
your permission to delete.
}
\seealso{
\code{\link[=hide]{hide()}} \code{\link[=deleteDataset]{deleteDataset()}} \code{\link[=deleteVariables]{deleteVariables()}} \code{\link[=deleteSubvariables]{deleteSubvariables()}}
}
