% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Crossword.R
\docType{class}
\name{Crossword}
\alias{Crossword}
\title{Crossword}
\format{An \code{\link{R6Class}} generator object for generating crosswords from word lists}
\usage{
Crossword
}
\description{
Crossword
}
\section{Fields}{

\describe{
\item{\code{letters}}{a character matrix  representing the grid of the crossword}

\item{\code{words}}{a data.frame like (tibble) storing words, their position on
the grid (row, col), their length in character, their direction ("right", "down")
the word and the clue}
}}

\section{Methods}{

\describe{
  \item{
    \code{add_words(words, clues = NULL)}}{
     this method will try to add words to the crossword by placing it on the grid;
     \code{clues} is optional and should be the same length;

   }
 \item{\code{density()}}{
   gives back statistics on fill state of grid
 }
 \item{\code{to_json(pretty = FALSE)}}{
   thi exports grid and word list data to JSON for external usage; \code{pretty}
   parameter determines if this is done in a human readable or more machine
   efficient way
 }
}
}

\examples{

library(crossword.r)
cw <- Crossword$new(rows = 4, columns = 4)
cw$add_words(c("back", "nasa", "kick", "nuk", "ic", "sic"))
cw
cw$letters
cw$words
cw$density()

}
\keyword{datasets}
