% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pivot.R
\name{transpose_crosstable}
\alias{transpose_crosstable}
\alias{t.crosstable}
\title{Transpose a crosstable}
\usage{
transpose_crosstable(x)

\method{t}{crosstable}(x)
}
\arguments{
\item{x}{a crosstable}
}
\value{
a tibble of class \code{transposed_crosstable}
}
\description{
Pivot a crosstable so the \code{label} column is swapped with the \code{by} row.
This requires the \code{variable} column to be the same for every data column, like when all columns are numeric of when all columns are factors with the same levels
}
\examples{
ct = crosstable(mtcars2, c(mpg, drat, wt, qsec), by=am)
ct \%>\% t() \%>\% as_flextable()
ct2 = crosstable(mtcars2, c(mpg, drat, wt, qsec), by=c(am, vs))
ct2 \%>\% t() \%>\% as_flextable()
}
