% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/labels.R
\name{rename_with_labels}
\alias{rename_with_labels}
\alias{rename_dataframe_with_labels}
\title{Rename every column of a dataframe with its label}
\source{
https://stackoverflow.com/q/75848408/3888000
}
\usage{
rename_with_labels(df, except = NULL)
}
\arguments{
\item{df}{a data.frame}

\item{except}{<\code{\link[tidyselect:language]{tidy-select}}> columns that should not be renamed.}
}
\value{
A dataframe which names are copied from the label attribute
}
\description{
Rename every column of a dataframe with its label
}
\examples{
rename_with_labels(mtcars2[,1:5], except=5) \%>\% names()
rename_with_labels(iris2, except=Sepal.Length) \%>\% names()
rename_with_labels(iris2, except=starts_with("Pet")) \%>\% names()
}
\author{
Dan Chaltiel
}
