% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/officer.R
\name{write_and_open}
\alias{write_and_open}
\title{Alternative to default \code{officer} print() function. Write the file and try to open it right away.}
\usage{
write_and_open(doc, docx.file)
}
\arguments{
\item{doc}{the docx object}

\item{docx.file}{the name of the target file. If missing or NULL, the doc will open in a temporary file.}
}
\value{
Nothing, called for its side effects
}
\description{
As it tests if the file is writable, this function also prevents \code{officer:::print.rdocx()} to abort the RStudio session.
}
\examples{
library(officer)
library(crosstable)
mytable = crosstable(mtcars2)
doc = read_docx() \%>\%
    body_add_crosstable(mytable)

write_and_open(doc)
\dontrun{
write_and_open(doc, "example.docx")
}
}
\author{
Dan Chaltiel
}
