% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flextable.R
\docType{import}
\name{as_flextable.crosstable}
\alias{as_flextable.crosstable}
\alias{ctf}
\alias{cross_to_flextable}
\alias{to_flextable}
\alias{as_flextable}
\alias{af}
\title{Turns a \code{crosstable} object into a formatted \code{flextable}}
\usage{
\method{as_flextable}{crosstable}(
  x,
  keep_id = FALSE,
  by_header = NULL,
  autofit = TRUE,
  compact = FALSE,
  show_test_name = TRUE,
  fontsizes = list(body = 11, subheaders = 11, header = 11),
  padding_v = NULL,
  remove_header_keys = FALSE,
  header_show_n = FALSE,
  generic_labels = list(id = ".id", variable = "variable", value = "value", total =
    "Total", label = "label", test = "test", effect = "effect"),
  ...
)
}
\arguments{
\item{x}{the result of \code{\link[=crosstable]{crosstable()}}}

\item{keep_id}{whether to keep the \code{.id} column}

\item{by_header}{a string to override the \code{by} header}

\item{autofit}{whether to use \code{\link[flextable:autofit]{flextable::autofit()}} on the table}

\item{compact}{whether to compact the table}

\item{show_test_name}{in the \code{test} column, show the test name}

\item{fontsizes}{font sizes as a list of keys \code{c(body, subheaders, header)}. If set through arguments instead of options, all 3 names should be specified.}

\item{padding_v}{vertical padding (body)}

\item{remove_header_keys}{if \code{TRUE} and \code{x} has several \code{by} strata, header will only display values}

\item{header_show_n}{show the size (\code{N=xx}) of each terminal \code{by} strata in their header}

\item{generic_labels}{names of the crosstable default columns. Useful for translation for instance.}

\item{...}{unused}
}
\value{
a flextable
}
\section{Methods (by class)}{
\itemize{
\item \code{crosstable}: Turns a \code{crosstable} object into a formatted \code{flextable}.
}}

\examples{
#Crosstables
library(crosstable)
library(dplyr)
crosstable_options(crosstable_fontsize_header=14, 
                   crosstable_fontsize_subheaders=10, 
                   crosstable_fontsize_body=8)
crosstable(iris) \%>\% as_flextable()
crosstable(mtcars2, by=c(am, vs)) \%>\% as_flextable()
crosstable(mtcars2, cols=c(mpg, cyl), by=am, effect=TRUE) \%>\% 
   as_flextable(keep_id=TRUE, autofit=FALSE)
crosstable(mtcars2, cols=c(mpg, cyl), by=am, effect=TRUE) \%>\% 
   as_flextable(compact=TRUE)

#Renaming (because why not?)
crosstable(mtcars2, by=vs, total="both", test=TRUE, effect=TRUE) \%>\%
   rename(ID=.id, math=variable, Tot=Total, lab=label, pval=test, fx=effect) \%>\%
   as_flextable(by_header = "Engine shape", 
                generic_labels=list(id = "ID", variable = "math", total="Tot", 
                                    label = "lab", test = "pval", effect="fx"))
}
\seealso{
\code{\link[=crosstable]{crosstable()}}, \code{\link[flextable:flextable]{flextable::flextable()}}, \code{\link[=as_gt.crosstable]{as_gt.crosstable()}}
}
\author{
Dan Chaltiel
}
\keyword{internal}
\description{
These objects are imported from other packages. Follow the links
below to see their documentation.

\describe{
  \item{flextable}{\code{\link[flextable]{as_flextable}}}
}}

