\name{analyze.rand}
\alias{analyze.rand}
\title{Analysis of a Simulation Study to Asses the Validity of a Randomization Procedure}
\description{
  The function analyzes the results of simulation studies done by functions like \code{rand.design.azais} or
  \code{rand.design.RC}.
  A table of results and, optionally, graphs are given that help to assess whether a randomization procedure validates
  a certain model for a given design.
}
\usage{
analyze.rand(where, fig = FALSE, ref = FALSE, refval = numeric(6),
    reftext = "Reference Value", pch1 = 1, pch2 = 46, col1 = "red",
    col2 = "black", ...)
}
\arguments{
  \item{where}{ Path that gives the location of the simulation results }
  \item{fig}{ Logical flag. Set to TRUE if you want to display the results in graphs }
  \item{ref}{ Logical flag. TRUE if you want to use your own reference values for the estimated contrast
                 in the simulation study. Otherwise, the true values of the contrast are used.}
  \item{refval}{ A numerical vector of length 6. The values that the contrast estimates are compared to.
                 This is set automatically to the true values of the contrast if \code{ref} is FALSE. }
  \item{reftext}{ Character string that contains the legend text in a graph displaying the location of the estimated
                  contrast and the corresponding reference value. }
  \item{pch1}{ A scalar that corresponds to the plotting character in the Q-Q-Plot of the difference of variance 
               estimates that is displayed if \code{fig} is TRUE. }
  \item{pch2}{ A scalar that corresponds to the plotting character in the Q-Q-Plot of the estimated contrast that is
               displayed if \code{fig} is TRUE. }
  \item{col1}{ The colour of the theoretical CDF in the CDF-Plots that are displayed if \code{fig} is TRUE
           Also the colour of the reference values described above. }
  \item{col2}{ The colour of the empirical CDF in the CDF-Plots that are displayed if \code{fig} is TRUE }
  \item{\dots}{ Additional parameters for the graphs. }
}
\details{
  The input to the function comes from a file that is generated by the functions \code{rand.design.azais} or
  \code{rand.design.RC}.
  This file contains simulated values for contrast estimates and corresponding variance estimates. It also
  contains information on the experimental design and the model used.

  The output contains two tables. The first one displays empirical quantiles of the randomization t-statistics for the
  contrast as well as estimates of the location of the contrasts. The second table contains estimates of the variance of
  the contrast. In theory, the randomization validates the model for the design used, if the contrast estimate is unbiased and
  the variance estimate of the contrast is unbiased, too.
  The simulation study suggests that this is achieved, if two conditions hold: First, the absolute value of the
  Z-statistic of table 1 is less than 1.96 (Gauss test on the randomization contrasts).
  Second, the confidence interval for the difference of the model variance estimate and the empirical
  variance of the randomization contrasts should include zero. The boundaries of the interval
  are given in columns 4 and 6 of table 2.
  An additional information on the validity is given by the randomization t-statistics. If the model is valid, for most
  real data they will be approximately t-distributed. This can be checked by comparing the empirical 5\% quantile
  to the 5\% quantile of the true t-distribution.
  The plots show histograms of the randomization contrast estimates and cumulative distribution functions for the
  permutation t-statistics. Also, normal Q-Q-Plots of the estimated contrast and the estimate of the difference
  between the true variance and the model variance of the contrast are given.


}
\value{
  \item{1}{A 6*5 matrix of results. The rows correspond to the cases considered in \code{\link{rand.design.azais}}.
                  The first column contains the number of randomization t-statistics smaller than the 5\% quantile of the
                  theoretical t-distribution. The second column has the fraction of t-statistics smaller than this
                  quantile. The third column contains the mean of the estimated contrast values.
                  The fourth has the reference value for this mean.
                  In the fifth column the test statistic for the Gauss test of the contrast being equal to the reference value
                  is displayed.}
  \item{2}{A 6*5 matrix of results. The rows correspond to the cases considered in \code{\link{rand.design.azais}}.
                  The first column contains the empirical variance of the contrast estimates, the second column
                  has the average value of the variance estimate for the contrast under the applied model.
                  The following columns contain the lower, center and upper value of the confidence intervals
                  for the difference of the true variance and the estimated variance of the estimated contrast.}
}

\references{ Bailey, R.A. and Rowley C.A. (1987): Valid randomization.
Proceedings of the Royal Society London A 410, 105-124.

Kunert, J. and Sailer, O. (2006): On nearly balanced designs for sensory trials. Food Quality and Preference 17,
219-227.

Kunert, J. and Sailer, O. (2007): Randomization of neighbour balanced generalized Youden designs. 
Journal of Statistical Planning and Inference 137, 2045-2055.}

\author{ Oliver Sailer \email{sailer@statistik.uni-dortmund.de}}
\note{ If \code{fig} is TRUE, 24 graphics windows are opened.}

\seealso{ \code{\link{rand.design.azais}}, \code{\link{rand.design.RC}} }
\examples{
\dontrun{
# First create a data set to analyze:
d <- matrix(c(1:4,2:4,1,4,1:3,3,4,1,2),ncol=4)
rand.design.RC( d, rnorm(16), -1, 1, 1000, "D:\\mytest.txt" )
# Now do the analysis:
analyze.rand( "D:\\mytest.txt" )
analyze.rand( "D:\\mytest.txt", fig=TRUE, ref=TRUE,
    refval=c(0, -1, 0, -1, -.25, -1.25) )
}
}


\keyword{ design }
