% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{txt_sprintf}
\alias{txt_sprintf}
\title{\code{NA} friendly version of sprintf}
\usage{
txt_sprintf(fmt, ...)
}
\arguments{
\item{fmt}{a character vector of format strings, which will be fed on to \code{\link[base]{sprintf}}}

\item{...}{values to be passed into \code{fmt}, the \code{...} will be passed on to \code{\link[base]{sprintf}}}
}
\value{
The same as what \code{\link[base]{sprintf}} returns:
a character vector of length that of the longest input in \code{...}. \cr
Except, in case any of the values passed on to \code{...} are \code{NA}, 
the corresponding returned value will be set to \code{NA} for that element of the vector. \cr
See the examples to see the difference with \code{\link[base]{sprintf}}
}
\description{
Does the same as the function \code{\link[base]{sprintf}} except that if 
in ... \code{NA} values are passed, also \code{NA} values are returned instead of being replaced by the character string \code{'NA'}.
}
\examples{
sprintf("(w-1):\%s", c("xyz", NA, "abc"))
txt_sprintf("(w-1):\%s", c("xyz", NA, "abc"))
sprintf("(w-1):\%s_\%s", c("xyz", NA, "abc"), c(NA, "xyz", "abc"))
txt_sprintf("(w-1):\%s_\%s", c("xyz", NA, "abc"), c(NA, "xyz", "abc"))
}
\seealso{
\code{\link[base]{sprintf}}
}
