% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crestS3.R
\name{crestObj}
\alias{crestObj}
\title{Create a \code{crestObj} object.}
\usage{
crestObj(
  taxa.name,
  taxaType,
  climate,
  pse = NA,
  dbname = NA,
  continents = NA,
  countries = NA,
  basins = NA,
  sectors = NA,
  realms = NA,
  biomes = NA,
  ecoregions = NA,
  xmn = NA,
  xmx = NA,
  ymn = NA,
  ymx = NA,
  elev_min = NA,
  elev_max = NA,
  elev_range = NA,
  year_min = 1900,
  year_max = 2021,
  nodate = TRUE,
  type_of_obs = c(1, 2, 3, 8, 9),
  df = NA,
  x = NA,
  x.name = "",
  minGridCells = 20,
  weightedPresences = FALSE,
  bin_width = NA,
  shape = NA,
  npoints = 200,
  geoWeighting = TRUE,
  climateSpaceWeighting = TRUE,
  selectedTaxa = NA,
  distributions = NA,
  presenceThreshold = 0,
  taxWeight = "normalisation",
  uncertainties = c(0.5, 0.95)
)
}
\arguments{
\item{taxa.name}{A vector that contains the names of the taxa to study.}

\item{taxaType}{A numerical index (between 1 and 6) to define the type of
palaeoproxy used: 1 for plants, 2 for beetles, 3 for chironomids,
4 for foraminifers, 5 for diatoms and 6 for rodents. The example
dataset uses taxaType=0 (pseudo-data). Default is 1.}

\item{climate}{A vector of the climate variables to extract. See
\code{\link{accClimateVariables}} for the list of accepted values.}

\item{pse}{A pollen-Species equivalency table. See \code{\link{createPSE}} for
details.}

\item{dbname}{The name of the data source database.}

\item{continents}{A vector of the continent names defining the study area.}

\item{countries}{A vector of the country names defining the study area.}

\item{basins}{A vector of the ocean names defining the study area.}

\item{sectors}{A vector of the marine sector names defining the study area.}

\item{realms}{A vector of the studied botanical realms defining the study area.}

\item{biomes}{A vector of the studied botanical biomes defining the study area.}

\item{ecoregions}{A vector of the studied botanical ecoregions defining the
study area.}

\item{xmn, xmx, ymn, ymx}{The coordinates defining the study area.}

\item{elev_min, elev_max}{Parameters to only selected grid cells with an
elevation higher than elev_min or lower than elev_max (default is
'\code{NA} ).}

\item{elev_range}{Parameters discard the grid cell with a high elevation
range (default is \code{NA}).}

\item{year_min, year_max}{The oldest and youngest occurrences accepted
(default is 1900-2021).}

\item{nodate}{A boolean to accept occurrences without a date (can overlap
with occurrences with a date; default \code{TRUE}).}

\item{type_of_obs}{The type of observation to use in the study. 1: human
observation, 2: observation, 3: preserved specimen, 4: living specimen,
5: fossil specimen, 6: material sample, 7: machine observation, 8:
literature, 9: unknown (Default \code{c(1, 2, 3, 8, 9)})}

\item{df}{A data frame containing the data to reconstruct (counts,
percentages or presence/absence data).}

\item{x}{The name, age or depth of the rows of df (the samples).}

\item{x.name}{A string describing the x axis (e.g. 'Sample Name', 'Age',
'Depth').}

\item{minGridCells}{The minimum number of unique presence data necessary to
estimate a species' climate response. Default is 20.}

\item{weightedPresences}{A boolean to indicate whether the presence records
should be weighted. Default is \code{FALSE}.}

\item{bin_width}{The width of the bins used to correct for unbalanced climate
state. Use values that split the studied climate gradient in
15-25 classes (e.g. 2°C for temperature variables). Default is 1.}

\item{shape}{The imposed shape of the species \code{pdfs}. We recommend using
'normal' for temperature variables and 'lognormal' for the
variables that can only take positive values, such as
precipitation or aridity. Default is 'normal' for all.}

\item{npoints}{The number of points to be used to fit the \code{pdfs}. Default 200.}

\item{geoWeighting}{A boolean to indicate if the species should be weighting
by the square root of their extension when estimating a genus/family
level taxon-climate relationships.}

\item{climateSpaceWeighting}{A boolean to indicate if the species \code{pdfs}
should be corrected for the modern distribution of the climate space
(default \code{TRUE}).}

\item{selectedTaxa}{A data frame assigns which taxa should be used for each
variable (1 if the taxon should be used, 0 otherwise). The colnames
should be the climate variables' names and the rownames the taxa
names. Default is 1 for all taxa and all variables.}

\item{distributions}{A dataframe containing the presence records of the
studied proxies and their associated climate values.}

\item{presenceThreshold}{All values above that threshold will be used in the
reconstruction (e.g. if set at 1, all percentages below 1 will be set
to 0 and the associated presences discarded). Default is 0.}

\item{taxWeight}{One value among the following: 'originalData',
'presence/absence', 'percentages' or 'normalisation' (default).}

\item{uncertainties}{A (vector of) threshold value(s) indicating the error
bars that should be calculated (default both 50 and 95\% ranges).}
}
\value{
A \code{crestObj} object that is used to store data and information
for reconstructing climate
}
\description{
Creates a \code{crestObj} object with all default parameters.
}
\seealso{
See \code{vignette('technicalities')} for details about the structure
of the object. See also \url{https://gbif.github.io/parsers/apidocs/org/gbif/api/vocabulary/BasisOfRecord.html}
for a detailed explanation of the types of observation.
}
