% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/add_conventions.R
\name{add_conventions}
\alias{add_conventions}
\title{Return accounting conventions}
\usage{
add_conventions(x, currency.var = "currency")
}
\arguments{
\item{x}{a data frame containing all necessary information}

\item{currency.var}{a character indicating the name of currency column}
}
\value{
a data frame with eight more columns of accounting conventions:
  badDayConvention (a character indicating how non-business days are
  converted), mmDCC (the day count convention of the instruments),
  mmCalendars (any calendar adjustment for the CDS), fixedDCC (the day count
  convention of the fixed leg), floatDCC (the day count convention of the
  floating leg), fixedFreq (the frequency of the fixed rate of swap being
  paid), floatFreq (the frequency of the floating rate of swap being paid)
  and swapCalendars (any calendar adjustment for swap rate)
}
\description{
\code{add_conventions} takes a data frame with a currency.var column and
returns the same data frame with eight other columns of accounting
conventions added to it.
}
\examples{
x <- data.frame(date = c(as.Date("2014-05-06"), as.Date("2014-05-07")),
                currency = c("USD", "JPY"))
add_conventions(x)
}
\references{
\url{
http://www.cdsmodel.com/cdsmodel/assets/cds-model/docs/c-code%20Key%20Functions-v1.pdf
}
}

