% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_visualization.R
\name{plot_oot_perf}
\alias{plot_oot_perf}
\title{plot_oot_perf
\code{plot_oot_perf} is for ploting performance of cross time samples in the future}
\usage{
plot_oot_perf(dat_test, x, occur_time, target, k = 3, g = 10,
  period = "month", best = FALSE, equal_bins = TRUE, pl = "rate",
  breaks = NULL, cut_bin = "equal_depth", gtitle = NULL,
  perf_dir_path = NULL, save_data = FALSE, plot_show = TRUE)
}
\arguments{
\item{dat_test}{A data frame of testing dataset with predicted prob or score.}

\item{x}{The name of prob or score variable.}

\item{occur_time}{The name of the variable that represents the time at which each observation takes place.}

\item{target}{The name of target variable.}

\item{k}{If period is NULL, number of equal frequency samples.}

\item{g}{Number of breaks for prob or score.}

\item{period}{OOT period, 'weekly' and 'month' are available.if NULL, use k equal frequency samples.}

\item{best}{Logical, merge initial breaks to get optimal breaks for binning.}

\item{equal_bins}{Logical, generates initial breaks for equal frequency or width binning.}

\item{pl}{'lift' is for lift chart plot,'rate' is for positive rate plot.}

\item{breaks}{Splitting points of prob or score.}

\item{cut_bin}{A string, if equal_bins is TRUE, 'equal_depth' or 'equal_width', default is 'equal_depth'.}

\item{gtitle}{The title of the graph & The name for periodically saved graphic file.}

\item{perf_dir_path}{The path for periodically saved graphic files.}

\item{save_data}{Logical, save results in locally specified folder. Default is FALSE.}

\item{plot_show}{Logical, show model performance in current graphic device. Default is TRUE.}
}
\description{
plot_oot_perf
\code{plot_oot_perf} is for ploting performance of cross time samples in the future
}
\examples{
sub = cv_split(UCICreditCard, k = 30)[[1]]
dat = UCICreditCard[sub,]
dat = re_name(dat, "default.payment.next.month", "target")
x_list = c("PAY_0", "LIMIT_BAL", "PAY_AMT5", "PAY_3", "PAY_2")
dat = data_cleansing(dat, target = "target", obs_id = "ID",x_list = x_list,
occur_time = "apply_date", miss_values = list("", -1))
dat = process_nas(dat,default_miss = TRUE)
train_test <- train_test_split(dat, split_type = "OOT", prop = 0.7,
                                occur_time = "apply_date")
dat_train = train_test$train
dat_test = train_test$test
Formula = as.formula(paste("target", paste(x_list, collapse = ' + '), sep = ' ~ '))
set.seed(46)
lr_model = glm(Formula, data = dat_train[, c("target", x_list)], family = binomial(logit))

dat_train$pred_LR = round(predict(lr_model, dat_train[, x_list], type = "response"), 5)
dat_test$pred_LR = round(predict(lr_model, dat_test[, x_list], type = "response"), 5)
plot_oot_perf(dat_test = dat_test, occur_time = "apply_date", target = "target", x = "pred_LR")
}
