% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/outliers_missing_treatment.R
\name{process_nas}
\alias{process_nas}
\alias{process_nas_var}
\title{Missing Treatment}
\usage{
process_nas(dat, x_list = NULL, default_miss = TRUE,
  class_var = FALSE, miss_values = NULL, parallel = FALSE,
  ex_cols = NULL, method = "median", note = FALSE,
  save_data = FALSE, file_name = NULL, dir_path = tempdir(), ...)

process_nas_var(dat = dat, x, default_miss = TRUE, nas_rate = NULL,
  mat_nas_shadow = NULL, dt_nas_random = NULL, missing_type = NULL,
  method = "median", note = FALSE, save_data = FALSE,
  file_name = NULL, dir_path = tempdir(), ...)
}
\arguments{
\item{dat}{A data.frame with independent variables.}

\item{x_list}{Names of independent variables.}

\item{default_miss}{Logical. If TRUE, assigning the missing values to -1 or "Missing", otherwise ,processing the missing values according to the results of missing analysis.}

\item{class_var}{Logical, nas analysis of the nominal variables. Default is TRUE.}

\item{miss_values}{Other extreme value might be used to represent missing values, e.g: -9999, -9998. These miss_values will be encoded to -1 or "Missing".}

\item{parallel}{Logical, parallel computing. Default is FALSE.}

\item{ex_cols}{A list of excluded variables. Regular expressions can also be used to match variable names. Default is NULL.}

\item{method}{The methods of imputation by knn."median" is knn imputation by k neighbors median.}

\item{note}{Logical, outputs info. Default is TRUE.}

\item{save_data}{Logical. If TRUE, save missing analysis to \code{dir_path}}

\item{file_name}{The file name for periodically saved missing analysis file. Default is NULL.}

\item{dir_path}{The path for periodically saved missing analysis file. Default is "./variable".}

\item{...}{Other parameters.}

\item{x}{The name of variable to process.}

\item{nas_rate}{A list contains nas rate of each variable.}

\item{mat_nas_shadow}{A shadow matrix of variables which contain nas.}

\item{dt_nas_random}{A data.frame with random nas imputation.}

\item{missing_type}{Type of missing, genereted by code{\link{analysis_nas}}}
}
\value{
A dat frame with no NAs.
}
\description{
\code{process_nas_var} is for missing value analysis and treatment using knn imputation, central impulation and random imputation.
\code{process_nas} is a simpler wrapper for \code{process_nas_var}.
}
\examples{
dat_na = process_nas(dat = UCICreditCard[1:1000,], default_miss = FALSE,
target = "default.payment.next.month",
parallel = FALSE,ex_cols = "ID$" ,method = "median")

}
