% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colors.R
\docType{data}
\name{crayons}
\alias{crayons}
\title{Crayons Color Palettes}
\format{
list of \link[palette:palette]{palette::palette} vectors
}
\usage{
crayons
}
\description{
Crayon colors, based on common Crayola colors.
Palettes build from \href{https://en.wikipedia.org/wiki/List_of_Crayola_crayon_colors}{Wikipedia}
}
\details{
Included palettes:
\itemize{
\item \strong{billionth}, celebrates the 100 billionth crayon
\item \strong{color_n_smell}, scented colors
\item \strong{colors_of_the_world}, additional human colors
\item \strong{construction_paper}, colors for construction paper
\item \strong{fluorescent}, neon colors
\item \strong{gel_fx}, gel colors
\item \strong{gem_tones}, gemstones
\item \strong{heads_n_tails}, double sided colors
\item \strong{magic_scent}, scented colors
\item \strong{metallic_fx}, metal colors
\item \strong{mini_twistables}, colors, but twistable
\item \strong{modern}, historical colors since 1990
\item \strong{munsell}, historical colors 1926-1944
\item \strong{multicultural}, skin colors
\item \strong{no_48}, historical crayons 48-pack in 1949
\item \strong{no_64}, historical crayons 64-pack in 1958
\item \strong{original}, historical crayons original in 1903
\item \strong{pearl}, updated perlescent colors
\item \strong{pearl_brite}, pearlescent colors
\item \strong{silly_scents}, scented in reality but not in R
\item \strong{silver_swirls}, colors with a tinge of silver
\item \strong{standard}, a large set of standard colors
\item \strong{standard16}, colors for a 16 pack of crayons
\item \strong{standard24}, colors for a 24 pack of crayons
\item \strong{standard32}, colors for a 32 pack of crayons
\item \strong{standard64}, colors for a 64 pack of crayons
\item \strong{star_brite}, colors from 1997
}
}
\examples{
plot(crayons$billionth)
plot(crayons$color_n_smell)
plot(crayons$colors_of_the_world)
plot(crayons$construction_paper)
plot(crayons$fluorescent)
plot(crayons$gel_fx)
plot(crayons$gem_tones)
plot(crayons$heads_n_tails)
plot(crayons$magic_scent)
plot(crayons$metallic_fx)
plot(crayons$mini_twistables)
plot(crayons$modern)
plot(crayons$munsell)
plot(crayons$multicultural)
plot(crayons$no_48)
plot(crayons$no_64)
plot(crayons$original)
plot(crayons$pearl)
plot(crayons$pearl_brite)
plot(crayons$silly_scents)
plot(crayons$silver_swirls)
plot(crayons$standard)
plot(crayons$standard16)
plot(crayons$standard24)
plot(crayons$standard32)
plot(crayons$standard64)
plot(crayons$star_brite)

}
\concept{colors}
\keyword{datasets}
