% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wordcloud.R
\name{compute_term_frequency}
\alias{compute_term_frequency}
\title{Compute term frequencies from a vector of text}
\usage{
compute_term_frequency(txt, ignore_words = c("www.jstor.org",
  "www.arxiv.org", "arxiv.org", "provides", "https"), stem = FALSE,
  remove_punctuation = TRUE, remove_stopwords = TRUE,
  remove_numbers = TRUE, to_lower = TRUE, frequency = "term")
}
\arguments{
\item{txt}{a vector of character strings.}

\item{ignore_words}{a vector of words to be ignored when forming the corpus.}

\item{stem}{should words be stemmed using Porter's stemming algorithm? Default is \code{FALSE}. See \link[tm:stemDocument]{tm::stemDocument}.}

\item{remove_punctuation}{should punctuation be removed when forming the corpus? Default is \code{TRUE}. See \link[tm:removePunctuation]{tm::removePunctuation}.}

\item{remove_stopwords}{should english stopwords be removed when forming the corpus? Default is \code{TRUE}. See \link[tm:removeWords]{tm::removeWords} and \link[tm:stopwords]{tm::stopwords}.}

\item{remove_numbers}{should numbers be removed when forming the corpus? Default is \code{TRUE}. See \link[tm:removeNumbers]{tm::removeNumbers}.}

\item{to_lower}{should all terms be coerced to lower-case when forming the corpus? Default is \code{TRUE}.}

\item{frequency}{the type of term frequencies to return. Options are \code{"term"} (default; a named vector of term frequencies), \code{"document-term"} (a document-term frequency matrix; see \link[tm:TermDocumentMatrix]{tm::TermDocumentMatrix}), \code{"term-document"} (a term-document frequency matrix; see \link[tm:DocumentTermMatrix]{tm::DocumentTermMatrix}).

The operations are taking place as follows: remove special
characters, covert to lower-case (depending on the values of
\code{to_lower}), remove numbers (depending on the value of
\code{remove_numbers}), remove stop words (depending on the value of
\code{remove_stopwords}), remove custom words (depending on the value of
\code{ignore_words}), remove punctuation (depending on the value of
\code{remove_punctuation}), clean up any leading or trailing whitespace,
and, finally stem words (depending on the value of \code{stem}).}
}
\value{
Either a named numeric vector (\code{frequency = "term"}), or an object of class \link[tm:DocumentTermMatrix]{tm::DocumentTermMatrix} (\code{frequency = "document-term"}), or or an object of class \code{\link[tm:TermDocumentMatrix]{tm::TermDocumentMatrix}} (\code{frequency = "term-document"}).
}
\description{
Compute term frequencies from a vector of text
}
\details{
If \code{txt} is a named vector then the names are used as document id's
when forming the corpus.
}
\seealso{
\code{\link{word_cloud}}
}
