% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{mcmc_pol}
\alias{mcmc_pol}
\title{Markov chain Monte Carlo for Zipf-polylog distribution}
\usage{
mcmc_pol(
  x,
  count,
  alpha,
  theta,
  a_alpha,
  b_alpha,
  a_theta,
  b_theta,
  a_pseudo,
  b_pseudo,
  pr_power,
  iter,
  thin,
  burn,
  freq,
  invt,
  mc3_or_marg,
  x_max
)
}
\arguments{
\item{x}{Vector of the unique values (positive integers) of the data}

\item{count}{Vector of the same length as x that contains the counts of each unique value in the full data, which is essentially rep(x, count)}

\item{alpha}{Real number greater than 1, initial value of the parameter}

\item{theta}{Real number in (0, 1], initial value of the parameter}

\item{a_alpha}{Real number, mean of the prior normal distribution for alpha}

\item{b_alpha}{Positive real number, standard deviation of the prior normal distribution for alpha}

\item{a_theta}{Positive real number, first parameter of the prior beta distribution for theta; ignored if pr_power = 1.0}

\item{b_theta}{Positive real number, second parameter of the prior beta distribution for theta; ignored if pr_power = 1.0}

\item{a_pseudo}{Positive real number, first parameter of the pseudoprior beta distribution for theta in model selection; ignored if pr_power = 1.0}

\item{b_pseudo}{Positive real number, second parameter of the pseudoprior beta distribution for theta in model selection; ignored if pr_power = 1.0}

\item{pr_power}{Real number in [0, 1], prior probability of the discrete power law}

\item{iter}{Positive integer representing the length of the MCMC output}

\item{thin}{Positive integer representing the thinning in the MCMC}

\item{burn}{Non-negative integer representing the burn-in of the MCMC}

\item{freq}{Positive integer representing the frequency of the sampled values being printed}

\item{invt}{Vector of the inverse temperatures for Metropolis-coupled MCMC}

\item{mc3_or_marg}{Boolean, is invt for parallel tempering / Metropolis-coupled MCMC (TRUE, default) or marginal likelihood via power posterior (FALSE)?}

\item{x_max}{Scalar, positive integer limit for computing the normalising constant}
}
\value{
A list: $pars is a data frame of iter rows of the MCMC samples, $fitted is a data frame of length(x) rows with the fitted values, amongst other quantities related to the MCMC
}
\description{
\code{mcmc_pol} returns the samples from the posterior of alpha and theta, for fitting the Zipf-polylog distribution to the data x. The samples are obtained using Markov chain Monte Carlo (MCMC). In the MCMC, a Metropolis-Hastings algorithm is used.
}
\seealso{
\code{\link{mcmc_mix2}} and \code{\link{mcmc_mix3}} for MCMC for the 2-component and 3-component discrete extreme value mixture distributions, respectively.
}
