% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{mcmc_upp}
\alias{mcmc_upp}
\title{Markov chain Monte Carlo for discrete power law}
\usage{
mcmc_upp(
  x,
  u,
  xi1,
  a_xi1,
  b_xi1,
  N = 20000L,
  thin = 10L,
  burnin = 20000L,
  print_freq = 10000L
)
}
\arguments{
\item{x}{Vector of positive integers, representing the data}

\item{u}{Scalar, non-negative integer threshold}

\item{xi1}{Scalar, initial value of the shape parameter}

\item{a_xi1}{Scalar, lower bound of the uniform distribution as the prior of xi1}

\item{b_xi1}{Scalar, upper bound of the uniform distribution as the prior of xi1}

\item{N}{Scalar, positive integer representing the length of the output chain i.e. the number of rows in the returned data frame}

\item{thin}{Scalar, positive integer representing the thinning in the MCMC}

\item{burnin}{Scalar, non-negative integer representing the burn-in of the MCMC}

\item{print_freq}{Scalar, positive integer representing the frequency of printing the sampled values}
}
\value{
A data frame containing N rows and 2 columns which represent xi1 and the log-posterior density (lpost)
}
\description{
\code{mcmc_upp} returns the samples from the posterior of xi1, for fitting the discrete power law to the data x. The samples are obtained using Markov chain Monte Carlo (MCMC).
}
\details{
In the MCMC, a componentwise Metropolis-Hastings algorithm is used. Unlike \code{mcmc_mix}, the threshold u is treated as fixed in \code{mcmc_upp}.
}
\seealso{
\code{\link{mcmc_mix}} for MCMC for the discrete extreme value mixture distribution.
}
