% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph.R
\name{get_graph_all_packages}
\alias{get_graph_all_packages}
\title{Graph of dependencies of all CRAN packages}
\usage{
get_graph_all_packages(type, gc = TRUE)
}
\arguments{
\item{type}{One of the following dependency words: "Depends", "Imports", "LinkingTo", "Suggests", "Reverse depends", "Reverse imports", "Reverse linking to", "Reverse suggests", up to letter case and space replaced by underscore}

\item{gc}{Boolean, if 'TRUE' (default) then the giant component is extracted, if 'FALSE' then the whole graph is returned}
}
\value{
An igraph object & a connected graph if gc is 'TRUE'
}
\description{
\code{get_graph_all_packages} returns an igraph object representing the network of one type of dependencies of all CRAN packages.
}
\examples{
\dontrun{
g0.cran.depends <- get_graph_all_packages("depends")
g1.cran.imports <- get_graph_all_packages("reverse imports")
}
}
