% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cpop.R
\name{cost}
\alias{cost}
\alias{cost,cpop.class-method}
\title{A function for calculating the cost of a model fitted by cpop}
\usage{
cost(object)
}
\arguments{
\item{object}{An instance of an S4 class produced by \code{\link{cpop}}.}
}
\value{
Numerical value of the penalised cost associated with the segmentations determined by using \code{\link{cpop}}
}
\description{
Calculates the penalised cost of a model fitted by cpop using the residual sum of squares and the penalty values.
}
\examples{
library(cpop)

# simulate data with change in gradient
set.seed(1)
x <- (1:50/5)^2
y <- simulate(x,changepoints=c(10,50),change.slope=c(0.25,-0.25),sigma=1)

# determine changepoints
res <- cpop(y,x,beta=2*log(length(y)))

# calculate the penalised cost 
cost(res)

}
