#include "ChangePointModelExponentialAdjusted.h"
#include <cmath> 
#include <R.h>

ChangePointModelExponentialAdjusted::ChangePointModelExponentialAdjusted() {
	m_startup=20;
	initarray();
}


ChangePointModelExponentialAdjusted::ChangePointModelExponentialAdjusted(const std::vector<double> &thresholds, int startup) {
	m_thresholds = thresholds;
	m_startup=startup;
	initarray();
}


void ChangePointModelExponentialAdjusted::cpmMLEaux(std::vector <double> &Us) {
	int i,sz,k;
	double n0,n1,s0,s1,K,temp,BC;
	Us.reserve(m_statistics[0].size());	
	sz = m_statistics[0].size();
    //Us.push_back(0);
    
	//for (i = 1 ; i < sz-2 ; i++) {
	for (i = 0 ; i < sz-1 ; i++) {
		k = i+1;
		n0 = (double) k;
		n1 = (double) sz-n0;
		s0 = (double) m_statistics[0][i];
		s1 = (double) m_statistics[0].back() - s0;
		K = sz*log((double)sz) - n0*log((double)n0)-n1*log((double)n1);
		//temp = -sz*log(s0+s1) + n0*log(s0) + n1*log(s1)+K;
		temp = sz*log(sz/(s0+s1)) - n0*log(n0/s0) - n1*log(n1/s1);
		
		//BC = (k*digamma[k] + (sz-k)*digamma[sz-k] - sz*digamma[sz] + sz*log(sz) - k*log(k) - k*log(sz-k));
		BC = k*digamma[k] + (sz-k)*digamma[sz-k] - sz*digamma[sz] + K; // is this right? is it really the same as K?
		//Rprintf("%f %f\n",temp,BC);
		Us.push_back(temp/BC);    
	}
    Us.push_back(0);
    //Us.push_back(0);
}


//digamma function is very slow to compute, so precompute all values!
void ChangePointModelExponentialAdjusted::initarray() {
	digamma[0]=0;digamma[1]=-1.9635100260;digamma[2]=-0.5772156649;digamma[3]=0.0364899740;digamma[4]=0.4227843351;digamma[5]=0.7031566406;digamma[6]=0.9227843351;digamma[7]=1.1031566406;digamma[8]=1.2561176684;digamma[9]=1.3888709264;digamma[10]=1.5061176684;digamma[11]=1.6110931486;digamma[12]=1.7061176684;digamma[13]=1.7929113304;digamma[14]=1.8727843351;digamma[15]=1.9467574842;digamma[16]=2.0156414780;digamma[17]=2.0800908176;digamma[18]=2.1406414780;digamma[19]=2.1977378764;digamma[20]=2.2517525891;digamma[21]=2.3030010343;digamma[22]=2.3517525891;digamma[23]=2.3982391295;digamma[24]=2.4426616800;digamma[25]=2.4851956513;digamma[26]=2.5259950133;digamma[27]=2.5651956513;digamma[28]=2.6029180902;digamma[29]=2.6392697253;digamma[30]=2.6743466617;digamma[31]=2.7082352426;digamma[32]=2.7410133283;digamma[33]=2.7727513716;digamma[34]=2.8035133283;digamma[35]=2.8333574322;digamma[36]=2.8623368577;digamma[37]=2.8905002894;digamma[38]=2.9178924133;digamma[39]=2.9445543434;digamma[40]=2.9705239922;digamma[41]=2.9958363947;digamma[42]=3.0205239922;digamma[43]=3.0446168825;digamma[44]=3.0681430399;digamma[45]=3.0911285104;digamma[46]=3.1135975853;digamma[47]=3.1355729549;digamma[48]=3.1570758462;digamma[49]=3.1781261464;digamma[50]=3.1987425129;digamma[51]=3.2189424729;digamma[52]=3.2387425129;digamma[53]=3.2581581592;digamma[54]=3.2772040513;digamma[55]=3.2958940082;digamma[56]=3.3142410884;digamma[57]=3.3322576446;digamma[58]=3.3499553741;digamma[59]=3.3673453639;digamma[60]=3.3844381327;digamma[61]=3.4012436690;digamma[62]=3.4177714660;digamma[63]=3.4340305542;digamma[64]=3.4500295305;digamma[65]=3.4657765860;digamma[66]=3.4812795305;digamma[67]=3.4965458167;digamma[68]=3.5115825608;digamma[69]=3.5263965630;digamma[70]=3.5409943255;digamma[71]=3.5553820702;digamma[72]=3.5695657541;digamma[73]=3.5835510843;digamma[74]=3.5973435319;digamma[75]=3.6109483446;digamma[76]=3.6243705589;digamma[77]=3.6376150113;digamma[78]=3.6506863484;digamma[79]=3.6635890372;digamma[80]=3.6763273740;digamma[81]=3.6889054929;digamma[82]=3.7013273740;digamma[83]=3.7135968510;digamma[84]=3.7257176179;digamma[85]=3.7376932365;digamma[86]=3.7495271417;digamma[87]=3.7612226483;digamma[88]=3.7727829557;digamma[89]=3.7842111540;digamma[90]=3.7955102284;digamma[91]=3.8066830641;digamma[92]=3.8177324506;digamma[93]=3.8286610861;digamma[94]=3.8394715811;digamma[95]=3.8501664624;digamma[96]=3.8607481768;digamma[97]=3.8712190940;digamma[98]=3.8815815102;digamma[99]=3.8918376507;digamma[100]=3.9019896734;digamma[101]=3.9120396709;digamma[102]=3.9219896734;digamma[103]=3.9318416511;digamma[104]=3.9415975166;digamma[105]=3.9512591269;digamma[106]=3.9608282858;digamma[107]=3.9703067459;digamma[108]=3.9796962103;digamma[109]=3.9889983347;digamma[110]=3.9982147288;digamma[111]=4.0073469585;digamma[112]=4.0163965470;digamma[113]=4.0253649766;digamma[114]=4.0342536899;digamma[115]=4.0430640916;digamma[116]=4.0517975495;digamma[117]=4.0604553960;digamma[118]=4.0690389288;digamma[119]=4.0775494130;digamma[120]=4.0859880814;digamma[121]=4.0943561357;digamma[122]=4.1026547481;digamma[123]=4.1108850614;digamma[124]=4.1190481907;digamma[125]=4.1271452240;digamma[126]=4.1351772229;digamma[127]=4.1431452240;digamma[128]=4.1510502388;digamma[129]=4.1588932555;digamma[130]=4.1666752388;digamma[131]=4.1743971314;digamma[132]=4.1820598542;digamma[133]=4.1896643070;digamma[134]=4.1972113693;digamma[135]=4.2047019010;digamma[136]=4.2121367425;digamma[137]=4.2195167158;digamma[138]=4.2268426248;digamma[139]=4.2341152559;digamma[140]=4.2413353785;digamma[141]=4.2485037451;digamma[142]=4.2556210927;digamma[143]=4.2626881423;digamma[144]=4.2697055998;digamma[145]=4.2766741563;digamma[146]=4.2835944887;digamma[147]=4.2904672597;digamma[148]=4.2972931188;digamma[149]=4.3040727019;digamma[150]=4.3108066323;digamma[151]=4.3174955207;digamma[152]=4.3241399657;digamma[153]=4.3307405538;digamma[154]=4.3372978604;digamma[155]=4.3438124493;digamma[156]=4.3502848734;digamma[157]=4.3567156751;digamma[158]=4.3631053862;digamma[159]=4.3694545286;digamma[160]=4.3757636140;digamma[161]=4.3820331449;digamma[162]=4.3882636140;digamma[163]=4.3944555052;digamma[164]=4.4006092931;digamma[165]=4.4067254438;digamma[166]=4.4128044150;digamma[167]=4.4188466559;digamma[168]=4.4248526078;digamma[169]=4.4308227038;digamma[170]=4.4367573697;digamma[171]=4.4426570234;digamma[172]=4.4485220756;digamma[173]=4.4543529298;digamma[174]=4.4601499825;digamma[175]=4.4659136234;digamma[176]=4.4716442354;digamma[177]=4.4773421949;digamma[178]=4.4830078718;digamma[179]=4.4886416299;digamma[180]=4.4942438268;digamma[181]=4.4998148143;digamma[182]=4.5053549379;digamma[183]=4.5108645380;digamma[184]=4.5163439489;digamma[185]=4.5217934998;digamma[186]=4.5272135142;digamma[187]=4.5326043106;digamma[188]=4.5379662023;digamma[189]=4.5432994977;digamma[190]=4.5486045002;digamma[191]=4.5538815083;digamma[192]=4.5591308160;digamma[193]=4.5643527125;digamma[194]=4.5695474827;digamma[195]=4.5747154068;digamma[196]=4.5798567610;digamma[197]=4.5849718171;digamma[198]=4.5900608426;digamma[199]=4.5951241013;digamma[200]=4.6001618527;digamma[201]=4.6051743526;digamma[202]=4.6101618527;digamma[203]=4.6151246013;digamma[204]=4.6200628428;digamma[205]=4.6249768181;digamma[206]=4.6298667644;digamma[207]=4.6347329156;digamma[208]=4.6395755023;digamma[209]=4.6443947514;digamma[210]=4.6491908869;digamma[211]=4.6539641294;digamma[212]=4.6587146964;digamma[213]=4.6634428024;digamma[214]=4.6681486587;digamma[215]=4.6728324737;digamma[216]=4.6774944531;digamma[217]=4.6821347993;digamma[218]=4.6867537123;digamma[219]=4.6913513892;digamma[220]=4.6959280243;digamma[221]=4.7004838093;digamma[222]=4.7050189333;digamma[223]=4.7095335830;digamma[224]=4.7140279424;digamma[225]=4.7185021929;digamma[226]=4.7229565138;digamma[227]=4.7273910818;digamma[228]=4.7318060713;digamma[229]=4.7362016545;digamma[230]=4.7405780011;digamma[231]=4.7449352789;digamma[232]=4.7492736533;digamma[233]=4.7535932876;digamma[234]=4.7578943430;digamma[235]=4.7621769786;digamma[236]=4.7664413515;digamma[237]=4.7706876169;digamma[238]=4.7749159278;digamma[239]=4.7791264354;digamma[240]=4.7833192891;digamma[241]=4.7874946363;digamma[242]=4.7916526225;digamma[243]=4.7957933915;digamma[244]=4.7999170853;digamma[245]=4.8040238441;digamma[246]=4.8081138066;digamma[247]=4.8121871094;digamma[248]=4.8162438879;digamma[249]=4.8202842754;digamma[250]=4.8243084040;digamma[251]=4.8283164039;digamma[252]=4.8323084040;digamma[253]=4.8362845314;digamma[254]=4.8402449119;digamma[255]=4.8441896698;digamma[256]=4.8481189277;digamma[257]=4.8520328070;digamma[258]=4.8559314277;digamma[259]=4.8598149082;digamma[260]=4.8636833657;digamma[261]=4.8675369159;digamma[262]=4.8713756734;digamma[263]=4.8751997512;digamma[264]=4.8790092612;digamma[265]=4.8828043139;digamma[266]=4.8865850187;digamma[267]=4.8903514837;digamma[268]=4.8941038157;digamma[269]=4.8978421204;digamma[270]=4.9015665023;digamma[271]=4.9052770647;digamma[272]=4.9089739097;digamma[273]=4.9126571385;digamma[274]=4.9163268509;digamma[275]=4.9199831458;digamma[276]=4.9236261209;digamma[277]=4.9272558731;digamma[278]=4.9308724978;digamma[279]=4.9344760897;digamma[280]=4.9380667424;digamma[281]=4.9416445484;digamma[282]=4.9452095995;digamma[283]=4.9487619862;digamma[284]=4.9523017981;digamma[285]=4.9558291240;digamma[286]=4.9593440516;digamma[287]=4.9628466678;digamma[288]=4.9663370586;digamma[289]=4.9698153089;digamma[290]=4.9732815030;digamma[291]=4.9767357242;digamma[292]=4.9801780548;digamma[293]=4.9836085764;digamma[294]=4.9870273698;digamma[295]=4.9904345150;digamma[296]=4.9938300909;digamma[297]=4.9972141760;digamma[298]=5.0005868477;digamma[299]=5.0039481827;digamma[300]=5.0072982571;digamma[301]=5.0106371459;digamma[302]=5.0139649237;digamma[303]=5.0172816642;digamma[304]=5.0205874403;digamma[305]=5.0238823243;digamma[306]=5.0271663877;digamma[307]=5.0304397013;digamma[308]=5.0337023354;digamma[309]=5.0369543593;digamma[310]=5.0401958419;digamma[311]=5.0434268512;digamma[312]=5.0466474548;digamma[313]=5.0498577194;digamma[314]=5.0530577112;digamma[315]=5.0562474957;digamma[316]=5.0594271379;digamma[317]=5.0625967021;digamma[318]=5.0657562519;digamma[319]=5.0689058504;digamma[320]=5.0720455600;digamma[321]=5.0751754428;digamma[322]=5.0782955600;digamma[323]=5.0814059724;digamma[324]=5.0845067402;digamma[325]=5.0875979229;digamma[326]=5.0906795797;digamma[327]=5.0937517690;digamma[328]=5.0968145490;digamma[329]=5.0998679770;digamma[330]=5.1029121100;digamma[331]=5.1059470043;digamma[332]=5.1089727160;digamma[333]=5.1119893004;digamma[334]=5.1149968124;digamma[335]=5.1179953064;digamma[336]=5.1209848364;digamma[337]=5.1239654557;digamma[338]=5.1269372173;digamma[339]=5.1299001738;digamma[340]=5.1328543771;digamma[341]=5.1357998788;digamma[342]=5.1387367300;digamma[343]=5.1416649814;digamma[344]=5.1445846832;digamma[345]=5.1474958852;digamma[346]=5.1503986367;digamma[347]=5.1532929867;digamma[348]=5.1561789836;digamma[349]=5.1590566754;digamma[350]=5.1619261100;digamma[351]=5.1647873345;digamma[352]=5.1676403957;digamma[353]=5.1704853402;digamma[354]=5.1733222139;digamma[355]=5.1761510625;digamma[356]=5.1789719314;digamma[357]=5.1817848654;digamma[358]=5.1845899089;digamma[359]=5.1873871063;digamma[360]=5.1901765011;digamma[361]=5.1929581369;digamma[362]=5.1957320567;digamma[363]=5.1984983031;digamma[364]=5.2012569185;digamma[365]=5.2040079450;digamma[366]=5.2067514240;digamma[367]=5.2094873970;digamma[368]=5.2122159049;digamma[369]=5.2149369883;digamma[370]=5.2176506875;digamma[371]=5.2203570425;digamma[372]=5.2230560929;digamma[373]=5.2257478781;digamma[374]=5.2284324370;digamma[375]=5.2311098084;digamma[376]=5.2337800306;digamma[377]=5.2364431417;digamma[378]=5.2390991795;digamma[379]=5.2417481815;digamma[380]=5.2443901848;digamma[381]=5.2470252264;digamma[382]=5.2496533427;digamma[383]=5.2522745702;digamma[384]=5.2548889448;digamma[385]=5.2574965023;digamma[386]=5.2600972781;digamma[387]=5.2626913075;digamma[388]=5.2652786253;digamma[389]=5.2678592662;digamma[390]=5.2704332645;digamma[391]=5.2730006543;digamma[392]=5.2755614696;digamma[393]=5.2781157438;digamma[394]=5.2806635104;digamma[395]=5.2832048024;digamma[396]=5.2857396525;digamma[397]=5.2882680935;digamma[398]=5.2907901576;digamma[399]=5.2933058769;digamma[400]=5.2958152832;digamma[401]=5.2983184082;digamma[402]=5.3008152832;digamma[403]=5.3033059394;digamma[404]=5.3057904076;digamma[405]=5.3082687185;digamma[406]=5.3107409026;digamma[407]=5.3132069901;digamma[408]=5.3156670110;digamma[409]=5.3181209951;digamma[410]=5.3205689718;digamma[411]=5.3230109706;digamma[412]=5.3254470206;digamma[413]=5.3278771507;digamma[414]=5.3303013895;digamma[415]=5.3327197657;digamma[416]=5.3351323074;digamma[417]=5.3375390428;digamma[418]=5.3399399997;digamma[419]=5.3423352058;digamma[420]=5.3447246887;digamma[421]=5.3471084755;digamma[422]=5.3494865935;digamma[423]=5.3518590694;digamma[424]=5.3542259300;digamma[425]=5.3565872017;digamma[426]=5.3589429111;digamma[427]=5.3612930841;digamma[428]=5.3636377468;digamma[429]=5.3659769249;digamma[430]=5.3683106440;digamma[431]=5.3706389295;digamma[432]=5.3729618068;digamma[433]=5.3752793007;digamma[434]=5.3775914364;digamma[435]=5.3798982384;digamma[436]=5.3821997313;digamma[437]=5.3844959395;digamma[438]=5.3867868873;digamma[439]=5.3890725986;digamma[440]=5.3913530973;digamma[441]=5.3936284072;digamma[442]=5.3958985519;digamma[443]=5.3981635546;digamma[444]=5.4004234387;digamma[445]=5.4026782273;digamma[446]=5.4049279432;digamma[447]=5.4071726093;digamma[448]=5.4094122482;digamma[449]=5.4116468823;digamma[450]=5.4138765339;digamma[451]=5.4161012252;digamma[452]=5.4183209783;digamma[453]=5.4205358150;digamma[454]=5.4227457571;digamma[455]=5.4249508261;digamma[456]=5.4271510434;digamma[457]=5.4293464305;digamma[458]=5.4315370084;digamma[459]=5.4337227981;digamma[460]=5.4359038206;digamma[461]=5.4380800966;digamma[462]=5.4402516467;digamma[463]=5.4424184914;digamma[464]=5.4445806510;digamma[465]=5.4467381458;digamma[466]=5.4488909958;digamma[467]=5.4510392211;digamma[468]=5.4531828413;digamma[469]=5.4553218763;digamma[470]=5.4574563456;digamma[471]=5.4595862686;digamma[472]=5.4617116647;digamma[473]=5.4638325531;digamma[474]=5.4659489529;digamma[475]=5.4680608829;digamma[476]=5.4701683622;digamma[477]=5.4722714093;digamma[478]=5.4743700428;digamma[479]=5.4764642814;digamma[480]=5.4785541433;digamma[481]=5.4806396467;digamma[482]=5.4827208099;digamma[483]=5.4847976509;digamma[484]=5.4868701875;digamma[485]=5.4889384376;digamma[486]=5.4910024189;digamma[487]=5.4930621490;digamma[488]=5.4951176453;digamma[489]=5.4971689251;digamma[490]=5.4992160059;digamma[491]=5.5012589047;digamma[492]=5.5032976386;digamma[493]=5.5053322245;digamma[494]=5.5073626792;digamma[495]=5.5093890196;digamma[496]=5.5114112622;digamma[497]=5.5134294236;digamma[498]=5.5154435203;digamma[499]=5.5174535685;digamma[500]=5.5194595845;digamma[501]=5.5214615845;digamma[502]=5.5234595845;digamma[503]=5.5254536005;digamma[504]=5.5274436483;digamma[505]=5.5294297436;digamma[506]=5.5314119022;digamma[507]=5.5333901397;digamma[508]=5.5353644714;digamma[509]=5.5373349129;digamma[510]=5.5393014793;digamma[511]=5.5412641859;digamma[512]=5.5432230479;digamma[513]=5.5451780803;digamma[514]=5.5471292979;digamma[515]=5.5490767157;digamma[516]=5.5510203485;digamma[517]=5.5529602109;digamma[518]=5.5548963175;digamma[519]=5.5568286828;digamma[520]=5.5587573214;digamma[521]=5.5606822474;digamma[522]=5.5626034752;digamma[523]=5.5645210190;digamma[524]=5.5664348928;digamma[525]=5.5683451108;digamma[526]=5.5702516867;digamma[527]=5.5721546346;digamma[528]=5.5740539681;digamma[529]=5.5759497010;digamma[530]=5.5778418469;digamma[531]=5.5797304193;digamma[532]=5.5816154318;digamma[533]=5.5834968977;digamma[534]=5.5853748303;digamma[535]=5.5872492429;digamma[536]=5.5891201486;digamma[537]=5.5909875606;digamma[538]=5.5928514919;digamma[539]=5.5947119554;digamma[540]=5.5965689640;digamma[541]=5.5984225306;digamma[542]=5.6002726677;digamma[543]=5.6021193882;digamma[544]=5.6039627046;digamma[545]=5.6058026295;digamma[546]=5.6076391752;digamma[547]=5.6094723543;digamma[548]=5.6113021789;digamma[549]=5.6131286614;digamma[550]=5.6149518139;digamma[551]=5.6167716486;digamma[552]=5.6185881776;digamma[553]=5.6204014127;digamma[554]=5.6222113660;digamma[555]=5.6240180492;digamma[556]=5.6258214743;digamma[557]=5.6276216528;digamma[558]=5.6294185966;digamma[559]=5.6312123171;digamma[560]=5.6330028260;digamma[561]=5.6347901346;digamma[562]=5.6365742545;digamma[563]=5.6383551970;digamma[564]=5.6401329734;digamma[565]=5.6419075949;digamma[566]=5.6436790727;digamma[567]=5.6454474179;digamma[568]=5.6472126416;digamma[569]=5.6489747548;digamma[570]=5.6507337683;digamma[571]=5.6524896932;digamma[572]=5.6542425403;digamma[573]=5.6559923202;digamma[574]=5.6577390438;digamma[575]=5.6594827216;digamma[576]=5.6612233643;digamma[577]=5.6629609825;digamma[578]=5.6646955866;digamma[579]=5.6664271870;digamma[580]=5.6681557942;digamma[581]=5.6698814184;digamma[582]=5.6716040700;digamma[583]=5.6733237592;digamma[584]=5.6750404961;digamma[585]=5.6767542909;digamma[586]=5.6784651537;digamma[587]=5.6801730944;digamma[588]=5.6818781230;digamma[589]=5.6835802494;digamma[590]=5.6852794835;digamma[591]=5.6869758351;digamma[592]=5.6886693140;digamma[593]=5.6903599299;digamma[594]=5.6920476924;digamma[595]=5.6937326112;digamma[596]=5.6954146958;digamma[597]=5.6970939557;digamma[598]=5.6987704005;digamma[599]=5.7004440395;digamma[600]=5.7021148821;digamma[601]=5.7037829376;digamma[602]=5.7054482154;digamma[603]=5.7071107246;digamma[604]=5.7087704745;digamma[605]=5.7104274742;digamma[606]=5.7120817328;digamma[607]=5.7137332593;digamma[608]=5.7153820628;digamma[609]=5.7170281523;digamma[610]=5.7186715365;digamma[611]=5.7203122245;digamma[612]=5.7219502251;digamma[613]=5.7235855469;digamma[614]=5.7252181989;digamma[615]=5.7268481897;digamma[616]=5.7284755279;digamma[617]=5.7301002222;digamma[618]=5.7317222811;digamma[619]=5.7333417133;digamma[620]=5.7349585271;digamma[621]=5.7365727311;digamma[622]=5.7381843336;digamma[623]=5.7397933430;digamma[624]=5.7413997676;digamma[625]=5.7430036158;digamma[626]=5.7446048958;digamma[627]=5.7462036158;digamma[628]=5.7477997840;digamma[629]=5.7493934085;digamma[630]=5.7509844974;digamma[631]=5.7525730587;digamma[632]=5.7541591006;digamma[633]=5.7557426309;digamma[634]=5.7573236575;digamma[635]=5.7589021885;digamma[636]=5.7604782317;digamma[637]=5.7620517948;digamma[638]=5.7636228858;digamma[639]=5.7651915122;digamma[640]=5.7667576820;digamma[641]=5.7683214027;digamma[642]=5.7698826820;digamma[643]=5.7714415275;digamma[644]=5.7729979468;digamma[645]=5.7745519474;digamma[646]=5.7761035369;digamma[647]=5.7776527226;digamma[648]=5.7791995121;digamma[649]=5.7807439127;digamma[650]=5.7822859318;digamma[651]=5.7838255768;digamma[652]=5.7853628549;digamma[653]=5.7868977734;digamma[654]=5.7884303396;digamma[655]=5.7899605606;digamma[656]=5.7914884436;digamma[657]=5.7930139957;digamma[658]=5.7945372240;digamma[659]=5.7960581357;digamma[660]=5.7975767377;digamma[661]=5.7990930371;digamma[662]=5.8006070407;digamma[663]=5.8021187557;digamma[664]=5.8036281888;digamma[665]=5.8051353469;digamma[666]=5.8066402370;digamma[667]=5.8081428657;digamma[668]=5.8096432400;digamma[669]=5.8111413665;digamma[670]=5.8126372520;digamma[671]=5.8141309031;digamma[672]=5.8156223266;digamma[673]=5.8171115290;digamma[674]=5.8185985171;digamma[675]=5.8200832972;digamma[676]=5.8215658761;digamma[677]=5.8230462602;digamma[678]=5.8245244560;digamma[679]=5.8260004699;digamma[680]=5.8274743085;digamma[681]=5.8289459780;digamma[682]=5.8304154850;digamma[683]=5.8318828356;digamma[684]=5.8333480363;digamma[685]=5.8348110933;digamma[686]=5.8362720129;digamma[687]=5.8377308013;digamma[688]=5.8391874648;digamma[689]=5.8406420095;digamma[690]=5.8420944415;digamma[691]=5.8435447671;digamma[692]=5.8449929923;digamma[693]=5.8464391231;digamma[694]=5.8478831657;digamma[695]=5.8493251260;digamma[696]=5.8507650101;digamma[697]=5.8522028238;digamma[698]=5.8536385733;digamma[699]=5.8550722643;digamma[700]=5.8565039028;digamma[701]=5.8579334946;digamma[702]=5.8593610456;digamma[703]=5.8607865617;digamma[704]=5.8622100485;digamma[705]=5.8636315119;digamma[706]=5.8650509576;digamma[707]=5.8664683913;digamma[708]=5.8678838188;digamma[709]=5.8692972456;digamma[710]=5.8707086775;digamma[711]=5.8721181201;digamma[712]=5.8735255789;digamma[713]=5.8749310596;digamma[714]=5.8763345677;digamma[715]=5.8777361087;digamma[716]=5.8791356881;digamma[717]=5.8805333115;digamma[718]=5.8819289842;digamma[719]=5.8833227118;digamma[720]=5.8847144996;digamma[721]=5.8861043530;digamma[722]=5.8874922773;digamma[723]=5.8888782781;digamma[724]=5.8902623604;digamma[725]=5.8916445298;digamma[726]=5.8930247914;digamma[727]=5.8944031505;digamma[728]=5.8957796123;digamma[729]=5.8971541821;digamma[730]=5.8985268651;digamma[731]=5.8998976663;digamma[732]=5.9012665911;digamma[733]=5.9026336444;digamma[734]=5.9039988315;digamma[735]=5.9053621574;digamma[736]=5.9067236272;digamma[737]=5.9080832458;digamma[738]=5.9094410185;digamma[739]=5.9107969501;digamma[740]=5.9121510456;digamma[741]=5.9135033100;digamma[742]=5.9148537483;digamma[743]=5.9162023653;digamma[744]=5.9175491661;digamma[745]=5.9188941554;digamma[746]=5.9202373381;digamma[747]=5.9215787191;digamma[748]=5.9229183033;digamma[749]=5.9242560953;digamma[750]=5.9255921000;digamma[751]=5.9269263223;digamma[752]=5.9282587667;digamma[753]=5.9295894381;digamma[754]=5.9309183412;digamma[755]=5.9322454806;digamma[756]=5.9335708611;digamma[757]=5.9348944872;digamma[758]=5.9362163637;digamma[759]=5.9375364952;digamma[760]=5.9388548861;digamma[761]=5.9401715413;digamma[762]=5.9414864651;digamma[763]=5.9427996622;digamma[764]=5.9441111370;digamma[765]=5.9454208941;digamma[766]=5.9467289381;digamma[767]=5.9480352732;digamma[768]=5.9493399041;digamma[769]=5.9506428352;digamma[770]=5.9519440708;digamma[771]=5.9532436154;digamma[772]=5.9545414734;digamma[773]=5.9558376491;digamma[774]=5.9571321470;digamma[775]=5.9584249712;digamma[776]=5.9597161263;digamma[777]=5.9610056164;digamma[778]=5.9622934459;digamma[779]=5.9635796190;digamma[780]=5.9648641400;digamma[781]=5.9661470131;digamma[782]=5.9674282425;digamma[783]=5.9687078325;digamma[784]=5.9699857873;digamma[785]=5.9712621109;digamma[786]=5.9725368077;digamma[787]=5.9738098816;digamma[788]=5.9750813369;digamma[789]=5.9763511777;digamma[790]=5.9776194080;digamma[791]=5.9788860320;digamma[792]=5.9801510536;digamma[793]=5.9814144770;digamma[794]=5.9826763061;digamma[795]=5.9839365451;digamma[796]=5.9851951978;digamma[797]=5.9864522683;digamma[798]=5.9877077606;digamma[799]=5.9889616786;digamma[800]=5.9902140263;digamma[801]=5.9914648075;digamma[802]=5.9927140263;digamma[803]=5.9939616864;digamma[804]=5.9952077919;digamma[805]=5.9964523465;digamma[806]=5.9976953541;digamma[807]=5.9989368185;digamma[808]=6.0001767436;digamma[809]=6.0014151332;digamma[810]=6.0026519912;digamma[811]=6.0038873211;digamma[812]=6.0051211270;digamma[813]=6.0063534124;digamma[814]=6.0075841811;digamma[815]=6.0088134370;digamma[816]=6.0100411836;digamma[817]=6.0112674247;digamma[818]=6.0124921640;digamma[819]=6.0137154051;digamma[820]=6.0149371518;digamma[821]=6.0161574076;digamma[822]=6.0173761762;digamma[823]=6.0185934612;digamma[824]=6.0198092662;digamma[825]=6.0210235948;digamma[826]=6.0222364506;digamma[827]=6.0234478372;digamma[828]=6.0246577582;digamma[829]=6.0258662169;digamma[830]=6.0270732171;digamma[831]=6.0282787622;digamma[832]=6.0294828556;digamma[833]=6.0306855010;digamma[834]=6.0318867018;digamma[835]=6.0330864614;digamma[836]=6.0342847833;digamma[837]=6.0354816710;digamma[838]=6.0366771278;digamma[839]=6.0378711573;digamma[840]=6.0390637627;digamma[841]=6.0402549475;digamma[842]=6.0414447151;digamma[843]=6.0426330688;digamma[844]=6.0438200120;digamma[845]=6.0450055480;digamma[846]=6.0461896802;digamma[847]=6.0473724119;digamma[848]=6.0485537464;digamma[849]=6.0497336870;digamma[850]=6.0509122370;digamma[851]=6.0520893996;digamma[852]=6.0532651782;digamma[853]=6.0544395759;digamma[854]=6.0556125960;digamma[855]=6.0567842418;digamma[856]=6.0579545164;digamma[857]=6.0591234230;digamma[858]=6.0602909650;digamma[859]=6.0614571453;digamma[860]=6.0626219673;digamma[861]=6.0637854340;digamma[862]=6.0649475487;digamma[863]=6.0661083144;digamma[864]=6.0672677343;digamma[865]=6.0684258115;digamma[866]=6.0695825491;digamma[867]=6.0707379502;digamma[868]=6.0718920179;digamma[869]=6.0730447553;digamma[870]=6.0741961654;digamma[871]=6.0753462513;digamma[872]=6.0764950160;digamma[873]=6.0776424625;digamma[874]=6.0787885940;digamma[875]=6.0799334133;digamma[876]=6.0810769235;digamma[877]=6.0822191276;digamma[878]=6.0833600285;digamma[879]=6.0844996293;digamma[880]=6.0856379328;digamma[881]=6.0867749421;digamma[882]=6.0879106601;digamma[883]=6.0890450897;digamma[884]=6.0901782338;digamma[885]=6.0913100954;digamma[886]=6.0924406772;digamma[887]=6.0935699824;digamma[888]=6.0946980136;digamma[889]=6.0958247738;digamma[890]=6.0969502658;digamma[891]=6.0980744926;digamma[892]=6.0991974568;digamma[893]=6.1003191615;digamma[894]=6.1014396093;digamma[895]=6.1025588031;digamma[896]=6.1036767458;digamma[897]=6.1047934400;digamma[898]=6.1059088886;digamma[899]=6.1070230944;digamma[900]=6.1081360601;digamma[901]=6.1092477885;digamma[902]=6.1103582824;digamma[903]=6.1114675444;digamma[904]=6.1125755773;digamma[905]=6.1136823838;digamma[906]=6.1147879666;digamma[907]=6.1158923285;digamma[908]=6.1169954722;digamma[909]=6.1180974002;digamma[910]=6.1191981153;digamma[911]=6.1202976202;digamma[912]=6.1213959175;digamma[913]=6.1224930099;digamma[914]=6.1235889000;digamma[915]=6.1246835904;digamma[916]=6.1257770838;digamma[917]=6.1268693827;digamma[918]=6.1279604899;digamma[919]=6.1290504078;digamma[920]=6.1301391391;digamma[921]=6.1312266864;digamma[922]=6.1323130522;digamma[923]=6.1333982391;digamma[924]=6.1344822496;digamma[925]=6.1355650863;digamma[926]=6.1366467517;digamma[927]=6.1377272485;digamma[928]=6.1388065790;digamma[929]=6.1398847458;digamma[930]=6.1409617514;digamma[931]=6.1420375983;digamma[932]=6.1431122890;digamma[933]=6.1441858260;digamma[934]=6.1452582118;digamma[935]=6.1463294487;digamma[936]=6.1473995394;digamma[937]=6.1484684862;digamma[938]=6.1495362915;digamma[939]=6.1506029579;digamma[940]=6.1516684877;digamma[941]=6.1527328833;digamma[942]=6.1537961472;digamma[943]=6.1548582818;digamma[944]=6.1559192895;digamma[945]=6.1569791726;digamma[946]=6.1580379336;digamma[947]=6.1590955747;digamma[948]=6.1601520985;digamma[949]=6.1612075071;digamma[950]=6.1622618031;digamma[951]=6.1633149887;digamma[952]=6.1643670663;digamma[953]=6.1654180381;digamma[954]=6.1664679066;digamma[955]=6.1675166740;digamma[956]=6.1685643427;digamma[957]=6.1696109149;digamma[958]=6.1706563929;digamma[959]=6.1717007790;digamma[960]=6.1727440755;digamma[961]=6.1737862847;digamma[962]=6.1748274089;digamma[963]=6.1758674502;digamma[964]=6.1769064110;digamma[965]=6.1779442934;digamma[966]=6.1789810998;digamma[967]=6.1800168323;digamma[968]=6.1810514931;digamma[969]=6.1820850846;digamma[970]=6.1831176088;digamma[971]=6.1841490681;digamma[972]=6.1851794645;digamma[973]=6.1862088003;digamma[974]=6.1872370777;digamma[975]=6.1882642988;digamma[976]=6.1892904658;digamma[977]=6.1903155808;digamma[978]=6.1913396461;digamma[979]=6.1923626637;digamma[980]=6.1933846359;digamma[981]=6.1944055646;digamma[982]=6.1954254522;digamma[983]=6.1964443006;digamma[984]=6.1974621121;digamma[985]=6.1984788886;digamma[986]=6.1994946324;digamma[987]=6.2005093455;digamma[988]=6.2015230300;digamma[989]=6.2025356879;digamma[990]=6.2035473215;digamma[991]=6.2045579326;digamma[992]=6.2055675235;digamma[993]=6.2065760961;digamma[994]=6.2075836525;digamma[995]=6.2085901948;digamma[996]=6.2095957249;digamma[997]=6.2106002450;digamma[998]=6.2116037571;digamma[999]=6.2126062631;digamma[1000]=6.2136077651;digamma[1001]=6.2146082651;digamma[1002]=6.2156077651;digamma[1003]=6.2166062671;digamma[1004]=6.2176037731;digamma[1005]=6.2186002850;digamma[1006]=6.2195958049;digamma[1007]=6.2205903348;digamma[1008]=6.2215838765;digamma[1009]=6.2225764321;digamma[1010]=6.2235680035;digamma[1011]=6.2245585927;digamma[1012]=6.2255482015;digamma[1013]=6.2265368320;digamma[1014]=6.2275244861;digamma[1015]=6.2285111657;digamma[1016]=6.2294968727;digamma[1017]=6.2304816090;digamma[1018]=6.2314653766;digamma[1019]=6.2324481774;digamma[1020]=6.2334300132;digamma[1021]=6.2344108859;digamma[1022]=6.2353907975;digamma[1023]=6.2363697498;digamma[1024]=6.2373477446;digamma[1025]=6.2383247840;digamma[1026]=6.2393008696;digamma[1027]=6.2402760035;digamma[1028]=6.2412501874;digamma[1029]=6.2422234232;digamma[1030]=6.2431957127;digamma[1031]=6.2441670578;digamma[1032]=6.2451374603;digamma[1033]=6.2461069220;digamma[1034]=6.2470754447;digamma[1035]=6.2480430304;digamma[1036]=6.2490096807;digamma[1037]=6.2499753975;digamma[1038]=6.2509401827;digamma[1039]=6.2519040379;digamma[1040]=6.2528669649;digamma[1041]=6.2538289657;digamma[1042]=6.2547900419;digamma[1043]=6.2557501953;digamma[1044]=6.2567094276;digamma[1045]=6.2576677408;digamma[1046]=6.2586251365;digamma[1047]=6.2595816164;digamma[1048]=6.2605371823;digamma[1049]=6.2614918361;digamma[1050]=6.2624455793;digamma[1051]=6.2633984138;digamma[1052]=6.2643503412;digamma[1053]=6.2653013633;digamma[1054]=6.2662514819;digamma[1055]=6.2672006986;digamma[1056]=6.2681490151;digamma[1057]=6.2690964332;digamma[1058]=6.2700429545;digamma[1059]=6.2709885808;digamma[1060]=6.2719333137;digamma[1061]=6.2728771549;digamma[1062]=6.2738201061;digamma[1063]=6.2747621690;digamma[1064]=6.2757033453;digamma[1065]=6.2766436366;digamma[1066]=6.2775830445;digamma[1067]=6.2785215708;digamma[1068]=6.2794592171;digamma[1069]=6.2803959851;digamma[1070]=6.2813318763;digamma[1071]=6.2822668925;digamma[1072]=6.2832010352;digamma[1073]=6.2841343061;digamma[1074]=6.2850667068;digamma[1075]=6.2859982390;digamma[1076]=6.2869289042;digamma[1077]=6.2878587041;digamma[1078]=6.2887876403;digamma[1079]=6.2897157143;digamma[1080]=6.2906429279;digamma[1081]=6.2915692824;digamma[1082]=6.2924947797;digamma[1083]=6.2934194212;digamma[1084]=6.2943432085;digamma[1085]=6.2952661433;digamma[1086]=6.2961882270;digamma[1087]=6.2971094612;digamma[1088]=6.2980298476;digamma[1089]=6.2989493877;digamma[1090]=6.2998680829;digamma[1091]=6.3007859349;digamma[1092]=6.3017029453;digamma[1093]=6.3026191155;digamma[1094]=6.3035344471;digamma[1095]=6.3044489417;digamma[1096]=6.3053626007;digamma[1097]=6.3062754257;digamma[1098]=6.3071874182;digamma[1099]=6.3080985798;digamma[1100]=6.3090089118;digamma[1101]=6.3099184160;digamma[1102]=6.3108270937;digamma[1103]=6.3117349464;digamma[1104]=6.3126419757;digamma[1105]=6.3135481830;digamma[1106]=6.3144535699;digamma[1107]=6.3153581378;digamma[1108]=6.3162618882;digamma[1109]=6.3171648225;digamma[1110]=6.3180669423;digamma[1111]=6.3189682490;digamma[1112]=6.3198687441;digamma[1113]=6.3207684290;digamma[1114]=6.3216673053;digamma[1115]=6.3225653742;digamma[1116]=6.3234626374;digamma[1117]=6.3243590962;digamma[1118]=6.3252547521;digamma[1119]=6.3261496065;digamma[1120]=6.3270436609;digamma[1121]=6.3279369166;digamma[1122]=6.3288293751;digamma[1123]=6.3297210379;digamma[1124]=6.3306119063;digamma[1125]=6.3315019818;digamma[1126]=6.3323912658;digamma[1127]=6.3332797596;digamma[1128]=6.3341674647;digamma[1129]=6.3350543825;digamma[1130]=6.3359405143;digamma[1131]=6.3368258617;digamma[1132]=6.3377104258;digamma[1133]=6.3385942083;digamma[1134]=6.3394772103;digamma[1135]=6.3403594333;digamma[1136]=6.3412408787;digamma[1137]=6.3421215479;digamma[1138]=6.3430014421;digamma[1139]=6.3438805628;digamma[1140]=6.3447589114;digamma[1141]=6.3456364891;digamma[1142]=6.3465132973;digamma[1143]=6.3473893375;digamma[1144]=6.3482646108;digamma[1145]=6.3491391187;digamma[1146]=6.3500128626;digamma[1147]=6.3508858436;digamma[1148]=6.3517580633;digamma[1149]=6.3526295228;digamma[1150]=6.3535002235;digamma[1151]=6.3543701668;digamma[1152]=6.3552393540;digamma[1153]=6.3561077863;digamma[1154]=6.3569754651;digamma[1155]=6.3578423917;digamma[1156]=6.3587085673;digamma[1157]=6.3595739934;digamma[1158]=6.3604386711;digamma[1159]=6.3613026019;digamma[1160]=6.3621657869;digamma[1161]=6.3630282274;digamma[1162]=6.3638899248;digamma[1163]=6.3647508803;digamma[1164]=6.3656110952;digamma[1165]=6.3664705707;digamma[1166]=6.3673293082;digamma[1167]=6.3681873089;digamma[1168]=6.3690445741;digamma[1169]=6.3699011050;digamma[1170]=6.3707569029;digamma[1171]=6.3716119690;digamma[1172]=6.3724663046;digamma[1173]=6.3733199109;digamma[1174]=6.3741727892;digamma[1175]=6.3750249408;digamma[1176]=6.3758763667;digamma[1177]=6.3767270684;digamma[1178]=6.3775770470;digamma[1179]=6.3784263038;digamma[1180]=6.3792748399;digamma[1181]=6.3801226566;digamma[1182]=6.3809697551;digamma[1183]=6.3818161367;digamma[1184]=6.3826618025;digamma[1185]=6.3835067538;digamma[1186]=6.3843509917;digamma[1187]=6.3851945175;digamma[1188]=6.3860373323;digamma[1189]=6.3868794375;digamma[1190]=6.3877208340;digamma[1191]=6.3885615232;digamma[1192]=6.3894015063;digamma[1193]=6.3902407844;digamma[1194]=6.3910793586;digamma[1195]=6.3919172303;digamma[1196]=6.3927544005;digamma[1197]=6.3935908705;digamma[1198]=6.3944266413;digamma[1199]=6.3952617142;digamma[1200]=6.3960960904;digamma[1201]=6.3969297710;digamma[1202]=6.3977627571;digamma[1203]=6.3985950499;digamma[1204]=6.3994266506;digamma[1205]=6.4002575603;digamma[1206]=6.4010877801;digamma[1207]=6.4019173113;digamma[1208]=6.4027461549;digamma[1209]=6.4035743121;digamma[1210]=6.4044017841;digamma[1211]=6.4052285719;digamma[1212]=6.4060546766;digamma[1213]=6.4068800995;digamma[1214]=6.4077048417;digamma[1215]=6.4085289041;digamma[1216]=6.4093522881;digamma[1217]=6.4101749947;digamma[1218]=6.4109970250;digamma[1219]=6.4118183801;digamma[1220]=6.4126390611;digamma[1221]=6.4134590691;digamma[1222]=6.4142784053;digamma[1223]=6.4150970708;digamma[1224]=6.4159150666;digamma[1225]=6.4167323938;digamma[1226]=6.4175490535;digamma[1227]=6.4183650468;digamma[1228]=6.4191803749;digamma[1229]=6.4199950387;digamma[1230]=6.4208090393;digamma[1231]=6.4216223780;digamma[1232]=6.4224350556;digamma[1233]=6.4232470733;digamma[1234]=6.4240584322;digamma[1235]=6.4248691334;digamma[1236]=6.4256791778;digamma[1237]=6.4264885666;digamma[1238]=6.4272973008;digamma[1239]=6.4281053814;digamma[1240]=6.4289128096;digamma[1241]=6.4297195864;digamma[1242]=6.4305257129;digamma[1243]=6.4313311900;digamma[1244]=6.4321360188;digamma[1245]=6.4329402004;digamma[1246]=6.4337437359;digamma[1247]=6.4345466261;digamma[1248]=6.4353488723;digamma[1249]=6.4361504754;digamma[1250]=6.4369514364;digamma[1251]=6.4377517564;digamma[1252]=6.4385514364;digamma[1253]=6.4393504774;digamma[1254]=6.4401488805;digamma[1255]=6.4409466466;digamma[1256]=6.4417437768;digamma[1257]=6.4425402721;digamma[1258]=6.4433361335;digamma[1259]=6.4441313620;digamma[1260]=6.4449259586;digamma[1261]=6.4457199244;digamma[1262]=6.4465132602;digamma[1263]=6.4473059672;digamma[1264]=6.4480980463;digamma[1265]=6.4488894985;digamma[1266]=6.4496803248;digamma[1267]=6.4504705261;digamma[1268]=6.4512601036;digamma[1269]=6.4520490581;digamma[1270]=6.4528373907;digamma[1271]=6.4536251022;digamma[1272]=6.4544121938;digamma[1273]=6.4551986663;digamma[1274]=6.4559845208;digamma[1275]=6.4567697583;digamma[1276]=6.4575543796;digamma[1277]=6.4583383857;digamma[1278]=6.4591217777;digamma[1279]=6.4599045564;digamma[1280]=6.4606867229;digamma[1281]=6.4614682781;digamma[1282]=6.4622492229;digamma[1283]=6.4630295583;digamma[1284]=6.4638092853;digamma[1285]=6.4645884048;digamma[1286]=6.4653669177;digamma[1287]=6.4661448250;digamma[1288]=6.4669221277;digamma[1289]=6.4676988266;digamma[1290]=6.4684749227;digamma[1291]=6.4692504169;digamma[1292]=6.4700253103;digamma[1293]=6.4707996036;digamma[1294]=6.4715732979;digamma[1295]=6.4723463940;digamma[1296]=6.4731188930;digamma[1297]=6.4738907956;digamma[1298]=6.4746621028;digamma[1299]=6.4754328156;digamma[1300]=6.4762029349;digamma[1301]=6.4769724615;digamma[1302]=6.4777413964;digamma[1303]=6.4785097405;digamma[1304]=6.4792774947;digamma[1305]=6.4800446599;digamma[1306]=6.4808112371;digamma[1307]=6.4815772270;digamma[1308]=6.4823426306;digamma[1309]=6.4831074489;digamma[1310]=6.4838716826;digamma[1311]=6.4846353328;digamma[1312]=6.4853984002;digamma[1313]=6.4861608858;digamma[1314]=6.4869227904;digamma[1315]=6.4876841150;digamma[1316]=6.4884448604;digamma[1317]=6.4892050276;digamma[1318]=6.4899646173;digamma[1319]=6.4907236304;digamma[1320]=6.4914820680;digamma[1321]=6.4922399307;digamma[1322]=6.4929972195;digamma[1323]=6.4937539352;digamma[1324]=6.4945100788;digamma[1325]=6.4952656510;digamma[1326]=6.4960206528;digamma[1327]=6.4967750850;digamma[1328]=6.4975289484;digamma[1329]=6.4982822440;digamma[1330]=6.4990349725;digamma[1331]=6.4997871349;digamma[1332]=6.5005387319;digamma[1333]=6.5012897645;digamma[1334]=6.5020402334;digamma[1335]=6.5027901396;digamma[1336]=6.5035394838;digamma[1337]=6.5042882669;digamma[1338]=6.5050364898;digamma[1339]=6.5057841532;digamma[1340]=6.5065312581;digamma[1341]=6.5072778052;digamma[1342]=6.5080237954;digamma[1343]=6.5087692295;digamma[1344]=6.5095141084;digamma[1345]=6.5102584328;digamma[1346]=6.5110022036;digamma[1347]=6.5117454216;digamma[1348]=6.5124880877;digamma[1349]=6.5132302026;digamma[1350]=6.5139717672;digamma[1351]=6.5147127823;digamma[1352]=6.5154532487;digamma[1353]=6.5161931672;digamma[1354]=6.5169325387;digamma[1355]=6.5176713638;digamma[1356]=6.5184096435;digamma[1357]=6.5191473786;digamma[1358]=6.5198845698;digamma[1359]=6.5206212179;digamma[1360]=6.5213573238;digamma[1361]=6.5220928883;digamma[1362]=6.5228279121;digamma[1363]=6.5235623960;digamma[1364]=6.5242963408;digamma[1365]=6.5250297474;digamma[1366]=6.5257626165;digamma[1367]=6.5264949489;digamma[1368]=6.5272267454;digamma[1369]=6.5279580067;digamma[1370]=6.5286887337;digamma[1371]=6.5294189271;digamma[1372]=6.5301485877;digamma[1373]=6.5308777163;digamma[1374]=6.5316063136;digamma[1375]=6.5323343805;digamma[1376]=6.5330619177;digamma[1377]=6.5337889260;digamma[1378]=6.5345154061;digamma[1379]=6.5352413588;digamma[1380]=6.5359667849;digamma[1381]=6.5366916851;digamma[1382]=6.5374160602;digamma[1383]=6.5381399110;digamma[1384]=6.5388632382;digamma[1385]=6.5395860426;digamma[1386]=6.5403083249;digamma[1387]=6.5410300860;digamma[1388]=6.5417513264;digamma[1389]=6.5424720470;digamma[1390]=6.5431922486;digamma[1391]=6.5439119318;digamma[1392]=6.5446310975;digamma[1393]=6.5453497463;digamma[1394]=6.5460678791;digamma[1395]=6.5467854965;digamma[1396]=6.5475025993;digamma[1397]=6.5482191883;digamma[1398]=6.5489352641;digamma[1399]=6.5496508275;digamma[1400]=6.5503658793;digamma[1401]=6.5510804201;digamma[1402]=6.5517944507;digamma[1403]=6.5525079718;digamma[1404]=6.5532209842;digamma[1405]=6.5539334886;digamma[1406]=6.5546454856;digamma[1407]=6.5553569761;digamma[1408]=6.5560679607;digamma[1409]=6.5567784402;digamma[1410]=6.5574884153;digamma[1411]=6.5581978866;digamma[1412]=6.5589068550;digamma[1413]=6.5596153211;digamma[1414]=6.5603232856;digamma[1415]=6.5610307493;digamma[1416]=6.5617377128;digamma[1417]=6.5624441768;digamma[1418]=6.5631501421;digamma[1419]=6.5638556094;digamma[1420]=6.5645605794;digamma[1421]=6.5652650527;digamma[1422]=6.5659690301;digamma[1423]=6.5666725122;digamma[1424]=6.5673754998;digamma[1425]=6.5680779936;digamma[1426]=6.5687799942;digamma[1427]=6.5694815024;digamma[1428]=6.5701825188;digamma[1429]=6.5708830441;digamma[1430]=6.5715830790;digamma[1431]=6.5722826242;digamma[1432]=6.5729816804;digamma[1433]=6.5736802482;digamma[1434]=6.5743783284;digamma[1435]=6.5750759216;digamma[1436]=6.5757730286;digamma[1437]=6.5764696499;digamma[1438]=6.5771657862;digamma[1439]=6.5778614383;digamma[1440]=6.5785566068;digamma[1441]=6.5792512924;digamma[1442]=6.5799454957;digamma[1443]=6.5806392174;digamma[1444]=6.5813324583;digamma[1445]=6.5820252188;digamma[1446]=6.5827174998;digamma[1447]=6.5834093019;digamma[1448]=6.5841006257;digamma[1449]=6.5847914719;digamma[1450]=6.5854818411;digamma[1451]=6.5861717341;digamma[1452]=6.5868611515;digamma[1453]=6.5875500939;digamma[1454]=6.5882385620;digamma[1455]=6.5889265564;digamma[1456]=6.5896140778;digamma[1457]=6.5903011268;digamma[1458]=6.5909877041;digamma[1459]=6.5916738104;digamma[1460]=6.5923594463;digamma[1461]=6.5930446123;digamma[1462]=6.5937293093;digamma[1463]=6.5944135377;digamma[1464]=6.5950972983;digamma[1465]=6.5957805917;digamma[1466]=6.5964634185;digamma[1467]=6.5971457794;digamma[1468]=6.5978276750;digamma[1469]=6.5985091060;digamma[1470]=6.5991900728;digamma[1471]=6.5998705763;digamma[1472]=6.6005506171;digamma[1473]=6.6012301956;digamma[1474]=6.6019093127;digamma[1475]=6.6025879689;digamma[1476]=6.6032661648;digamma[1477]=6.6039439011;digamma[1478]=6.6046211784;digamma[1479]=6.6052979972;digamma[1480]=6.6059743583;digamma[1481]=6.6066502623;digamma[1482]=6.6073257097;digamma[1483]=6.6080007012;digamma[1484]=6.6086752374;digamma[1485]=6.6093493188;digamma[1486]=6.6100229463;digamma[1487]=6.6106961202;digamma[1488]=6.6113688413;digamma[1489]=6.6120411101;digamma[1490]=6.6127129273;digamma[1491]=6.6133842935;digamma[1492]=6.6140552092;digamma[1493]=6.6147256751;digamma[1494]=6.6153956917;digamma[1495]=6.6160652598;digamma[1496]=6.6167343798;digamma[1497]=6.6174030524;digamma[1498]=6.6180712782;digamma[1499]=6.6187390578;digamma[1500]=6.6194063917;digamma[1501]=6.6200732806;digamma[1502]=6.6207397250;digamma[1503]=6.6214057256;digamma[1504]=6.6220712830;digamma[1505]=6.6227363976;digamma[1506]=6.6234010702;digamma[1507]=6.6240653013;digamma[1508]=6.6247290915;digamma[1509]=6.6253924413;digamma[1510]=6.6260553514;digamma[1511]=6.6267178223;digamma[1512]=6.6273798547;digamma[1513]=6.6280414491;digamma[1514]=6.6287026060;digamma[1515]=6.6293633261;digamma[1516]=6.6300236100;digamma[1517]=6.6306834582;digamma[1518]=6.6313428712;digamma[1519]=6.6320018497;digamma[1520]=6.6326603943;digamma[1521]=6.6333185054;digamma[1522]=6.6339761837;digamma[1523]=6.6346334298;digamma[1524]=6.6352902442;digamma[1525]=6.6359466274;digamma[1526]=6.6366025801;digamma[1527]=6.6372581029;digamma[1528]=6.6379131961;digamma[1529]=6.6385678606;digamma[1530]=6.6392220967;digamma[1531]=6.6398759050;digamma[1532]=6.6405292862;digamma[1533]=6.6411822408;digamma[1534]=6.6418347692;digamma[1535]=6.6424868722;digamma[1536]=6.6431385502;digamma[1537]=6.6437898038;digamma[1538]=6.6444406335;digamma[1539]=6.6450910400;digamma[1540]=6.6457410236;digamma[1541]=6.6463905851;digamma[1542]=6.6470397249;digamma[1543]=6.6476884437;digamma[1544]=6.6483367418;digamma[1545]=6.6489846199;digamma[1546]=6.6496320786;digamma[1547]=6.6502791183;digamma[1548]=6.6509257397;digamma[1549]=6.6515719431;digamma[1550]=6.6522177293;digamma[1551]=6.6528630987;digamma[1552]=6.6535080519;digamma[1553]=6.6541525894;digamma[1554]=6.6547967117;digamma[1555]=6.6554404194;digamma[1556]=6.6560837130;digamma[1557]=6.6567265930;digamma[1558]=6.6573690600;digamma[1559]=6.6580111145;digamma[1560]=6.6586527571;digamma[1561]=6.6592939882;digamma[1562]=6.6599348084;digamma[1563]=6.6605752182;digamma[1564]=6.6612152181;digamma[1565]=6.6618548087;digamma[1566]=6.6624939905;digamma[1567]=6.6631327640;digamma[1568]=6.6637711297;digamma[1569]=6.6644090881;digamma[1570]=6.6650466399;digamma[1571]=6.6656837854;digamma[1572]=6.6663205252;digamma[1573]=6.6669568599;digamma[1574]=6.6675927899;digamma[1575]=6.6682283157;digamma[1576]=6.6688634379;digamma[1577]=6.6694981570;digamma[1578]=6.6701324734;digamma[1579]=6.6707663878;digamma[1580]=6.6713999005;digamma[1581]=6.6720330122;digamma[1582]=6.6726657233;digamma[1583]=6.6732980344;digamma[1584]=6.6739299458;digamma[1585]=6.6745614582;digamma[1586]=6.6751925721;digamma[1587]=6.6758232879;digamma[1588]=6.6764536061;digamma[1589]=6.6770835273;digamma[1590]=6.6777130520;digamma[1591]=6.6783421806;digamma[1592]=6.6789709136;digamma[1593]=6.6795992516;digamma[1594]=6.6802271950;digamma[1595]=6.6808547444;digamma[1596]=6.6814819002;digamma[1597]=6.6821086629;digamma[1598]=6.6827350330;digamma[1599]=6.6833610110;digamma[1600]=6.6839865975;digamma[1601]=6.6846117928;digamma[1602]=6.6852365975;digamma[1603]=6.6858610120;digamma[1604]=6.6864850369;digamma[1605]=6.6871086726;digamma[1606]=6.6877319197;digamma[1607]=6.6883547786;digamma[1608]=6.6889772497;digamma[1609]=6.6895993336;digamma[1610]=6.6902210308;digamma[1611]=6.6908423417;digamma[1612]=6.6914632668;digamma[1613]=6.6920838066;digamma[1614]=6.6927039616;digamma[1615]=6.6933237322;digamma[1616]=6.6939431190;digamma[1617]=6.6945621223;digamma[1618]=6.6951807428;digamma[1619]=6.6957989807;digamma[1620]=6.6964168367;digamma[1621]=6.6970343112;digamma[1622]=6.6976514046;digamma[1623]=6.6982681175;digamma[1624]=6.6988844502;digamma[1625]=6.6995004034;digamma[1626]=6.7001159773;digamma[1627]=6.7007311726;digamma[1628]=6.7013459896;digamma[1629]=6.7019604289;digamma[1630]=6.7025744908;digamma[1631]=6.7031881760;digamma[1632]=6.7038014847;digamma[1633]=6.7044144175;digamma[1634]=6.7050269749;digamma[1635]=6.7056391573;digamma[1636]=6.7062509651;digamma[1637]=6.7068623989;digamma[1638]=6.7074734590;digamma[1639]=6.7080841460;digamma[1640]=6.7086944602;digamma[1641]=6.7093044022;digamma[1642]=6.7099139724;digamma[1643]=6.7105231713;digamma[1644]=6.7111319992;digamma[1645]=6.7117404567;digamma[1646]=6.7123485442;digamma[1647]=6.7129562622;digamma[1648]=6.7135636111;digamma[1649]=6.7141705913;digamma[1650]=6.7147772033;digamma[1651]=6.7153834476;digamma[1652]=6.7159893245;digamma[1653]=6.7165948346;digamma[1654]=6.7171999783;digamma[1655]=6.7178047559;digamma[1656]=6.7184091681;digamma[1657]=6.7190132152;digamma[1658]=6.7196168976;digamma[1659]=6.7202202158;digamma[1660]=6.7208231702;digamma[1661]=6.7214257613;digamma[1662]=6.7220279895;digamma[1663]=6.7226298552;digamma[1664]=6.7232313589;digamma[1665]=6.7238325010;digamma[1666]=6.7244332820;digamma[1667]=6.7250337022;digamma[1668]=6.7256337622;digamma[1669]=6.7262334623;digamma[1670]=6.7268328029;digamma[1671]=6.7274317846;digamma[1672]=6.7280304077;digamma[1673]=6.7286286727;digamma[1674]=6.7292265800;digamma[1675]=6.7298241300;digamma[1676]=6.7304213231;digamma[1677]=6.7310181598;digamma[1678]=6.7316146405;digamma[1679]=6.7322107657;digamma[1680]=6.7328065356;digamma[1681]=6.7334019509;digamma[1682]=6.7339970118;digamma[1683]=6.7345917189;digamma[1684]=6.7351860725;digamma[1685]=6.7357800730;digamma[1686]=6.7363737209;digamma[1687]=6.7369670166;digamma[1688]=6.7375599605;digamma[1689]=6.7381525531;digamma[1690]=6.7387447947;digamma[1691]=6.7393366857;digamma[1692]=6.7399282266;digamma[1693]=6.7405194178;digamma[1694]=6.7411102597;digamma[1695]=6.7417007527;digamma[1696]=6.7422908973;digamma[1697]=6.7428806937;digamma[1698]=6.7434701425;digamma[1699]=6.7440592441;digamma[1700]=6.7446479989;digamma[1701]=6.7452364072;digamma[1702]=6.7458244694;digamma[1703]=6.7464121861;digamma[1704]=6.7469995576;digamma[1705]=6.7475865842;digamma[1706]=6.7481732665;digamma[1707]=6.7487596048;digamma[1708]=6.7493455994;digamma[1709]=6.7499312509;digamma[1710]=6.7505165596;digamma[1711]=6.7511015259;digamma[1712]=6.7516861503;digamma[1713]=6.7522704330;digamma[1714]=6.7528543746;digamma[1715]=6.7534379753;digamma[1716]=6.7540212357;digamma[1717]=6.7546041561;digamma[1718]=6.7551867369;digamma[1719]=6.7557689785;digamma[1720]=6.7563508812;digamma[1721]=6.7569324456;digamma[1722]=6.7575136719;digamma[1723]=6.7580945606;digamma[1724]=6.7586751121;digamma[1725]=6.7592553267;digamma[1726]=6.7598352049;digamma[1727]=6.7604147470;digamma[1728]=6.7609939535;digamma[1729]=6.7615728246;digamma[1730]=6.7621513609;digamma[1731]=6.7627295626;digamma[1732]=6.7633074302;digamma[1733]=6.7638849641;digamma[1734]=6.7644621647;digamma[1735]=6.7650390322;digamma[1736]=6.7656155672;digamma[1737]=6.7661917700;digamma[1738]=6.7667676409;digamma[1739]=6.7673431804;digamma[1740]=6.7679183889;digamma[1741]=6.7684932667;digamma[1742]=6.7690678142;digamma[1743]=6.7696420318;digamma[1744]=6.7702159198;digamma[1745]=6.7707894787;digamma[1746]=6.7713627088;digamma[1747]=6.7719356105;digamma[1748]=6.7725081842;digamma[1749]=6.7730804302;digamma[1750]=6.7736523489;digamma[1751]=6.7742239408;digamma[1752]=6.7747952061;digamma[1753]=6.7753661452;digamma[1754]=6.7759367586;digamma[1755]=6.7765070465;digamma[1756]=6.7770770095;digamma[1757]=6.7776466477;digamma[1758]=6.7782159616;digamma[1759]=6.7787849516;digamma[1760]=6.7793536180;digamma[1761]=6.7799219613;digamma[1762]=6.7804899817;digamma[1763]=6.7810576796;digamma[1764]=6.7816250555;digamma[1765]=6.7821921096;digamma[1766]=6.7827588423;digamma[1767]=6.7833252540;digamma[1768]=6.7838913451;digamma[1769]=6.7844571160;digamma[1770]=6.7850225669;digamma[1771]=6.7855876982;digamma[1772]=6.7861525104;digamma[1773]=6.7867170037;digamma[1774]=6.7872811785;digamma[1775]=6.7878450353;digamma[1776]=6.7884085742;digamma[1777]=6.7889717958;digamma[1778]=6.7895347004;digamma[1779]=6.7900972882;digamma[1780]=6.7906595598;digamma[1781]=6.7912215153;digamma[1782]=6.7917831553;digamma[1783]=6.7923444800;digamma[1784]=6.7929054897;digamma[1785]=6.7934661849;digamma[1786]=6.7940265660;digamma[1787]=6.7945866331;digamma[1788]=6.7951463868;digamma[1789]=6.7957058273;digamma[1790]=6.7962649550;digamma[1791]=6.7968237703;digamma[1792]=6.7973822735;digamma[1793]=6.7979404649;digamma[1794]=6.7984983449;digamma[1795]=6.7990559138;digamma[1796]=6.7996131721;digamma[1797]=6.8001701200;digamma[1798]=6.8007267578;digamma[1799]=6.8012830860;digamma[1800]=6.8018391049;digamma[1801]=6.8023948148;digamma[1802]=6.8029502160;digamma[1803]=6.8035053089;digamma[1804]=6.8040600939;digamma[1805]=6.8046145713;digamma[1806]=6.8051687414;digamma[1807]=6.8057226045;digamma[1808]=6.8062761611;digamma[1809]=6.8068294114;digamma[1810]=6.8073823558;digamma[1811]=6.8079349946;digamma[1812]=6.8084873281;digamma[1813]=6.8090393568;digamma[1814]=6.8095910809;digamma[1815]=6.8101425008;digamma[1816]=6.8106936167;digamma[1817]=6.8112444291;digamma[1818]=6.8117949383;digamma[1819]=6.8123451446;digamma[1820]=6.8128950483;digamma[1821]=6.8134446498;digamma[1822]=6.8139939494;digamma[1823]=6.8145429475;digamma[1824]=6.8150916443;digamma[1825]=6.8156400402;digamma[1826]=6.8161881355;digamma[1827]=6.8167359306;digamma[1828]=6.8172834257;digamma[1829]=6.8178306213;digamma[1830]=6.8183775177;digamma[1831]=6.8189241150;digamma[1832]=6.8194704138;digamma[1833]=6.8200164143;digamma[1834]=6.8205621169;digamma[1835]=6.8211075218;digamma[1836]=6.8216526294;digamma[1837]=6.8221974401;digamma[1838]=6.8227419540;digamma[1839]=6.8232861717;digamma[1840]=6.8238300933;digamma[1841]=6.8243737193;digamma[1842]=6.8249170498;digamma[1843]=6.8254600854;digamma[1844]=6.8260028262;digamma[1845]=6.8265452726;digamma[1846]=6.8270874249;digamma[1847]=6.8276292834;digamma[1848]=6.8281708485;digamma[1849]=6.8287121204;digamma[1850]=6.8292530996;digamma[1851]=6.8297937862;digamma[1852]=6.8303341807;digamma[1853]=6.8308742832;digamma[1854]=6.8314140943;digamma[1855]=6.8319536141;digamma[1856]=6.8324928429;digamma[1857]=6.8330317812;digamma[1858]=6.8335704291;digamma[1859]=6.8341087871;digamma[1860]=6.8346468554;digamma[1861]=6.8351846343;digamma[1862]=6.8357221242;digamma[1863]=6.8362593253;digamma[1864]=6.8367962381;digamma[1865]=6.8373328627;digamma[1866]=6.8378691994;digamma[1867]=6.8384052487;digamma[1868]=6.8389410108;digamma[1869]=6.8394764860;digamma[1870]=6.8400116746;digamma[1871]=6.8405465769;digamma[1872]=6.8410811933;digamma[1873]=6.8416155240;digamma[1874]=6.8421495694;digamma[1875]=6.8426833297;digamma[1876]=6.8432168053;digamma[1877]=6.8437499964;digamma[1878]=6.8442829033;digamma[1879]=6.8448155265;digamma[1880]=6.8453478661;digamma[1881]=6.8458799224;digamma[1882]=6.8464116958;digamma[1883]=6.8469431866;digamma[1884]=6.8474743951;digamma[1885]=6.8480053215;digamma[1886]=6.8485359662;digamma[1887]=6.8490663295;digamma[1888]=6.8495964116;digamma[1889]=6.8501262129;digamma[1890]=6.8506557336;digamma[1891]=6.8511849742;digamma[1892]=6.8517139347;digamma[1893]=6.8522426156;digamma[1894]=6.8527710172;digamma[1895]=6.8532991396;digamma[1896]=6.8538269834;digamma[1897]=6.8543545486;digamma[1898]=6.8548818357;digamma[1899]=6.8554088449;digamma[1900]=6.8559355765;digamma[1901]=6.8564620308;digamma[1902]=6.8569882080;digamma[1903]=6.8575141086;digamma[1904]=6.8580397328;digamma[1905]=6.8585650808;digamma[1906]=6.8590901529;digamma[1907]=6.8596149495;digamma[1908]=6.8601394709;digamma[1909]=6.8606637172;digamma[1910]=6.8611876889;digamma[1911]=6.8617113862;digamma[1912]=6.8622348093;digamma[1913]=6.8627579586;digamma[1914]=6.8632808344;digamma[1915]=6.8638034369;digamma[1916]=6.8643257665;digamma[1917]=6.8648478234;digamma[1918]=6.8653696078;digamma[1919]=6.8658911202;digamma[1920]=6.8664123607;digamma[1921]=6.8669333297;digamma[1922]=6.8674540274;digamma[1923]=6.8679744541;digamma[1924]=6.8684946101;digamma[1925]=6.8690144957;digamma[1926]=6.8695341111;digamma[1927]=6.8700534567;digamma[1928]=6.8705725327;digamma[1929]=6.8710913394;digamma[1930]=6.8716098771;digamma[1931]=6.8721281461;digamma[1932]=6.8726461466;digamma[1933]=6.8731638789;digamma[1934]=6.8736813433;digamma[1935]=6.8741985400;digamma[1936]=6.8747154694;digamma[1937]=6.8752321317;digamma[1938]=6.8757485273;digamma[1939]=6.8762646563;digamma[1940]=6.8767805190;digamma[1941]=6.8772961158;digamma[1942]=6.8778114468;digamma[1943]=6.8783265125;digamma[1944]=6.8788413130;digamma[1945]=6.8793558486;digamma[1946]=6.8798701195;digamma[1947]=6.8803841262;digamma[1948]=6.8808978688;digamma[1949]=6.8814113476;digamma[1950]=6.8819245628;digamma[1951]=6.8824375148;digamma[1952]=6.8829502038;digamma[1953]=6.8834626302;digamma[1954]=6.8839747940;digamma[1955]=6.8844866957;digamma[1956]=6.8849983355;digamma[1957]=6.8855097136;digamma[1958]=6.8860208304;digamma[1959]=6.8865316860;digamma[1960]=6.8870422808;digamma[1961]=6.8875526150;digamma[1962]=6.8880626890;digamma[1963]=6.8885725029;digamma[1964]=6.8890820570;digamma[1965]=6.8895913516;digamma[1966]=6.8901003869;digamma[1967]=6.8906091633;digamma[1968]=6.8911176809;digamma[1969]=6.8916259401;digamma[1970]=6.8921339411;digamma[1971]=6.8926416841;digamma[1972]=6.8931491695;digamma[1973]=6.8936563975;digamma[1974]=6.8941633683;digamma[1975]=6.8946700822;digamma[1976]=6.8951765395;digamma[1977]=6.8956827404;digamma[1978]=6.8961886853;digamma[1979]=6.8966943742;digamma[1980]=6.8971998076;digamma[1981]=6.8977049856;digamma[1982]=6.8982099086;digamma[1983]=6.8987145768;digamma[1984]=6.8992189903;digamma[1985]=6.8997231496;digamma[1986]=6.9002270549;digamma[1987]=6.9007307063;digamma[1988]=6.9012341042;digamma[1989]=6.9017372488;digamma[1990]=6.9022401404;digamma[1991]=6.9027427792;digamma[1992]=6.9032451655;digamma[1993]=6.9037472996;digamma[1994]=6.9042491816;digamma[1995]=6.9047508119;digamma[1996]=6.9052521906;digamma[1997]=6.9057533181;digamma[1998]=6.9062541946;digamma[1999]=6.9067548204;digamma[2000]=6.9072551956;digamma[2001]=6.9077553206;digamma[2002]=6.9082551956;digamma[2003]=6.9087548209;digamma[2004]=6.9092541966;digamma[2005]=6.9097533231;digamma[2006]=6.9102522006;digamma[2007]=6.9107508294;digamma[2008]=6.9112492096;digamma[2009]=6.9117473416;digamma[2010]=6.9122452255;digamma[2011]=6.9127428617;digamma[2012]=6.9132402504;digamma[2013]=6.9137373918;digamma[2014]=6.9142342862;digamma[2015]=6.9147309338;digamma[2016]=6.9152273349;digamma[2017]=6.9157234896;digamma[2018]=6.9162193984;digamma[2019]=6.9167150613;digamma[2020]=6.9172104786;digamma[2021]=6.9177056507;digamma[2022]=6.9182005776;digamma[2023]=6.9186952598;digamma[2024]=6.9191896973;digamma[2025]=6.9196838905;digamma[2026]=6.9201778396;digamma[2027]=6.9206715449;digamma[2028]=6.9211650065;digamma[2029]=6.9216582247;digamma[2030]=6.9221511997;digamma[2031]=6.9226439319;digamma[2032]=6.9231364214;digamma[2033]=6.9236286685;digamma[2034]=6.9241206734;digamma[2035]=6.9246124363;digamma[2036]=6.9251039576;digamma[2037]=6.9255952373;digamma[2038]=6.9260862758;digamma[2039]=6.9265770734;digamma[2040]=6.9270676301;digamma[2041]=6.9275579463;digamma[2042]=6.9280480223;digamma[2043]=6.9285378581;digamma[2044]=6.9290274542;digamma[2045]=6.9295168107;digamma[2046]=6.9300059278;digamma[2047]=6.9304948058;digamma[2048]=6.9309834449;digamma[2049]=6.9314718453;digamma[2050]=6.9319600074;digamma[2051]=6.9324479312;digamma[2052]=6.9329356171;digamma[2053]=6.9334230653;digamma[2054]=6.9339102760;digamma[2055]=6.9343972494;digamma[2056]=6.9348839858;digamma[2057]=6.9353704854;digamma[2058]=6.9358567485;digamma[2059]=6.9363427752;digamma[2060]=6.9368285658;digamma[2061]=6.9373141205;digamma[2062]=6.9377994396;digamma[2063]=6.9382845232;digamma[2064]=6.9387693717;digamma[2065]=6.9392539852;digamma[2066]=6.9397383639;digamma[2067]=6.9402225082;digamma[2068]=6.9407064181;digamma[2069]=6.9411900940;digamma[2070]=6.9416735361;digamma[2071]=6.9421567446;digamma[2072]=6.9426397197;digamma[2073]=6.9431224616;digamma[2074]=6.9436049707;digamma[2075]=6.9440872470;digamma[2076]=6.9445692908;digamma[2077]=6.9450511024;digamma[2078]=6.9455326820;digamma[2079]=6.9460140297;digamma[2080]=6.9464951459;digamma[2081]=6.9469760307;digamma[2082]=6.9474566843;digamma[2083]=6.9479371071;digamma[2084]=6.9484172991;digamma[2085]=6.9488972607;digamma[2086]=6.9493769920;digamma[2087]=6.9498564933;digamma[2088]=6.9503357648;digamma[2089]=6.9508148067;digamma[2090]=6.9512936192;digamma[2091]=6.9517722026;digamma[2092]=6.9522505570;digamma[2093]=6.9527286827;digamma[2094]=6.9532065799;digamma[2095]=6.9536842489;digamma[2096]=6.9541616898;digamma[2097]=6.9546389028;digamma[2098]=6.9551158882;digamma[2099]=6.9555926463;digamma[2100]=6.9560691771;digamma[2101]=6.9565454809;digamma[2102]=6.9570215580;digamma[2103]=6.9574974086;digamma[2104]=6.9579730328;digamma[2105]=6.9584484309;digamma[2106]=6.9589236032;digamma[2107]=6.9593985497;digamma[2108]=6.9598732708;digamma[2109]=6.9603477666;digamma[2110]=6.9608220374;digamma[2111]=6.9612960833;digamma[2112]=6.9617699047;digamma[2113]=6.9622435016;digamma[2114]=6.9627168744;digamma[2115]=6.9631900232;digamma[2116]=6.9636629482;digamma[2117]=6.9641356496;digamma[2118]=6.9646081278;digamma[2119]=6.9650803828;digamma[2120]=6.9655524148;digamma[2121]=6.9660242242;digamma[2122]=6.9664958111;digamma[2123]=6.9669671756;digamma[2124]=6.9674383181;digamma[2125]=6.9679092387;digamma[2126]=6.9683799377;digamma[2127]=6.9688504152;digamma[2128]=6.9693206715;digamma[2129]=6.9697907067;digamma[2130]=6.9702605211;digamma[2131]=6.9707301149;digamma[2132]=6.9711994882;digamma[2133]=6.9716686414;digamma[2134]=6.9721375745;digamma[2135]=6.9726062879;digamma[2136]=6.9730747817;digamma[2137]=6.9735430560;digamma[2138]=6.9740111113;digamma[2139]=6.9744789475;digamma[2140]=6.9749465649;digamma[2141]=6.9754139638;digamma[2142]=6.9758811444;digamma[2143]=6.9763481068;digamma[2144]=6.9768148512;digamma[2145]=6.9772813779;digamma[2146]=6.9777476870;digamma[2147]=6.9782137788;digamma[2148]=6.9786796535;digamma[2149]=6.9791453112;digamma[2150]=6.9796107522;digamma[2151]=6.9800759766;digamma[2152]=6.9805409847;digamma[2153]=6.9810057767;digamma[2154]=6.9814703528;digamma[2155]=6.9819347131;digamma[2156]=6.9823988579;digamma[2157]=6.9828627873;digamma[2158]=6.9833265017;digamma[2159]=6.9837900010;digamma[2160]=6.9842532857;digamma[2161]=6.9847163558;digamma[2162]=6.9851792116;digamma[2163]=6.9856418533;digamma[2164]=6.9861042810;digamma[2165]=6.9865664950;digamma[2166]=6.9870284954;digamma[2167]=6.9874902825;digamma[2168]=6.9879518565;digamma[2169]=6.9884132175;digamma[2170]=6.9888743657;digamma[2171]=6.9893353014;digamma[2172]=6.9897960247;digamma[2173]=6.9902565358;digamma[2174]=6.9907168350;digamma[2175]=6.9911769224;digamma[2176]=6.9916367982;digamma[2177]=6.9920964626;digamma[2178]=6.9925559158;digamma[2179]=6.9930151581;digamma[2180]=6.9934741895;digamma[2181]=6.9939330103;digamma[2182]=6.9943916207;digamma[2183]=6.9948500208;digamma[2184]=6.9953082110;digamma[2185]=6.9957661912;digamma[2186]=6.9962239619;digamma[2187]=6.9966815231;digamma[2188]=6.9971388750;digamma[2189]=6.9975960178;digamma[2190]=6.9980529517;digamma[2191]=6.9985096770;digamma[2192]=6.9989661938;digamma[2193]=6.9994225022;digamma[2194]=6.9998786025;digamma[2195]=7.0003344949;digamma[2196]=7.0007901795;digamma[2197]=7.0012456566;digamma[2198]=7.0017009264;digamma[2199]=7.0021559889;digamma[2200]=7.0026108445;digamma[2201]=7.0030654932;digamma[2202]=7.0035199354;digamma[2203]=7.0039741711;digamma[2204]=7.0044282006;digamma[2205]=7.0048820240;digamma[2206]=7.0053356416;digamma[2207]=7.0057890535;digamma[2208]=7.0062422599;digamma[2209]=7.0066952610;digamma[2210]=7.0071480570;digamma[2211]=7.0076006481;digamma[2212]=7.0080530344;digamma[2213]=7.0085052161;digamma[2214]=7.0089571935;digamma[2215]=7.0094089667;digamma[2216]=7.0098605359;digamma[2217]=7.0103119012;digamma[2218]=7.0107630630;digamma[2219]=7.0112140212;digamma[2220]=7.0116647762;digamma[2221]=7.0121153281;digamma[2222]=7.0125656771;digamma[2223]=7.0130158234;digamma[2224]=7.0134657671;digamma[2225]=7.0139155085;digamma[2226]=7.0143650477;digamma[2227]=7.0148143849;digamma[2228]=7.0152635203;digamma[2229]=7.0157124541;digamma[2230]=7.0161611864;digamma[2231]=7.0166097174;digamma[2232]=7.0170580474;digamma[2233]=7.0175061764;digamma[2234]=7.0179541047;digamma[2235]=7.0184018325;digamma[2236]=7.0188493599;digamma[2237]=7.0192966871;digamma[2238]=7.0197438142;digamma[2239]=7.0201907416;digamma[2240]=7.0206374693;digamma[2241]=7.0210839975;digamma[2242]=7.0215303264;digamma[2243]=7.0219764562;digamma[2244]=7.0224223871;digamma[2245]=7.0228681192;digamma[2246]=7.0233136527;digamma[2247]=7.0237589878;digamma[2248]=7.0242041246;digamma[2249]=7.0246490634;digamma[2250]=7.0250938044;digamma[2251]=7.0255383476;digamma[2252]=7.0259826932;digamma[2253]=7.0264268416;digamma[2254]=7.0268707927;digamma[2255]=7.0273145468;digamma[2256]=7.0277581042;digamma[2257]=7.0282014648;digamma[2258]=7.0286446290;digamma[2259]=7.0290875968;digamma[2260]=7.0295303686;digamma[2261]=7.0299729443;digamma[2262]=7.0304153243;digamma[2263]=7.0308575087;digamma[2264]=7.0312994976;digamma[2265]=7.0317412913;digamma[2266]=7.0321828898;digamma[2267]=7.0326242935;digamma[2268]=7.0330655024;digamma[2269]=7.0335065167;digamma[2270]=7.0339473366;digamma[2271]=7.0343879623;digamma[2272]=7.0348283939;digamma[2273]=7.0352686316;digamma[2274]=7.0357086756;digamma[2275]=7.0361485260;digamma[2276]=7.0365881830;digamma[2277]=7.0370276469;digamma[2278]=7.0374669176;digamma[2279]=7.0379059956;digamma[2280]=7.0383448808;digamma[2281]=7.0387835734;digamma[2282]=7.0392220738;digamma[2283]=7.0396603819;digamma[2284]=7.0400984979;digamma[2285]=7.0405364222;digamma[2286]=7.0409741547;digamma[2287]=7.0414116957;digamma[2288]=7.0418490453;digamma[2289]=7.0422862038;digamma[2290]=7.0427231712;digamma[2291]=7.0431599478;digamma[2292]=7.0435965336;digamma[2293]=7.0440329290;digamma[2294]=7.0444691340;digamma[2295]=7.0449051488;digamma[2296]=7.0453409736;digamma[2297]=7.0457766085;digamma[2298]=7.0462120537;digamma[2299]=7.0466473094;digamma[2300]=7.0470823757;digamma[2301]=7.0475172529;digamma[2302]=7.0479519410;digamma[2303]=7.0483864402;digamma[2304]=7.0488207507;digamma[2305]=7.0492548727;digamma[2306]=7.0496888062;digamma[2307]=7.0501225516;digamma[2308]=7.0505561089;digamma[2309]=7.0509894784;digamma[2310]=7.0514226601;digamma[2311]=7.0518556542;digamma[2312]=7.0522884609;digamma[2313]=7.0527210804;digamma[2314]=7.0531535128;digamma[2315]=7.0535857583;digamma[2316]=7.0540178171;digamma[2317]=7.0544496892;digamma[2318]=7.0548813749;digamma[2319]=7.0553128744;digamma[2320]=7.0557441877;digamma[2321]=7.0561753151;digamma[2322]=7.0566062567;digamma[2323]=7.0570370126;digamma[2324]=7.0574675831;digamma[2325]=7.0578979683;digamma[2326]=7.0583281683;digamma[2327]=7.0587581833;digamma[2328]=7.0591880135;digamma[2329]=7.0596176590;digamma[2330]=7.0600471201;digamma[2331]=7.0604763967;digamma[2332]=7.0609054891;digamma[2333]=7.0613343976;digamma[2334]=7.0617631221;digamma[2335]=7.0621916629;digamma[2336]=7.0626200201;digamma[2337]=7.0630481939;digamma[2338]=7.0634761845;digamma[2339]=7.0639039920;digamma[2340]=7.0643316165;digamma[2341]=7.0647590582;digamma[2342]=7.0651863173;digamma[2343]=7.0656133940;digamma[2344]=7.0660402883;digamma[2345]=7.0664670005;digamma[2346]=7.0668935306;digamma[2347]=7.0673198789;digamma[2348]=7.0677460455;digamma[2349]=7.0681720306;digamma[2350]=7.0685978343;digamma[2351]=7.0690234568;digamma[2352]=7.0694488981;digamma[2353]=7.0698741586;digamma[2354]=7.0702992383;digamma[2355]=7.0707241373;digamma[2356]=7.0711488559;digamma[2357]=7.0715733942;digamma[2358]=7.0719977524;digamma[2359]=7.0724219305;digamma[2360]=7.0728459288;digamma[2361]=7.0732697474;digamma[2362]=7.0736933864;digamma[2363]=7.0741168461;digamma[2364]=7.0745401265;digamma[2365]=7.0749632278;digamma[2366]=7.0753861502;digamma[2367]=7.0758088938;digamma[2368]=7.0762314587;digamma[2369]=7.0766538452;digamma[2370]=7.0770760533;digamma[2371]=7.0774980832;digamma[2372]=7.0779199352;digamma[2373]=7.0783416092;digamma[2374]=7.0787631055;digamma[2375]=7.0791844242;digamma[2376]=7.0796055655;digamma[2377]=7.0800265294;digamma[2378]=7.0804473163;digamma[2379]=7.0808679262;digamma[2380]=7.0812883592;digamma[2381]=7.0817086155;digamma[2382]=7.0821286953;digamma[2383]=7.0825485987;digamma[2384]=7.0829683259;digamma[2385]=7.0833878770;digamma[2386]=7.0838072521;digamma[2387]=7.0842264514;digamma[2388]=7.0846454750;digamma[2389]=7.0850643232;digamma[2390]=7.0854829960;digamma[2391]=7.0859014935;digamma[2392]=7.0863198161;digamma[2393]=7.0867379636;digamma[2394]=7.0871559365;digamma[2395]=7.0875737346;digamma[2396]=7.0879913583;digamma[2397]=7.0884088077;digamma[2398]=7.0888260829;digamma[2399]=7.0892431840;digamma[2400]=7.0896601112;digamma[2401]=7.0900768647;digamma[2402]=7.0904934446;digamma[2403]=7.0909098510;digamma[2404]=7.0913260840;digamma[2405]=7.0917421439;digamma[2406]=7.0921580308;digamma[2407]=7.0925737448;digamma[2408]=7.0929892860;digamma[2409]=7.0934046546;digamma[2410]=7.0938198508;digamma[2411]=7.0942348746;digamma[2412]=7.0946497263;digamma[2413]=7.0950644059;digamma[2414]=7.0954789137;digamma[2415]=7.0958932497;digamma[2416]=7.0963074141;digamma[2417]=7.0967214070;digamma[2418]=7.0971352287;digamma[2419]=7.0975488791;digamma[2420]=7.0979623585;digamma[2421]=7.0983756670;digamma[2422]=7.0987888048;digamma[2423]=7.0992017720;digamma[2424]=7.0996145686;digamma[2425]=7.1000271950;digamma[2426]=7.1004396512;digamma[2427]=7.1008519373;digamma[2428]=7.1012640535;digamma[2429]=7.1016759999;digamma[2430]=7.1020877767;digamma[2431]=7.1024993840;digamma[2432]=7.1029108220;digamma[2433]=7.1033220907;digamma[2434]=7.1037331904;digamma[2435]=7.1041441211;digamma[2436]=7.1045548831;digamma[2437]=7.1049654764;digamma[2438]=7.1053759011;digamma[2439]=7.1057861575;digamma[2440]=7.1061962457;digamma[2441]=7.1066061657;digamma[2442]=7.1070159178;digamma[2443]=7.1074255021;digamma[2444]=7.1078349186;digamma[2445]=7.1082441676;digamma[2446]=7.1086532492;digamma[2447]=7.1090621635;digamma[2448]=7.1094709107;digamma[2449]=7.1098794909;digamma[2450]=7.1102879042;digamma[2451]=7.1106961507;digamma[2452]=7.1111042307;digamma[2453]=7.1115121442;digamma[2454]=7.1119198914;digamma[2455]=7.1123274724;digamma[2456]=7.1127348873;digamma[2457]=7.1131421363;digamma[2458]=7.1135492196;digamma[2459]=7.1139561372;digamma[2460]=7.1143628892;digamma[2461]=7.1147694759;digamma[2462]=7.1151758973;digamma[2463]=7.1155821537;digamma[2464]=7.1159882450;digamma[2465]=7.1163941715;digamma[2466]=7.1167999333;digamma[2467]=7.1172055306;digamma[2468]=7.1176109634;digamma[2469]=7.1180162318;digamma[2470]=7.1184213361;digamma[2471]=7.1188262764;digamma[2472]=7.1192310527;digamma[2473]=7.1196356653;digamma[2474]=7.1200401142;digamma[2475]=7.1204443996;digamma[2476]=7.1208485217;digamma[2477]=7.1212524804;digamma[2478]=7.1216562761;digamma[2479]=7.1220599088;digamma[2480]=7.1224633786;digamma[2481]=7.1228666857;digamma[2482]=7.1232698302;digamma[2483]=7.1236728123;digamma[2484]=7.1240756320;digamma[2485]=7.1244782895;digamma[2486]=7.1248807850;digamma[2487]=7.1252831185;digamma[2488]=7.1256852902;digamma[2489]=7.1260873002;digamma[2490]=7.1264891487;digamma[2491]=7.1268908358;digamma[2492]=7.1272923616;digamma[2493]=7.1276937262;digamma[2494]=7.1280949298;digamma[2495]=7.1284959725;digamma[2496]=7.1288968544;digamma[2497]=7.1292975757;digamma[2498]=7.1296981365;digamma[2499]=7.1300985368;digamma[2500]=7.1304987770;digamma[2501]=7.1308988570;digamma[2502]=7.1312987770;digamma[2503]=7.1316985371;digamma[2504]=7.1320981375;digamma[2505]=7.1324975782;digamma[2506]=7.1328968595;digamma[2507]=7.1332959814;digamma[2508]=7.1336949441;digamma[2509]=7.1340937477;digamma[2510]=7.1344923923;digamma[2511]=7.1348908780;digamma[2512]=7.1352892050;digamma[2513]=7.1356873734;digamma[2514]=7.1360853834;digamma[2515]=7.1364832350;digamma[2516]=7.1368809283;digamma[2517]=7.1372784636;digamma[2518]=7.1376758409;digamma[2519]=7.1380730603;digamma[2520]=7.1384701221;digamma[2521]=7.1388670262;digamma[2522]=7.1392637729;digamma[2523]=7.1396603622;digamma[2524]=7.1400567943;digamma[2525]=7.1404530693;digamma[2526]=7.1408491873;digamma[2527]=7.1412451485;digamma[2528]=7.1416409529;digamma[2529]=7.1420366008;digamma[2530]=7.1424320922;digamma[2531]=7.1428274272;digamma[2532]=7.1432226060;digamma[2533]=7.1436176287;digamma[2534]=7.1440124954;digamma[2535]=7.1444072063;digamma[2536]=7.1448017614;digamma[2537]=7.1451961609;digamma[2538]=7.1455904049;digamma[2539]=7.1459844936;digamma[2540]=7.1463784270;digamma[2541]=7.1467722053;digamma[2542]=7.1471658286;digamma[2543]=7.1475592970;digamma[2544]=7.1479526106;digamma[2545]=7.1483457697;digamma[2546]=7.1487387742;digamma[2547]=7.1491316243;digamma[2548]=7.1495243201;digamma[2549]=7.1499168618;digamma[2550]=7.1503092495;digamma[2551]=7.1507014832;digamma[2552]=7.1510935632;digamma[2553]=7.1514854895;digamma[2554]=7.1518772623;digamma[2555]=7.1522688816;digamma[2556]=7.1526603476;digamma[2557]=7.1530516604;digamma[2558]=7.1534428202;digamma[2559]=7.1538338270;digamma[2560]=7.1542246811;digamma[2561]=7.1546153823;digamma[2562]=7.1550059311;digamma[2563]=7.1553963273;digamma[2564]=7.1557865712;digamma[2565]=7.1561766628;digamma[2566]=7.1565666024;digamma[2567]=7.1569563899;digamma[2568]=7.1573460256;digamma[2569]=7.1577355095;digamma[2570]=7.1581248418;digamma[2571]=7.1585140226;digamma[2572]=7.1589030519;digamma[2573]=7.1592919300;digamma[2574]=7.1596806569;digamma[2575]=7.1600692328;digamma[2576]=7.1604576577;digamma[2577]=7.1608459318;digamma[2578]=7.1612340552;digamma[2579]=7.1616220280;digamma[2580]=7.1620098504;digamma[2581]=7.1623975224;digamma[2582]=7.1627850442;digamma[2583]=7.1631724158;digamma[2584]=7.1635596375;digamma[2585]=7.1639467093;digamma[2586]=7.1643336313;digamma[2587]=7.1647204037;digamma[2588]=7.1651070265;digamma[2589]=7.1654934999;digamma[2590]=7.1658798241;digamma[2591]=7.1662659990;digamma[2592]=7.1666520248;digamma[2593]=7.1670379017;digamma[2594]=7.1674236298;digamma[2595]=7.1678092091;digamma[2596]=7.1681946398;digamma[2597]=7.1685799220;digamma[2598]=7.1689650558;digamma[2599]=7.1693500414;digamma[2600]=7.1697348788;digamma[2601]=7.1701195681;digamma[2602]=7.1705041095;digamma[2603]=7.1708885031;digamma[2604]=7.1712727490;digamma[2605]=7.1716568473;digamma[2606]=7.1720407982;digamma[2607]=7.1724246017;digamma[2608]=7.1728082579;digamma[2609]=7.1731917670;digamma[2610]=7.1735751291;digamma[2611]=7.1739583442;digamma[2612]=7.1743414126;digamma[2613]=7.1747243343;digamma[2614]=7.1751071094;digamma[2615]=7.1754897380;digamma[2616]=7.1758722203;digamma[2617]=7.1762545564;digamma[2618]=7.1766367463;digamma[2619]=7.1770187902;digamma[2620]=7.1774006882;digamma[2621]=7.1777824405;digamma[2622]=7.1781640470;digamma[2623]=7.1785455080;digamma[2624]=7.1789268235;digamma[2625]=7.1793079937;digamma[2626]=7.1796890187;digamma[2627]=7.1800698985;digamma[2628]=7.1804506333;digamma[2629]=7.1808312232;digamma[2630]=7.1812116683;digamma[2631]=7.1815919687;digamma[2632]=7.1819721246;digamma[2633]=7.1823521359;digamma[2634]=7.1827320030;digamma[2635]=7.1831117258;digamma[2636]=7.1834913044;digamma[2637]=7.1838707390;digamma[2638]=7.1842500298;digamma[2639]=7.1846291767;digamma[2640]=7.1850081799;digamma[2641]=7.1853870395;digamma[2642]=7.1857657556;digamma[2643]=7.1861443284;digamma[2644]=7.1865227579;digamma[2645]=7.1869010443;digamma[2646]=7.1872791876;digamma[2647]=7.1876571879;digamma[2648]=7.1880350455;digamma[2649]=7.1884127603;digamma[2650]=7.1887903325;digamma[2651]=7.1891677622;digamma[2652]=7.1895450494;digamma[2653]=7.1899221944;digamma[2654]=7.1902991973;digamma[2655]=7.1906760580;digamma[2656]=7.1910527768;digamma[2657]=7.1914293537;digamma[2658]=7.1918057888;digamma[2659]=7.1921820823;digamma[2660]=7.1925582343;digamma[2661]=7.1929342448;digamma[2662]=7.1933101140;digamma[2663]=7.1936858419;digamma[2664]=7.1940614288;digamma[2665]=7.1944368746;digamma[2666]=7.1948121795;digamma[2667]=7.1951873436;digamma[2668]=7.1955623671;digamma[2669]=7.1959372499;digamma[2670]=7.1963119922;digamma[2671]=7.1966865942;digamma[2672]=7.1970610559;digamma[2673]=7.1974353774;digamma[2674]=7.1978095589;digamma[2675]=7.1981836004;digamma[2676]=7.1985575021;digamma[2677]=7.1989312640;digamma[2678]=7.1993048862;digamma[2679]=7.1996783689;digamma[2680]=7.2000517122;digamma[2681]=7.2004249161;digamma[2682]=7.2007979809;digamma[2683]=7.2011709065;digamma[2684]=7.2015436930;digamma[2685]=7.2019163407;digamma[2686]=7.2022888495;digamma[2687]=7.2026612196;digamma[2688]=7.2030334511;digamma[2689]=7.2034055442;digamma[2690]=7.2037774988;digamma[2691]=7.2041493151;digamma[2692]=7.2045209932;digamma[2693]=7.2048925332;digamma[2694]=7.2052639352;digamma[2695]=7.2056351994;digamma[2696]=7.2060063257;digamma[2697]=7.2063773144;digamma[2698]=7.2067481655;digamma[2699]=7.2071188791;digamma[2700]=7.2074894553;digamma[2701]=7.2078598943;digamma[2702]=7.2082301961;digamma[2703]=7.2086003608;digamma[2704]=7.2089703885;digamma[2705]=7.2093402794;digamma[2706]=7.2097100335;digamma[2707]=7.2100796509;digamma[2708]=7.2104491318;digamma[2709]=7.2108184762;digamma[2710]=7.2111876842;digamma[2711]=7.2115567560;digamma[2712]=7.2119256916;digamma[2713]=7.2122944912;digamma[2714]=7.2126631547;digamma[2715]=7.2130316825;digamma[2716]=7.2134000744;digamma[2717]=7.2137683307;digamma[2718]=7.2141364514;digamma[2719]=7.2145044367;digamma[2720]=7.2148722866;digamma[2721]=7.2152400013;digamma[2722]=7.2156075807;digamma[2723]=7.2159750251;digamma[2724]=7.2163423346;digamma[2725]=7.2167095092;digamma[2726]=7.2170765490;digamma[2727]=7.2174434541;digamma[2728]=7.2178102247;digamma[2729]=7.2181768608;digamma[2730]=7.2185433625;digamma[2731]=7.2189097300;digamma[2732]=7.2192759633;digamma[2733]=7.2196420625;digamma[2734]=7.2200080277;digamma[2735]=7.2203738590;digamma[2736]=7.2207395566;digamma[2737]=7.2211051204;digamma[2738]=7.2214705507;digamma[2739]=7.2218358475;digamma[2740]=7.2222010109;digamma[2741]=7.2225660410;digamma[2742]=7.2229309379;digamma[2743]=7.2232957017;digamma[2744]=7.2236603325;digamma[2745]=7.2240248304;digamma[2746]=7.2243891955;digamma[2747]=7.2247534279;digamma[2748]=7.2251175276;digamma[2749]=7.2254814949;digamma[2750]=7.2258453297;digamma[2751]=7.2262090321;digamma[2752]=7.2265726024;digamma[2753]=7.2269360405;digamma[2754]=7.2272993466;digamma[2755]=7.2276625207;digamma[2756]=7.2280255630;digamma[2757]=7.2283884735;digamma[2758]=7.2287512524;digamma[2759]=7.2291138997;digamma[2760]=7.2294764156;digamma[2761]=7.2298388000;digamma[2762]=7.2302010532;digamma[2763]=7.2305631753;digamma[2764]=7.2309251662;digamma[2765]=7.2312870261;digamma[2766]=7.2316487552;digamma[2767]=7.2320103534;digamma[2768]=7.2323718210;digamma[2769]=7.2327331579;digamma[2770]=7.2330943643;digamma[2771]=7.2334554403;digamma[2772]=7.2338163860;digamma[2773]=7.2341772014;digamma[2774]=7.2345378867;digamma[2775]=7.2348984420;digamma[2776]=7.2352588673;digamma[2777]=7.2356191627;digamma[2778]=7.2359793284;digamma[2779]=7.2363393644;digamma[2780]=7.2366992708;digamma[2781]=7.2370590477;digamma[2782]=7.2374186952;digamma[2783]=7.2377782135;digamma[2784]=7.2381376025;digamma[2785]=7.2384968624;digamma[2786]=7.2388559933;digamma[2787]=7.2392149953;digamma[2788]=7.2395738684;digamma[2789]=7.2399326128;digamma[2790]=7.2402912285;digamma[2791]=7.2406497157;digamma[2792]=7.2410080744;digamma[2793]=7.2413663047;digamma[2794]=7.2417244068;digamma[2795]=7.2420823806;digamma[2796]=7.2424402264;digamma[2797]=7.2427979441;digamma[2798]=7.2431555339;digamma[2799]=7.2435129960;digamma[2800]=7.2438703302;digamma[2801]=7.2442275369;digamma[2802]=7.2445846159;digamma[2803]=7.2449415676;digamma[2804]=7.2452983918;digamma[2805]=7.2456550888;digamma[2806]=7.2460116586;digamma[2807]=7.2463681013;digamma[2808]=7.2467244170;digamma[2809]=7.2470806057;digamma[2810]=7.2474366677;digamma[2811]=7.2477926029;digamma[2812]=7.2481484114;digamma[2813]=7.2485040934;digamma[2814]=7.2488596490;digamma[2815]=7.2492150782;digamma[2816]=7.2495703810;digamma[2817]=7.2499255577;digamma[2818]=7.2502806083;digamma[2819]=7.2506355329;digamma[2820]=7.2509903315;digamma[2821]=7.2513450043;digamma[2822]=7.2516995514;digamma[2823]=7.2520539728;digamma[2824]=7.2524082686;digamma[2825]=7.2527624390;digamma[2826]=7.2531164839;digamma[2827]=7.2534704036;digamma[2828]=7.2538241980;digamma[2829]=7.2541778673;digamma[2830]=7.2545314116;digamma[2831]=7.2548848309;digamma[2832]=7.2552381253;digamma[2833]=7.2555912950;digamma[2834]=7.2559443400;digamma[2835]=7.2562972604;digamma[2836]=7.2566500563;digamma[2837]=7.2570027278;digamma[2838]=7.2573552750;digamma[2839]=7.2577076979;digamma[2840]=7.2580599966;digamma[2841]=7.2584121713;digamma[2842]=7.2587642219;digamma[2843]=7.2591161487;digamma[2844]=7.2594679517;digamma[2845]=7.2598196310;digamma[2846]=7.2601711866;digamma[2847]=7.2605226187;digamma[2848]=7.2608739273;digamma[2849]=7.2612251125;digamma[2850]=7.2615761745;digamma[2851]=7.2619271132;digamma[2852]=7.2622779289;digamma[2853]=7.2626286215;digamma[2854]=7.2629791911;digamma[2855]=7.2633296379;digamma[2856]=7.2636799620;digamma[2857]=7.2640301633;digamma[2858]=7.2643802421;digamma[2859]=7.2647301983;digamma[2860]=7.2650800322;digamma[2861]=7.2654297436;digamma[2862]=7.2657793329;digamma[2863]=7.2661287999;digamma[2864]=7.2664781449;digamma[2865]=7.2668273678;digamma[2866]=7.2671764689;digamma[2867]=7.2675254481;digamma[2868]=7.2678743056;digamma[2869]=7.2682230414;digamma[2870]=7.2685716557;digamma[2871]=7.2689201484;digamma[2872]=7.2692685198;digamma[2873]=7.2696167698;digamma[2874]=7.2699648986;digamma[2875]=7.2703129063;digamma[2876]=7.2706607928;digamma[2877]=7.2710085584;digamma[2878]=7.2713562031;digamma[2879]=7.2717037270;digamma[2880]=7.2720511302;digamma[2881]=7.2723984127;digamma[2882]=7.2727455746;digamma[2883]=7.2730926161;digamma[2884]=7.2734395371;digamma[2885]=7.2737863379;digamma[2886]=7.2741330184;digamma[2887]=7.2744795788;digamma[2888]=7.2748260191;digamma[2889]=7.2751723394;digamma[2890]=7.2755185399;digamma[2891]=7.2758646205;digamma[2892]=7.2762105814;digamma[2893]=7.2765564226;digamma[2894]=7.2769021443;digamma[2895]=7.2772477465;digamma[2896]=7.2775932293;digamma[2897]=7.2779385928;digamma[2898]=7.2782838371;digamma[2899]=7.2786289622;digamma[2900]=7.2789739682;digamma[2901]=7.2793188552;digamma[2902]=7.2796636234;digamma[2903]=7.2800082727;digamma[2904]=7.2803528032;digamma[2905]=7.2806972151;digamma[2906]=7.2810415085;digamma[2907]=7.2813856833;digamma[2908]=7.2817297397;digamma[2909]=7.2820736778;digamma[2910]=7.2824174976;digamma[2911]=7.2827611993;digamma[2912]=7.2831047829;digamma[2913]=7.2834482484;digamma[2914]=7.2837915960;digamma[2915]=7.2841348258;digamma[2916]=7.2844779378;digamma[2917]=7.2848209322;digamma[2918]=7.2851638089;digamma[2919]=7.2855065681;digamma[2920]=7.2858492099;digamma[2921]=7.2861917342;digamma[2922]=7.2865341414;digamma[2923]=7.2868764313;digamma[2924]=7.2872186041;digamma[2925]=7.2875606598;digamma[2926]=7.2879025986;digamma[2927]=7.2882444205;digamma[2928]=7.2885861256;digamma[2929]=7.2889277140;digamma[2930]=7.2892691857;digamma[2931]=7.2896105409;digamma[2932]=7.2899517796;digamma[2933]=7.2902929018;digamma[2934]=7.2906339078;digamma[2935]=7.2909747975;digamma[2936]=7.2913155711;digamma[2937]=7.2916562285;digamma[2938]=7.2919967700;digamma[2939]=7.2923371955;digamma[2940]=7.2926775052;digamma[2941]=7.2930176991;digamma[2942]=7.2933577773;digamma[2943]=7.2936977399;digamma[2944]=7.2940375869;digamma[2945]=7.2943773185;digamma[2946]=7.2947169347;digamma[2947]=7.2950564357;digamma[2948]=7.2953958214;digamma[2949]=7.2957350919;digamma[2950]=7.2960742474;digamma[2951]=7.2964132879;digamma[2952]=7.2967522135;digamma[2953]=7.2970910243;digamma[2954]=7.2974297203;digamma[2955]=7.2977683016;digamma[2956]=7.2981067684;digamma[2957]=7.2984451206;digamma[2958]=7.2987833584;digamma[2959]=7.2991214818;digamma[2960]=7.2994594909;digamma[2961]=7.2997973858;digamma[2962]=7.3001351666;digamma[2963]=7.3004728333;digamma[2964]=7.3008103860;digamma[2965]=7.3011478248;digamma[2966]=7.3014851498;digamma[2967]=7.3018223611;digamma[2968]=7.3021594587;digamma[2969]=7.3024964426;digamma[2970]=7.3028333131;digamma[2971]=7.3031700701;digamma[2972]=7.3035067138;digamma[2973]=7.3038432441;digamma[2974]=7.3041796613;digamma[2975]=7.3045159653;digamma[2976]=7.3048521563;digamma[2977]=7.3051882342;digamma[2978]=7.3055241993;digamma[2979]=7.3058600515;digamma[2980]=7.3061957909;digamma[2981]=7.3065314177;digamma[2982]=7.3068669319;digamma[2983]=7.3072023335;digamma[2984]=7.3075376227;digamma[2985]=7.3078727995;digamma[2986]=7.3082078640;digamma[2987]=7.3085428162;digamma[2988]=7.3088776563;digamma[2989]=7.3092123844;digamma[2990]=7.3095470004;digamma[2991]=7.3098815045;digamma[2992]=7.3102158967;digamma[2993]=7.3105501772;digamma[2994]=7.3108843459;digamma[2995]=7.3112184030;digamma[2996]=7.3115523486;digamma[2997]=7.3118861826;digamma[2998]=7.3122199053;digamma[2999]=7.3125535166;digamma[3000]=7.3128870167;digamma[3001]=7.3132204056;digamma[3002]=7.3135536834;digamma[3003]=7.3138868501;digamma[3004]=7.3142199059;digamma[3005]=7.3145528508;digamma[3006]=7.3148856849;digamma[3007]=7.3152184082;digamma[3008]=7.3155510209;digamma[3009]=7.3158835229;digamma[3010]=7.3162159145;digamma[3011]=7.3165481956;digamma[3012]=7.3168803663;digamma[3013]=7.3172124267;digamma[3014]=7.3175443769;digamma[3015]=7.3178762170;digamma[3016]=7.3182079469;digamma[3017]=7.3185395669;digamma[3018]=7.3188710769;digamma[3019]=7.3192024771;digamma[3020]=7.3195337674;digamma[3021]=7.3198649481;digamma[3022]=7.3201960191;digamma[3023]=7.3205269805;digamma[3024]=7.3208578325;digamma[3025]=7.3211885750;digamma[3026]=7.3215192081;digamma[3027]=7.3218497320;digamma[3028]=7.3221801467;digamma[3029]=7.3225104522;digamma[3030]=7.3228406486;digamma[3031]=7.3231707361;digamma[3032]=7.3235007146;digamma[3033]=7.3238305843;digamma[3034]=7.3241603452;digamma[3035]=7.3244899975;digamma[3036]=7.3248195410;digamma[3037]=7.3251489760;digamma[3038]=7.3254783026;digamma[3039]=7.3258075207;digamma[3040]=7.3261366304;digamma[3041]=7.3264656319;digamma[3042]=7.3267945251;digamma[3043]=7.3271233103;digamma[3044]=7.3274519873;digamma[3045]=7.3277805564;digamma[3046]=7.3281090176;digamma[3047]=7.3284373709;digamma[3048]=7.3287656164;digamma[3049]=7.3290937542;digamma[3050]=7.3294217844;digamma[3051]=7.3297497070;digamma[3052]=7.3300775221;digamma[3053]=7.3304052297;digamma[3054]=7.3307328301;digamma[3055]=7.3310603231;digamma[3056]=7.3313877089;digamma[3057]=7.3317149876;digamma[3058]=7.3320421592;digamma[3059]=7.3323692238;digamma[3060]=7.3326961814;digamma[3061]=7.3330230322;digamma[3062]=7.3333497762;digamma[3063]=7.3336764134;digamma[3064]=7.3340029440;digamma[3065]=7.3343293681;digamma[3066]=7.3346556856;digamma[3067]=7.3349818966;digamma[3068]=7.3353080013;digamma[3069]=7.3356339996;digamma[3070]=7.3359598918;digamma[3071]=7.3362856777;digamma[3072]=7.3366113576;digamma[3073]=7.3369369314;digamma[3074]=7.3372623992;digamma[3075]=7.3375877612;digamma[3076]=7.3379130173;digamma[3077]=7.3382381677;digamma[3078]=7.3385632124;digamma[3079]=7.3388881514;digamma[3080]=7.3392129849;digamma[3081]=7.3395377130;digamma[3082]=7.3398623356;digamma[3083]=7.3401868529;digamma[3084]=7.3405112649;digamma[3085]=7.3408355716;digamma[3086]=7.3411597733;digamma[3087]=7.3414838699;digamma[3088]=7.3418078614;digamma[3089]=7.3421317481;digamma[3090]=7.3424555298;digamma[3091]=7.3427792068;digamma[3092]=7.3431027790;digamma[3093]=7.3434262466;digamma[3094]=7.3437496095;digamma[3095]=7.3440728680;digamma[3096]=7.3443960220;digamma[3097]=7.3447190715;digamma[3098]=7.3450420168;digamma[3099]=7.3453648578;digamma[3100]=7.3456875946;digamma[3101]=7.3460102273;digamma[3102]=7.3463327559;digamma[3103]=7.3466551805;digamma[3104]=7.3469775012;digamma[3105]=7.3472997180;digamma[3106]=7.3476218311;digamma[3107]=7.3479438404;digamma[3108]=7.3482657461;digamma[3109]=7.3485875482;digamma[3110]=7.3489092467;digamma[3111]=7.3492308418;digamma[3112]=7.3495523336;digamma[3113]=7.3498737219;digamma[3114]=7.3501950071;digamma[3115]=7.3505161890;digamma[3116]=7.3508372678;digamma[3117]=7.3511582436;digamma[3118]=7.3514791164;digamma[3119]=7.3517998862;digamma[3120]=7.3521205532;digamma[3121]=7.3524411174;digamma[3122]=7.3527615788;digamma[3123]=7.3530819376;digamma[3124]=7.3534021938;digamma[3125]=7.3537223475;digamma[3126]=7.3540423987;digamma[3127]=7.3543623475;digamma[3128]=7.3546821939;digamma[3129]=7.3550019381;digamma[3130]=7.3553215801;digamma[3131]=7.3556411200;digamma[3132]=7.3559605578;digamma[3133]=7.3562798935;digamma[3134]=7.3565991274;digamma[3135]=7.3569182593;digamma[3136]=7.3572372895;digamma[3137]=7.3575562179;digamma[3138]=7.3578750446;digamma[3139]=7.3581937697;digamma[3140]=7.3585123932;digamma[3141]=7.3588309152;digamma[3142]=7.3591493359;digamma[3143]=7.3594676551;digamma[3144]=7.3597858731;digamma[3145]=7.3601039899;digamma[3146]=7.3604220054;digamma[3147]=7.3607399199;digamma[3148]=7.3610577333;digamma[3149]=7.3613754458;digamma[3150]=7.3616930573;digamma[3151]=7.3620105681;digamma[3152]=7.3623279780;digamma[3153]=7.3626452872;digamma[3154]=7.3629624958;digamma[3155]=7.3632796037;digamma[3156]=7.3635966112;digamma[3157]=7.3639135181;digamma[3158]=7.3642303247;digamma[3159]=7.3645470310;digamma[3160]=7.3648636369;digamma[3161]=7.3651801427;digamma[3162]=7.3654965483;digamma[3163]=7.3658128539;digamma[3164]=7.3661290594;digamma[3165]=7.3664451650;digamma[3166]=7.3667611707;digamma[3167]=7.3670770765;digamma[3168]=7.3673928826;digamma[3169]=7.3677085890;digamma[3170]=7.3680241957;digamma[3171]=7.3683397029;digamma[3172]=7.3686551106;digamma[3173]=7.3689704188;digamma[3174]=7.3692856276;digamma[3175]=7.3696007371;digamma[3176]=7.3699157473;digamma[3177]=7.3702306583;digamma[3178]=7.3705454702;digamma[3179]=7.3708601830;digamma[3180]=7.3711747968;digamma[3181]=7.3714893117;digamma[3182]=7.3718037277;digamma[3183]=7.3721180448;digamma[3184]=7.3724322632;digamma[3185]=7.3727463828;digamma[3186]=7.3730604039;digamma[3187]=7.3733743263;digamma[3188]=7.3736881503;digamma[3189]=7.3740018757;digamma[3190]=7.3743155028;digamma[3191]=7.3746290316;digamma[3192]=7.3749424621;digamma[3193]=7.3752557944;digamma[3194]=7.3755690285;digamma[3195]=7.3758821646;digamma[3196]=7.3761952026;digamma[3197]=7.3765081426;digamma[3198]=7.3768209848;digamma[3199]=7.3771337291;digamma[3200]=7.3774463757;digamma[3201]=7.3777589245;digamma[3202]=7.3780713757;digamma[3203]=7.3783837293;digamma[3204]=7.3786959853;digamma[3205]=7.3790081439;digamma[3206]=7.3793202050;digamma[3207]=7.3796321688;digamma[3208]=7.3799440353;digamma[3209]=7.3802558046;digamma[3210]=7.3805674767;digamma[3211]=7.3808790517;digamma[3212]=7.3811905297;digamma[3213]=7.3815019107;digamma[3214]=7.3818131947;digamma[3215]=7.3821243819;digamma[3216]=7.3824354722;digamma[3217]=7.3827464659;digamma[3218]=7.3830573628;digamma[3219]=7.3833681631;digamma[3220]=7.3836788668;digamma[3221]=7.3839894741;digamma[3222]=7.3842999848;digamma[3223]=7.3846103992;digamma[3224]=7.3849207173;digamma[3225]=7.3852309391;digamma[3226]=7.3855410647;digamma[3227]=7.3858510941;digamma[3228]=7.3861610275;digamma[3229]=7.3864708648;digamma[3230]=7.3867806062;digamma[3231]=7.3870902516;digamma[3232]=7.3873998012;digamma[3233]=7.3877092550;digamma[3234]=7.3880186131;digamma[3235]=7.3883278755;digamma[3236]=7.3886370423;digamma[3237]=7.3889461135;digamma[3238]=7.3892550893;digamma[3239]=7.3895639696;digamma[3240]=7.3898727545;digamma[3241]=7.3901814441;digamma[3242]=7.3904900384;digamma[3243]=7.3907985376;digamma[3244]=7.3911069416;digamma[3245]=7.3914152505;digamma[3246]=7.3917234644;digamma[3247]=7.3920315833;digamma[3248]=7.3923396074;digamma[3249]=7.3926475365;digamma[3250]=7.3929553709;digamma[3251]=7.3932631105;digamma[3252]=7.3935707555;digamma[3253]=7.3938783059;digamma[3254]=7.3941857617;digamma[3255]=7.3944931230;digamma[3256]=7.3948003898;digamma[3257]=7.3951075623;digamma[3258]=7.3954146404;digamma[3259]=7.3957216243;digamma[3260]=7.3960285140;digamma[3261]=7.3963353095;digamma[3262]=7.3966420109;digamma[3263]=7.3969486183;digamma[3264]=7.3972551317;digamma[3265]=7.3975615512;digamma[3266]=7.3978678768;digamma[3267]=7.3981741086;digamma[3268]=7.3984802467;digamma[3269]=7.3987862910;digamma[3270]=7.3990922418;digamma[3271]=7.3993980989;digamma[3272]=7.3997038626;digamma[3273]=7.4000095327;digamma[3274]=7.4003151095;digamma[3275]=7.4006205929;digamma[3276]=7.4009259830;digamma[3277]=7.4012312799;digamma[3278]=7.4015364837;digamma[3279]=7.4018415943;digamma[3280]=7.4021466118;digamma[3281]=7.4024515363;digamma[3282]=7.4027563679;digamma[3283]=7.4030611066;digamma[3284]=7.4033657524;digamma[3285]=7.4036703055;digamma[3286]=7.4039747658;digamma[3287]=7.4042791335;digamma[3288]=7.4045834085;digamma[3289]=7.4048875910;digamma[3290]=7.4051916810;digamma[3291]=7.4054956786;digamma[3292]=7.4057995838;digamma[3293]=7.4061033966;digamma[3294]=7.4064071172;digamma[3295]=7.4067107455;digamma[3296]=7.4070142817;digamma[3297]=7.4073177258;digamma[3298]=7.4076210778;digamma[3299]=7.4079243379;digamma[3300]=7.4082275060;digamma[3301]=7.4085305822;digamma[3302]=7.4088335666;digamma[3303]=7.4091364592;digamma[3304]=7.4094392601;digamma[3305]=7.4097419693;digamma[3306]=7.4100445870;digamma[3307]=7.4103471131;digamma[3308]=7.4106495477;digamma[3309]=7.4109518908;digamma[3310]=7.4112541426;digamma[3311]=7.4115563030;digamma[3312]=7.4118583722;digamma[3313]=7.4121603501;digamma[3314]=7.4124622369;digamma[3315]=7.4127640326;digamma[3316]=7.4130657372;digamma[3317]=7.4133673509;digamma[3318]=7.4136688735;digamma[3319]=7.4139703053;digamma[3320]=7.4142716463;digamma[3321]=7.4145728965;digamma[3322]=7.4148740559;digamma[3323]=7.4151751247;digamma[3324]=7.4154761029;digamma[3325]=7.4157769905;digamma[3326]=7.4160777876;digamma[3327]=7.4163784943;digamma[3328]=7.4166791105;digamma[3329]=7.4169796364;digamma[3330]=7.4172800721;digamma[3331]=7.4175804174;digamma[3332]=7.4178806727;digamma[3333]=7.4181808377;digamma[3334]=7.4184809128;digamma[3335]=7.4187808977;digamma[3336]=7.4190807928;digamma[3337]=7.4193805979;digamma[3338]=7.4196803132;digamma[3339]=7.4199799386;digamma[3340]=7.4202794743;digamma[3341]=7.4205789204;digamma[3342]=7.4208782767;digamma[3343]=7.4211775435;digamma[3344]=7.4214767208;digamma[3345]=7.4217758085;digamma[3346]=7.4220748069;digamma[3347]=7.4223737159;digamma[3348]=7.4226725355;digamma[3349]=7.4229712659;digamma[3350]=7.4232699071;digamma[3351]=7.4235684591;digamma[3352]=7.4238669220;digamma[3353]=7.4241652959;digamma[3354]=7.4244635807;digamma[3355]=7.4247617766;digamma[3356]=7.4250598837;digamma[3357]=7.4253579018;digamma[3358]=7.4256558312;digamma[3359]=7.4259536719;digamma[3360]=7.4262514238;digamma[3361]=7.4265490872;digamma[3362]=7.4268466619;digamma[3363]=7.4271441482;digamma[3364]=7.4274415459;digamma[3365]=7.4277388553;digamma[3366]=7.4280360762;digamma[3367]=7.4283332089;digamma[3368]=7.4286302533;digamma[3369]=7.4289272095;digamma[3370]=7.4292240775;digamma[3371]=7.4295208575;digamma[3372]=7.4298175493;digamma[3373]=7.4301141532;digamma[3374]=7.4304106692;digamma[3375]=7.4307070972;digamma[3376]=7.4310034374;digamma[3377]=7.4312996898;digamma[3378]=7.4315958544;digamma[3379]=7.4318919314;digamma[3380]=7.4321879208;digamma[3381]=7.4324838225;digamma[3382]=7.4327796367;digamma[3383]=7.4330753635;digamma[3384]=7.4333710028;digamma[3385]=7.4336665547;digamma[3386]=7.4339620193;digamma[3387]=7.4342573967;digamma[3388]=7.4345526868;digamma[3389]=7.4348478897;digamma[3390]=7.4351430056;digamma[3391]=7.4354380343;digamma[3392]=7.4357329761;digamma[3393]=7.4360278308;digamma[3394]=7.4363225987;digamma[3395]=7.4366172797;digamma[3396]=7.4369118739;digamma[3397]=7.4372063813;digamma[3398]=7.4375008020;digamma[3399]=7.4377951361;digamma[3400]=7.4380893836;digamma[3401]=7.4383835445;digamma[3402]=7.4386776189;digamma[3403]=7.4389716068;digamma[3404]=7.4392655083;digamma[3405]=7.4395593235;digamma[3406]=7.4398530524;digamma[3407]=7.4401466950;digamma[3408]=7.4404402515;digamma[3409]=7.4407337217;digamma[3410]=7.4410271059;digamma[3411]=7.4413204041;digamma[3412]=7.4416136162;digamma[3413]=7.4419067424;digamma[3414]=7.4421997827;digamma[3415]=7.4424927371;digamma[3416]=7.4427856057;digamma[3417]=7.4430783886;digamma[3418]=7.4433710858;digamma[3419]=7.4436636974;digamma[3420]=7.4439562233;digamma[3421]=7.4442486637;digamma[3422]=7.4445410187;digamma[3423]=7.4448332881;digamma[3424]=7.4451254722;digamma[3425]=7.4454175709;digamma[3426]=7.4457095843;digamma[3427]=7.4460015125;digamma[3428]=7.4462933555;digamma[3429]=7.4465851133;digamma[3430]=7.4468767861;digamma[3431]=7.4471683738;digamma[3432]=7.4474598765;digamma[3433]=7.4477512942;digamma[3434]=7.4480426270;digamma[3435]=7.4483338750;digamma[3436]=7.4486250382;digamma[3437]=7.4489161167;digamma[3438]=7.4492071104;digamma[3439]=7.4494980195;digamma[3440]=7.4497888440;digamma[3441]=7.4500795839;digamma[3442]=7.4503702393;digamma[3443]=7.4506608103;digamma[3444]=7.4509512968;digamma[3445]=7.4512416990;digamma[3446]=7.4515320169;digamma[3447]=7.4518222506;digamma[3448]=7.4521124000;digamma[3449]=7.4524024652;digamma[3450]=7.4526924464;digamma[3451]=7.4529823435;digamma[3452]=7.4532721565;digamma[3453]=7.4535618856;digamma[3454]=7.4538515308;digamma[3455]=7.4541410921;digamma[3456]=7.4544305696;digamma[3457]=7.4547199633;digamma[3458]=7.4550092733;digamma[3459]=7.4552984996;digamma[3460]=7.4555876423;digamma[3461]=7.4558767014;digamma[3462]=7.4561656770;digamma[3463]=7.4564545691;digamma[3464]=7.4567433777;digamma[3465]=7.4570321030;digamma[3466]=7.4573207449;digamma[3467]=7.4576093036;digamma[3468]=7.4578977790;digamma[3469]=7.4581861712;digamma[3470]=7.4584744803;digamma[3471]=7.4587627062;digamma[3472]=7.4590508491;digamma[3473]=7.4593389090;digamma[3474]=7.4596268860;digamma[3475]=7.4599147801;digamma[3476]=7.4602025912;digamma[3477]=7.4604903196;digamma[3478]=7.4607779652;digamma[3479]=7.4610655281;digamma[3480]=7.4613530084;digamma[3481]=7.4616404060;digamma[3482]=7.4619277210;digamma[3483]=7.4622149535;digamma[3484]=7.4625021035;digamma[3485]=7.4627891711;digamma[3486]=7.4630761564;digamma[3487]=7.4633630592;digamma[3488]=7.4636498798;digamma[3489]=7.4639366182;digamma[3490]=7.4642232743;digamma[3491]=7.4645098483;digamma[3492]=7.4647963402;digamma[3493]=7.4650827501;digamma[3494]=7.4653690779;digamma[3495]=7.4656553238;digamma[3496]=7.4659414878;digamma[3497]=7.4662275699;digamma[3498]=7.4665135701;digamma[3499]=7.4667994886;digamma[3500]=7.4670853254;digamma[3501]=7.4673710805;digamma[3502]=7.4676567540;digamma[3503]=7.4679423459;digamma[3504]=7.4682278562;digamma[3505]=7.4685132851;digamma[3506]=7.4687986325;digamma[3507]=7.4690838985;digamma[3508]=7.4693690831;digamma[3509]=7.4696541865;digamma[3510]=7.4699392086;digamma[3511]=7.4702241494;digamma[3512]=7.4705090091;digamma[3513]=7.4707937877;digamma[3514]=7.4710784852;digamma[3515]=7.4713631017;digamma[3516]=7.4716476372;digamma[3517]=7.4719320917;digamma[3518]=7.4722164654;digamma[3519]=7.4725007582;digamma[3520]=7.4727849702;digamma[3521]=7.4730691015;digamma[3522]=7.4733531520;digamma[3523]=7.4736371219;digamma[3524]=7.4739210112;digamma[3525]=7.4742048199;digamma[3526]=7.4744885481;digamma[3527]=7.4747721958;digamma[3528]=7.4750557631;digamma[3529]=7.4753392500;digamma[3530]=7.4756226565;digamma[3531]=7.4759059827;digamma[3532]=7.4761892287;digamma[3533]=7.4764723945;digamma[3534]=7.4767554802;digamma[3535]=7.4770384857;digamma[3536]=7.4773214111;digamma[3537]=7.4776042565;digamma[3538]=7.4778870220;digamma[3539]=7.4781697075;digamma[3540]=7.4784523131;digamma[3541]=7.4787348389;digamma[3542]=7.4790172848;digamma[3543]=7.4792996511;digamma[3544]=7.4795819376;digamma[3545]=7.4798641444;digamma[3546]=7.4801462717;digamma[3547]=7.4804283193;digamma[3548]=7.4807102875;digamma[3549]=7.4809921761;digamma[3550]=7.4812739853;digamma[3551]=7.4815557151;digamma[3552]=7.4818373656;digamma[3553]=7.4821189368;digamma[3554]=7.4824004287;digamma[3555]=7.4826818413;digamma[3556]=7.4829631749;digamma[3557]=7.4832444293;digamma[3558]=7.4835256046;digamma[3559]=7.4838067008;digamma[3560]=7.4840877181;digamma[3561]=7.4843686564;digamma[3562]=7.4846495159;digamma[3563]=7.4849302964;digamma[3564]=7.4852109982;digamma[3565]=7.4854916212;digamma[3566]=7.4857721654;digamma[3567]=7.4860526310;digamma[3568]=7.4863330179;digamma[3569]=7.4866133262;digamma[3570]=7.4868935560;digamma[3571]=7.4871737073;digamma[3572]=7.4874537801;digamma[3573]=7.4877337745;digamma[3574]=7.4880136905;digamma[3575]=7.4882935282;digamma[3576]=7.4885732876;digamma[3577]=7.4888529688;digamma[3578]=7.4891325717;digamma[3579]=7.4894120965;digamma[3580]=7.4896915432;digamma[3581]=7.4899709118;digamma[3582]=7.4902502024;digamma[3583]=7.4905294151;digamma[3584]=7.4908085497;digamma[3585]=7.4910876065;digamma[3586]=7.4913665854;digamma[3587]=7.4916454866;digamma[3588]=7.4919243099;digamma[3589]=7.4922030556;digamma[3590]=7.4924817235;digamma[3591]=7.4927603139;digamma[3592]=7.4930388266;digamma[3593]=7.4933172618;digamma[3594]=7.4935956195;digamma[3595]=7.4938738997;digamma[3596]=7.4941521025;digamma[3597]=7.4944302279;digamma[3598]=7.4947082760;digamma[3599]=7.4949862468;digamma[3600]=7.4952641404;digamma[3601]=7.4955419567;digamma[3602]=7.4958196959;digamma[3603]=7.4960973580;digamma[3604]=7.4963749430;digamma[3605]=7.4966524510;digamma[3606]=7.4969298820;digamma[3607]=7.4972072360;digamma[3608]=7.4974845132;digamma[3609]=7.4977617134;digamma[3610]=7.4980388369;digamma[3611]=7.4983158836;digamma[3612]=7.4985928535;digamma[3613]=7.4988697468;digamma[3614]=7.4991465634;digamma[3615]=7.4994233034;digamma[3616]=7.4996999668;digamma[3617]=7.4999765537;digamma[3618]=7.5002530641;digamma[3619]=7.5005294981;digamma[3620]=7.5008058557;digamma[3621]=7.5010821370;digamma[3622]=7.5013583419;digamma[3623]=7.5016344706;digamma[3624]=7.5019105230;digamma[3625]=7.5021864993;digamma[3626]=7.5024623994;digamma[3627]=7.5027382234;digamma[3628]=7.5030139714;digamma[3629]=7.5032896433;digamma[3630]=7.5035652393;digamma[3631]=7.5038407593;digamma[3632]=7.5041162035;digamma[3633]=7.5043915718;digamma[3634]=7.5046668643;digamma[3635]=7.5049420810;digamma[3636]=7.5052172220;digamma[3637]=7.5054922873;digamma[3638]=7.5057672770;digamma[3639]=7.5060421911;digamma[3640]=7.5063170296;digamma[3641]=7.5065917926;digamma[3642]=7.5068664802;digamma[3643]=7.5071410923;digamma[3644]=7.5074156290;digamma[3645]=7.5076900904;digamma[3646]=7.5079644764;digamma[3647]=7.5082387872;digamma[3648]=7.5085130228;digamma[3649]=7.5087871832;digamma[3650]=7.5090612684;digamma[3651]=7.5093352785;digamma[3652]=7.5096092136;digamma[3653]=7.5098830737;digamma[3654]=7.5101568587;digamma[3655]=7.5104305689;digamma[3656]=7.5107042041;digamma[3657]=7.5109777645;digamma[3658]=7.5112512501;digamma[3659]=7.5115246608;digamma[3660]=7.5117979969;digamma[3661]=7.5120712583;digamma[3662]=7.5123444450;digamma[3663]=7.5126175571;digamma[3664]=7.5128905946;digamma[3665]=7.5131635576;digamma[3666]=7.5134364462;digamma[3667]=7.5137092602;digamma[3668]=7.5139819999;digamma[3669]=7.5142546652;digamma[3670]=7.5145272562;digamma[3671]=7.5147997729;digamma[3672]=7.5150722153;digamma[3673]=7.5153445835;digamma[3674]=7.5156168776;digamma[3675]=7.5158890976;digamma[3676]=7.5161612434;digamma[3677]=7.5164333152;digamma[3678]=7.5167053131;digamma[3679]=7.5169772369;digamma[3680]=7.5172490869;digamma[3681]=7.5175208629;digamma[3682]=7.5177925651;digamma[3683]=7.5180641935;digamma[3684]=7.5183357482;digamma[3685]=7.5186072291;digamma[3686]=7.5188786363;digamma[3687]=7.5191499699;digamma[3688]=7.5194212299;digamma[3689]=7.5196924164;digamma[3690]=7.5199635293;digamma[3691]=7.5202345687;digamma[3692]=7.5205055347;digamma[3693]=7.5207764273;digamma[3694]=7.5210472465;digamma[3695]=7.5213179924;digamma[3696]=7.5215886650;digamma[3697]=7.5218592644;digamma[3698]=7.5221297906;digamma[3699]=7.5224002436;digamma[3700]=7.5226706235;digamma[3701]=7.5229409302;digamma[3702]=7.5232111640;digamma[3703]=7.5234813247;digamma[3704]=7.5237514125;digamma[3705]=7.5240214274;digamma[3706]=7.5242913693;digamma[3707]=7.5245612384;digamma[3708]=7.5248310347;digamma[3709]=7.5251007582;digamma[3710]=7.5253704090;digamma[3711]=7.5256399872;digamma[3712]=7.5259094926;digamma[3713]=7.5261789254;digamma[3714]=7.5264482857;digamma[3715]=7.5267175734;digamma[3716]=7.5269867887;digamma[3717]=7.5272559314;digamma[3718]=7.5275250018;digamma[3719]=7.5277939998;digamma[3720]=7.5280629254;digamma[3721]=7.5283317788;digamma[3722]=7.5286005598;digamma[3723]=7.5288692687;digamma[3724]=7.5291379053;digamma[3725]=7.5294064699;digamma[3726]=7.5296749623;digamma[3727]=7.5299433826;digamma[3728]=7.5302117309;digamma[3729]=7.5304800072;digamma[3730]=7.5307482116;digamma[3731]=7.5310163441;digamma[3732]=7.5312844046;digamma[3733]=7.5315523934;digamma[3734]=7.5318203103;digamma[3735]=7.5320881555;digamma[3736]=7.5323559290;digamma[3737]=7.5326236307;digamma[3738]=7.5328912609;digamma[3739]=7.5331588194;digamma[3740]=7.5334263063;digamma[3741]=7.5336937218;digamma[3742]=7.5339610657;digamma[3743]=7.5342283382;digamma[3744]=7.5344955392;digamma[3745]=7.5347626689;digamma[3746]=7.5350297273;digamma[3747]=7.5352967143;digamma[3748]=7.5355636301;digamma[3749]=7.5358304747;digamma[3750]=7.5360972480;digamma[3751]=7.5363639503;digamma[3752]=7.5366305814;digamma[3753]=7.5368971414;digamma[3754]=7.5371636304;digamma[3755]=7.5374300484;digamma[3756]=7.5376963955;digamma[3757]=7.5379626716;digamma[3758]=7.5382288768;digamma[3759]=7.5384950112;digamma[3760]=7.5387610748;digamma[3761]=7.5390270676;digamma[3762]=7.5392929897;digamma[3763]=7.5395588411;digamma[3764]=7.5398246218;digamma[3765]=7.5400903319;digamma[3766]=7.5403559714;digamma[3767]=7.5406215404;digamma[3768]=7.5408870389;digamma[3769]=7.5411524669;digamma[3770]=7.5414178244;digamma[3771]=7.5416831116;digamma[3772]=7.5419483284;digamma[3773]=7.5422134749;digamma[3774]=7.5424785511;digamma[3775]=7.5427435571;digamma[3776]=7.5430084928;digamma[3777]=7.5432733584;digamma[3778]=7.5435381538;digamma[3779]=7.5438028792;digamma[3780]=7.5440675345;digamma[3781]=7.5443321197;digamma[3782]=7.5445966350;digamma[3783]=7.5448610803;digamma[3784]=7.5451254557;digamma[3785]=7.5453897613;digamma[3786]=7.5456539969;digamma[3787]=7.5459181628;digamma[3788]=7.5461822590;digamma[3789]=7.5464462854;digamma[3790]=7.5467102421;digamma[3791]=7.5469741291;digamma[3792]=7.5472379466;digamma[3793]=7.5475016944;digamma[3794]=7.5477653727;digamma[3795]=7.5480289815;digamma[3796]=7.5482925208;digamma[3797]=7.5485559907;digamma[3798]=7.5488193912;digamma[3799]=7.5490827224;digamma[3800]=7.5493459842;digamma[3801]=7.5496091767;digamma[3802]=7.5498723000;digamma[3803]=7.5501353540;digamma[3804]=7.5503983389;digamma[3805]=7.5506612546;digamma[3806]=7.5509241012;digamma[3807]=7.5511868788;digamma[3808]=7.5514495873;digamma[3809]=7.5517122268;digamma[3810]=7.5519747974;digamma[3811]=7.5522372990;digamma[3812]=7.5524997318;digamma[3813]=7.5527620957;digamma[3814]=7.5530243908;digamma[3815]=7.5532866171;digamma[3816]=7.5535487746;digamma[3817]=7.5538108635;digamma[3818]=7.5540728836;digamma[3819]=7.5543348352;digamma[3820]=7.5545967181;digamma[3821]=7.5548585325;digamma[3822]=7.5551202783;digamma[3823]=7.5553819556;digamma[3824]=7.5556435645;digamma[3825]=7.5559051050;digamma[3826]=7.5561665771;digamma[3827]=7.5564279808;digamma[3828]=7.5566893162;digamma[3829]=7.5569505834;digamma[3830]=7.5572117823;digamma[3831]=7.5574729130;digamma[3832]=7.5577339755;digamma[3833]=7.5579949699;digamma[3834]=7.5582558962;digamma[3835]=7.5585167544;digamma[3836]=7.5587775446;digamma[3837]=7.5590382668;digamma[3838]=7.5592989210;digamma[3839]=7.5595595073;digamma[3840]=7.5598200257;digamma[3841]=7.5600804763;digamma[3842]=7.5603408591;digamma[3843]=7.5606011741;digamma[3844]=7.5608614213;digamma[3845]=7.5611216008;digamma[3846]=7.5613817127;digamma[3847]=7.5616417569;digamma[3848]=7.5619017335;digamma[3849]=7.5621616425;digamma[3850]=7.5624214840;digamma[3851]=7.5626812580;digamma[3852]=7.5629409645;digamma[3853]=7.5632006036;digamma[3854]=7.5634601753;digamma[3855]=7.5637196796;digamma[3856]=7.5639791167;digamma[3857]=7.5642384864;digamma[3858]=7.5644977889;digamma[3859]=7.5647570241;digamma[3860]=7.5650161922;digamma[3861]=7.5652752931;digamma[3862]=7.5655343269;digamma[3863]=7.5657932936;digamma[3864]=7.5660521933;digamma[3865]=7.5663110259;digamma[3866]=7.5665697916;digamma[3867]=7.5668284904;digamma[3868]=7.5670871222;digamma[3869]=7.5673456872;digamma[3870]=7.5676041853;digamma[3871]=7.5678626166;digamma[3872]=7.5681209811;digamma[3873]=7.5683792790;digamma[3874]=7.5686375101;digamma[3875]=7.5688956745;digamma[3876]=7.5691537723;digamma[3877]=7.5694118035;digamma[3878]=7.5696697682;digamma[3879]=7.5699276663;digamma[3880]=7.5701854980;digamma[3881]=7.5704432631;digamma[3882]=7.5707009619;digamma[3883]=7.5709585942;digamma[3884]=7.5712161602;digamma[3885]=7.5714736599;digamma[3886]=7.5717310933;digamma[3887]=7.5719884604;digamma[3888]=7.5722457613;digamma[3889]=7.5725029960;digamma[3890]=7.5727601646;digamma[3891]=7.5730172671;digamma[3892]=7.5732743034;digamma[3893]=7.5735312737;digamma[3894]=7.5737881780;digamma[3895]=7.5740450164;digamma[3896]=7.5743017887;digamma[3897]=7.5745584952;digamma[3898]=7.5748151358;digamma[3899]=7.5750717105;digamma[3900]=7.5753282194;digamma[3901]=7.5755846625;digamma[3902]=7.5758410399;digamma[3903]=7.5760973516;digamma[3904]=7.5763535976;digamma[3905]=7.5766097779;digamma[3906]=7.5768658926;digamma[3907]=7.5771219418;digamma[3908]=7.5773779254;digamma[3909]=7.5776338435;digamma[3910]=7.5778896961;digamma[3911]=7.5781454833;digamma[3912]=7.5784012051;digamma[3913]=7.5786568615;digamma[3914]=7.5789124525;digamma[3915]=7.5791679783;digamma[3916]=7.5794234387;digamma[3917]=7.5796788340;digamma[3918]=7.5799341640;digamma[3919]=7.5801894288;digamma[3920]=7.5804446285;digamma[3921]=7.5806997631;digamma[3922]=7.5809548326;digamma[3923]=7.5812098370;digamma[3924]=7.5814647765;digamma[3925]=7.5817196509;digamma[3926]=7.5819744605;digamma[3927]=7.5822292051;digamma[3928]=7.5824838848;digamma[3929]=7.5827384997;digamma[3930]=7.5829930498;digamma[3931]=7.5832475351;digamma[3932]=7.5835019556;digamma[3933]=7.5837563115;digamma[3934]=7.5840106026;digamma[3935]=7.5842648292;digamma[3936]=7.5845189911;digamma[3937]=7.5847730884;digamma[3938]=7.5850271211;digamma[3939]=7.5852810894;digamma[3940]=7.5855349932;digamma[3941]=7.5857888325;digamma[3942]=7.5860426074;digamma[3943]=7.5862963179;digamma[3944]=7.5865499640;digamma[3945]=7.5868035459;digamma[3946]=7.5870570634;digamma[3947]=7.5873105167;digamma[3948]=7.5875639058;digamma[3949]=7.5878172307;digamma[3950]=7.5880704914;digamma[3951]=7.5883236880;digamma[3952]=7.5885768205;digamma[3953]=7.5888298890;digamma[3954]=7.5890828934;digamma[3955]=7.5893358338;digamma[3956]=7.5895887103;digamma[3957]=7.5898415228;digamma[3958]=7.5900942715;digamma[3959]=7.5903469562;digamma[3960]=7.5905995772;digamma[3961]=7.5908521343;digamma[3962]=7.5911046277;digamma[3963]=7.5913570573;digamma[3964]=7.5916094232;digamma[3965]=7.5918617255;digamma[3966]=7.5921139641;digamma[3967]=7.5923661391;digamma[3968]=7.5926182505;digamma[3969]=7.5928702984;digamma[3970]=7.5931222828;digamma[3971]=7.5933742037;digamma[3972]=7.5936260611;digamma[3973]=7.5938778552;digamma[3974]=7.5941295858;digamma[3975]=7.5943812531;digamma[3976]=7.5946328571;digamma[3977]=7.5948843978;digamma[3978]=7.5951358752;digamma[3979]=7.5953872894;digamma[3980]=7.5956386404;digamma[3981]=7.5958899282;digamma[3982]=7.5961411530;digamma[3983]=7.5963923146;digamma[3984]=7.5966434131;digamma[3985]=7.5968944486;digamma[3986]=7.5971454212;digamma[3987]=7.5973963307;digamma[3988]=7.5976471773;digamma[3989]=7.5978979610;digamma[3990]=7.5981486818;digamma[3991]=7.5983993398;digamma[3992]=7.5986499350;digamma[3993]=7.5989004673;digamma[3994]=7.5991509370;digamma[3995]=7.5994013439;digamma[3996]=7.5996516881;digamma[3997]=7.5999019696;digamma[3998]=7.6001521886;digamma[3999]=7.6004023449;digamma[4000]=7.6006524387;digamma[4001]=7.6009024700;digamma[4002]=7.6011524387;digamma[4003]=7.6014023450;digamma[4004]=7.6016521888;digamma[4005]=7.6019019703;digamma[4006]=7.6021516893;digamma[4007]=7.6024013461;digamma[4008]=7.6026509405;digamma[4009]=7.6029004726;digamma[4010]=7.6031499425;digamma[4011]=7.6033993501;digamma[4012]=7.6036486956;digamma[4013]=7.6038979789;digamma[4014]=7.6041472001;digamma[4015]=7.6043963591;digamma[4016]=7.6046454562;digamma[4017]=7.6048944911;digamma[4018]=7.6051434641;digamma[4019]=7.6053923751;digamma[4020]=7.6056412242;digamma[4021]=7.6058900114;digamma[4022]=7.6061387366;digamma[4023]=7.6063874001;digamma[4024]=7.6066360017;digamma[4025]=7.6068845415;digamma[4026]=7.6071330196;digamma[4027]=7.6073814359;digamma[4028]=7.6076297906;digamma[4029]=7.6078780836;digamma[4030]=7.6081263149;digamma[4031]=7.6083744846;digamma[4032]=7.6086225928;digamma[4033]=7.6088706394;digamma[4034]=7.6091186246;digamma[4035]=7.6093665482;digamma[4036]=7.6096144104;digamma[4037]=7.6098622111;digamma[4038]=7.6101099505;digamma[4039]=7.6103576285;digamma[4040]=7.6106052452;digamma[4041]=7.6108528006;digamma[4042]=7.6111002947;digamma[4043]=7.6113477276;digamma[4044]=7.6115950993;digamma[4045]=7.6118424098;digamma[4046]=7.6120896591;digamma[4047]=7.6123368473;digamma[4048]=7.6125839745;digamma[4049]=7.6128310406;digamma[4050]=7.6130780456;digamma[4051]=7.6133249897;digamma[4052]=7.6135718728;digamma[4053]=7.6138186950;digamma[4054]=7.6140654562;digamma[4055]=7.6143121566;digamma[4056]=7.6145587961;digamma[4057]=7.6148053748;digamma[4058]=7.6150518928;digamma[4059]=7.6152983499;digamma[4060]=7.6155447464;digamma[4061]=7.6157910821;digamma[4062]=7.6160373572;digamma[4063]=7.6162835717;digamma[4064]=7.6165297255;digamma[4065]=7.6167758188;digamma[4066]=7.6170218515;digamma[4067]=7.6172678237;digamma[4068]=7.6175137354;digamma[4069]=7.6177595867;digamma[4070]=7.6180053775;digamma[4071]=7.6182511079;digamma[4072]=7.6184967780;digamma[4073]=7.6187423877;digamma[4074]=7.6189879371;digamma[4075]=7.6192334263;digamma[4076]=7.6194788552;digamma[4077]=7.6197242238;digamma[4078]=7.6199695323;digamma[4079]=7.6202147806;digamma[4080]=7.6204599688;digamma[4081]=7.6207050969;digamma[4082]=7.6209501649;digamma[4083]=7.6211951728;digamma[4084]=7.6214401208;digamma[4085]=7.6216850087;digamma[4086]=7.6219298367;digamma[4087]=7.6221746048;digamma[4088]=7.6224193130;digamma[4089]=7.6226639613;digamma[4090]=7.6229085498;digamma[4091]=7.6231530784;digamma[4092]=7.6233975473;digamma[4093]=7.6236419565;digamma[4094]=7.6238863059;digamma[4095]=7.6241305956;digamma[4096]=7.6243748257;digamma[4097]=7.6246189961;digamma[4098]=7.6248631069;digamma[4099]=7.6251071582;digamma[4100]=7.6253511499;digamma[4101]=7.6255950820;digamma[4102]=7.6258389547;digamma[4103]=7.6260827680;digamma[4104]=7.6263265218;digamma[4105]=7.6265702162;digamma[4106]=7.6268138512;digamma[4107]=7.6270574269;digamma[4108]=7.6273009433;digamma[4109]=7.6275444004;digamma[4110]=7.6277877982;digamma[4111]=7.6280311368;digamma[4112]=7.6282744162;digamma[4113]=7.6285176364;digamma[4114]=7.6287607975;digamma[4115]=7.6290038995;digamma[4116]=7.6292469424;digamma[4117]=7.6294899262;digamma[4118]=7.6297328510;digamma[4119]=7.6299757169;digamma[4120]=7.6302185237;digamma[4121]=7.6304612716;digamma[4122]=7.6307039606;digamma[4123]=7.6309465907;digamma[4124]=7.6311891620;digamma[4125]=7.6314316744;digamma[4126]=7.6316741280;digamma[4127]=7.6319165229;digamma[4128]=7.6321588590;digamma[4129]=7.6324011364;digamma[4130]=7.6326433551;digamma[4131]=7.6328855152;digamma[4132]=7.6331276166;digamma[4133]=7.6333696594;digamma[4134]=7.6336116437;digamma[4135]=7.6338535694;digamma[4136]=7.6340954366;digamma[4137]=7.6343372454;digamma[4138]=7.6345789956;digamma[4139]=7.6348206875;digamma[4140]=7.6350623209;digamma[4141]=7.6353038960;digamma[4142]=7.6355454127;digamma[4143]=7.6357868711;digamma[4144]=7.6360282712;digamma[4145]=7.6362696131;digamma[4146]=7.6365108967;digamma[4147]=7.6367521221;digamma[4148]=7.6369932894;digamma[4149]=7.6372343985;digamma[4150]=7.6374754495;digamma[4151]=7.6377164423;digamma[4152]=7.6379573772;digamma[4153]=7.6381982540;digamma[4154]=7.6384390727;digamma[4155]=7.6386798335;digamma[4156]=7.6389205364;digamma[4157]=7.6391611813;digamma[4158]=7.6394017683;digamma[4159]=7.6396422975;digamma[4160]=7.6398827688;digamma[4161]=7.6401231823;digamma[4162]=7.6403635380;digamma[4163]=7.6406038360;digamma[4164]=7.6408440763;digamma[4165]=7.6410842588;digamma[4166]=7.6413243836;digamma[4167]=7.6415644509;digamma[4168]=7.6418044605;digamma[4169]=7.6420444125;digamma[4170]=7.6422843069;digamma[4171]=7.6425241438;digamma[4172]=7.6427639232;digamma[4173]=7.6430036451;digamma[4174]=7.6432433096;digamma[4175]=7.6434829166;digamma[4176]=7.6437224663;digamma[4177]=7.6439619586;digamma[4178]=7.6442013935;digamma[4179]=7.6444407711;digamma[4180]=7.6446800914;digamma[4181]=7.6449193545;digamma[4182]=7.6451585603;digamma[4183]=7.6453977090;digamma[4184]=7.6456368004;digamma[4185]=7.6458758347;digamma[4186]=7.6461148119;digamma[4187]=7.6463537320;digamma[4188]=7.6465925950;digamma[4189]=7.6468314009;digamma[4190]=7.6470701499;digamma[4191]=7.6473088418;digamma[4192]=7.6475474769;digamma[4193]=7.6477860549;digamma[4194]=7.6480245761;digamma[4195]=7.6482630404;digamma[4196]=7.6485014478;digamma[4197]=7.6487397984;digamma[4198]=7.6489780922;digamma[4199]=7.6492163293;digamma[4200]=7.6494545096;digamma[4201]=7.6496926332;digamma[4202]=7.6499307001;digamma[4203]=7.6501687103;digamma[4204]=7.6504066639;digamma[4205]=7.6506445609;digamma[4206]=7.6508824013;digamma[4207]=7.6511201851;digamma[4208]=7.6513579124;digamma[4209]=7.6515955833;digamma[4210]=7.6518331976;digamma[4211]=7.6520707555;digamma[4212]=7.6523082570;digamma[4213]=7.6525457021;digamma[4214]=7.6527830908;digamma[4215]=7.6530204232;digamma[4216]=7.6532576993;digamma[4217]=7.6534949190;digamma[4218]=7.6537320826;digamma[4219]=7.6539691898;digamma[4220]=7.6542062409;digamma[4221]=7.6544432358;digamma[4222]=7.6546801746;digamma[4223]=7.6549170572;digamma[4224]=7.6551538837;digamma[4225]=7.6553906542;digamma[4226]=7.6556273686;digamma[4227]=7.6558640269;digamma[4228]=7.6561006293;digamma[4229]=7.6563371758;digamma[4230]=7.6565736662;digamma[4231]=7.6568101008;digamma[4232]=7.6570464795;digamma[4233]=7.6572828023;digamma[4234]=7.6575190693;digamma[4235]=7.6577552804;digamma[4236]=7.6579914358;digamma[4237]=7.6582275354;digamma[4238]=7.6584635794;digamma[4239]=7.6586995675;digamma[4240]=7.6589355001;digamma[4241]=7.6591713769;digamma[4242]=7.6594071982;digamma[4243]=7.6596429638;digamma[4244]=7.6598786739;digamma[4245]=7.6601143284;digamma[4246]=7.6603499274;digamma[4247]=7.6605854709;digamma[4248]=7.6608209590;digamma[4249]=7.6610563916;digamma[4250]=7.6612917688;digamma[4251]=7.6615270906;digamma[4252]=7.6617623570;digamma[4253]=7.6619975681;digamma[4254]=7.6622327239;digamma[4255]=7.6624678244;digamma[4256]=7.6627028697;digamma[4257]=7.6629378597;digamma[4258]=7.6631727945;digamma[4259]=7.6634076741;digamma[4260]=7.6636424986;digamma[4261]=7.6638772679;digamma[4262]=7.6641119821;digamma[4263]=7.6643466413;digamma[4264]=7.6645812454;digamma[4265]=7.6648157945;digamma[4266]=7.6650502885;digamma[4267]=7.6652847276;digamma[4268]=7.6655191118;digamma[4269]=7.6657534410;digamma[4270]=7.6659877153;digamma[4271]=7.6662219348;digamma[4272]=7.6664560994;digamma[4273]=7.6666902092;digamma[4274]=7.6669242642;digamma[4275]=7.6671582644;digamma[4276]=7.6673922099;digamma[4277]=7.6676261007;digamma[4278]=7.6678599368;digamma[4279]=7.6680937182;digamma[4280]=7.6683274450;digamma[4281]=7.6685611171;digamma[4282]=7.6687947347;digamma[4283]=7.6690282977;digamma[4284]=7.6692618061;digamma[4285]=7.6694952601;digamma[4286]=7.6697286595;digamma[4287]=7.6699620045;digamma[4288]=7.6701952951;digamma[4289]=7.6704285313;digamma[4290]=7.6706617130;digamma[4291]=7.6708948404;digamma[4292]=7.6711279135;digamma[4293]=7.6713609322;digamma[4294]=7.6715938967;digamma[4295]=7.6718268069;digamma[4296]=7.6720596629;digamma[4297]=7.6722924647;digamma[4298]=7.6725252122;digamma[4299]=7.6727579057;digamma[4300]=7.6729905450;digamma[4301]=7.6732231301;digamma[4302]=7.6734556612;digamma[4303]=7.6736881383;digamma[4304]=7.6739205613;digamma[4305]=7.6741529303;digamma[4306]=7.6743852453;digamma[4307]=7.6746175064;digamma[4308]=7.6748497135;digamma[4309]=7.6750818667;digamma[4310]=7.6753139660;digamma[4311]=7.6755460115;digamma[4312]=7.6757780032;digamma[4313]=7.6760099410;digamma[4314]=7.6762418250;digamma[4315]=7.6764736553;digamma[4316]=7.6767054319;digamma[4317]=7.6769371548;digamma[4318]=7.6771688239;digamma[4319]=7.6774004395;digamma[4320]=7.6776320013;digamma[4321]=7.6778635096;digamma[4322]=7.6780949643;digamma[4323]=7.6783263654;digamma[4324]=7.6785577130;digamma[4325]=7.6787890071;digamma[4326]=7.6790202477;digamma[4327]=7.6792514349;digamma[4328]=7.6794825686;digamma[4329]=7.6797136489;digamma[4330]=7.6799446758;digamma[4331]=7.6801756493;digamma[4332]=7.6804065695;digamma[4333]=7.6806374364;digamma[4334]=7.6808682501;digamma[4335]=7.6810990104;digamma[4336]=7.6813297175;digamma[4337]=7.6815603714;digamma[4338]=7.6817909721;digamma[4339]=7.6820215197;digamma[4340]=7.6822520141;digamma[4341]=7.6824824554;digamma[4342]=7.6827128436;digamma[4343]=7.6829431787;digamma[4344]=7.6831734608;digamma[4345]=7.6834036899;digamma[4346]=7.6836338660;digamma[4347]=7.6838639891;digamma[4348]=7.6840940592;digamma[4349]=7.6843240765;digamma[4350]=7.6845540408;digamma[4351]=7.6847839523;digamma[4352]=7.6850138110;digamma[4353]=7.6852436168;digamma[4354]=7.6854733698;digamma[4355]=7.6857030700;digamma[4356]=7.6859327175;digamma[4357]=7.6861623123;digamma[4358]=7.6863918543;digamma[4359]=7.6866213437;digamma[4360]=7.6868507804;digamma[4361]=7.6870801646;digamma[4362]=7.6873094960;digamma[4363]=7.6875387750;digamma[4364]=7.6877680013;digamma[4365]=7.6879971751;digamma[4366]=7.6882262965;digamma[4367]=7.6884553653;digamma[4368]=7.6886843817;digamma[4369]=7.6889133456;digamma[4370]=7.6891422571;digamma[4371]=7.6893711163;digamma[4372]=7.6895999230;digamma[4373]=7.6898286775;digamma[4374]=7.6900573796;digamma[4375]=7.6902860294;digamma[4376]=7.6905146269;digamma[4377]=7.6907431722;digamma[4378]=7.6909716653;digamma[4379]=7.6912001062;digamma[4380]=7.6914284949;digamma[4381]=7.6916568315;digamma[4382]=7.6918851159;digamma[4383]=7.6921133483;digamma[4384]=7.6923415285;digamma[4385]=7.6925696567;digamma[4386]=7.6927977329;digamma[4387]=7.6930257571;digamma[4388]=7.6932537293;digamma[4389]=7.6934816495;digamma[4390]=7.6937095178;digamma[4391]=7.6939373342;digamma[4392]=7.6941650986;digamma[4393]=7.6943928113;digamma[4394]=7.6946204721;digamma[4395]=7.6948480810;digamma[4396]=7.6950756382;digamma[4397]=7.6953031436;digamma[4398]=7.6955305972;digamma[4399]=7.6957579992;digamma[4400]=7.6959853494;digamma[4401]=7.6962126480;digamma[4402]=7.6964398949;digamma[4403]=7.6966670901;digamma[4404]=7.6968942338;digamma[4405]=7.6971213259;digamma[4406]=7.6973483664;digamma[4407]=7.6975753554;digamma[4408]=7.6978022929;digamma[4409]=7.6980291789;digamma[4410]=7.6982560134;digamma[4411]=7.6984827965;digamma[4412]=7.6987095281;digamma[4413]=7.6989362084;digamma[4414]=7.6991628373;digamma[4415]=7.6993894148;digamma[4416]=7.6996159410;digamma[4417]=7.6998424159;digamma[4418]=7.7000688396;digamma[4419]=7.7002952120;digamma[4420]=7.7005215331;digamma[4421]=7.7007478030;digamma[4422]=7.7009740218;digamma[4423]=7.7012001894;digamma[4424]=7.7014263058;digamma[4425]=7.7016523712;digamma[4426]=7.7018783854;digamma[4427]=7.7021043486;digamma[4428]=7.7023302607;digamma[4429]=7.7025561218;digamma[4430]=7.7027819319;digamma[4431]=7.7030076910;digamma[4432]=7.7032333991;digamma[4433]=7.7034590564;digamma[4434]=7.7036846627;digamma[4435]=7.7039102181;digamma[4436]=7.7041357227;digamma[4437]=7.7043611764;digamma[4438]=7.7045865793;digamma[4439]=7.7048119314;digamma[4440]=7.7050372327;digamma[4441]=7.7052624833;digamma[4442]=7.7054876832;digamma[4443]=7.7057128323;digamma[4444]=7.7059379308;digamma[4445]=7.7061629786;digamma[4446]=7.7063879758;digamma[4447]=7.7066129224;digamma[4448]=7.7068378184;digamma[4449]=7.7070626638;digamma[4450]=7.7072874587;digamma[4451]=7.7075122030;digamma[4452]=7.7077368969;digamma[4453]=7.7079615402;digamma[4454]=7.7081861332;digamma[4455]=7.7084106757;digamma[4456]=7.7086351677;digamma[4457]=7.7088596094;digamma[4458]=7.7090840008;digamma[4459]=7.7093083418;digamma[4460]=7.7095326325;digamma[4461]=7.7097568728;digamma[4462]=7.7099810629;digamma[4463]=7.7102052028;digamma[4464]=7.7104292924;digamma[4465]=7.7106533319;digamma[4466]=7.7108773211;digamma[4467]=7.7111012602;digamma[4468]=7.7113251491;digamma[4469]=7.7115489880;digamma[4470]=7.7117727767;digamma[4471]=7.7119965154;digamma[4472]=7.7122202040;digamma[4473]=7.7124438426;digamma[4474]=7.7126674312;digamma[4475]=7.7128909698;digamma[4476]=7.7131144585;digamma[4477]=7.7133378972;digamma[4478]=7.7135612860;digamma[4479]=7.7137846249;digamma[4480]=7.7140079140;digamma[4481]=7.7142311532;digamma[4482]=7.7144543425;digamma[4483]=7.7146774821;digamma[4484]=7.7149005719;digamma[4485]=7.7151236119;digamma[4486]=7.7153466022;digamma[4487]=7.7155695428;digamma[4488]=7.7157924337;digamma[4489]=7.7160152749;digamma[4490]=7.7162380665;digamma[4491]=7.7164608084;digamma[4492]=7.7166835008;digamma[4493]=7.7169061436;digamma[4494]=7.7171287368;digamma[4495]=7.7173512804;digamma[4496]=7.7175737746;digamma[4497]=7.7177962193;digamma[4498]=7.7180186145;digamma[4499]=7.7182409602;digamma[4500]=7.7184632565;digamma[4501]=7.7186855034;digamma[4502]=7.7189077010;digamma[4503]=7.7191298491;digamma[4504]=7.7193519480;digamma[4505]=7.7195739975;digamma[4506]=7.7197959977;digamma[4507]=7.7200179486;digamma[4508]=7.7202398503;digamma[4509]=7.7204617028;digamma[4510]=7.7206835061;digamma[4511]=7.7209052601;digamma[4512]=7.7211269650;digamma[4513]=7.7213486208;digamma[4514]=7.7215702275;digamma[4515]=7.7217917850;digamma[4516]=7.7220132935;digamma[4517]=7.7222347529;digamma[4518]=7.7224561633;digamma[4519]=7.7226775246;digamma[4520]=7.7228988370;digamma[4521]=7.7231201004;digamma[4522]=7.7233413149;digamma[4523]=7.7235624804;digamma[4524]=7.7237835971;digamma[4525]=7.7240046648;digamma[4526]=7.7242256837;digamma[4527]=7.7244466538;digamma[4528]=7.7246675750;digamma[4529]=7.7248884475;digamma[4530]=7.7251092711;digamma[4531]=7.7253300460;digamma[4532]=7.7255507722;digamma[4533]=7.7257714497;digamma[4534]=7.7259920785;digamma[4535]=7.7262126586;digamma[4536]=7.7264331901;digamma[4537]=7.7266536729;digamma[4538]=7.7268741072;digamma[4539]=7.7270944929;digamma[4540]=7.7273148300;digamma[4541]=7.7275351186;digamma[4542]=7.7277553586;digamma[4543]=7.7279755502;digamma[4544]=7.7281956933;digamma[4545]=7.7284157879;digamma[4546]=7.7286358341;digamma[4547]=7.7288558319;digamma[4548]=7.7290757813;digamma[4549]=7.7292956824;digamma[4550]=7.7295155351;digamma[4551]=7.7297353394;digamma[4552]=7.7299550955;digamma[4553]=7.7301748033;digamma[4554]=7.7303944628;digamma[4555]=7.7306140741;digamma[4556]=7.7308336372;digamma[4557]=7.7310531520;digamma[4558]=7.7312726187;digamma[4559]=7.7314920373;digamma[4560]=7.7317114077;digamma[4561]=7.7319307300;digamma[4562]=7.7321500042;digamma[4563]=7.7323692303;digamma[4564]=7.7325884084;digamma[4565]=7.7328075384;digamma[4566]=7.7330266205;digamma[4567]=7.7332456545;digamma[4568]=7.7334646406;digamma[4569]=7.7336835788;digamma[4570]=7.7339024690;digamma[4571]=7.7341213113;digamma[4572]=7.7343401057;digamma[4573]=7.7345588523;digamma[4574]=7.7347775511;digamma[4575]=7.7349962020;digamma[4576]=7.7352148051;digamma[4577]=7.7354333605;digamma[4578]=7.7356518680;digamma[4579]=7.7358703279;digamma[4580]=7.7360887400;digamma[4581]=7.7363071045;digamma[4582]=7.7365254213;digamma[4583]=7.7367436904;digamma[4584]=7.7369619119;digamma[4585]=7.7371800858;digamma[4586]=7.7373982121;digamma[4587]=7.7376162908;digamma[4588]=7.7378343220;digamma[4589]=7.7380523056;digamma[4590]=7.7382702417;digamma[4591]=7.7384881304;digamma[4592]=7.7387059716;digamma[4593]=7.7389237653;digamma[4594]=7.7391415117;digamma[4595]=7.7393592106;digamma[4596]=7.7395768621;digamma[4597]=7.7397944663;digamma[4598]=7.7400120231;digamma[4599]=7.7402295326;digamma[4600]=7.7404469949;digamma[4601]=7.7406644098;digamma[4602]=7.7408817775;digamma[4603]=7.7410990979;digamma[4604]=7.7413163711;digamma[4605]=7.7415335971;digamma[4606]=7.7417507760;digamma[4607]=7.7419679077;digamma[4608]=7.7421849922;digamma[4609]=7.7424020297;digamma[4610]=7.7426190200;digamma[4611]=7.7428359633;digamma[4612]=7.7430528595;digamma[4613]=7.7432697087;digamma[4614]=7.7434865108;digamma[4615]=7.7437032660;digamma[4616]=7.7439199742;digamma[4617]=7.7441366354;digamma[4618]=7.7443532498;digamma[4619]=7.7445698172;digamma[4620]=7.7447863377;digamma[4621]=7.7450028113;digamma[4622]=7.7452192381;digamma[4623]=7.7454356181;digamma[4624]=7.7456519512;digamma[4625]=7.7458682376;digamma[4626]=7.7460844772;digamma[4627]=7.7463006700;digamma[4628]=7.7465168161;digamma[4629]=7.7467329155;digamma[4630]=7.7469489682;digamma[4631]=7.7471649743;digamma[4632]=7.7473809337;digamma[4633]=7.7475968465;digamma[4634]=7.7478127126;digamma[4635]=7.7480285322;digamma[4636]=7.7482443052;digamma[4637]=7.7484600317;digamma[4638]=7.7486757116;digamma[4639]=7.7488913450;digamma[4640]=7.7491069319;digamma[4641]=7.7493224724;digamma[4642]=7.7495379664;digamma[4643]=7.7497534140;digamma[4644]=7.7499688152;digamma[4645]=7.7501841700;digamma[4646]=7.7503994784;digamma[4647]=7.7506147405;digamma[4648]=7.7508299562;digamma[4649]=7.7510451257;digamma[4650]=7.7512602488;digamma[4651]=7.7514753257;digamma[4652]=7.7516903564;digamma[4653]=7.7519053408;digamma[4654]=7.7521202790;digamma[4655]=7.7523351710;digamma[4656]=7.7525500168;digamma[4657]=7.7527648165;digamma[4658]=7.7529795701;digamma[4659]=7.7531942776;digamma[4660]=7.7534089389;digamma[4661]=7.7536235542;digamma[4662]=7.7538381235;digamma[4663]=7.7540526467;digamma[4664]=7.7542671239;digamma[4665]=7.7544815551;digamma[4666]=7.7546959404;digamma[4667]=7.7549102797;digamma[4668]=7.7551245730;digamma[4669]=7.7553388205;digamma[4670]=7.7555530221;digamma[4671]=7.7557671777;digamma[4672]=7.7559812876;digamma[4673]=7.7561953516;digamma[4674]=7.7564093698;digamma[4675]=7.7566233422;digamma[4676]=7.7568372688;digamma[4677]=7.7570511497;digamma[4678]=7.7572649848;digamma[4679]=7.7574787742;digamma[4680]=7.7576925179;digamma[4681]=7.7579062160;digamma[4682]=7.7581198683;digamma[4683]=7.7583334751;digamma[4684]=7.7585470362;digamma[4685]=7.7587605518;digamma[4686]=7.7589740217;digamma[4687]=7.7591874461;digamma[4688]=7.7594008249;digamma[4689]=7.7596141583;digamma[4690]=7.7598274461;digamma[4691]=7.7600406885;digamma[4692]=7.7602538853;digamma[4693]=7.7604670368;digamma[4694]=7.7606801428;digamma[4695]=7.7608932034;digamma[4696]=7.7611062186;digamma[4697]=7.7613191885;digamma[4698]=7.7615321130;digamma[4699]=7.7617449922;digamma[4700]=7.7619578261;digamma[4701]=7.7621706147;digamma[4702]=7.7623833580;digamma[4703]=7.7625960561;digamma[4704]=7.7628087089;digamma[4705]=7.7630213166;digamma[4706]=7.7632338790;digamma[4707]=7.7634463963;digamma[4708]=7.7636588684;digamma[4709]=7.7638712953;digamma[4710]=7.7640836772;digamma[4711]=7.7642960140;digamma[4712]=7.7645083056;digamma[4713]=7.7647205523;digamma[4714]=7.7649327539;digamma[4715]=7.7651449104;digamma[4716]=7.7653570220;digamma[4717]=7.7655690886;digamma[4718]=7.7657811102;digamma[4719]=7.7659930869;digamma[4720]=7.7662050187;digamma[4721]=7.7664169055;digamma[4722]=7.7666287475;digamma[4723]=7.7668405446;digamma[4724]=7.7670522968;digamma[4725]=7.7672640042;digamma[4726]=7.7674756668;digamma[4727]=7.7676872846;digamma[4728]=7.7678988577;digamma[4729]=7.7681103860;digamma[4730]=7.7683218695;digamma[4731]=7.7685333084;digamma[4732]=7.7687447025;digamma[4733]=7.7689560520;digamma[4734]=7.7691673568;digamma[4735]=7.7693786170;digamma[4736]=7.7695898325;digamma[4737]=7.7698010034;digamma[4738]=7.7700121298;digamma[4739]=7.7702232116;digamma[4740]=7.7704342488;digamma[4741]=7.7706452415;digamma[4742]=7.7708561898;digamma[4743]=7.7710670935;digamma[4744]=7.7712779527;digamma[4745]=7.7714887675;digamma[4746]=7.7716995379;digamma[4747]=7.7719102638;digamma[4748]=7.7721209454;digamma[4749]=7.7723315826;digamma[4750]=7.7725421754;digamma[4751]=7.7727527239;digamma[4752]=7.7729632280;digamma[4753]=7.7731736879;digamma[4754]=7.7733841034;digamma[4755]=7.7735944747;digamma[4756]=7.7738048018;digamma[4757]=7.7740150846;digamma[4758]=7.7742253232;digamma[4759]=7.7744355177;digamma[4760]=7.7746456679;digamma[4761]=7.7748557740;digamma[4762]=7.7750658360;digamma[4763]=7.7752758538;digamma[4764]=7.7754858276;digamma[4765]=7.7756957573;digamma[4766]=7.7759056429;digamma[4767]=7.7761154844;digamma[4768]=7.7763252820;digamma[4769]=7.7765350355;digamma[4770]=7.7767447451;digamma[4771]=7.7769544106;digamma[4772]=7.7771640323;digamma[4773]=7.7773736100;digamma[4774]=7.7775831438;digamma[4775]=7.7777926337;digamma[4776]=7.7780020797;digamma[4777]=7.7782114818;digamma[4778]=7.7784208401;digamma[4779]=7.7786301546;digamma[4780]=7.7788394253;digamma[4781]=7.7790486522;digamma[4782]=7.7792578354;digamma[4783]=7.7794669747;digamma[4784]=7.7796760704;digamma[4785]=7.7798851224;digamma[4786]=7.7800941306;digamma[4787]=7.7803030952;digamma[4788]=7.7805120161;digamma[4789]=7.7807208934;digamma[4790]=7.7809297270;digamma[4791]=7.7811385171;digamma[4792]=7.7813472636;digamma[4793]=7.7815559665;digamma[4794]=7.7817646259;digamma[4795]=7.7819732417;digamma[4796]=7.7821818140;digamma[4797]=7.7823903428;digamma[4798]=7.7825988282;digamma[4799]=7.7828072701;digamma[4800]=7.7830156685;digamma[4801]=7.7832240236;digamma[4802]=7.7834323352;digamma[4803]=7.7836406034;digamma[4804]=7.7838488283;digamma[4805]=7.7840570099;digamma[4806]=7.7842651481;digamma[4807]=7.7844732430;digamma[4808]=7.7846812945;digamma[4809]=7.7848893029;digamma[4810]=7.7850972679;digamma[4811]=7.7853051897;digamma[4812]=7.7855130683;digamma[4813]=7.7857209037;digamma[4814]=7.7859286959;digamma[4815]=7.7861364450;digamma[4816]=7.7863441509;digamma[4817]=7.7865518136;digamma[4818]=7.7867594333;digamma[4819]=7.7869670098;digamma[4820]=7.7871745433;digamma[4821]=7.7873820337;digamma[4822]=7.7875894810;digamma[4823]=7.7877968853;digamma[4824]=7.7880042467;digamma[4825]=7.7882115650;digamma[4826]=7.7884188404;digamma[4827]=7.7886260728;digamma[4828]=7.7888332623;digamma[4829]=7.7890404088;digamma[4830]=7.7892475125;digamma[4831]=7.7894545732;digamma[4832]=7.7896615911;digamma[4833]=7.7898685662;digamma[4834]=7.7900754984;digamma[4835]=7.7902823878;digamma[4836]=7.7904892345;digamma[4837]=7.7906960383;digamma[4838]=7.7909027994;digamma[4839]=7.7911095177;digamma[4840]=7.7913161934;digamma[4841]=7.7915228263;digamma[4842]=7.7917294165;digamma[4843]=7.7919359640;digamma[4844]=7.7921424689;digamma[4845]=7.7923489312;digamma[4846]=7.7925553509;digamma[4847]=7.7927617279;digamma[4848]=7.7929680624;digamma[4849]=7.7931743543;digamma[4850]=7.7933806036;digamma[4851]=7.7935868105;digamma[4852]=7.7937929748;digamma[4853]=7.7939990966;digamma[4854]=7.7942051759;digamma[4855]=7.7944112128;digamma[4856]=7.7946172072;digamma[4857]=7.7948231592;digamma[4858]=7.7950290689;digamma[4859]=7.7952349361;digamma[4860]=7.7954407609;digamma[4861]=7.7956465434;digamma[4862]=7.7958522835;digamma[4863]=7.7960579814;digamma[4864]=7.7962636369;digamma[4865]=7.7964692501;digamma[4866]=7.7966748211;digamma[4867]=7.7968803498;digamma[4868]=7.7970858363;digamma[4869]=7.7972912806;digamma[4870]=7.7974966827;digamma[4871]=7.7977020425;digamma[4872]=7.7979073603;digamma[4873]=7.7981126359;digamma[4874]=7.7983178693;digamma[4875]=7.7985230606;digamma[4876]=7.7987282099;digamma[4877]=7.7989333171;digamma[4878]=7.7991383822;digamma[4879]=7.7993434052;digamma[4880]=7.7995483863;digamma[4881]=7.7997533253;digamma[4882]=7.7999582223;digamma[4883]=7.8001630774;digamma[4884]=7.8003678905;digamma[4885]=7.8005726617;digamma[4886]=7.8007773909;digamma[4887]=7.8009820782;digamma[4888]=7.8011867237;digamma[4889]=7.8013913273;digamma[4890]=7.8015958890;digamma[4891]=7.8018004089;digamma[4892]=7.8020048869;digamma[4893]=7.8022093232;digamma[4894]=7.8024137177;digamma[4895]=7.8026180704;digamma[4896]=7.8028223814;digamma[4897]=7.8030266506;digamma[4898]=7.8032308781;digamma[4899]=7.8034350639;digamma[4900]=7.8036392080;digamma[4901]=7.8038433105;digamma[4902]=7.8040473713;digamma[4903]=7.8042513905;digamma[4904]=7.8044553680;digamma[4905]=7.8046593040;digamma[4906]=7.8048631984;digamma[4907]=7.8050670512;digamma[4908]=7.8052708625;digamma[4909]=7.8054746322;digamma[4910]=7.8056783604;digamma[4911]=7.8058820471;digamma[4912]=7.8060856924;digamma[4913]=7.8062892962;digamma[4914]=7.8064928585;digamma[4915]=7.8066963794;digamma[4916]=7.8068998589;digamma[4917]=7.8071032970;digamma[4918]=7.8073066937;digamma[4919]=7.8075100491;digamma[4920]=7.8077133631;digamma[4921]=7.8079166358;digamma[4922]=7.8081198672;digamma[4923]=7.8083230573;digamma[4924]=7.8085262061;digamma[4925]=7.8087293136;digamma[4926]=7.8089323799;digamma[4927]=7.8091354050;digamma[4928]=7.8093383888;digamma[4929]=7.8095413315;digamma[4930]=7.8097442330;digamma[4931]=7.8099470933;digamma[4932]=7.8101499125;digamma[4933]=7.8103526906;digamma[4934]=7.8105554275;digamma[4935]=7.8107581234;digamma[4936]=7.8109607782;digamma[4937]=7.8111633919;digamma[4938]=7.8113659645;digamma[4939]=7.8115684962;digamma[4940]=7.8117709868;digamma[4941]=7.8119734365;digamma[4942]=7.8121758451;digamma[4943]=7.8123782128;digamma[4944]=7.8125805396;digamma[4945]=7.8127828254;digamma[4946]=7.8129850703;digamma[4947]=7.8131872743;digamma[4948]=7.8133894375;digamma[4949]=7.8135915598;digamma[4950]=7.8137936412;digamma[4951]=7.8139956818;digamma[4952]=7.8141976816;digamma[4953]=7.8143996406;digamma[4954]=7.8146015588;digamma[4955]=7.8148034363;digamma[4956]=7.8150052730;digamma[4957]=7.8152070690;digamma[4958]=7.8154088242;digamma[4959]=7.8156105388;digamma[4960]=7.8158122127;digamma[4961]=7.8160138459;digamma[4962]=7.8162154385;digamma[4963]=7.8164169905;digamma[4964]=7.8166185018;digamma[4965]=7.8168199725;digamma[4966]=7.8170214027;digamma[4967]=7.8172227923;digamma[4968]=7.8174241413;digamma[4969]=7.8176254498;digamma[4970]=7.8178267178;digamma[4971]=7.8180279453;digamma[4972]=7.8182291323;digamma[4973]=7.8184302788;digamma[4974]=7.8186313849;digamma[4975]=7.8188324505;digamma[4976]=7.8190334758;digamma[4977]=7.8192344606;digamma[4978]=7.8194354050;digamma[4979]=7.8196363091;digamma[4980]=7.8198371728;digamma[4981]=7.8200379962;digamma[4982]=7.8202387792;digamma[4983]=7.8204395220;digamma[4984]=7.8206402244;digamma[4985]=7.8208408866;digamma[4986]=7.8210415085;digamma[4987]=7.8212420902;digamma[4988]=7.8214426317;digamma[4989]=7.8216431329;digamma[4990]=7.8218435940;digamma[4991]=7.8220440149;digamma[4992]=7.8222443956;digamma[4993]=7.8224447362;digamma[4994]=7.8226450366;digamma[4995]=7.8228452970;digamma[4996]=7.8230455172;digamma[4997]=7.8232456974;digamma[4998]=7.8234458375;digamma[4999]=7.8236459375;digamma[5000]=7.8238459975;digamma[5001]=7.8240460175;digamma[5002]=7.8242459975;digamma[5003]=7.8244459375;digamma[5004]=7.8246458376;digamma[5005]=7.8248456977;digamma[5006]=7.8250455178;digamma[5007]=7.8252452981;digamma[5008]=7.8254450384;digamma[5009]=7.8256447389;digamma[5010]=7.8258443994;digamma[5011]=7.8260440202;digamma[5012]=7.8262436010;digamma[5013]=7.8264431421;digamma[5014]=7.8266426433;digamma[5015]=7.8268421048;digamma[5016]=7.8270415265;digamma[5017]=7.8272409084;digamma[5018]=7.8274402505;digamma[5019]=7.8276395530;digamma[5020]=7.8278388157;digamma[5021]=7.8280380387;digamma[5022]=7.8282372221;digamma[5023]=7.8284363658;digamma[5024]=7.8286354698;digamma[5025]=7.8288345342;digamma[5026]=7.8290335590;digamma[5027]=7.8292325441;digamma[5028]=7.8294314897;digamma[5029]=7.8296303957;digamma[5030]=7.8298292622;digamma[5031]=7.8300280891;digamma[5032]=7.8302268765;digamma[5033]=7.8304256244;digamma[5034]=7.8306243328;digamma[5035]=7.8308230017;digamma[5036]=7.8310216312;digamma[5037]=7.8312202212;digamma[5038]=7.8314187718;digamma[5039]=7.8316172829;digamma[5040]=7.8318157547;digamma[5041]=7.8320141871;digamma[5042]=7.8322125801;digamma[5043]=7.8324109337;digamma[5044]=7.8326092481;digamma[5045]=7.8328075231;digamma[5046]=7.8330057588;digamma[5047]=7.8332039552;digamma[5048]=7.8334021123;digamma[5049]=7.8336002302;digamma[5050]=7.8337983088;digamma[5051]=7.8339963482;digamma[5052]=7.8341943484;digamma[5053]=7.8343923094;digamma[5054]=7.8345902313;digamma[5055]=7.8347881139;digamma[5056]=7.8349859574;digamma[5057]=7.8351837618;digamma[5058]=7.8353815270;digamma[5059]=7.8355792532;digamma[5060]=7.8357769402;digamma[5061]=7.8359745882;digamma[5062]=7.8361721972;digamma[5063]=7.8363697670;digamma[5064]=7.8365672979;digamma[5065]=7.8367647898;digamma[5066]=7.8369622426;digamma[5067]=7.8371596565;digamma[5068]=7.8373570314;digamma[5069]=7.8375543674;digamma[5070]=7.8377516644;digamma[5071]=7.8379489225;digamma[5072]=7.8381461417;digamma[5073]=7.8383433220;digamma[5074]=7.8385404635;digamma[5075]=7.8387375661;digamma[5076]=7.8389346298;digamma[5077]=7.8391316547;digamma[5078]=7.8393286409;digamma[5079]=7.8395255882;digamma[5080]=7.8397224967;digamma[5081]=7.8399193665;digamma[5082]=7.8401161975;digamma[5083]=7.8403129898;digamma[5084]=7.8405097433;digamma[5085]=7.8407064582;digamma[5086]=7.8409031344;digamma[5087]=7.8410997719;digamma[5088]=7.8412963707;digamma[5089]=7.8414929309;digamma[5090]=7.8416894525;digamma[5091]=7.8418859354;digamma[5092]=7.8420823798;digamma[5093]=7.8422787855;digamma[5094]=7.8424751528;digamma[5095]=7.8426714814;digamma[5096]=7.8428677715;digamma[5097]=7.8430640231;digamma[5098]=7.8432602362;digamma[5099]=7.8434564108;digamma[5100]=7.8436525469;digamma[5101]=7.8438486446;digamma[5102]=7.8440447038;digamma[5103]=7.8442407245;digamma[5104]=7.8444367069;digamma[5105]=7.8446326509;digamma[5106]=7.8448285564;digamma[5107]=7.8450244236;digamma[5108]=7.8452202525;digamma[5109]=7.8454160430;digamma[5110]=7.8456117952;digamma[5111]=7.8458075090;digamma[5112]=7.8460031846;digamma[5113]=7.8461988219;digamma[5114]=7.8463944209;digamma[5115]=7.8465899817;digamma[5116]=7.8467855042;digamma[5117]=7.8469809885;digamma[5118]=7.8471764346;digamma[5119]=7.8473718425;digamma[5120]=7.8475672123;digamma[5121]=7.8477625438;digamma[5122]=7.8479578373;digamma[5123]=7.8481530926;digamma[5124]=7.8483483097;digamma[5125]=7.8485434888;digamma[5126]=7.8487386298;digamma[5127]=7.8489337327;digamma[5128]=7.8491287976;digamma[5129]=7.8493238244;digamma[5130]=7.8495188132;digamma[5131]=7.8497137639;digamma[5132]=7.8499086767;digamma[5133]=7.8501035515;digamma[5134]=7.8502983883;digamma[5135]=7.8504931872;digamma[5136]=7.8506879481;digamma[5137]=7.8508826711;digamma[5138]=7.8510773562;digamma[5139]=7.8512720034;digamma[5140]=7.8514666127;digamma[5141]=7.8516611842;digamma[5142]=7.8518557178;digamma[5143]=7.8520502136;digamma[5144]=7.8522446715;digamma[5145]=7.8524390917;digamma[5146]=7.8526334740;digamma[5147]=7.8528278186;digamma[5148]=7.8530221254;digamma[5149]=7.8532163944;digamma[5150]=7.8534106258;digamma[5151]=7.8536048194;digamma[5152]=7.8537989753;digamma[5153]=7.8539930935;digamma[5154]=7.8541871740;digamma[5155]=7.8543812169;digamma[5156]=7.8545752222;digamma[5157]=7.8547691898;digamma[5158]=7.8549631198;digamma[5159]=7.8551570121;digamma[5160]=7.8553508669;digamma[5161]=7.8555446842;digamma[5162]=7.8557384638;digamma[5163]=7.8559322060;digamma[5164]=7.8561259106;digamma[5165]=7.8563195777;digamma[5166]=7.8565132072;digamma[5167]=7.8567067993;digamma[5168]=7.8569003540;digamma[5169]=7.8570938711;digamma[5170]=7.8572873509;digamma[5171]=7.8574807932;digamma[5172]=7.8576741981;digamma[5173]=7.8578675656;digamma[5174]=7.8580608957;digamma[5175]=7.8582541884;digamma[5176]=7.8584474438;digamma[5177]=7.8586406618;digamma[5178]=7.8588338426;digamma[5179]=7.8590269860;digamma[5180]=7.8592200921;digamma[5181]=7.8594131609;digamma[5182]=7.8596061925;digamma[5183]=7.8597991868;digamma[5184]=7.8599921438;digamma[5185]=7.8601850637;digamma[5186]=7.8603779463;digamma[5187]=7.8605707917;digamma[5188]=7.8607636000;digamma[5189]=7.8609563711;digamma[5190]=7.8611491050;digamma[5191]=7.8613418018;digamma[5192]=7.8615344615;digamma[5193]=7.8617270840;digamma[5194]=7.8619196695;digamma[5195]=7.8621122178;digamma[5196]=7.8623047291;digamma[5197]=7.8624972034;digamma[5198]=7.8626896406;digamma[5199]=7.8628820408;digamma[5200]=7.8630744040;digamma[5201]=7.8632667302;digamma[5202]=7.8634590194;digamma[5203]=7.8636512716;digamma[5204]=7.8638434869;digamma[5205]=7.8640356652;digamma[5206]=7.8642278066;digamma[5207]=7.8644199111;digamma[5208]=7.8646119788;digamma[5209]=7.8648040095;digamma[5210]=7.8649960033;digamma[5211]=7.8651879603;digamma[5212]=7.8653798805;digamma[5213]=7.8655717638;digamma[5214]=7.8657636103;digamma[5215]=7.8659554201;digamma[5216]=7.8661471930;digamma[5217]=7.8663389292;digamma[5218]=7.8665306286;digamma[5219]=7.8667222913;digamma[5220]=7.8669139172;digamma[5221]=7.8671055064;digamma[5222]=7.8672970590;digamma[5223]=7.8674885748;digamma[5224]=7.8676800540;digamma[5225]=7.8678714965;digamma[5226]=7.8680629024;digamma[5227]=7.8682542716;digamma[5228]=7.8684456043;digamma[5229]=7.8686369003;digamma[5230]=7.8688281597;digamma[5231]=7.8690193826;digamma[5232]=7.8692105689;digamma[5233]=7.8694017187;digamma[5234]=7.8695928319;digamma[5235]=7.8697839086;digamma[5236]=7.8699749488;digamma[5237]=7.8701659525;digamma[5238]=7.8703569198;digamma[5239]=7.8705478506;digamma[5240]=7.8707387449;digamma[5241]=7.8709296028;digamma[5242]=7.8711204243;digamma[5243]=7.8713112094;digamma[5244]=7.8715019581;digamma[5245]=7.8716926704;digamma[5246]=7.8718833463;digamma[5247]=7.8720739859;digamma[5248]=7.8722645892;digamma[5249]=7.8724551561;digamma[5250]=7.8726456867;digamma[5251]=7.8728361811;digamma[5252]=7.8730266391;digamma[5253]=7.8732170609;digamma[5254]=7.8734074464;digamma[5255]=7.8735977957;digamma[5256]=7.8737881088;digamma[5257]=7.8739783856;digamma[5258]=7.8741686263;digamma[5259]=7.8743588308;digamma[5260]=7.8745489991;digamma[5261]=7.8747391312;digamma[5262]=7.8749292272;digamma[5263]=7.8751192871;digamma[5264]=7.8753093108;digamma[5265]=7.8754992985;digamma[5266]=7.8756892500;digamma[5267]=7.8758791655;digamma[5268]=7.8760690449;digamma[5269]=7.8762588883;digamma[5270]=7.8764486957;digamma[5271]=7.8766384670;digamma[5272]=7.8768282023;digamma[5273]=7.8770179016;digamma[5274]=7.8772075650;digamma[5275]=7.8773971923;digamma[5276]=7.8775867838;digamma[5277]=7.8777763393;digamma[5278]=7.8779658588;digamma[5279]=7.8781553425;digamma[5280]=7.8783447902;digamma[5281]=7.8785342021;digamma[5282]=7.8787235781;digamma[5283]=7.8789129183;digamma[5284]=7.8791022226;digamma[5285]=7.8792914911;digamma[5286]=7.8794807237;digamma[5287]=7.8796699206;digamma[5288]=7.8798590816;digamma[5289]=7.8800482069;digamma[5290]=7.8802372965;digamma[5291]=7.8804263502;digamma[5292]=7.8806153683;digamma[5293]=7.8808043506;digamma[5294]=7.8809932972;digamma[5295]=7.8811822082;digamma[5296]=7.8813710834;digamma[5297]=7.8815599230;digamma[5298]=7.8817487269;digamma[5299]=7.8819374952;digamma[5300]=7.8821262279;digamma[5301]=7.8823149249;digamma[5302]=7.8825035864;digamma[5303]=7.8826922122;digamma[5304]=7.8828808025;digamma[5305]=7.8830693572;digamma[5306]=7.8832578764;digamma[5307]=7.8834463601;digamma[5308]=7.8836348082;digamma[5309]=7.8838232208;digamma[5310]=7.8840115979;digamma[5311]=7.8841999396;digamma[5312]=7.8843882458;digamma[5313]=7.8845765165;digamma[5314]=7.8847647518;digamma[5315]=7.8849529517;digamma[5316]=7.8851411161;digamma[5317]=7.8853292452;digamma[5318]=7.8855173388;digamma[5319]=7.8857053971;digamma[5320]=7.8858934201;digamma[5321]=7.8860814077;digamma[5322]=7.8862693599;digamma[5323]=7.8864572769;digamma[5324]=7.8866451585;digamma[5325]=7.8868330048;digamma[5326]=7.8870208159;digamma[5327]=7.8872085917;digamma[5328]=7.8873963322;digamma[5329]=7.8875840375;digamma[5330]=7.8877717076;digamma[5331]=7.8879593425;digamma[5332]=7.8881469421;digamma[5333]=7.8883345066;digamma[5334]=7.8885220359;digamma[5335]=7.8887095300;digamma[5336]=7.8888969890;digamma[5337]=7.8890844129;digamma[5338]=7.8892718016;digamma[5339]=7.8894591553;digamma[5340]=7.8896464738;digamma[5341]=7.8898337572;digamma[5342]=7.8900210056;digamma[5343]=7.8902082190;digamma[5344]=7.8903953972;digamma[5345]=7.8905825405;digamma[5346]=7.8907696487;digamma[5347]=7.8909567220;digamma[5348]=7.8911437602;digamma[5349]=7.8913307635;digamma[5350]=7.8915177318;digamma[5351]=7.8917046652;digamma[5352]=7.8918915636;digamma[5353]=7.8920784271;digamma[5354]=7.8922652556;digamma[5355]=7.8924520493;digamma[5356]=7.8926388081;digamma[5357]=7.8928255321;digamma[5358]=7.8930122211;digamma[5359]=7.8931988754;digamma[5360]=7.8933854947;digamma[5361]=7.8935720793;digamma[5362]=7.8937586291;digamma[5363]=7.8939451440;digamma[5364]=7.8941316242;digamma[5365]=7.8943180696;digamma[5366]=7.8945044803;digamma[5367]=7.8946908562;digamma[5368]=7.8948771974;digamma[5369]=7.8950635039;digamma[5370]=7.8952497756;digamma[5371]=7.8954360127;digamma[5372]=7.8956222151;digamma[5373]=7.8958083829;digamma[5374]=7.8959945159;digamma[5375]=7.8961806144;digamma[5376]=7.8963666782;digamma[5377]=7.8965527074;digamma[5378]=7.8967387020;digamma[5379]=7.8969246620;digamma[5380]=7.8971105875;digamma[5381]=7.8972964784;digamma[5382]=7.8974823347;digamma[5383]=7.8976681565;digamma[5384]=7.8978539438;digamma[5385]=7.8980396965;digamma[5386]=7.8982254148;digamma[5387]=7.8984110986;digamma[5388]=7.8985967479;digamma[5389]=7.8987823627;digamma[5390]=7.8989679431;digamma[5391]=7.8991534891;digamma[5392]=7.8993390006;digamma[5393]=7.8995244778;digamma[5394]=7.8997099205;digamma[5395]=7.8998953289;digamma[5396]=7.9000807029;digamma[5397]=7.9002660425;digamma[5398]=7.9004513478;digamma[5399]=7.9006366187;digamma[5400]=7.9008218554;digamma[5401]=7.9010070577;digamma[5402]=7.9011922257;digamma[5403]=7.9013773595;digamma[5404]=7.9015624590;digamma[5405]=7.9017475242;digamma[5406]=7.9019325552;digamma[5407]=7.9021175520;digamma[5408]=7.9023025145;digamma[5409]=7.9024874429;digamma[5410]=7.9026723370;digamma[5411]=7.9028571970;digamma[5412]=7.9030420228;digamma[5413]=7.9032268144;digamma[5414]=7.9034115719;digamma[5415]=7.9035962953;digamma[5416]=7.9037809846;digamma[5417]=7.9039656397;digamma[5418]=7.9041502608;digamma[5419]=7.9043348478;digamma[5420]=7.9045194007;digamma[5421]=7.9047039195;digamma[5422]=7.9048884044;digamma[5423]=7.9050728552;digamma[5424]=7.9052572719;digamma[5425]=7.9054416547;digamma[5426]=7.9056260035;digamma[5427]=7.9058103183;digamma[5428]=7.9059945992;digamma[5429]=7.9061788461;digamma[5430]=7.9063630590;digamma[5431]=7.9065472380;digamma[5432]=7.9067313831;digamma[5433]=7.9069154943;digamma[5434]=7.9070995716;digamma[5435]=7.9072836151;digamma[5436]=7.9074676246;digamma[5437]=7.9076516004;digamma[5438]=7.9078355422;digamma[5439]=7.9080194503;digamma[5440]=7.9082033245;digamma[5441]=7.9083871649;digamma[5442]=7.9085709716;digamma[5443]=7.9087547444;digamma[5444]=7.9089384835;digamma[5445]=7.9091221888;digamma[5446]=7.9093058604;digamma[5447]=7.9094894983;digamma[5448]=7.9096731024;digamma[5449]=7.9098566729;digamma[5450]=7.9100402096;digamma[5451]=7.9102237127;digamma[5452]=7.9104071821;digamma[5453]=7.9105906179;digamma[5454]=7.9107740200;digamma[5455]=7.9109573884;digamma[5456]=7.9111407233;digamma[5457]=7.9113240246;digamma[5458]=7.9115072922;digamma[5459]=7.9116905263;digamma[5460]=7.9118737268;digamma[5461]=7.9120568938;digamma[5462]=7.9122400272;digamma[5463]=7.9124231271;digamma[5464]=7.9126061934;digamma[5465]=7.9127892263;digamma[5466]=7.9129722256;digamma[5467]=7.9131551915;digamma[5468]=7.9133381239;digamma[5469]=7.9135210229;digamma[5470]=7.9137038884;digamma[5471]=7.9138867204;digamma[5472]=7.9140695191;digamma[5473]=7.9142522843;digamma[5474]=7.9144350161;digamma[5475]=7.9146177146;digamma[5476]=7.9148003797;digamma[5477]=7.9149830114;digamma[5478]=7.9151656098;digamma[5479]=7.9153481748;digamma[5480]=7.9155307065;digamma[5481]=7.9157132049;digamma[5482]=7.9158956700;digamma[5483]=7.9160781018;digamma[5484]=7.9162605004;digamma[5485]=7.9164428657;digamma[5486]=7.9166251977;digamma[5487]=7.9168074965;digamma[5488]=7.9169897620;digamma[5489]=7.9171719944;digamma[5490]=7.9173541935;digamma[5491]=7.9175363595;digamma[5492]=7.9177184922;digamma[5493]=7.9179005919;digamma[5494]=7.9180826583;digamma[5495]=7.9182646916;digamma[5496]=7.9184466918;digamma[5497]=7.9186286589;digamma[5498]=7.9188105928;digamma[5499]=7.9189924937;digamma[5500]=7.9191743615;digamma[5501]=7.9193561962;digamma[5502]=7.9195379978;digamma[5503]=7.9197197664;digamma[5504]=7.9199015020;digamma[5505]=7.9200832046;digamma[5506]=7.9202648741;digamma[5507]=7.9204465106;digamma[5508]=7.9206281142;digamma[5509]=7.9208096848;digamma[5510]=7.9209912224;digamma[5511]=7.9211727271;digamma[5512]=7.9213541988;digamma[5513]=7.9215356376;digamma[5514]=7.9217170435;digamma[5515]=7.9218984165;digamma[5516]=7.9220797566;digamma[5517]=7.9222610638;digamma[5518]=7.9224423382;digamma[5519]=7.9226235797;digamma[5520]=7.9228047884;digamma[5521]=7.9229859642;digamma[5522]=7.9231671072;digamma[5523]=7.9233482174;digamma[5524]=7.9235292948;digamma[5525]=7.9237103394;digamma[5526]=7.9238913513;digamma[5527]=7.9240723304;digamma[5528]=7.9242532767;digamma[5529]=7.9244341903;digamma[5530]=7.9246150712;digamma[5531]=7.9247959194;digamma[5532]=7.9249767349;digamma[5533]=7.9251575177;digamma[5534]=7.9253382678;digamma[5535]=7.9255189852;digamma[5536]=7.9256996700;digamma[5537]=7.9258803222;digamma[5538]=7.9260609417;digamma[5539]=7.9262415286;digamma[5540]=7.9264220829;digamma[5541]=7.9266026046;digamma[5542]=7.9267830937;digamma[5543]=7.9269635503;digamma[5544]=7.9271439743;digamma[5545]=7.9273243657;digamma[5546]=7.9275047246;digamma[5547]=7.9276850510;digamma[5548]=7.9278653449;digamma[5549]=7.9280456063;digamma[5550]=7.9282258352;digamma[5551]=7.9284060316;digamma[5552]=7.9285861955;digamma[5553]=7.9287663270;digamma[5554]=7.9289464261;digamma[5555]=7.9291264927;digamma[5556]=7.9293065269;digamma[5557]=7.9294865287;digamma[5558]=7.9296664981;digamma[5559]=7.9298464351;digamma[5560]=7.9300263398;digamma[5561]=7.9302062121;digamma[5562]=7.9303860520;digamma[5563]=7.9305658596;digamma[5564]=7.9307456349;digamma[5565]=7.9309253779;digamma[5566]=7.9311050885;digamma[5567]=7.9312847669;digamma[5568]=7.9314644130;digamma[5569]=7.9316440268;digamma[5570]=7.9318236084;digamma[5571]=7.9320031577;digamma[5572]=7.9321826748;digamma[5573]=7.9323621597;digamma[5574]=7.9325416124;digamma[5575]=7.9327210328;digamma[5576]=7.9329004211;digamma[5577]=7.9330797772;digamma[5578]=7.9332591012;digamma[5579]=7.9334383930;digamma[5580]=7.9336176526;digamma[5581]=7.9337968802;digamma[5582]=7.9339760756;digamma[5583]=7.9341552389;digamma[5584]=7.9343343701;digamma[5585]=7.9345134692;digamma[5586]=7.9346925363;digamma[5587]=7.9348715713;digamma[5588]=7.9350505742;digamma[5589]=7.9352295452;digamma[5590]=7.9354084840;digamma[5591]=7.9355873909;digamma[5592]=7.9357662658;digamma[5593]=7.9359451087;digamma[5594]=7.9361239196;digamma[5595]=7.9363026985;digamma[5596]=7.9364814455;digamma[5597]=7.9366601605;digamma[5598]=7.9368388437;digamma[5599]=7.9370174948;digamma[5600]=7.9371961141;digamma[5601]=7.9373747015;digamma[5602]=7.9375532570;digamma[5603]=7.9377317806;digamma[5604]=7.9379102723;digamma[5605]=7.9380887322;digamma[5606]=7.9382671603;digamma[5607]=7.9384455565;digamma[5608]=7.9386239209;digamma[5609]=7.9388022535;digamma[5610]=7.9389805542;digamma[5611]=7.9391588233;digamma[5612]=7.9393370605;digamma[5613]=7.9395152660;digamma[5614]=7.9396934397;digamma[5615]=7.9398715817;digamma[5616]=7.9400496919;digamma[5617]=7.9402277704;digamma[5618]=7.9404058173;digamma[5619]=7.9405838324;digamma[5620]=7.9407618158;digamma[5621]=7.9409397676;digamma[5622]=7.9411176877;digamma[5623]=7.9412955762;digamma[5624]=7.9414734330;digamma[5625]=7.9416512582;digamma[5626]=7.9418290518;digamma[5627]=7.9420068138;digamma[5628]=7.9421845441;digamma[5629]=7.9423622429;digamma[5630]=7.9425399102;digamma[5631]=7.9427175458;digamma[5632]=7.9428951500;digamma[5633]=7.9430727225;digamma[5634]=7.9432502636;digamma[5635]=7.9434277731;digamma[5636]=7.9436052512;digamma[5637]=7.9437826977;digamma[5638]=7.9439601128;digamma[5639]=7.9441374964;digamma[5640]=7.9443148485;digamma[5641]=7.9444921692;digamma[5642]=7.9446694584;digamma[5643]=7.9448467162;digamma[5644]=7.9450239426;digamma[5645]=7.9452011376;digamma[5646]=7.9453783013;digamma[5647]=7.9455554335;digamma[5648]=7.9457325343;digamma[5649]=7.9459096038;digamma[5650]=7.9460866420;digamma[5651]=7.9462636488;digamma[5652]=7.9464406243;digamma[5653]=7.9466175685;digamma[5654]=7.9467944813;digamma[5655]=7.9469713629;digamma[5656]=7.9471482132;digamma[5657]=7.9473250322;digamma[5658]=7.9475018200;digamma[5659]=7.9476785765;digamma[5660]=7.9478553018;digamma[5661]=7.9480319958;digamma[5662]=7.9482086587;digamma[5663]=7.9483852903;digamma[5664]=7.9485618908;digamma[5665]=7.9487384600;digamma[5666]=7.9489149981;digamma[5667]=7.9490915050;digamma[5668]=7.9492679808;digamma[5669]=7.9494444254;digamma[5670]=7.9496208390;digamma[5671]=7.9497972213;digamma[5672]=7.9499735726;digamma[5673]=7.9501498928;digamma[5674]=7.9503261819;digamma[5675]=7.9505024400;digamma[5676]=7.9506786670;digamma[5677]=7.9508548629;digamma[5678]=7.9510310278;digamma[5679]=7.9512071616;digamma[5680]=7.9513832645;digamma[5681]=7.9515593363;digamma[5682]=7.9517353772;digamma[5683]=7.9519113870;digamma[5684]=7.9520873659;digamma[5685]=7.9522633138;digamma[5686]=7.9524392308;digamma[5687]=7.9526151168;digamma[5688]=7.9527909719;digamma[5689]=7.9529667961;digamma[5690]=7.9531425893;digamma[5691]=7.9533183517;digamma[5692]=7.9534940832;digamma[5693]=7.9536697838;digamma[5694]=7.9538454535;digamma[5695]=7.9540210924;digamma[5696]=7.9541967005;digamma[5697]=7.9543722777;digamma[5698]=7.9545478241;digamma[5699]=7.9547233396;digamma[5700]=7.9548988244;digamma[5701]=7.9550742784;digamma[5702]=7.9552497016;digamma[5703]=7.9554250940;digamma[5704]=7.9556004557;digamma[5705]=7.9557757867;digamma[5706]=7.9559510869;digamma[5707]=7.9561263563;digamma[5708]=7.9563015951;digamma[5709]=7.9564768032;digamma[5710]=7.9566519805;digamma[5711]=7.9568271272;digamma[5712]=7.9570022432;digamma[5713]=7.9571773286;digamma[5714]=7.9573523833;digamma[5715]=7.9575274073;digamma[5716]=7.9577024008;digamma[5717]=7.9578773636;digamma[5718]=7.9580522958;digamma[5719]=7.9582271974;digamma[5720]=7.9584020685;digamma[5721]=7.9585769089;digamma[5722]=7.9587517188;digamma[5723]=7.9589264981;digamma[5724]=7.9591012469;digamma[5725]=7.9592759652;digamma[5726]=7.9594506529;digamma[5727]=7.9596253102;digamma[5728]=7.9597999369;digamma[5729]=7.9599745332;digamma[5730]=7.9601490989;digamma[5731]=7.9603236342;digamma[5732]=7.9604981391;digamma[5733]=7.9606726135;digamma[5734]=7.9608470574;digamma[5735]=7.9610214710;digamma[5736]=7.9611958541;digamma[5737]=7.9613702068;digamma[5738]=7.9615445291;digamma[5739]=7.9617188210;digamma[5740]=7.9618930826;digamma[5741]=7.9620673138;digamma[5742]=7.9622415147;digamma[5743]=7.9624156852;digamma[5744]=7.9625898254;digamma[5745]=7.9627639352;digamma[5746]=7.9629380148;digamma[5747]=7.9631120640;digamma[5748]=7.9632860830;digamma[5749]=7.9634600717;digamma[5750]=7.9636340301;digamma[5751]=7.9638079583;digamma[5752]=7.9639818562;digamma[5753]=7.9641557239;digamma[5754]=7.9643295613;digamma[5755]=7.9645033686;digamma[5756]=7.9646771456;digamma[5757]=7.9648508925;digamma[5758]=7.9650246091;digamma[5759]=7.9651982956;digamma[5760]=7.9653719520;digamma[5761]=7.9655455782;digamma[5762]=7.9657191742;digamma[5763]=7.9658927401;digamma[5764]=7.9660662759;digamma[5765]=7.9662397816;digamma[5766]=7.9664132572;digamma[5767]=7.9665867027;digamma[5768]=7.9667601181;digamma[5769]=7.9669335034;digamma[5770]=7.9671068587;digamma[5771]=7.9672801839;digamma[5772]=7.9674534792;digamma[5773]=7.9676267443;digamma[5774]=7.9677999795;digamma[5775]=7.9679731847;digamma[5776]=7.9681463598;digamma[5777]=7.9683195050;digamma[5778]=7.9684926202;digamma[5779]=7.9686657055;digamma[5780]=7.9688387607;digamma[5781]=7.9690117861;digamma[5782]=7.9691847815;digamma[5783]=7.9693577470;digamma[5784]=7.9695306826;digamma[5785]=7.9697035883;digamma[5786]=7.9698764640;digamma[5787]=7.9700493100;digamma[5788]=7.9702221260;digamma[5789]=7.9703949122;digamma[5790]=7.9705676685;digamma[5791]=7.9707403950;digamma[5792]=7.9709130916;digamma[5793]=7.9710857585;digamma[5794]=7.9712583955;digamma[5795]=7.9714310027;digamma[5796]=7.9716035802;digamma[5797]=7.9717761278;digamma[5798]=7.9719486457;digamma[5799]=7.9721211339;digamma[5800]=7.9722935923;digamma[5801]=7.9724660209;digamma[5802]=7.9726384199;digamma[5803]=7.9728107891;digamma[5804]=7.9729831286;digamma[5805]=7.9731554384;digamma[5806]=7.9733277185;digamma[5807]=7.9734999690;digamma[5808]=7.9736721898;digamma[5809]=7.9738443809;digamma[5810]=7.9740165424;digamma[5811]=7.9741886742;digamma[5812]=7.9743607765;digamma[5813]=7.9745328491;digamma[5814]=7.9747048921;digamma[5815]=7.9748769055;digamma[5816]=7.9750488893;digamma[5817]=7.9752208436;digamma[5818]=7.9753927683;digamma[5819]=7.9755646634;digamma[5820]=7.9757365290;digamma[5821]=7.9759083651;digamma[5822]=7.9760801716;digamma[5823]=7.9762519487;digamma[5824]=7.9764236962;digamma[5825]=7.9765954142;digamma[5826]=7.9767671028;digamma[5827]=7.9769387619;digamma[5828]=7.9771103915;digamma[5829]=7.9772819917;digamma[5830]=7.9774535624;digamma[5831]=7.9776251037;digamma[5832]=7.9777966156;digamma[5833]=7.9779680980;digamma[5834]=7.9781395511;digamma[5835]=7.9783109748;digamma[5836]=7.9784823691;digamma[5837]=7.9786537340;digamma[5838]=7.9788250695;digamma[5839]=7.9789963757;digamma[5840]=7.9791676526;digamma[5841]=7.9793389001;digamma[5842]=7.9795101184;digamma[5843]=7.9796813073;digamma[5844]=7.9798524669;digamma[5845]=7.9800235972;digamma[5846]=7.9801946982;digamma[5847]=7.9803657700;digamma[5848]=7.9805368125;digamma[5849]=7.9807078257;digamma[5850]=7.9808788098;digamma[5851]=7.9810497645;digamma[5852]=7.9812206901;digamma[5853]=7.9813915864;digamma[5854]=7.9815624536;digamma[5855]=7.9817332916;digamma[5856]=7.9819041003;digamma[5857]=7.9820748799;digamma[5858]=7.9822456304;digamma[5859]=7.9824163517;digamma[5860]=7.9825870438;digamma[5861]=7.9827577069;digamma[5862]=7.9829283408;digamma[5863]=7.9830989456;digamma[5864]=7.9832695213;digamma[5865]=7.9834400679;digamma[5866]=7.9836105854;digamma[5867]=7.9837810738;digamma[5868]=7.9839515332;digamma[5869]=7.9841219635;digamma[5870]=7.9842923648;digamma[5871]=7.9844627371;digamma[5872]=7.9846330803;digamma[5873]=7.9848033946;digamma[5874]=7.9849736798;digamma[5875]=7.9851439360;digamma[5876]=7.9853141633;digamma[5877]=7.9854843616;digamma[5878]=7.9856545309;digamma[5879]=7.9858246712;digamma[5880]=7.9859947827;digamma[5881]=7.9861648652;digamma[5882]=7.9863349187;digamma[5883]=7.9865049434;digamma[5884]=7.9866749391;digamma[5885]=7.9868449060;digamma[5886]=7.9870148439;digamma[5887]=7.9871847530;digamma[5888]=7.9873546333;digamma[5889]=7.9875244847;digamma[5890]=7.9876943072;digamma[5891]=7.9878641009;digamma[5892]=7.9880338658;digamma[5893]=7.9882036018;digamma[5894]=7.9883733091;digamma[5895]=7.9885429875;digamma[5896]=7.9887126372;digamma[5897]=7.9888822581;digamma[5898]=7.9890518502;digamma[5899]=7.9892214136;digamma[5900]=7.9893909482;digamma[5901]=7.9895604541;digamma[5902]=7.9897299313;digamma[5903]=7.9898993797;digamma[5904]=7.9900687995;digamma[5905]=7.9902381905;digamma[5906]=7.9904075529;digamma[5907]=7.9905768865;digamma[5908]=7.9907461915;digamma[5909]=7.9909154679;digamma[5910]=7.9910847156;digamma[5911]=7.9912539346;digamma[5912]=7.9914231250;digamma[5913]=7.9915922868;digamma[5914]=7.9917614200;digamma[5915]=7.9919305246;digamma[5916]=7.9920996006;digamma[5917]=7.9922686480;digamma[5918]=7.9924376669;digamma[5919]=7.9926066572;digamma[5920]=7.9927756189;digamma[5921]=7.9929445521;digamma[5922]=7.9931134567;digamma[5923]=7.9932823329;digamma[5924]=7.9934511805;digamma[5925]=7.9936199996;digamma[5926]=7.9937887902;digamma[5927]=7.9939575523;digamma[5928]=7.9941262860;digamma[5929]=7.9942949912;digamma[5930]=7.9944636679;digamma[5931]=7.9946323162;digamma[5932]=7.9948009360;digamma[5933]=7.9949695274;digamma[5934]=7.9951380904;digamma[5935]=7.9953066250;digamma[5936]=7.9954751312;digamma[5937]=7.9956436090;digamma[5938]=7.9958120584;digamma[5939]=7.9959804795;digamma[5940]=7.9961488722;digamma[5941]=7.9963172365;digamma[5942]=7.9964855725;digamma[5943]=7.9966538802;digamma[5944]=7.9968221595;digamma[5945]=7.9969904106;digamma[5946]=7.9971586333;digamma[5947]=7.9973268277;digamma[5948]=7.9974949939;digamma[5949]=7.9976631317;digamma[5950]=7.9978312413;digamma[5951]=7.9979993227;digamma[5952]=7.9981673758;digamma[5953]=7.9983354007;digamma[5954]=7.9985033973;digamma[5955]=7.9986713657;digamma[5956]=7.9988393059;digamma[5957]=7.9990072179;digamma[5958]=7.9991751018;digamma[5959]=7.9993429574;digamma[5960]=7.9995107849;digamma[5961]=7.9996785842;digamma[5962]=7.9998463554;digamma[5963]=8.0000140984;digamma[5964]=8.0001818133;digamma[5965]=8.0003495000;digamma[5966]=8.0005171587;digamma[5967]=8.0006847892;digamma[5968]=8.0008523916;digamma[5969]=8.0010199660;digamma[5970]=8.0011875123;digamma[5971]=8.0013550305;digamma[5972]=8.0015225207;digamma[5973]=8.0016899828;digamma[5974]=8.0018574168;digamma[5975]=8.0020248229;digamma[5976]=8.0021922009;digamma[5977]=8.0023595509;digamma[5978]=8.0025268729;digamma[5979]=8.0026941669;digamma[5980]=8.0028614330;digamma[5981]=8.0030286710;digamma[5982]=8.0031958811;digamma[5983]=8.0033630633;digamma[5984]=8.0035302175;digamma[5985]=8.0036973437;digamma[5986]=8.0038644421;digamma[5987]=8.0040315125;digamma[5988]=8.0041985550;digamma[5989]=8.0043655696;digamma[5990]=8.0045325564;digamma[5991]=8.0046995152;digamma[5992]=8.0048664462;digamma[5993]=8.0050333493;digamma[5994]=8.0052002245;digamma[5995]=8.0053670720;digamma[5996]=8.0055338915;digamma[5997]=8.0057006833;digamma[5998]=8.0058674472;digamma[5999]=8.0060341834;digamma[6000]=8.0062008917;digamma[6001]=8.0063675723;digamma[6002]=8.0065342251;digamma[6003]=8.0067008501;digamma[6004]=8.0068674473;digamma[6005]=8.0070340168;digamma[6006]=8.0072005586;digamma[6007]=8.0073670726;digamma[6008]=8.0075335589;digamma[6009]=8.0077000175;digamma[6010]=8.0078664484;digamma[6011]=8.0080328516;digamma[6012]=8.0081992271;digamma[6013]=8.0083655749;digamma[6014]=8.0085318951;digamma[6015]=8.0086981876;digamma[6016]=8.0088644525;digamma[6017]=8.0090306897;digamma[6018]=8.0091968993;digamma[6019]=8.0093630812;digamma[6020]=8.0095292356;digamma[6021]=8.0096953623;digamma[6022]=8.0098614615;digamma[6023]=8.0100275331;digamma[6024]=8.0101935771;digamma[6025]=8.0103595935;digamma[6026]=8.0105255824;digamma[6027]=8.0106915437;digamma[6028]=8.0108574775;digamma[6029]=8.0110233838;digamma[6030]=8.0111892625;digamma[6031]=8.0113551137;digamma[6032]=8.0115209375;digamma[6033]=8.0116867337;digamma[6034]=8.0118525025;digamma[6035]=8.0120182437;digamma[6036]=8.0121839575;digamma[6037]=8.0123496439;digamma[6038]=8.0125153028;digamma[6039]=8.0126809343;digamma[6040]=8.0128465383;digamma[6041]=8.0130121149;digamma[6042]=8.0131776641;digamma[6043]=8.0133431860;digamma[6044]=8.0135086804;digamma[6045]=8.0136741474;digamma[6046]=8.0138395870;digamma[6047]=8.0140049993;digamma[6048]=8.0141703843;digamma[6049]=8.0143357419;digamma[6050]=8.0145010721;digamma[6051]=8.0146663750;digamma[6052]=8.0148316506;digamma[6053]=8.0149968989;digamma[6054]=8.0151621199;digamma[6055]=8.0153273136;digamma[6056]=8.0154924800;digamma[6057]=8.0156576191;digamma[6058]=8.0158227310;digamma[6059]=8.0159878156;digamma[6060]=8.0161528729;digamma[6061]=8.0163179030;digamma[6062]=8.0164829059;digamma[6063]=8.0166478816;digamma[6064]=8.0168128300;digamma[6065]=8.0169777513;digamma[6066]=8.0171426453;digamma[6067]=8.0173075122;digamma[6068]=8.0174723519;digamma[6069]=8.0176371644;digamma[6070]=8.0178019498;digamma[6071]=8.0179667080;digamma[6072]=8.0181314391;digamma[6073]=8.0182961430;digamma[6074]=8.0184608199;digamma[6075]=8.0186254696;digamma[6076]=8.0187900922;digamma[6077]=8.0189546877;digamma[6078]=8.0191192561;digamma[6079]=8.0192837974;digamma[6080]=8.0194483117;digamma[6081]=8.0196127989;digamma[6082]=8.0197772591;digamma[6083]=8.0199416922;digamma[6084]=8.0201060983;digamma[6085]=8.0202704773;digamma[6086]=8.0204348294;digamma[6087]=8.0205991544;digamma[6088]=8.0207634524;digamma[6089]=8.0209277235;digamma[6090]=8.0210919675;digamma[6091]=8.0212561846;digamma[6092]=8.0214203748;digamma[6093]=8.0215845379;digamma[6094]=8.0217486742;digamma[6095]=8.0219127835;digamma[6096]=8.0220768658;digamma[6097]=8.0222409213;digamma[6098]=8.0224049498;digamma[6099]=8.0225689515;digamma[6100]=8.0227329262;digamma[6101]=8.0228968741;digamma[6102]=8.0230607951;digamma[6103]=8.0232246892;digamma[6104]=8.0233885565;digamma[6105]=8.0235523969;digamma[6106]=8.0237162105;digamma[6107]=8.0238799972;digamma[6108]=8.0240437571;digamma[6109]=8.0242074902;digamma[6110]=8.0243711966;digamma[6111]=8.0245348761;digamma[6112]=8.0246985288;digamma[6113]=8.0248621547;digamma[6114]=8.0250257539;digamma[6115]=8.0251893263;digamma[6116]=8.0253528720;digamma[6117]=8.0255163909;digamma[6118]=8.0256798831;digamma[6119]=8.0258433486;digamma[6120]=8.0260067874;digamma[6121]=8.0261701994;digamma[6122]=8.0263335847;digamma[6123]=8.0264969434;digamma[6124]=8.0266602754;digamma[6125]=8.0268235807;digamma[6126]=8.0269868593;digamma[6127]=8.0271501113;digamma[6128]=8.0273133366;digamma[6129]=8.0274765353;digamma[6130]=8.0276397074;digamma[6131]=8.0278028528;digamma[6132]=8.0279659716;digamma[6133]=8.0281290639;digamma[6134]=8.0282921295;digamma[6135]=8.0284551685;digamma[6136]=8.0286181810;digamma[6137]=8.0287811669;digamma[6138]=8.0289441263;digamma[6139]=8.0291070590;digamma[6140]=8.0292699653;digamma[6141]=8.0294328450;digamma[6142]=8.0295956982;digamma[6143]=8.0297585249;digamma[6144]=8.0299213250;digamma[6145]=8.0300840987;digamma[6146]=8.0302468459;digamma[6147]=8.0304095665;digamma[6148]=8.0305722608;digamma[6149]=8.0307349285;digamma[6150]=8.0308975698;digamma[6151]=8.0310601846;digamma[6152]=8.0312227731;digamma[6153]=8.0313853350;digamma[6154]=8.0315478706;digamma[6155]=8.0317103797;digamma[6156]=8.0318728625;digamma[6157]=8.0320353188;digamma[6158]=8.0321977487;digamma[6159]=8.0323601523;digamma[6160]=8.0325225295;digamma[6161]=8.0326848804;digamma[6162]=8.0328472048;digamma[6163]=8.0330095030;digamma[6164]=8.0331717748;digamma[6165]=8.0333340203;digamma[6166]=8.0334962394;digamma[6167]=8.0336584323;digamma[6168]=8.0338205988;digamma[6169]=8.0339827391;digamma[6170]=8.0341448530;digamma[6171]=8.0343069407;digamma[6172]=8.0344690021;digamma[6173]=8.0346310373;digamma[6174]=8.0347930462;digamma[6175]=8.0349550289;digamma[6176]=8.0351169853;digamma[6177]=8.0352789155;digamma[6178]=8.0354408195;digamma[6179]=8.0356026973;digamma[6180]=8.0357645489;digamma[6181]=8.0359263743;digamma[6182]=8.0360881735;digamma[6183]=8.0362499465;digamma[6184]=8.0364116934;digamma[6185]=8.0365734141;digamma[6186]=8.0367351086;digamma[6187]=8.0368967770;digamma[6188]=8.0370584193;digamma[6189]=8.0372200355;digamma[6190]=8.0373816255;digamma[6191]=8.0375431895;digamma[6192]=8.0377047273;digamma[6193]=8.0378662391;digamma[6194]=8.0380277247;digamma[6195]=8.0381891843;digamma[6196]=8.0383506178;digamma[6197]=8.0385120253;digamma[6198]=8.0386734067;digamma[6199]=8.0388347621;digamma[6200]=8.0389960915;digamma[6201]=8.0391573948;digamma[6202]=8.0393186721;digamma[6203]=8.0394799234;digamma[6204]=8.0396411487;digamma[6205]=8.0398023481;digamma[6206]=8.0399635214;digamma[6207]=8.0401246688;digamma[6208]=8.0402857902;digamma[6209]=8.0404468856;digamma[6210]=8.0406079551;digamma[6211]=8.0407689987;digamma[6212]=8.0409300163;digamma[6213]=8.0410910080;digamma[6214]=8.0412519738;digamma[6215]=8.0414129137;digamma[6216]=8.0415738277;digamma[6217]=8.0417347158;digamma[6218]=8.0418955780;digamma[6219]=8.0420564144;digamma[6220]=8.0422172249;digamma[6221]=8.0423780095;digamma[6222]=8.0425387683;digamma[6223]=8.0426995012;digamma[6224]=8.0428602083;digamma[6225]=8.0430208896;digamma[6226]=8.0431815451;digamma[6227]=8.0433421747;digamma[6228]=8.0435027786;digamma[6229]=8.0436633567;digamma[6230]=8.0438239090;digamma[6231]=8.0439844355;digamma[6232]=8.0441449363;digamma[6233]=8.0443054113;digamma[6234]=8.0444658605;digamma[6235]=8.0446262841;digamma[6236]=8.0447866818;digamma[6237]=8.0449470539;digamma[6238]=8.0451074003;digamma[6239]=8.0452677209;digamma[6240]=8.0454280158;digamma[6241]=8.0455882851;digamma[6242]=8.0457485287;digamma[6243]=8.0459087465;digamma[6244]=8.0460689388;digamma[6245]=8.0462291054;digamma[6246]=8.0463892463;digamma[6247]=8.0465493616;digamma[6248]=8.0467094512;digamma[6249]=8.0468695152;digamma[6250]=8.0470295536;digamma[6251]=8.0471895664;digamma[6252]=8.0473495536;digamma[6253]=8.0475095152;digamma[6254]=8.0476694513;digamma[6255]=8.0478293617;digamma[6256]=8.0479892466;digamma[6257]=8.0481491059;digamma[6258]=8.0483089397;digamma[6259]=8.0484687479;digamma[6260]=8.0486285306;digamma[6261]=8.0487882878;digamma[6262]=8.0489480194;digamma[6263]=8.0491077256;digamma[6264]=8.0492674062;digamma[6265]=8.0494270614;digamma[6266]=8.0495866910;digamma[6267]=8.0497462952;digamma[6268]=8.0499058739;digamma[6269]=8.0500654272;digamma[6270]=8.0502249550;digamma[6271]=8.0503844573;digamma[6272]=8.0505439342;digamma[6273]=8.0507033857;digamma[6274]=8.0508628118;digamma[6275]=8.0510222124;digamma[6276]=8.0511815877;digamma[6277]=8.0513409375;digamma[6278]=8.0515002620;digamma[6279]=8.0516595611;digamma[6280]=8.0518188348;digamma[6281]=8.0519780831;digamma[6282]=8.0521373061;digamma[6283]=8.0522965038;digamma[6284]=8.0524556761;digamma[6285]=8.0526148230;digamma[6286]=8.0527739447;digamma[6287]=8.0529330410;digamma[6288]=8.0530921120;digamma[6289]=8.0532511578;digamma[6290]=8.0534101782;digamma[6291]=8.0535691733;digamma[6292]=8.0537281432;digamma[6293]=8.0538870878;digamma[6294]=8.0540460072;digamma[6295]=8.0542049013;digamma[6296]=8.0543637701;digamma[6297]=8.0545226137;digamma[6298]=8.0546814321;digamma[6299]=8.0548402253;digamma[6300]=8.0549989933;digamma[6301]=8.0551577360;digamma[6302]=8.0553164536;digamma[6303]=8.0554751460;digamma[6304]=8.0556338131;digamma[6305]=8.0557924552;digamma[6306]=8.0559510720;digamma[6307]=8.0561096637;digamma[6308]=8.0562682303;digamma[6309]=8.0564267717;digamma[6310]=8.0565852880;digamma[6311]=8.0567437792;digamma[6312]=8.0569022452;digamma[6313]=8.0570606861;digamma[6314]=8.0572191020;digamma[6315]=8.0573774927;digamma[6316]=8.0575358584;digamma[6317]=8.0576941990;digamma[6318]=8.0578525145;digamma[6319]=8.0580108050;digamma[6320]=8.0581690704;digamma[6321]=8.0583273108;digamma[6322]=8.0584855261;digamma[6323]=8.0586437164;digamma[6324]=8.0588018817;digamma[6325]=8.0589600219;digamma[6326]=8.0591181372;digamma[6327]=8.0592762275;digamma[6328]=8.0594342928;digamma[6329]=8.0595923330;digamma[6330]=8.0597503484;digamma[6331]=8.0599083387;digamma[6332]=8.0600663041;digamma[6333]=8.0602242446;digamma[6334]=8.0603821601;digamma[6335]=8.0605400507;digamma[6336]=8.0606979163;digamma[6337]=8.0608557571;digamma[6338]=8.0610135729;digamma[6339]=8.0611713638;digamma[6340]=8.0613291299;digamma[6341]=8.0614868710;digamma[6342]=8.0616445873;digamma[6343]=8.0618022787;digamma[6344]=8.0619599452;digamma[6345]=8.0621175869;digamma[6346]=8.0622752037;digamma[6347]=8.0624327957;digamma[6348]=8.0625903629;digamma[6349]=8.0627479052;digamma[6350]=8.0629054227;digamma[6351]=8.0630629155;digamma[6352]=8.0632203834;digamma[6353]=8.0633778265;digamma[6354]=8.0635352448;digamma[6355]=8.0636926384;digamma[6356]=8.0638500072;digamma[6357]=8.0640073512;digamma[6358]=8.0641646705;digamma[6359]=8.0643219650;digamma[6360]=8.0644792348;digamma[6361]=8.0646364799;digamma[6362]=8.0647937002;digamma[6363]=8.0649508959;digamma[6364]=8.0651080668;digamma[6365]=8.0652652130;digamma[6366]=8.0654223345;digamma[6367]=8.0655794314;digamma[6368]=8.0657365036;digamma[6369]=8.0658935511;digamma[6370]=8.0660505739;digamma[6371]=8.0662075721;digamma[6372]=8.0663645457;digamma[6373]=8.0665214946;digamma[6374]=8.0666784189;digamma[6375]=8.0668353185;digamma[6376]=8.0669921936;digamma[6377]=8.0671490440;digamma[6378]=8.0673058699;digamma[6379]=8.0674626711;digamma[6380]=8.0676194478;digamma[6381]=8.0677761999;digamma[6382]=8.0679329274;digamma[6383]=8.0680896304;digamma[6384]=8.0682463088;digamma[6385]=8.0684029627;digamma[6386]=8.0685595920;digamma[6387]=8.0687161968;digamma[6388]=8.0688727771;digamma[6389]=8.0690293329;digamma[6390]=8.0691858641;digamma[6391]=8.0693423709;digamma[6392]=8.0694988532;digamma[6393]=8.0696553110;digamma[6394]=8.0698117443;digamma[6395]=8.0699681531;digamma[6396]=8.0701245375;digamma[6397]=8.0702808975;digamma[6398]=8.0704372330;digamma[6399]=8.0705935440;digamma[6400]=8.0707498306;digamma[6401]=8.0709060929;digamma[6402]=8.0710623306;digamma[6403]=8.0712185440;digamma[6404]=8.0713747330;digamma[6405]=8.0715308976;digamma[6406]=8.0716870378;digamma[6407]=8.0718431537;digamma[6408]=8.0719992451;digamma[6409]=8.0721553122;digamma[6410]=8.0723113550;digamma[6411]=8.0724673734;digamma[6412]=8.0726233675;digamma[6413]=8.0727793372;digamma[6414]=8.0729352826;digamma[6415]=8.0730912037;digamma[6416]=8.0732471005;digamma[6417]=8.0734029730;digamma[6418]=8.0735588212;digamma[6419]=8.0737146452;digamma[6420]=8.0738704448;digamma[6421]=8.0740262202;digamma[6422]=8.0741819713;digamma[6423]=8.0743376981;digamma[6424]=8.0744934007;digamma[6425]=8.0746490791;digamma[6426]=8.0748047332;digamma[6427]=8.0749603632;digamma[6428]=8.0751159688;digamma[6429]=8.0752715503;digamma[6430]=8.0754271076;digamma[6431]=8.0755826407;digamma[6432]=8.0757381496;digamma[6433]=8.0758936343;digamma[6434]=8.0760490949;digamma[6435]=8.0762045313;digamma[6436]=8.0763599435;digamma[6437]=8.0765153316;digamma[6438]=8.0766706955;digamma[6439]=8.0768260353;digamma[6440]=8.0769813510;digamma[6441]=8.0771366426;digamma[6442]=8.0772919100;digamma[6443]=8.0774471533;digamma[6444]=8.0776023726;digamma[6445]=8.0777575678;digamma[6446]=8.0779127388;digamma[6447]=8.0780678858;digamma[6448]=8.0782230088;digamma[6449]=8.0783781076;digamma[6450]=8.0785331825;digamma[6451]=8.0786882332;digamma[6452]=8.0788432600;digamma[6453]=8.0789982627;digamma[6454]=8.0791532414;digamma[6455]=8.0793081961;digamma[6456]=8.0794631267;digamma[6457]=8.0796180334;digamma[6458]=8.0797729161;digamma[6459]=8.0799277748;digamma[6460]=8.0800826095;digamma[6461]=8.0802374202;digamma[6462]=8.0803922070;digamma[6463]=8.0805469698;digamma[6464]=8.0807017087;digamma[6465]=8.0808564236;digamma[6466]=8.0810111146;digamma[6467]=8.0811657817;digamma[6468]=8.0813204249;digamma[6469]=8.0814750441;digamma[6470]=8.0816296395;digamma[6471]=8.0817842109;digamma[6472]=8.0819387585;digamma[6473]=8.0820932822;digamma[6474]=8.0822477820;digamma[6475]=8.0824022579;digamma[6476]=8.0825567100;digamma[6477]=8.0827111382;digamma[6478]=8.0828655426;digamma[6479]=8.0830199231;digamma[6480]=8.0831742799;digamma[6481]=8.0833286128;digamma[6482]=8.0834829218;digamma[6483]=8.0836372071;digamma[6484]=8.0837914686;digamma[6485]=8.0839457063;digamma[6486]=8.0840999202;digamma[6487]=8.0842541103;digamma[6488]=8.0844082766;digamma[6489]=8.0845624192;digamma[6490]=8.0847165380;digamma[6491]=8.0848706331;digamma[6492]=8.0850247044;digamma[6493]=8.0851787520;digamma[6494]=8.0853327759;digamma[6495]=8.0854867761;digamma[6496]=8.0856407525;digamma[6497]=8.0857947052;digamma[6498]=8.0859486343;digamma[6499]=8.0861025396;digamma[6500]=8.0862564213;digamma[6501]=8.0864102793;digamma[6502]=8.0865641136;digamma[6503]=8.0867179242;digamma[6504]=8.0868717113;digamma[6505]=8.0870254746;digamma[6506]=8.0871792143;digamma[6507]=8.0873329304;digamma[6508]=8.0874866229;digamma[6509]=8.0876402917;digamma[6510]=8.0877939369;digamma[6511]=8.0879475586;digamma[6512]=8.0881011566;digamma[6513]=8.0882547311;digamma[6514]=8.0884082819;digamma[6515]=8.0885618092;digamma[6516]=8.0887153129;digamma[6517]=8.0888687931;digamma[6518]=8.0890222497;digamma[6519]=8.0891756828;digamma[6520]=8.0893290923;digamma[6521]=8.0894824783;digamma[6522]=8.0896358408;digamma[6523]=8.0897891797;digamma[6524]=8.0899424952;digamma[6525]=8.0900957871;digamma[6526]=8.0902490555;digamma[6527]=8.0904023005;digamma[6528]=8.0905555220;digamma[6529]=8.0907087200;digamma[6530]=8.0908618945;digamma[6531]=8.0910150456;digamma[6532]=8.0911681733;digamma[6533]=8.0913212774;digamma[6534]=8.0914743582;digamma[6535]=8.0916274155;digamma[6536]=8.0917804494;digamma[6537]=8.0919334599;digamma[6538]=8.0920864470;digamma[6539]=8.0922394106;digamma[6540]=8.0923923509;digamma[6541]=8.0925452678;digamma[6542]=8.0926981613;digamma[6543]=8.0928510314;digamma[6544]=8.0930038782;digamma[6545]=8.0931567016;digamma[6546]=8.0933095017;digamma[6547]=8.0934622784;digamma[6548]=8.0936150318;digamma[6549]=8.0937677618;digamma[6550]=8.0939204685;digamma[6551]=8.0940731520;digamma[6552]=8.0942258121;digamma[6553]=8.0943784489;digamma[6554]=8.0945310624;digamma[6555]=8.0946836526;digamma[6556]=8.0948362195;digamma[6557]=8.0949887632;digamma[6558]=8.0951412836;digamma[6559]=8.0952937807;digamma[6560]=8.0954462546;digamma[6561]=8.0955987053;digamma[6562]=8.0957511327;digamma[6563]=8.0959035368;digamma[6564]=8.0960559178;digamma[6565]=8.0962082755;digamma[6566]=8.0963606100;digamma[6567]=8.0965129214;digamma[6568]=8.0966652095;digamma[6569]=8.0968174744;digamma[6570]=8.0969697162;digamma[6571]=8.0971219348;digamma[6572]=8.0972741302;digamma[6573]=8.0974263025;digamma[6574]=8.0975784516;digamma[6575]=8.0977305775;digamma[6576]=8.0978826803;digamma[6577]=8.0980347600;digamma[6578]=8.0981868166;digamma[6579]=8.0983388500;digamma[6580]=8.0984908604;digamma[6581]=8.0986428476;digamma[6582]=8.0987948117;digamma[6583]=8.0989467528;digamma[6584]=8.0990986708;digamma[6585]=8.0992505656;digamma[6586]=8.0994024375;digamma[6587]=8.0995542862;digamma[6588]=8.0997061119;digamma[6589]=8.0998579146;digamma[6590]=8.1000096942;digamma[6591]=8.1001614508;digamma[6592]=8.1003131843;digamma[6593]=8.1004648949;digamma[6594]=8.1006165824;digamma[6595]=8.1007682469;digamma[6596]=8.1009198884;digamma[6597]=8.1010715070;digamma[6598]=8.1012231025;digamma[6599]=8.1013746751;digamma[6600]=8.1015262247;digamma[6601]=8.1016777513;digamma[6602]=8.1018292550;digamma[6603]=8.1019807357;digamma[6604]=8.1021321935;digamma[6605]=8.1022836283;digamma[6606]=8.1024350402;digamma[6607]=8.1025864292;digamma[6608]=8.1027377953;digamma[6609]=8.1028891385;digamma[6610]=8.1030404587;digamma[6611]=8.1031917561;digamma[6612]=8.1033430306;digamma[6613]=8.1034942822;digamma[6614]=8.1036455109;digamma[6615]=8.1037967168;digamma[6616]=8.1039478998;digamma[6617]=8.1040990600;digamma[6618]=8.1042501973;digamma[6619]=8.1044013117;digamma[6620]=8.1045524034;digamma[6621]=8.1047034722;digamma[6622]=8.1048545182;digamma[6623]=8.1050055413;digamma[6624]=8.1051565417;digamma[6625]=8.1053075193;digamma[6626]=8.1054584741;digamma[6627]=8.1056094061;digamma[6628]=8.1057603153;digamma[6629]=8.1059112018;digamma[6630]=8.1060620655;digamma[6631]=8.1062129064;digamma[6632]=8.1063637246;digamma[6633]=8.1065145200;digamma[6634]=8.1066652928;digamma[6635]=8.1068160427;digamma[6636]=8.1069667700;digamma[6637]=8.1071174745;digamma[6638]=8.1072681564;digamma[6639]=8.1074188155;digamma[6640]=8.1075694519;digamma[6641]=8.1077200657;digamma[6642]=8.1078706568;digamma[6643]=8.1080212252;digamma[6644]=8.1081717709;digamma[6645]=8.1083222939;digamma[6646]=8.1084727944;digamma[6647]=8.1086232721;digamma[6648]=8.1087737273;digamma[6649]=8.1089241597;digamma[6650]=8.1090745696;digamma[6651]=8.1092249569;digamma[6652]=8.1093753215;digamma[6653]=8.1095256635;digamma[6654]=8.1096759829;digamma[6655]=8.1098262798;digamma[6656]=8.1099765540;digamma[6657]=8.1101268057;digamma[6658]=8.1102770348;digamma[6659]=8.1104272413;digamma[6660]=8.1105774253;digamma[6661]=8.1107275867;digamma[6662]=8.1108777256;digamma[6663]=8.1110278419;digamma[6664]=8.1111779358;digamma[6665]=8.1113280070;digamma[6666]=8.1114780558;digamma[6667]=8.1116280821;digamma[6668]=8.1117780858;digamma[6669]=8.1119280671;digamma[6670]=8.1120780258;digamma[6671]=8.1122279621;digamma[6672]=8.1123778759;digamma[6673]=8.1125277672;digamma[6674]=8.1126776361;digamma[6675]=8.1128274825;digamma[6676]=8.1129773064;digamma[6677]=8.1131271080;digamma[6678]=8.1132768870;digamma[6679]=8.1134266437;digamma[6680]=8.1135763779;digamma[6681]=8.1137260897;digamma[6682]=8.1138757791;digamma[6683]=8.1140254461;digamma[6684]=8.1141750907;digamma[6685]=8.1143247129;digamma[6686]=8.1144743127;digamma[6687]=8.1146238901;digamma[6688]=8.1147734452;digamma[6689]=8.1149229779;digamma[6690]=8.1150724883;digamma[6691]=8.1152219763;digamma[6692]=8.1153714419;digamma[6693]=8.1155208853;digamma[6694]=8.1156703063;digamma[6695]=8.1158197049;digamma[6696]=8.1159690813;digamma[6697]=8.1161184353;digamma[6698]=8.1162677671;digamma[6699]=8.1164170765;digamma[6700]=8.1165663637;digamma[6701]=8.1167156285;digamma[6702]=8.1168648711;digamma[6703]=8.1170140914;digamma[6704]=8.1171632895;digamma[6705]=8.1173124653;digamma[6706]=8.1174616189;digamma[6707]=8.1176107502;digamma[6708]=8.1177598592;digamma[6709]=8.1179089461;digamma[6710]=8.1180580107;digamma[6711]=8.1182070531;digamma[6712]=8.1183560733;digamma[6713]=8.1185050713;digamma[6714]=8.1186540471;digamma[6715]=8.1188030007;digamma[6716]=8.1189519321;digamma[6717]=8.1191008413;digamma[6718]=8.1192497284;digamma[6719]=8.1193985933;digamma[6720]=8.1195474361;digamma[6721]=8.1196962566;digamma[6722]=8.1198450551;digamma[6723]=8.1199938314;digamma[6724]=8.1201425856;digamma[6725]=8.1202913177;digamma[6726]=8.1204400276;digamma[6727]=8.1205887154;digamma[6728]=8.1207373811;digamma[6729]=8.1208860248;digamma[6730]=8.1210346463;digamma[6731]=8.1211832458;digamma[6732]=8.1213318231;digamma[6733]=8.1214803784;digamma[6734]=8.1216289117;digamma[6735]=8.1217774228;digamma[6736]=8.1219259120;digamma[6737]=8.1220743790;digamma[6738]=8.1222228241;digamma[6739]=8.1223712471;digamma[6740]=8.1225196481;digamma[6741]=8.1226680270;digamma[6742]=8.1228163840;digamma[6743]=8.1229647189;digamma[6744]=8.1231130318;digamma[6745]=8.1232613228;digamma[6746]=8.1234095917;digamma[6747]=8.1235578387;digamma[6748]=8.1237060637;digamma[6749]=8.1238542668;digamma[6750]=8.1240024478;digamma[6751]=8.1241506070;digamma[6752]=8.1242987441;digamma[6753]=8.1244468594;digamma[6754]=8.1245949527;digamma[6755]=8.1247430240;digamma[6756]=8.1248910735;digamma[6757]=8.1250391010;digamma[6758]=8.1251871066;digamma[6759]=8.1253350904;digamma[6760]=8.1254830522;digamma[6761]=8.1256309921;digamma[6762]=8.1257789102;digamma[6763]=8.1259268064;digamma[6764]=8.1260746807;digamma[6765]=8.1262225331;digamma[6766]=8.1263703637;digamma[6767]=8.1265181724;digamma[6768]=8.1266659593;digamma[6769]=8.1268137244;digamma[6770]=8.1269614676;digamma[6771]=8.1271091890;digamma[6772]=8.1272568886;digamma[6773]=8.1274045663;digamma[6774]=8.1275522223;digamma[6775]=8.1276998564;digamma[6776]=8.1278474688;digamma[6777]=8.1279950594;digamma[6778]=8.1281426282;digamma[6779]=8.1282901752;digamma[6780]=8.1284377005;digamma[6781]=8.1285852040;digamma[6782]=8.1287326857;digamma[6783]=8.1288801457;digamma[6784]=8.1290275840;digamma[6785]=8.1291750005;digamma[6786]=8.1293223953;digamma[6787]=8.1294697684;digamma[6788]=8.1296171198;digamma[6789]=8.1297644494;digamma[6790]=8.1299117574;digamma[6791]=8.1300590436;digamma[6792]=8.1302063082;digamma[6793]=8.1303535510;digamma[6794]=8.1305007722;digamma[6795]=8.1306479718;digamma[6796]=8.1307951496;digamma[6797]=8.1309423058;digamma[6798]=8.1310894404;digamma[6799]=8.1312365533;digamma[6800]=8.1313836446;digamma[6801]=8.1315307142;digamma[6802]=8.1316777622;digamma[6803]=8.1318247886;digamma[6804]=8.1319717934;digamma[6805]=8.1321187766;digamma[6806]=8.1322657381;digamma[6807]=8.1324126781;digamma[6808]=8.1325595965;digamma[6809]=8.1327064933;digamma[6810]=8.1328533685;digamma[6811]=8.1330002222;digamma[6812]=8.1331470543;digamma[6813]=8.1332938648;digamma[6814]=8.1334406538;digamma[6815]=8.1335874213;digamma[6816]=8.1337341672;digamma[6817]=8.1338808915;digamma[6818]=8.1340275944;digamma[6819]=8.1341742757;digamma[6820]=8.1343209355;digamma[6821]=8.1344675739;digamma[6822]=8.1346141907;digamma[6823]=8.1347607860;digamma[6824]=8.1349073598;digamma[6825]=8.1350539122;digamma[6826]=8.1352004431;digamma[6827]=8.1353469525;digamma[6828]=8.1354934404;digamma[6829]=8.1356399069;digamma[6830]=8.1357863520;digamma[6831]=8.1359327756;digamma[6832]=8.1360791777;digamma[6833]=8.1362255585;digamma[6834]=8.1363719178;digamma[6835]=8.1365182557;digamma[6836]=8.1366645722;digamma[6837]=8.1368108672;digamma[6838]=8.1369571409;digamma[6839]=8.1371033932;digamma[6840]=8.1372496241;digamma[6841]=8.1373958336;digamma[6842]=8.1375420218;digamma[6843]=8.1376881885;digamma[6844]=8.1378343340;digamma[6845]=8.1379804580;digamma[6846]=8.1381265607;digamma[6847]=8.1382726421;digamma[6848]=8.1384187021;digamma[6849]=8.1385647408;digamma[6850]=8.1387107582;digamma[6851]=8.1388567542;digamma[6852]=8.1390027290;digamma[6853]=8.1391486824;digamma[6854]=8.1392946146;digamma[6855]=8.1394405254;digamma[6856]=8.1395864150;digamma[6857]=8.1397322833;digamma[6858]=8.1398781303;digamma[6859]=8.1400239560;digamma[6860]=8.1401697605;digamma[6861]=8.1403155437;digamma[6862]=8.1404613057;digamma[6863]=8.1406070464;digamma[6864]=8.1407527659;digamma[6865]=8.1408984641;digamma[6866]=8.1410441412;digamma[6867]=8.1411897970;digamma[6868]=8.1413354316;digamma[6869]=8.1414810450;digamma[6870]=8.1416266372;digamma[6871]=8.1417722082;digamma[6872]=8.1419177580;digamma[6873]=8.1420632866;digamma[6874]=8.1422087941;digamma[6875]=8.1423542804;digamma[6876]=8.1424997455;digamma[6877]=8.1426451895;digamma[6878]=8.1427906123;digamma[6879]=8.1429360140;digamma[6880]=8.1430813945;digamma[6881]=8.1432267539;digamma[6882]=8.1433720922;digamma[6883]=8.1435174093;digamma[6884]=8.1436627054;digamma[6885]=8.1438079803;digamma[6886]=8.1439532341;digamma[6887]=8.1440984669;digamma[6888]=8.1442436785;digamma[6889]=8.1443888691;digamma[6890]=8.1445340385;digamma[6891]=8.1446791870;digamma[6892]=8.1448243143;digamma[6893]=8.1449694206;digamma[6894]=8.1451145058;digamma[6895]=8.1452595700;digamma[6896]=8.1454046132;digamma[6897]=8.1455496353;digamma[6898]=8.1456946364;digamma[6899]=8.1458396164;digamma[6900]=8.1459845755;digamma[6901]=8.1461295135;digamma[6902]=8.1462744306;digamma[6903]=8.1464193266;digamma[6904]=8.1465642016;digamma[6905]=8.1467090557;digamma[6906]=8.1468538888;digamma[6907]=8.1469987009;digamma[6908]=8.1471434920;digamma[6909]=8.1472882622;digamma[6910]=8.1474330114;digamma[6911]=8.1475777397;digamma[6912]=8.1477224470;digamma[6913]=8.1478671334;digamma[6914]=8.1480117989;digamma[6915]=8.1481564434;digamma[6916]=8.1483010670;digamma[6917]=8.1484456697;digamma[6918]=8.1485902515;digamma[6919]=8.1487348124;digamma[6920]=8.1488793524;digamma[6921]=8.1490238715;digamma[6922]=8.1491683698;digamma[6923]=8.1493128471;digamma[6924]=8.1494573036;digamma[6925]=8.1496017392;digamma[6926]=8.1497461540;digamma[6927]=8.1498905479;digamma[6928]=8.1500349209;digamma[6929]=8.1501792732;digamma[6930]=8.1503236045;digamma[6931]=8.1504679151;digamma[6932]=8.1506122048;digamma[6933]=8.1507564737;digamma[6934]=8.1509007218;digamma[6935]=8.1510449492;digamma[6936]=8.1511891557;digamma[6937]=8.1513333414;digamma[6938]=8.1514775063;digamma[6939]=8.1516216504;digamma[6940]=8.1517657738;digamma[6941]=8.1519098764;digamma[6942]=8.1520539582;digamma[6943]=8.1521980193;digamma[6944]=8.1523420597;digamma[6945]=8.1524860792;digamma[6946]=8.1526300781;digamma[6947]=8.1527740562;digamma[6948]=8.1529180136;digamma[6949]=8.1530619503;digamma[6950]=8.1532058662;digamma[6951]=8.1533497614;digamma[6952]=8.1534936360;digamma[6953]=8.1536374898;digamma[6954]=8.1537813230;digamma[6955]=8.1539251355;digamma[6956]=8.1540689272;digamma[6957]=8.1542126984;digamma[6958]=8.1543564488;digamma[6959]=8.1545001786;digamma[6960]=8.1546438877;digamma[6961]=8.1547875762;digamma[6962]=8.1549312440;digamma[6963]=8.1550748913;digamma[6964]=8.1552185178;digamma[6965]=8.1553621238;digamma[6966]=8.1555057091;digamma[6967]=8.1556492738;digamma[6968]=8.1557928179;digamma[6969]=8.1559363414;digamma[6970]=8.1560798443;digamma[6971]=8.1562233266;digamma[6972]=8.1563667884;digamma[6973]=8.1565102295;digamma[6974]=8.1566536501;digamma[6975]=8.1567970501;digamma[6976]=8.1569404296;digamma[6977]=8.1570837885;digamma[6978]=8.1572271268;digamma[6979]=8.1573704446;digamma[6980]=8.1575137419;digamma[6981]=8.1576570186;digamma[6982]=8.1578002748;digamma[6983]=8.1579435105;digamma[6984]=8.1580867257;digamma[6985]=8.1582299204;digamma[6986]=8.1583730945;digamma[6987]=8.1585162482;digamma[6988]=8.1586593814;digamma[6989]=8.1588024941;digamma[6990]=8.1589455863;digamma[6991]=8.1590886581;digamma[6992]=8.1592317094;digamma[6993]=8.1593747402;digamma[6994]=8.1595177506;digamma[6995]=8.1596607405;digamma[6996]=8.1598037099;digamma[6997]=8.1599466590;digamma[6998]=8.1600895876;digamma[6999]=8.1602324958;digamma[7000]=8.1603753835;digamma[7001]=8.1605182509;digamma[7002]=8.1606610978;digamma[7003]=8.1608039244;digamma[7004]=8.1609467305;digamma[7005]=8.1610895162;digamma[7006]=8.1612322816;digamma[7007]=8.1613750266;digamma[7008]=8.1615177512;digamma[7009]=8.1616604554;digamma[7010]=8.1618031393;digamma[7011]=8.1619458029;digamma[7012]=8.1620884460;digamma[7013]=8.1622310689;digamma[7014]=8.1623736714;digamma[7015]=8.1625162535;digamma[7016]=8.1626588154;digamma[7017]=8.1628013569;digamma[7018]=8.1629438781;digamma[7019]=8.1630863790;digamma[7020]=8.1632288596;digamma[7021]=8.1633713198;digamma[7022]=8.1635137598;digamma[7023]=8.1636561795;digamma[7024]=8.1637985790;digamma[7025]=8.1639409581;digamma[7026]=8.1640833170;digamma[7027]=8.1642256556;digamma[7028]=8.1643679740;digamma[7029]=8.1645102721;digamma[7030]=8.1646525500;digamma[7031]=8.1647948076;digamma[7032]=8.1649370450;digamma[7033]=8.1650792622;digamma[7034]=8.1652214591;digamma[7035]=8.1653636358;digamma[7036]=8.1655057924;digamma[7037]=8.1656479287;digamma[7038]=8.1657900448;digamma[7039]=8.1659321407;digamma[7040]=8.1660742164;digamma[7041]=8.1662162720;digamma[7042]=8.1663583073;digamma[7043]=8.1665003225;digamma[7044]=8.1666423175;digamma[7045]=8.1667842924;digamma[7046]=8.1669262471;digamma[7047]=8.1670681817;digamma[7048]=8.1672100961;digamma[7049]=8.1673519904;digamma[7050]=8.1674938646;digamma[7051]=8.1676357186;digamma[7052]=8.1677775525;digamma[7053]=8.1679193663;digamma[7054]=8.1680611600;digamma[7055]=8.1682029336;digamma[7056]=8.1683446871;digamma[7057]=8.1684864205;digamma[7058]=8.1686281338;digamma[7059]=8.1687698270;digamma[7060]=8.1689115002;digamma[7061]=8.1690531533;digamma[7062]=8.1691947863;digamma[7063]=8.1693363993;digamma[7064]=8.1694779922;digamma[7065]=8.1696195651;digamma[7066]=8.1697611179;digamma[7067]=8.1699026507;digamma[7068]=8.1700441635;digamma[7069]=8.1701856562;digamma[7070]=8.1703271289;digamma[7071]=8.1704685817;digamma[7072]=8.1706100144;digamma[7073]=8.1707514271;digamma[7074]=8.1708928198;digamma[7075]=8.1710341925;digamma[7076]=8.1711755453;digamma[7077]=8.1713168780;digamma[7078]=8.1714581908;digamma[7079]=8.1715994837;digamma[7080]=8.1717407565;digamma[7081]=8.1718820095;digamma[7082]=8.1720232424;digamma[7083]=8.1721644554;digamma[7084]=8.1723056485;digamma[7085]=8.1724468217;digamma[7086]=8.1725879749;digamma[7087]=8.1727291082;digamma[7088]=8.1728702216;digamma[7089]=8.1730113150;digamma[7090]=8.1731523886;digamma[7091]=8.1732934423;digamma[7092]=8.1734344761;digamma[7093]=8.1735754899;digamma[7094]=8.1737164840;digamma[7095]=8.1738574581;digamma[7096]=8.1739984123;digamma[7097]=8.1741393467;digamma[7098]=8.1742802613;digamma[7099]=8.1744211560;digamma[7100]=8.1745620308;digamma[7101]=8.1747028858;digamma[7102]=8.1748437209;digamma[7103]=8.1749845362;digamma[7104]=8.1751253317;digamma[7105]=8.1752661074;digamma[7106]=8.1754068633;digamma[7107]=8.1755475993;digamma[7108]=8.1756883156;digamma[7109]=8.1758290120;digamma[7110]=8.1759696887;digamma[7111]=8.1761103455;digamma[7112]=8.1762509826;digamma[7113]=8.1763915999;digamma[7114]=8.1765321975;digamma[7115]=8.1766727752;digamma[7116]=8.1768133333;digamma[7117]=8.1769538715;digamma[7118]=8.1770943900;digamma[7119]=8.1772348888;digamma[7120]=8.1773753678;digamma[7121]=8.1775158271;digamma[7122]=8.1776562667;digamma[7123]=8.1777966866;digamma[7124]=8.1779370867;digamma[7125]=8.1780774671;digamma[7126]=8.1782178279;digamma[7127]=8.1783581689;digamma[7128]=8.1784984902;digamma[7129]=8.1786387919;digamma[7130]=8.1787790738;digamma[7131]=8.1789193361;digamma[7132]=8.1790595787;digamma[7133]=8.1791998017;digamma[7134]=8.1793400050;digamma[7135]=8.1794801886;digamma[7136]=8.1796203526;digamma[7137]=8.1797604970;digamma[7138]=8.1799006217;digamma[7139]=8.1800407268;digamma[7140]=8.1801808122;digamma[7141]=8.1803208780;digamma[7142]=8.1804609243;digamma[7143]=8.1806009509;digamma[7144]=8.1807409579;digamma[7145]=8.1808809453;digamma[7146]=8.1810209131;digamma[7147]=8.1811608613;digamma[7148]=8.1813007899;digamma[7149]=8.1814406990;digamma[7150]=8.1815805885;digamma[7151]=8.1817204584;digamma[7152]=8.1818603087;digamma[7153]=8.1820001396;digamma[7154]=8.1821399508;digamma[7155]=8.1822797425;digamma[7156]=8.1824195147;digamma[7157]=8.1825592673;digamma[7158]=8.1826990004;digamma[7159]=8.1828387140;digamma[7160]=8.1829784081;digamma[7161]=8.1831180826;digamma[7162]=8.1832577377;digamma[7163]=8.1833973732;digamma[7164]=8.1835369893;digamma[7165]=8.1836765859;digamma[7166]=8.1838161629;digamma[7167]=8.1839557206;digamma[7168]=8.1840952587;digamma[7169]=8.1842347773;digamma[7170]=8.1843742765;digamma[7171]=8.1845137563;digamma[7172]=8.1846532166;digamma[7173]=8.1847926574;digamma[7174]=8.1849320788;digamma[7175]=8.1850714808;digamma[7176]=8.1852108633;digamma[7177]=8.1853502264;digamma[7178]=8.1854895701;digamma[7179]=8.1856288944;digamma[7180]=8.1857681993;digamma[7181]=8.1859074847;digamma[7182]=8.1860467508;digamma[7183]=8.1861859975;digamma[7184]=8.1863252247;digamma[7185]=8.1864644327;digamma[7186]=8.1866036212;digamma[7187]=8.1867427903;digamma[7188]=8.1868819401;digamma[7189]=8.1870210706;digamma[7190]=8.1871601816;digamma[7191]=8.1872992734;digamma[7192]=8.1874383458;digamma[7193]=8.1875773988;digamma[7194]=8.1877164325;digamma[7195]=8.1878554469;digamma[7196]=8.1879944420;digamma[7197]=8.1881334177;digamma[7198]=8.1882723742;digamma[7199]=8.1884113113;digamma[7200]=8.1885502291;digamma[7201]=8.1886891277;digamma[7202]=8.1888280069;digamma[7203]=8.1889668669;digamma[7204]=8.1891057075;digamma[7205]=8.1892445289;digamma[7206]=8.1893833311;digamma[7207]=8.1895221140;digamma[7208]=8.1896608776;digamma[7209]=8.1897996219;digamma[7210]=8.1899383471;digamma[7211]=8.1900770529;digamma[7212]=8.1902157396;digamma[7213]=8.1903544070;digamma[7214]=8.1904930551;digamma[7215]=8.1906316841;digamma[7216]=8.1907702938;digamma[7217]=8.1909088844;digamma[7218]=8.1910474557;digamma[7219]=8.1911860078;digamma[7220]=8.1913245408;digamma[7221]=8.1914630545;digamma[7222]=8.1916015491;digamma[7223]=8.1917400245;digamma[7224]=8.1918784807;digamma[7225]=8.1920169177;digamma[7226]=8.1921553356;digamma[7227]=8.1922937343;digamma[7228]=8.1924321139;digamma[7229]=8.1925704743;digamma[7230]=8.1927088156;digamma[7231]=8.1928471378;digamma[7232]=8.1929854408;digamma[7233]=8.1931237247;digamma[7234]=8.1932619895;digamma[7235]=8.1934002351;digamma[7236]=8.1935384617;digamma[7237]=8.1936766691;digamma[7238]=8.1938148575;digamma[7239]=8.1939530267;digamma[7240]=8.1940911769;digamma[7241]=8.1942293080;digamma[7242]=8.1943674200;digamma[7243]=8.1945055129;digamma[7244]=8.1946435868;digamma[7245]=8.1947816416;digamma[7246]=8.1949196774;digamma[7247]=8.1950576941;digamma[7248]=8.1951956917;digamma[7249]=8.1953336703;digamma[7250]=8.1954716299;digamma[7251]=8.1956095705;digamma[7252]=8.1957474920;digamma[7253]=8.1958853945;digamma[7254]=8.1960232780;digamma[7255]=8.1961611425;digamma[7256]=8.1962989879;digamma[7257]=8.1964368144;digamma[7258]=8.1965746219;digamma[7259]=8.1967124104;digamma[7260]=8.1968501799;digamma[7261]=8.1969879304;digamma[7262]=8.1971256620;digamma[7263]=8.1972633746;digamma[7264]=8.1974010682;digamma[7265]=8.1975387429;digamma[7266]=8.1976763986;digamma[7267]=8.1978140354;digamma[7268]=8.1979516532;digamma[7269]=8.1980892521;digamma[7270]=8.1982268321;digamma[7271]=8.1983643931;digamma[7272]=8.1985019352;digamma[7273]=8.1986394584;digamma[7274]=8.1987769627;digamma[7275]=8.1989144481;digamma[7276]=8.1990519146;digamma[7277]=8.1991893622;digamma[7278]=8.1993267909;digamma[7279]=8.1994642008;digamma[7280]=8.1996015917;digamma[7281]=8.1997389638;digamma[7282]=8.1998763170;digamma[7283]=8.2000136513;digamma[7284]=8.2001509668;digamma[7285]=8.2002882634;digamma[7286]=8.2004255412;digamma[7287]=8.2005628001;digamma[7288]=8.2007000402;digamma[7289]=8.2008372615;digamma[7290]=8.2009744640;digamma[7291]=8.2011116476;digamma[7292]=8.2012488124;digamma[7293]=8.2013859584;digamma[7294]=8.2015230856;digamma[7295]=8.2016601939;digamma[7296]=8.2017972835;digamma[7297]=8.2019343543;digamma[7298]=8.2020714063;digamma[7299]=8.2022084396;digamma[7300]=8.2023454540;digamma[7301]=8.2024824497;digamma[7302]=8.2026194266;digamma[7303]=8.2027563848;digamma[7304]=8.2028933242;digamma[7305]=8.2030302448;digamma[7306]=8.2031671467;digamma[7307]=8.2033040299;digamma[7308]=8.2034408944;digamma[7309]=8.2035777401;digamma[7310]=8.2037145670;digamma[7311]=8.2038513753;digamma[7312]=8.2039881649;digamma[7313]=8.2041249357;digamma[7314]=8.2042616878;digamma[7315]=8.2043984213;digamma[7316]=8.2045351360;digamma[7317]=8.2046718321;digamma[7318]=8.2048085094;digamma[7319]=8.2049451681;digamma[7320]=8.2050818082;digamma[7321]=8.2052184295;digamma[7322]=8.2053550322;digamma[7323]=8.2054916162;digamma[7324]=8.2056281816;digamma[7325]=8.2057647283;digamma[7326]=8.2059012564;digamma[7327]=8.2060377659;digamma[7328]=8.2061742567;digamma[7329]=8.2063107289;digamma[7330]=8.2064471825;digamma[7331]=8.2065836174;digamma[7332]=8.2067200338;digamma[7333]=8.2068564315;digamma[7334]=8.2069928106;digamma[7335]=8.2071291712;digamma[7336]=8.2072655131;digamma[7337]=8.2074018365;digamma[7338]=8.2075381413;digamma[7339]=8.2076744275;digamma[7340]=8.2078106951;digamma[7341]=8.2079469441;digamma[7342]=8.2080831746;digamma[7343]=8.2082193866;digamma[7344]=8.2083555800;digamma[7345]=8.2084917548;digamma[7346]=8.2086279111;digamma[7347]=8.2087640489;digamma[7348]=8.2089001681;digamma[7349]=8.2090362689;digamma[7350]=8.2091723511;digamma[7351]=8.2093084147;digamma[7352]=8.2094444599;digamma[7353]=8.2095804866;digamma[7354]=8.2097164947;digamma[7355]=8.2098524844;digamma[7356]=8.2099884556;digamma[7357]=8.2101244082;digamma[7358]=8.2102603425;digamma[7359]=8.2103962582;digamma[7360]=8.2105321554;digamma[7361]=8.2106680342;digamma[7362]=8.2108038946;digamma[7363]=8.2109397365;digamma[7364]=8.2110755599;digamma[7365]=8.2112113649;digamma[7366]=8.2113471514;digamma[7367]=8.2114829195;digamma[7368]=8.2116186692;digamma[7369]=8.2117544004;digamma[7370]=8.2118901133;digamma[7371]=8.2120258077;digamma[7372]=8.2121614837;digamma[7373]=8.2122971413;digamma[7374]=8.2124327805;digamma[7375]=8.2125684013;digamma[7376]=8.2127040037;digamma[7377]=8.2128395877;digamma[7378]=8.2129751534;digamma[7379]=8.2131107007;digamma[7380]=8.2132462296;digamma[7381]=8.2133817401;digamma[7382]=8.2135172323;digamma[7383]=8.2136527061;digamma[7384]=8.2137881616;digamma[7385]=8.2139235987;digamma[7386]=8.2140590175;digamma[7387]=8.2141944179;digamma[7388]=8.2143298000;digamma[7389]=8.2144651638;digamma[7390]=8.2146005093;digamma[7391]=8.2147358364;digamma[7392]=8.2148711453;digamma[7393]=8.2150064358;digamma[7394]=8.2151417080;digamma[7395]=8.2152769620;digamma[7396]=8.2154121976;digamma[7397]=8.2155474150;digamma[7398]=8.2156826141;digamma[7399]=8.2158177949;digamma[7400]=8.2159529574;digamma[7401]=8.2160881017;digamma[7402]=8.2162232277;digamma[7403]=8.2163583354;digamma[7404]=8.2164934249;digamma[7405]=8.2166284962;digamma[7406]=8.2167635492;digamma[7407]=8.2168985840;digamma[7408]=8.2170336005;digamma[7409]=8.2171685988;digamma[7410]=8.2173035789;digamma[7411]=8.2174385408;digamma[7412]=8.2175734844;digamma[7413]=8.2177084099;digamma[7414]=8.2178433171;digamma[7415]=8.2179782062;digamma[7416]=8.2181130770;digamma[7417]=8.2182479297;digamma[7418]=8.2183827642;digamma[7419]=8.2185175805;digamma[7420]=8.2186523787;digamma[7421]=8.2187871586;digamma[7422]=8.2189219204;digamma[7423]=8.2190566641;digamma[7424]=8.2191913896;digamma[7425]=8.2193260969;digamma[7426]=8.2194607861;digamma[7427]=8.2195954572;digamma[7428]=8.2197301101;digamma[7429]=8.2198647449;digamma[7430]=8.2199993616;digamma[7431]=8.2201339602;digamma[7432]=8.2202685406;digamma[7433]=8.2204031030;digamma[7434]=8.2205376472;digamma[7435]=8.2206721733;digamma[7436]=8.2208066813;digamma[7437]=8.2209411713;digamma[7438]=8.2210756432;digamma[7439]=8.2212100969;digamma[7440]=8.2213445326;digamma[7441]=8.2214789503;digamma[7442]=8.2216133498;digamma[7443]=8.2217477314;digamma[7444]=8.2218820948;digamma[7445]=8.2220164402;digamma[7446]=8.2221507676;digamma[7447]=8.2222850769;digamma[7448]=8.2224193682;digamma[7449]=8.2225536414;digamma[7450]=8.2226878966;digamma[7451]=8.2228221338;digamma[7452]=8.2229563530;digamma[7453]=8.2230905542;digamma[7454]=8.2232247373;digamma[7455]=8.2233589025;digamma[7456]=8.2234930496;digamma[7457]=8.2236271788;digamma[7458]=8.2237612900;digamma[7459]=8.2238953832;digamma[7460]=8.2240294584;digamma[7461]=8.2241635156;digamma[7462]=8.2242975549;digamma[7463]=8.2244315762;digamma[7464]=8.2245655796;digamma[7465]=8.2246995650;digamma[7466]=8.2248335324;digamma[7467]=8.2249674819;digamma[7468]=8.2251014135;digamma[7469]=8.2252353271;digamma[7470]=8.2253692228;digamma[7471]=8.2255031006;digamma[7472]=8.2256369604;digamma[7473]=8.2257708023;digamma[7474]=8.2259046264;digamma[7475]=8.2260384325;digamma[7476]=8.2261722207;digamma[7477]=8.2263059910;digamma[7478]=8.2264397434;digamma[7479]=8.2265734780;digamma[7480]=8.2267071946;digamma[7481]=8.2268408934;digamma[7482]=8.2269745743;digamma[7483]=8.2271082373;digamma[7484]=8.2272418825;digamma[7485]=8.2273755098;digamma[7486]=8.2275091193;digamma[7487]=8.2276427109;digamma[7488]=8.2277762846;digamma[7489]=8.2279098406;digamma[7490]=8.2280433787;digamma[7491]=8.2281768989;digamma[7492]=8.2283104014;digamma[7493]=8.2284438860;digamma[7494]=8.2285773528;digamma[7495]=8.2287108018;digamma[7496]=8.2288442329;digamma[7497]=8.2289776463;digamma[7498]=8.2291110419;digamma[7499]=8.2292444197;digamma[7500]=8.2293777797;digamma[7501]=8.2295111219;digamma[7502]=8.2296444464;digamma[7503]=8.2297777530;digamma[7504]=8.2299110419;digamma[7505]=8.2300443131;digamma[7506]=8.2301775665;digamma[7507]=8.2303108021;digamma[7508]=8.2304440200;digamma[7509]=8.2305772201;digamma[7510]=8.2307104025;digamma[7511]=8.2308435672;digamma[7512]=8.2309767141;digamma[7513]=8.2311098433;digamma[7514]=8.2312429548;digamma[7515]=8.2313760485;digamma[7516]=8.2315091246;digamma[7517]=8.2316421829;digamma[7518]=8.2317752236;digamma[7519]=8.2319082465;digamma[7520]=8.2320412518;digamma[7521]=8.2321742393;digamma[7522]=8.2323072092;digamma[7523]=8.2324401614;digamma[7524]=8.2325730959;digamma[7525]=8.2327060128;digamma[7526]=8.2328389120;digamma[7527]=8.2329717935;digamma[7528]=8.2331046574;digamma[7529]=8.2332375036;digamma[7530]=8.2333703322;digamma[7531]=8.2335031432;digamma[7532]=8.2336359365;digamma[7533]=8.2337687122;digamma[7534]=8.2339014702;digamma[7535]=8.2340342106;digamma[7536]=8.2341669334;digamma[7537]=8.2342996386;digamma[7538]=8.2344323262;digamma[7539]=8.2345649962;digamma[7540]=8.2346976486;digamma[7541]=8.2348302834;digamma[7542]=8.2349629006;digamma[7543]=8.2350955002;digamma[7544]=8.2352280822;digamma[7545]=8.2353606467;digamma[7546]=8.2354931936;digamma[7547]=8.2356257229;digamma[7548]=8.2357582347;digamma[7549]=8.2358907289;digamma[7550]=8.2360232055;digamma[7551]=8.2361556646;digamma[7552]=8.2362881062;digamma[7553]=8.2364205302;digamma[7554]=8.2365529367;digamma[7555]=8.2366853256;digamma[7556]=8.2368176971;digamma[7557]=8.2369500510;digamma[7558]=8.2370823874;digamma[7559]=8.2372147063;digamma[7560]=8.2373470076;digamma[7561]=8.2374792915;digamma[7562]=8.2376115579;digamma[7563]=8.2377438068;digamma[7564]=8.2378760382;digamma[7565]=8.2380082521;digamma[7566]=8.2381404486;digamma[7567]=8.2382726275;digamma[7568]=8.2384047890;digamma[7569]=8.2385369331;digamma[7570]=8.2386690597;digamma[7571]=8.2388011688;digamma[7572]=8.2389332605;digamma[7573]=8.2390653347;digamma[7574]=8.2391973915;digamma[7575]=8.2393294308;digamma[7576]=8.2394614527;digamma[7577]=8.2395934572;digamma[7578]=8.2397254443;digamma[7579]=8.2398574139;digamma[7580]=8.2399893662;digamma[7581]=8.2401213010;digamma[7582]=8.2402532184;digamma[7583]=8.2403851184;digamma[7584]=8.2405170010;digamma[7585]=8.2406488663;digamma[7586]=8.2407807141;digamma[7587]=8.2409125446;digamma[7588]=8.2410443577;digamma[7589]=8.2411761534;digamma[7590]=8.2413079317;digamma[7591]=8.2414396927;digamma[7592]=8.2415714363;digamma[7593]=8.2417031626;digamma[7594]=8.2418348715;digamma[7595]=8.2419665631;digamma[7596]=8.2420982374;digamma[7597]=8.2422298943;digamma[7598]=8.2423615338;digamma[7599]=8.2424931561;digamma[7600]=8.2426247610;digamma[7601]=8.2427563486;digamma[7602]=8.2428879189;digamma[7603]=8.2430194719;digamma[7604]=8.2431510076;digamma[7605]=8.2432825259;digamma[7606]=8.2434140270;digamma[7607]=8.2435455108;digamma[7608]=8.2436769773;digamma[7609]=8.2438084265;digamma[7610]=8.2439398585;digamma[7611]=8.2440712732;digamma[7612]=8.2442026706;digamma[7613]=8.2443340507;digamma[7614]=8.2444654136;digamma[7615]=8.2445967593;digamma[7616]=8.2447280876;digamma[7617]=8.2448593988;digamma[7618]=8.2449906927;digamma[7619]=8.2451219694;digamma[7620]=8.2452532288;digamma[7621]=8.2453844710;digamma[7622]=8.2455156960;digamma[7623]=8.2456469037;digamma[7624]=8.2457780943;digamma[7625]=8.2459092676;digamma[7626]=8.2460404238;digamma[7627]=8.2461715627;digamma[7628]=8.2463026845;digamma[7629]=8.2464337890;digamma[7630]=8.2465648764;digamma[7631]=8.2466959466;digamma[7632]=8.2468269996;digamma[7633]=8.2469580354;digamma[7634]=8.2470890541;digamma[7635]=8.2472200556;digamma[7636]=8.2473510400;digamma[7637]=8.2474820071;digamma[7638]=8.2476129572;digamma[7639]=8.2477438901;digamma[7640]=8.2478748058;digamma[7641]=8.2480057045;digamma[7642]=8.2481365859;digamma[7643]=8.2482674503;digamma[7644]=8.2483982975;digamma[7645]=8.2485291277;digamma[7646]=8.2486599407;digamma[7647]=8.2487907365;digamma[7648]=8.2489215153;digamma[7649]=8.2490522770;digamma[7650]=8.2491830216;digamma[7651]=8.2493137491;digamma[7652]=8.2494444595;digamma[7653]=8.2495751528;digamma[7654]=8.2497058291;digamma[7655]=8.2498364883;digamma[7656]=8.2499671304;digamma[7657]=8.2500977554;digamma[7658]=8.2502283634;digamma[7659]=8.2503589543;digamma[7660]=8.2504895282;digamma[7661]=8.2506200850;digamma[7662]=8.2507506248;digamma[7663]=8.2508811475;digamma[7664]=8.2510116532;digamma[7665]=8.2511421419;digamma[7666]=8.2512726136;digamma[7667]=8.2514030682;digamma[7668]=8.2515335058;digamma[7669]=8.2516639264;digamma[7670]=8.2517943300;digamma[7671]=8.2519247166;digamma[7672]=8.2520550862;digamma[7673]=8.2521854388;digamma[7674]=8.2523157744;digamma[7675]=8.2524460931;digamma[7676]=8.2525763947;digamma[7677]=8.2527066794;digamma[7678]=8.2528369471;digamma[7679]=8.2529671978;digamma[7680]=8.2530974316;digamma[7681]=8.2532276484;digamma[7682]=8.2533578483;digamma[7683]=8.2534880312;digamma[7684]=8.2536181971;digamma[7685]=8.2537483462;digamma[7686]=8.2538784782;digamma[7687]=8.2540085934;digamma[7688]=8.2541386916;digamma[7689]=8.2542687729;digamma[7690]=8.2543988373;digamma[7691]=8.2545288848;digamma[7692]=8.2546589153;digamma[7693]=8.2547889290;digamma[7694]=8.2549189257;digamma[7695]=8.2550489056;digamma[7696]=8.2551788685;digamma[7697]=8.2553088146;digamma[7698]=8.2554387438;digamma[7699]=8.2555686561;digamma[7700]=8.2556985515;digamma[7701]=8.2558284301;digamma[7702]=8.2559582918;digamma[7703]=8.2560881366;digamma[7704]=8.2562179646;digamma[7705]=8.2563477757;digamma[7706]=8.2564775700;digamma[7707]=8.2566073474;digamma[7708]=8.2567371080;digamma[7709]=8.2568668518;digamma[7710]=8.2569965787;digamma[7711]=8.2571262888;digamma[7712]=8.2572559821;digamma[7713]=8.2573856585;digamma[7714]=8.2575153182;digamma[7715]=8.2576449610;digamma[7716]=8.2577745870;digamma[7717]=8.2579041963;digamma[7718]=8.2580337887;digamma[7719]=8.2581633643;digamma[7720]=8.2582929232;digamma[7721]=8.2584224653;digamma[7722]=8.2585519905;digamma[7723]=8.2586814991;digamma[7724]=8.2588109908;digamma[7725]=8.2589404658;digamma[7726]=8.2590699240;digamma[7727]=8.2591993655;digamma[7728]=8.2593287902;digamma[7729]=8.2594581981;digamma[7730]=8.2595875893;digamma[7731]=8.2597169638;digamma[7732]=8.2598463215;digamma[7733]=8.2599756626;digamma[7734]=8.2601049868;digamma[7735]=8.2602342944;digamma[7736]=8.2603635852;digamma[7737]=8.2604928594;digamma[7738]=8.2606221168;digamma[7739]=8.2607513575;digamma[7740]=8.2608805815;digamma[7741]=8.2610097888;digamma[7742]=8.2611389794;digamma[7743]=8.2612681534;digamma[7744]=8.2613973106;digamma[7745]=8.2615264512;digamma[7746]=8.2616555751;digamma[7747]=8.2617846823;digamma[7748]=8.2619137728;digamma[7749]=8.2620428467;digamma[7750]=8.2621719040;digamma[7751]=8.2623009446;digamma[7752]=8.2624299685;digamma[7753]=8.2625589758;digamma[7754]=8.2626879664;digamma[7755]=8.2628169404;digamma[7756]=8.2629458978;digamma[7757]=8.2630748386;digamma[7758]=8.2632037627;digamma[7759]=8.2633326702;digamma[7760]=8.2634615611;digamma[7761]=8.2635904354;digamma[7762]=8.2637192931;digamma[7763]=8.2638481341;digamma[7764]=8.2639769586;digamma[7765]=8.2641057665;digamma[7766]=8.2642345578;digamma[7767]=8.2643633325;digamma[7768]=8.2644920906;digamma[7769]=8.2646208322;digamma[7770]=8.2647495572;digamma[7771]=8.2648782656;digamma[7772]=8.2650069574;digamma[7773]=8.2651356327;digamma[7774]=8.2652642914;digamma[7775]=8.2653929336;digamma[7776]=8.2655215592;digamma[7777]=8.2656501683;digamma[7778]=8.2657787609;digamma[7779]=8.2659073369;digamma[7780]=8.2660358964;digamma[7781]=8.2661644394;digamma[7782]=8.2662929658;digamma[7783]=8.2664214757;digamma[7784]=8.2665499692;digamma[7785]=8.2666784461;digamma[7786]=8.2668069065;digamma[7787]=8.2669353504;digamma[7788]=8.2670637778;digamma[7789]=8.2671921887;digamma[7790]=8.2673205831;digamma[7791]=8.2674489611;digamma[7792]=8.2675773225;digamma[7793]=8.2677056675;digamma[7794]=8.2678339960;digamma[7795]=8.2679623081;digamma[7796]=8.2680906037;digamma[7797]=8.2682188828;digamma[7798]=8.2683471455;digamma[7799]=8.2684753917;digamma[7800]=8.2686036215;digamma[7801]=8.2687318349;digamma[7802]=8.2688600318;digamma[7803]=8.2689882122;digamma[7804]=8.2691163763;digamma[7805]=8.2692445239;digamma[7806]=8.2693726551;digamma[7807]=8.2695007699;digamma[7808]=8.2696288683;digamma[7809]=8.2697569503;digamma[7810]=8.2698850158;digamma[7811]=8.2700130650;digamma[7812]=8.2701410978;digamma[7813]=8.2702691142;digamma[7814]=8.2703971142;digamma[7815]=8.2705250978;digamma[7816]=8.2706530650;digamma[7817]=8.2707810159;digamma[7818]=8.2709089504;digamma[7819]=8.2710368685;digamma[7820]=8.2711647703;digamma[7821]=8.2712926557;digamma[7822]=8.2714205248;digamma[7823]=8.2715483775;digamma[7824]=8.2716762138;digamma[7825]=8.2718040339;digamma[7826]=8.2719318376;digamma[7827]=8.2720596249;digamma[7828]=8.2721873960;digamma[7829]=8.2723151507;digamma[7830]=8.2724428891;digamma[7831]=8.2725706111;digamma[7832]=8.2726983169;digamma[7833]=8.2728260064;digamma[7834]=8.2729536795;digamma[7835]=8.2730813364;digamma[7836]=8.2732089769;digamma[7837]=8.2733366012;digamma[7838]=8.2734642092;digamma[7839]=8.2735918009;digamma[7840]=8.2737193763;digamma[7841]=8.2738469355;digamma[7842]=8.2739744784;digamma[7843]=8.2741020050;digamma[7844]=8.2742295154;digamma[7845]=8.2743570095;digamma[7846]=8.2744844873;digamma[7847]=8.2746119489;digamma[7848]=8.2747393943;digamma[7849]=8.2748668234;digamma[7850]=8.2749942363;digamma[7851]=8.2751216329;digamma[7852]=8.2752490133;digamma[7853]=8.2753763775;digamma[7854]=8.2755037255;digamma[7855]=8.2756310573;digamma[7856]=8.2757583728;digamma[7857]=8.2758856722;digamma[7858]=8.2760129553;digamma[7859]=8.2761402223;digamma[7860]=8.2762674730;digamma[7861]=8.2763947076;digamma[7862]=8.2765219259;digamma[7863]=8.2766491281;digamma[7864]=8.2767763141;digamma[7865]=8.2769034840;digamma[7866]=8.2770306376;digamma[7867]=8.2771577751;digamma[7868]=8.2772848965;digamma[7869]=8.2774120016;digamma[7870]=8.2775390907;digamma[7871]=8.2776661635;digamma[7872]=8.2777932203;digamma[7873]=8.2779202609;digamma[7874]=8.2780472853;digamma[7875]=8.2781742936;digamma[7876]=8.2783012858;digamma[7877]=8.2784282619;digamma[7878]=8.2785552218;digamma[7879]=8.2786821657;digamma[7880]=8.2788090934;digamma[7881]=8.2789360050;digamma[7882]=8.2790629005;digamma[7883]=8.2791897799;digamma[7884]=8.2793166432;digamma[7885]=8.2794434904;digamma[7886]=8.2795703215;digamma[7887]=8.2796971366;digamma[7888]=8.2798239355;digamma[7889]=8.2799507184;digamma[7890]=8.2800774852;digamma[7891]=8.2802042360;digamma[7892]=8.2803309706;digamma[7893]=8.2804576893;digamma[7894]=8.2805843918;digamma[7895]=8.2807110783;digamma[7896]=8.2808377488;digamma[7897]=8.2809644032;digamma[7898]=8.2810910416;digamma[7899]=8.2812176640;digamma[7900]=8.2813442703;digamma[7901]=8.2814708606;digamma[7902]=8.2815974348;digamma[7903]=8.2817239931;digamma[7904]=8.2818505353;digamma[7905]=8.2819770615;digamma[7906]=8.2821035718;digamma[7907]=8.2822300660;digamma[7908]=8.2823565442;digamma[7909]=8.2824830064;digamma[7910]=8.2826094526;digamma[7911]=8.2827358829;digamma[7912]=8.2828622971;digamma[7913]=8.2829886954;digamma[7914]=8.2831150777;digamma[7915]=8.2832414440;digamma[7916]=8.2833677944;digamma[7917]=8.2834941288;digamma[7918]=8.2836204473;digamma[7919]=8.2837467498;digamma[7920]=8.2838730363;digamma[7921]=8.2839993069;digamma[7922]=8.2841255616;digamma[7923]=8.2842518003;digamma[7924]=8.2843780231;digamma[7925]=8.2845042299;digamma[7926]=8.2846304208;digamma[7927]=8.2847565958;digamma[7928]=8.2848827549;digamma[7929]=8.2850088981;digamma[7930]=8.2851350254;digamma[7931]=8.2852611367;digamma[7932]=8.2853872322;digamma[7933]=8.2855133117;digamma[7934]=8.2856393754;digamma[7935]=8.2857654232;digamma[7936]=8.2858914550;digamma[7937]=8.2860174711;digamma[7938]=8.2861434712;digamma[7939]=8.2862694554;digamma[7940]=8.2863954238;digamma[7941]=8.2865213763;digamma[7942]=8.2866473130;digamma[7943]=8.2867732338;digamma[7944]=8.2868991387;digamma[7945]=8.2870250278;digamma[7946]=8.2871509011;digamma[7947]=8.2872767585;digamma[7948]=8.2874026000;digamma[7949]=8.2875284258;digamma[7950]=8.2876542357;digamma[7951]=8.2877800297;digamma[7952]=8.2879058080;digamma[7953]=8.2880315704;digamma[7954]=8.2881573170;digamma[7955]=8.2882830478;digamma[7956]=8.2884087628;digamma[7957]=8.2885344620;digamma[7958]=8.2886601454;digamma[7959]=8.2887858131;digamma[7960]=8.2889114649;digamma[7961]=8.2890371009;digamma[7962]=8.2891627212;digamma[7963]=8.2892883256;digamma[7964]=8.2894139143;digamma[7965]=8.2895394873;digamma[7966]=8.2896650444;digamma[7967]=8.2897905858;digamma[7968]=8.2899161114;digamma[7969]=8.2900416213;digamma[7970]=8.2901671155;digamma[7971]=8.2902925938;digamma[7972]=8.2904180565;digamma[7973]=8.2905435034;digamma[7974]=8.2906689346;digamma[7975]=8.2907943500;digamma[7976]=8.2909197497;digamma[7977]=8.2910451337;digamma[7978]=8.2911705020;digamma[7979]=8.2912958545;digamma[7980]=8.2914211914;digamma[7981]=8.2915465125;digamma[7982]=8.2916718179;digamma[7983]=8.2917971077;digamma[7984]=8.2919223817;digamma[7985]=8.2920476400;digamma[7986]=8.2921728827;digamma[7987]=8.2922981097;digamma[7988]=8.2924233210;digamma[7989]=8.2925485166;digamma[7990]=8.2926736965;digamma[7991]=8.2927988608;digamma[7992]=8.2929240094;digamma[7993]=8.2930491424;digamma[7994]=8.2931742597;digamma[7995]=8.2932993613;digamma[7996]=8.2934244473;digamma[7997]=8.2935495177;digamma[7998]=8.2936745724;digamma[7999]=8.2937996115;digamma[8000]=8.2939246349;digamma[8001]=8.2940496427;digamma[8002]=8.2941746349;digamma[8003]=8.2942996115;digamma[8004]=8.2944245724;digamma[8005]=8.2945495177;digamma[8006]=8.2946744475;digamma[8007]=8.2947993616;digamma[8008]=8.2949242601;digamma[8009]=8.2950491430;digamma[8010]=8.2951740104;digamma[8011]=8.2952988621;digamma[8012]=8.2954236983;digamma[8013]=8.2955485188;digamma[8014]=8.2956733238;digamma[8015]=8.2957981132;digamma[8016]=8.2959228871;digamma[8017]=8.2960476454;digamma[8018]=8.2961723881;digamma[8019]=8.2962971152;digamma[8020]=8.2964218268;digamma[8021]=8.2965465229;digamma[8022]=8.2966712034;digamma[8023]=8.2967958684;digamma[8024]=8.2969205178;digamma[8025]=8.2970451517;digamma[8026]=8.2971697700;digamma[8027]=8.2972943729;digamma[8028]=8.2974189602;digamma[8029]=8.2975435319;digamma[8030]=8.2976680882;digamma[8031]=8.2977926290;digamma[8032]=8.2979171542;digamma[8033]=8.2980416640;digamma[8034]=8.2981661582;digamma[8035]=8.2982906369;digamma[8036]=8.2984151002;digamma[8037]=8.2985395480;digamma[8038]=8.2986639802;digamma[8039]=8.2987883970;digamma[8040]=8.2989127983;digamma[8041]=8.2990371842;digamma[8042]=8.2991615546;digamma[8043]=8.2992859095;digamma[8044]=8.2994102489;digamma[8045]=8.2995345729;digamma[8046]=8.2996588814;digamma[8047]=8.2997831745;digamma[8048]=8.2999074522;digamma[8049]=8.3000317144;digamma[8050]=8.3001559611;digamma[8051]=8.3002801924;digamma[8052]=8.3004044083;digamma[8053]=8.3005286088;digamma[8054]=8.3006527938;digamma[8055]=8.3007769634;digamma[8056]=8.3009011176;digamma[8057]=8.3010252564;digamma[8058]=8.3011493798;digamma[8059]=8.3012734878;digamma[8060]=8.3013975803;digamma[8061]=8.3015216575;digamma[8062]=8.3016457193;digamma[8063]=8.3017697657;digamma[8064]=8.3018937967;digamma[8065]=8.3020178123;digamma[8066]=8.3021418126;digamma[8067]=8.3022657974;digamma[8068]=8.3023897669;digamma[8069]=8.3025137211;digamma[8070]=8.3026376598;digamma[8071]=8.3027615833;digamma[8072]=8.3028854913;digamma[8073]=8.3030093840;digamma[8074]=8.3031332614;digamma[8075]=8.3032571234;digamma[8076]=8.3033809701;digamma[8077]=8.3035048014;digamma[8078]=8.3036286174;digamma[8079]=8.3037524181;digamma[8080]=8.3038762035;digamma[8081]=8.3039999735;digamma[8082]=8.3041237282;digamma[8083]=8.3042474676;digamma[8084]=8.3043711917;digamma[8085]=8.3044949005;digamma[8086]=8.3046185940;digamma[8087]=8.3047422722;digamma[8088]=8.3048659351;digamma[8089]=8.3049895827;digamma[8090]=8.3051132150;digamma[8091]=8.3052368320;digamma[8092]=8.3053604338;digamma[8093]=8.3054840203;digamma[8094]=8.3056075915;digamma[8095]=8.3057311474;digamma[8096]=8.3058546881;digamma[8097]=8.3059782135;digamma[8098]=8.3061017237;digamma[8099]=8.3062252186;digamma[8100]=8.3063486982;digamma[8101]=8.3064721626;digamma[8102]=8.3065956118;digamma[8103]=8.3067190457;digamma[8104]=8.3068424644;digamma[8105]=8.3069658679;digamma[8106]=8.3070892561;digamma[8107]=8.3072126292;digamma[8108]=8.3073359870;digamma[8109]=8.3074593295;digamma[8110]=8.3075826569;digamma[8111]=8.3077059691;digamma[8112]=8.3078292660;digamma[8113]=8.3079525478;digamma[8114]=8.3080758144;digamma[8115]=8.3081990657;digamma[8116]=8.3083223019;digamma[8117]=8.3084455229;digamma[8118]=8.3085687287;digamma[8119]=8.3086919194;digamma[8120]=8.3088150948;digamma[8121]=8.3089382551;digamma[8122]=8.3090614002;digamma[8123]=8.3091845302;digamma[8124]=8.3093076450;digamma[8125]=8.3094307447;digamma[8126]=8.3095538292;digamma[8127]=8.3096768985;digamma[8128]=8.3097999527;digamma[8129]=8.3099229918;digamma[8130]=8.3100460157;digamma[8131]=8.3101690245;digamma[8132]=8.3102920182;digamma[8133]=8.3104149967;digamma[8134]=8.3105379601;digamma[8135]=8.3106609084;digamma[8136]=8.3107838416;digamma[8137]=8.3109067597;digamma[8138]=8.3110296627;digamma[8139]=8.3111525505;digamma[8140]=8.3112754233;digamma[8141]=8.3113982810;digamma[8142]=8.3115211235;digamma[8143]=8.3116439510;digamma[8144]=8.3117667634;digamma[8145]=8.3118895607;digamma[8146]=8.3120123430;digamma[8147]=8.3121351102;digamma[8148]=8.3122578623;digamma[8149]=8.3123805993;digamma[8150]=8.3125033213;digamma[8151]=8.3126260282;digamma[8152]=8.3127487200;digamma[8153]=8.3128713969;digamma[8154]=8.3129940586;digamma[8155]=8.3131167053;digamma[8156]=8.3132393370;digamma[8157]=8.3133619536;digamma[8158]=8.3134845552;digamma[8159]=8.3136071418;digamma[8160]=8.3137297134;digamma[8161]=8.3138522699;digamma[8162]=8.3139748114;digamma[8163]=8.3140973379;digamma[8164]=8.3142198494;digamma[8165]=8.3143423459;digamma[8166]=8.3144648273;digamma[8167]=8.3145872938;digamma[8168]=8.3147097453;digamma[8169]=8.3148321818;digamma[8170]=8.3149546033;digamma[8171]=8.3150770098;digamma[8172]=8.3151994013;digamma[8173]=8.3153217779;digamma[8174]=8.3154441395;digamma[8175]=8.3155664861;digamma[8176]=8.3156888177;digamma[8177]=8.3158111344;digamma[8178]=8.3159334361;digamma[8179]=8.3160557229;digamma[8180]=8.3161779947;digamma[8181]=8.3163002515;digamma[8182]=8.3164224934;digamma[8183]=8.3165447204;digamma[8184]=8.3166669325;digamma[8185]=8.3167891296;digamma[8186]=8.3169113117;digamma[8187]=8.3170334790;digamma[8188]=8.3171556313;digamma[8189]=8.3172777687;digamma[8190]=8.3173998912;digamma[8191]=8.3175219988;digamma[8192]=8.3176440914;digamma[8193]=8.3177661692;digamma[8194]=8.3178882321;digamma[8195]=8.3180102800;digamma[8196]=8.3181323131;digamma[8197]=8.3182543313;digamma[8198]=8.3183763346;digamma[8199]=8.3184983230;digamma[8200]=8.3186202965;digamma[8201]=8.3187422552;digamma[8202]=8.3188641990;digamma[8203]=8.3189861279;digamma[8204]=8.3191080419;digamma[8205]=8.3192299411;digamma[8206]=8.3193518254;digamma[8207]=8.3194736949;digamma[8208]=8.3195955495;digamma[8209]=8.3197173893;digamma[8210]=8.3198392143;digamma[8211]=8.3199610244;digamma[8212]=8.3200828196;digamma[8213]=8.3202046001;digamma[8214]=8.3203263657;digamma[8215]=8.3204481164;digamma[8216]=8.3205698524;digamma[8217]=8.3206915735;digamma[8218]=8.3208132798;digamma[8219]=8.3209349714;digamma[8220]=8.3210566481;digamma[8221]=8.3211783100;digamma[8222]=8.3212999571;digamma[8223]=8.3214215894;digamma[8224]=8.3215432069;digamma[8225]=8.3216648096;digamma[8226]=8.3217863975;digamma[8227]=8.3219079707;digamma[8228]=8.3220295291;digamma[8229]=8.3221510727;digamma[8230]=8.3222726015;digamma[8231]=8.3223941156;digamma[8232]=8.3225156149;digamma[8233]=8.3226370994;digamma[8234]=8.3227585692;digamma[8235]=8.3228800242;digamma[8236]=8.3230014645;digamma[8237]=8.3231228900;digamma[8238]=8.3232443008;digamma[8239]=8.3233656969;digamma[8240]=8.3234870782;digamma[8241]=8.3236084448;digamma[8242]=8.3237297967;digamma[8243]=8.3238511338;digamma[8244]=8.3239724562;digamma[8245]=8.3240937639;digamma[8246]=8.3242150569;digamma[8247]=8.3243363352;digamma[8248]=8.3244575987;digamma[8249]=8.3245788476;digamma[8250]=8.3247000818;digamma[8251]=8.3248213012;digamma[8252]=8.3249425060;digamma[8253]=8.3250636961;digamma[8254]=8.3251848715;digamma[8255]=8.3253060322;digamma[8256]=8.3254271782;digamma[8257]=8.3255483096;digamma[8258]=8.3256694263;digamma[8259]=8.3257905283;digamma[8260]=8.3259116157;digamma[8261]=8.3260326884;digamma[8262]=8.3261537464;digamma[8263]=8.3262747898;digamma[8264]=8.3263958186;digamma[8265]=8.3265168327;digamma[8266]=8.3266378321;digamma[8267]=8.3267588170;digamma[8268]=8.3268797871;digamma[8269]=8.3270007427;digamma[8270]=8.3271216836;digamma[8271]=8.3272426099;digamma[8272]=8.3273635216;digamma[8273]=8.3274844186;digamma[8274]=8.3276053011;digamma[8275]=8.3277261689;digamma[8276]=8.3278470221;digamma[8277]=8.3279678607;digamma[8278]=8.3280886848;digamma[8279]=8.3282094942;digamma[8280]=8.3283302890;digamma[8281]=8.3284510693;digamma[8282]=8.3285718349;digamma[8283]=8.3286925860;digamma[8284]=8.3288133225;digamma[8285]=8.3289340444;digamma[8286]=8.3290547517;digamma[8287]=8.3291754445;digamma[8288]=8.3292961227;digamma[8289]=8.3294167864;digamma[8290]=8.3295374355;digamma[8291]=8.3296580700;digamma[8292]=8.3297786900;digamma[8293]=8.3298992954;digamma[8294]=8.3300198863;digamma[8295]=8.3301404627;digamma[8296]=8.3302610245;digamma[8297]=8.3303815718;digamma[8298]=8.3305021045;digamma[8299]=8.3306226228;digamma[8300]=8.3307431265;digamma[8301]=8.3308636156;digamma[8302]=8.3309840903;digamma[8303]=8.3311045505;digamma[8304]=8.3312249961;digamma[8305]=8.3313454273;digamma[8306]=8.3314658439;digamma[8307]=8.3315862460;digamma[8308]=8.3317066337;digamma[8309]=8.3318270069;digamma[8310]=8.3319473655;digamma[8311]=8.3320677097;digamma[8312]=8.3321880394;digamma[8313]=8.3323083546;digamma[8314]=8.3324286554;digamma[8315]=8.3325489417;digamma[8316]=8.3326692135;digamma[8317]=8.3327894708;digamma[8318]=8.3329097137;digamma[8319]=8.3330299422;digamma[8320]=8.3331501561;digamma[8321]=8.3332703557;digamma[8322]=8.3333905407;digamma[8323]=8.3335107114;digamma[8324]=8.3336308676;digamma[8325]=8.3337510094;digamma[8326]=8.3338711367;digamma[8327]=8.3339912496;digamma[8328]=8.3341113481;digamma[8329]=8.3342314321;digamma[8330]=8.3343515018;digamma[8331]=8.3344715570;digamma[8332]=8.3345915978;digamma[8333]=8.3347116242;digamma[8334]=8.3348316362;digamma[8335]=8.3349516338;digamma[8336]=8.3350716170;digamma[8337]=8.3351915858;digamma[8338]=8.3353115402;digamma[8339]=8.3354314803;digamma[8340]=8.3355514059;digamma[8341]=8.3356713172;digamma[8342]=8.3357912141;digamma[8343]=8.3359110966;digamma[8344]=8.3360309647;digamma[8345]=8.3361508185;digamma[8346]=8.3362706579;digamma[8347]=8.3363904830;digamma[8348]=8.3365102937;digamma[8349]=8.3366300900;digamma[8350]=8.3367498720;digamma[8351]=8.3368696397;digamma[8352]=8.3369893930;digamma[8353]=8.3371091320;digamma[8354]=8.3372288566;digamma[8355]=8.3373485669;digamma[8356]=8.3374682629;digamma[8357]=8.3375879445;digamma[8358]=8.3377076118;digamma[8359]=8.3378272648;digamma[8360]=8.3379469035;digamma[8361]=8.3380665279;digamma[8362]=8.3381861380;digamma[8363]=8.3383057337;digamma[8364]=8.3384253152;digamma[8365]=8.3385448824;digamma[8366]=8.3386644352;digamma[8367]=8.3387839738;digamma[8368]=8.3389034981;digamma[8369]=8.3390230081;digamma[8370]=8.3391425039;digamma[8371]=8.3392619853;digamma[8372]=8.3393814525;digamma[8373]=8.3395009054;digamma[8374]=8.3396203440;digamma[8375]=8.3397397684;digamma[8376]=8.3398591785;digamma[8377]=8.3399785744;digamma[8378]=8.3400979560;digamma[8379]=8.3402173233;digamma[8380]=8.3403366764;digamma[8381]=8.3404560153;digamma[8382]=8.3405753399;digamma[8383]=8.3406946503;digamma[8384]=8.3408139464;digamma[8385]=8.3409332284;digamma[8386]=8.3410524961;digamma[8387]=8.3411717495;digamma[8388]=8.3412909888;digamma[8389]=8.3414102138;digamma[8390]=8.3415294247;digamma[8391]=8.3416486213;digamma[8392]=8.3417678037;digamma[8393]=8.3418869719;digamma[8394]=8.3420061259;digamma[8395]=8.3421252657;digamma[8396]=8.3422443913;digamma[8397]=8.3423635027;digamma[8398]=8.3424826000;digamma[8399]=8.3426016830;digamma[8400]=8.3427207519;digamma[8401]=8.3428398066;digamma[8402]=8.3429588472;digamma[8403]=8.3430778735;digamma[8404]=8.3431968857;digamma[8405]=8.3433158838;digamma[8406]=8.3434348676;digamma[8407]=8.3435538374;digamma[8408]=8.3436727929;digamma[8409]=8.3437917344;digamma[8410]=8.3439106616;digamma[8411]=8.3440295748;digamma[8412]=8.3441484738;digamma[8413]=8.3442673586;digamma[8414]=8.3443862293;digamma[8415]=8.3445050859;digamma[8416]=8.3446239284;digamma[8417]=8.3447427568;digamma[8418]=8.3448615710;digamma[8419]=8.3449803711;digamma[8420]=8.3450991571;digamma[8421]=8.3452179290;digamma[8422]=8.3453366868;digamma[8423]=8.3454554305;digamma[8424]=8.3455741601;digamma[8425]=8.3456928756;digamma[8426]=8.3458115770;digamma[8427]=8.3459302643;digamma[8428]=8.3460489376;digamma[8429]=8.3461675967;digamma[8430]=8.3462862418;digamma[8431]=8.3464048728;digamma[8432]=8.3465234897;digamma[8433]=8.3466420926;digamma[8434]=8.3467606814;digamma[8435]=8.3468792561;digamma[8436]=8.3469978168;digamma[8437]=8.3471163634;digamma[8438]=8.3472348959;digamma[8439]=8.3473534145;digamma[8440]=8.3474719189;digamma[8441]=8.3475904094;digamma[8442]=8.3477088858;digamma[8443]=8.3478273481;digamma[8444]=8.3479457964;digamma[8445]=8.3480642307;digamma[8446]=8.3481826510;digamma[8447]=8.3483010573;digamma[8448]=8.3484194495;digamma[8449]=8.3485378277;digamma[8450]=8.3486561919;digamma[8451]=8.3487745421;digamma[8452]=8.3488928783;digamma[8453]=8.3490112005;digamma[8454]=8.3491295087;digamma[8455]=8.3492478029;digamma[8456]=8.3493660831;digamma[8457]=8.3494843493;digamma[8458]=8.3496026016;digamma[8459]=8.3497208398;digamma[8460]=8.3498390641;digamma[8461]=8.3499572744;digamma[8462]=8.3500754707;digamma[8463]=8.3501936530;digamma[8464]=8.3503118214;digamma[8465]=8.3504299759;digamma[8466]=8.3505481163;digamma[8467]=8.3506662428;digamma[8468]=8.3507843554;digamma[8469]=8.3509024540;digamma[8470]=8.3510205387;digamma[8471]=8.3511386094;digamma[8472]=8.3512566662;digamma[8473]=8.3513747090;digamma[8474]=8.3514927380;digamma[8475]=8.3516107529;digamma[8476]=8.3517287540;digamma[8477]=8.3518467411;digamma[8478]=8.3519647144;digamma[8479]=8.3520826737;digamma[8480]=8.3522006191;digamma[8481]=8.3523185505;digamma[8482]=8.3524364681;digamma[8483]=8.3525543718;digamma[8484]=8.3526722616;digamma[8485]=8.3527901374;digamma[8486]=8.3529079994;digamma[8487]=8.3530258475;digamma[8488]=8.3531436817;digamma[8489]=8.3532615020;digamma[8490]=8.3533793085;digamma[8491]=8.3534971011;digamma[8492]=8.3536148798;digamma[8493]=8.3537326446;digamma[8494]=8.3538503955;digamma[8495]=8.3539681326;digamma[8496]=8.3540858559;digamma[8497]=8.3542035652;digamma[8498]=8.3543212608;digamma[8499]=8.3544389424;digamma[8500]=8.3545566102;digamma[8501]=8.3546742642;digamma[8502]=8.3547919044;digamma[8503]=8.3549095307;digamma[8504]=8.3550271431;digamma[8505]=8.3551447418;digamma[8506]=8.3552623266;digamma[8507]=8.3553798976;digamma[8508]=8.3554974547;digamma[8509]=8.3556149981;digamma[8510]=8.3557325276;digamma[8511]=8.3558500433;digamma[8512]=8.3559675452;digamma[8513]=8.3560850333;digamma[8514]=8.3562025076;digamma[8515]=8.3563199681;digamma[8516]=8.3564374148;digamma[8517]=8.3565548478;digamma[8518]=8.3566722669;digamma[8519]=8.3567896722;digamma[8520]=8.3569070638;digamma[8521]=8.3570244416;digamma[8522]=8.3571418056;digamma[8523]=8.3572591558;digamma[8524]=8.3573764923;digamma[8525]=8.3574938150;digamma[8526]=8.3576111239;digamma[8527]=8.3577284191;digamma[8528]=8.3578457005;digamma[8529]=8.3579629681;digamma[8530]=8.3580802221;digamma[8531]=8.3581974622;digamma[8532]=8.3583146886;digamma[8533]=8.3584319013;digamma[8534]=8.3585491003;digamma[8535]=8.3586662855;digamma[8536]=8.3587834570;digamma[8537]=8.3589006147;digamma[8538]=8.3590177587;digamma[8539]=8.3591348890;digamma[8540]=8.3592520056;digamma[8541]=8.3593691085;digamma[8542]=8.3594861977;digamma[8543]=8.3596032731;digamma[8544]=8.3597203349;digamma[8545]=8.3598373829;digamma[8546]=8.3599544173;digamma[8547]=8.3600714379;digamma[8548]=8.3601884449;digamma[8549]=8.3603054382;digamma[8550]=8.3604224177;digamma[8551]=8.3605393837;digamma[8552]=8.3606563359;digamma[8553]=8.3607732744;digamma[8554]=8.3608901993;digamma[8555]=8.3610071105;digamma[8556]=8.3611240080;digamma[8557]=8.3612408919;digamma[8558]=8.3613577621;digamma[8559]=8.3614746187;digamma[8560]=8.3615914616;digamma[8561]=8.3617082909;digamma[8562]=8.3618251065;digamma[8563]=8.3619419084;digamma[8564]=8.3620586967;digamma[8565]=8.3621754714;digamma[8566]=8.3622922325;digamma[8567]=8.3624089799;digamma[8568]=8.3625257137;digamma[8569]=8.3626424338;digamma[8570]=8.3627591404;digamma[8571]=8.3628758333;digamma[8572]=8.3629925126;digamma[8573]=8.3631091783;digamma[8574]=8.3632258304;digamma[8575]=8.3633424689;digamma[8576]=8.3634590937;digamma[8577]=8.3635757050;digamma[8578]=8.3636923027;digamma[8579]=8.3638088868;digamma[8580]=8.3639254573;digamma[8581]=8.3640420142;digamma[8582]=8.3641585575;digamma[8583]=8.3642750873;digamma[8584]=8.3643916034;digamma[8585]=8.3645081060;digamma[8586]=8.3646245950;digamma[8587]=8.3647410705;digamma[8588]=8.3648575324;digamma[8589]=8.3649739807;digamma[8590]=8.3650904155;digamma[8591]=8.3652068367;digamma[8592]=8.3653232443;digamma[8593]=8.3654396384;digamma[8594]=8.3655560190;digamma[8595]=8.3656723860;digamma[8596]=8.3657887395;digamma[8597]=8.3659050795;digamma[8598]=8.3660214059;digamma[8599]=8.3661377188;digamma[8600]=8.3662540181;digamma[8601]=8.3663703039;digamma[8602]=8.3664865762;digamma[8603]=8.3666028350;digamma[8604]=8.3667190803;digamma[8605]=8.3668353121;digamma[8606]=8.3669515303;digamma[8607]=8.3670677351;digamma[8608]=8.3671839263;digamma[8609]=8.3673001041;digamma[8610]=8.3674162683;digamma[8611]=8.3675324191;digamma[8612]=8.3676485564;digamma[8613]=8.3677646802;digamma[8614]=8.3678807905;digamma[8615]=8.3679968873;digamma[8616]=8.3681129706;digamma[8617]=8.3682290405;digamma[8618]=8.3683450969;digamma[8619]=8.3684611399;digamma[8620]=8.3685771693;digamma[8621]=8.3686931853;digamma[8622]=8.3688091879;digamma[8623]=8.3689251770;digamma[8624]=8.3690411526;digamma[8625]=8.3691571148;digamma[8626]=8.3692730636;digamma[8627]=8.3693889989;digamma[8628]=8.3695049208;digamma[8629]=8.3696208292;digamma[8630]=8.3697367242;digamma[8631]=8.3698526058;digamma[8632]=8.3699684739;digamma[8633]=8.3700843286;digamma[8634]=8.3702001699;digamma[8635]=8.3703159978;digamma[8636]=8.3704318123;digamma[8637]=8.3705476133;digamma[8638]=8.3706634010;digamma[8639]=8.3707791752;digamma[8640]=8.3708949360;digamma[8641]=8.3710106835;digamma[8642]=8.3711264175;digamma[8643]=8.3712421382;digamma[8644]=8.3713578454;digamma[8645]=8.3714735393;digamma[8646]=8.3715892198;digamma[8647]=8.3717048869;digamma[8648]=8.3718205406;digamma[8649]=8.3719361810;digamma[8650]=8.3720518080;digamma[8651]=8.3721674216;digamma[8652]=8.3722830218;digamma[8653]=8.3723986087;digamma[8654]=8.3725141823;digamma[8655]=8.3726297425;digamma[8656]=8.3727452893;digamma[8657]=8.3728608228;digamma[8658]=8.3729763429;digamma[8659]=8.3730918497;digamma[8660]=8.3732073431;digamma[8661]=8.3733228232;digamma[8662]=8.3734382900;digamma[8663]=8.3735537434;digamma[8664]=8.3736691836;digamma[8665]=8.3737846103;digamma[8666]=8.3739000238;digamma[8667]=8.3740154240;digamma[8668]=8.3741308108;digamma[8669]=8.3742461843;digamma[8670]=8.3743615445;digamma[8671]=8.3744768914;digamma[8672]=8.3745922250;digamma[8673]=8.3747075453;digamma[8674]=8.3748228523;digamma[8675]=8.3749381461;digamma[8676]=8.3750534265;digamma[8677]=8.3751686936;digamma[8678]=8.3752839474;digamma[8679]=8.3753991880;digamma[8680]=8.3755144153;digamma[8681]=8.3756296293;digamma[8682]=8.3757448300;digamma[8683]=8.3758600175;digamma[8684]=8.3759751917;digamma[8685]=8.3760903526;digamma[8686]=8.3762055003;digamma[8687]=8.3763206347;digamma[8688]=8.3764357559;digamma[8689]=8.3765508638;digamma[8690]=8.3766659585;digamma[8691]=8.3767810399;digamma[8692]=8.3768961081;digamma[8693]=8.3770111630;digamma[8694]=8.3771262047;digamma[8695]=8.3772412332;digamma[8696]=8.3773562484;digamma[8697]=8.3774712504;digamma[8698]=8.3775862392;digamma[8699]=8.3777012148;digamma[8700]=8.3778161772;digamma[8701]=8.3779311263;digamma[8702]=8.3780460622;digamma[8703]=8.3781609849;digamma[8704]=8.3782758944;digamma[8705]=8.3783907907;digamma[8706]=8.3785056738;digamma[8707]=8.3786205438;digamma[8708]=8.3787354005;digamma[8709]=8.3788502440;digamma[8710]=8.3789650743;digamma[8711]=8.3790798915;digamma[8712]=8.3791946955;digamma[8713]=8.3793094862;digamma[8714]=8.3794242639;digamma[8715]=8.3795390283;digamma[8716]=8.3796537796;digamma[8717]=8.3797685177;digamma[8718]=8.3798832426;digamma[8719]=8.3799979544;digamma[8720]=8.3801126531;digamma[8721]=8.3802273385;digamma[8722]=8.3803420109;digamma[8723]=8.3804566700;digamma[8724]=8.3805713161;digamma[8725]=8.3806859490;digamma[8726]=8.3808005687;digamma[8727]=8.3809151753;digamma[8728]=8.3810297688;digamma[8729]=8.3811443491;digamma[8730]=8.3812589164;digamma[8731]=8.3813734705;digamma[8732]=8.3814880114;digamma[8733]=8.3816025393;digamma[8734]=8.3817170540;digamma[8735]=8.3818315557;digamma[8736]=8.3819460442;digamma[8737]=8.3820605196;digamma[8738]=8.3821749819;digamma[8739]=8.3822894311;digamma[8740]=8.3824038672;digamma[8741]=8.3825182903;digamma[8742]=8.3826327002;digamma[8743]=8.3827470970;digamma[8744]=8.3828614808;digamma[8745]=8.3829758515;digamma[8746]=8.3830902091;digamma[8747]=8.3832045536;digamma[8748]=8.3833188850;digamma[8749]=8.3834332034;digamma[8750]=8.3835475087;digamma[8751]=8.3836618010;digamma[8752]=8.3837760802;digamma[8753]=8.3838903463;digamma[8754]=8.3840045993;digamma[8755]=8.3841188394;digamma[8756]=8.3842330663;digamma[8757]=8.3843472803;digamma[8758]=8.3844614811;digamma[8759]=8.3845756690;digamma[8760]=8.3846898438;digamma[8761]=8.3848040055;digamma[8762]=8.3849181543;digamma[8763]=8.3850322900;digamma[8764]=8.3851464127;digamma[8765]=8.3852605223;digamma[8766]=8.3853746190;digamma[8767]=8.3854887026;digamma[8768]=8.3856027732;digamma[8769]=8.3857168308;digamma[8770]=8.3858308754;digamma[8771]=8.3859449070;digamma[8772]=8.3860589256;digamma[8773]=8.3861729311;digamma[8774]=8.3862869237;digamma[8775]=8.3864009033;digamma[8776]=8.3865148699;digamma[8777]=8.3866288236;digamma[8778]=8.3867427642;digamma[8779]=8.3868566919;digamma[8780]=8.3869706065;digamma[8781]=8.3870845082;digamma[8782]=8.3871983970;digamma[8783]=8.3873122727;digamma[8784]=8.3874261355;digamma[8785]=8.3875399853;digamma[8786]=8.3876538222;digamma[8787]=8.3877676461;digamma[8788]=8.3878814571;digamma[8789]=8.3879952551;digamma[8790]=8.3881090402;digamma[8791]=8.3882228123;digamma[8792]=8.3883365714;digamma[8793]=8.3884503177;digamma[8794]=8.3885640510;digamma[8795]=8.3886777713;digamma[8796]=8.3887914788;digamma[8797]=8.3889051733;digamma[8798]=8.3890188548;digamma[8799]=8.3891325235;digamma[8800]=8.3892461792;digamma[8801]=8.3893598221;digamma[8802]=8.3894734520;digamma[8803]=8.3895870690;digamma[8804]=8.3897006731;digamma[8805]=8.3898142642;digamma[8806]=8.3899278425;digamma[8807]=8.3900414079;digamma[8808]=8.3901549604;digamma[8809]=8.3902685000;digamma[8810]=8.3903820267;digamma[8811]=8.3904955405;digamma[8812]=8.3906090415;digamma[8813]=8.3907225295;digamma[8814]=8.3908360047;digamma[8815]=8.3909494670;digamma[8816]=8.3910629164;digamma[8817]=8.3911763530;digamma[8818]=8.3912897767;digamma[8819]=8.3914031875;digamma[8820]=8.3915165855;digamma[8821]=8.3916299706;digamma[8822]=8.3917433428;digamma[8823]=8.3918567022;digamma[8824]=8.3919700488;digamma[8825]=8.3920833825;digamma[8826]=8.3921967034;digamma[8827]=8.3923100114;digamma[8828]=8.3924233066;digamma[8829]=8.3925365890;digamma[8830]=8.3926498585;digamma[8831]=8.3927631152;digamma[8832]=8.3928763590;digamma[8833]=8.3929895901;digamma[8834]=8.3931028083;digamma[8835]=8.3932160137;digamma[8836]=8.3933292063;digamma[8837]=8.3934423861;digamma[8838]=8.3935555531;digamma[8839]=8.3936687073;digamma[8840]=8.3937818486;digamma[8841]=8.3938949772;digamma[8842]=8.3940080930;digamma[8843]=8.3941211960;digamma[8844]=8.3942342861;digamma[8845]=8.3943473635;digamma[8846]=8.3944604282;digamma[8847]=8.3945734800;digamma[8848]=8.3946865191;digamma[8849]=8.3947995453;digamma[8850]=8.3949125588;digamma[8851]=8.3950255596;digamma[8852]=8.3951385475;digamma[8853]=8.3952515227;digamma[8854]=8.3953644852;digamma[8855]=8.3954774349;digamma[8856]=8.3955903718;digamma[8857]=8.3957032960;digamma[8858]=8.3958162074;digamma[8859]=8.3959291060;digamma[8860]=8.3960419920;digamma[8861]=8.3961548652;digamma[8862]=8.3962677256;digamma[8863]=8.3963805733;digamma[8864]=8.3964934083;digamma[8865]=8.3966062305;digamma[8866]=8.3967190401;digamma[8867]=8.3968318369;digamma[8868]=8.3969446209;digamma[8869]=8.3970573923;digamma[8870]=8.3971701509;digamma[8871]=8.3972828969;digamma[8872]=8.3973956301;digamma[8873]=8.3975083506;digamma[8874]=8.3976210584;digamma[8875]=8.3977337535;digamma[8876]=8.3978464359;digamma[8877]=8.3979591056;digamma[8878]=8.3980717626;digamma[8879]=8.3981844069;digamma[8880]=8.3982970386;digamma[8881]=8.3984096575;digamma[8882]=8.3985222638;digamma[8883]=8.3986348574;digamma[8884]=8.3987474383;digamma[8885]=8.3988600066;digamma[8886]=8.3989725621;digamma[8887]=8.3990851050;digamma[8888]=8.3991976353;digamma[8889]=8.3993101529;digamma[8890]=8.3994226578;digamma[8891]=8.3995351501;digamma[8892]=8.3996476297;digamma[8893]=8.3997600966;digamma[8894]=8.3998725509;digamma[8895]=8.3999849926;digamma[8896]=8.4000974216;digamma[8897]=8.4002098380;digamma[8898]=8.4003222418;digamma[8899]=8.4004346329;digamma[8900]=8.4005470114;digamma[8901]=8.4006593773;digamma[8902]=8.4007717305;digamma[8903]=8.4008840711;digamma[8904]=8.4009963991;digamma[8905]=8.4011087145;digamma[8906]=8.4012210173;digamma[8907]=8.4013333074;digamma[8908]=8.4014455850;digamma[8909]=8.4015578499;digamma[8910]=8.4016701023;digamma[8911]=8.4017823420;digamma[8912]=8.4018945692;digamma[8913]=8.4020067837;digamma[8914]=8.4021189857;digamma[8915]=8.4022311750;digamma[8916]=8.4023433518;digamma[8917]=8.4024555160;digamma[8918]=8.4025676677;digamma[8919]=8.4026798067;digamma[8920]=8.4027919332;digamma[8921]=8.4029040471;digamma[8922]=8.4030161484;digamma[8923]=8.4031282372;digamma[8924]=8.4032403134;digamma[8925]=8.4033523771;digamma[8926]=8.4034644282;digamma[8927]=8.4035764667;digamma[8928]=8.4036884927;digamma[8929]=8.4038005062;digamma[8930]=8.4039125070;digamma[8931]=8.4040244954;digamma[8932]=8.4041364712;digamma[8933]=8.4042484345;digamma[8934]=8.4043603852;digamma[8935]=8.4044723234;digamma[8936]=8.4045842491;digamma[8937]=8.4046961623;digamma[8938]=8.4048080629;digamma[8939]=8.4049199510;digamma[8940]=8.4050318266;digamma[8941]=8.4051436897;digamma[8942]=8.4052555403;digamma[8943]=8.4053673783;digamma[8944]=8.4054792039;digamma[8945]=8.4055910169;digamma[8946]=8.4057028175;digamma[8947]=8.4058146055;digamma[8948]=8.4059263811;digamma[8949]=8.4060381441;digamma[8950]=8.4061498947;digamma[8951]=8.4062616328;digamma[8952]=8.4063733584;digamma[8953]=8.4064850715;digamma[8954]=8.4065967722;digamma[8955]=8.4067084603;digamma[8956]=8.4068201360;digamma[8957]=8.4069317992;digamma[8958]=8.4070434500;digamma[8959]=8.4071550883;digamma[8960]=8.4072667141;digamma[8961]=8.4073783275;digamma[8962]=8.4074899284;digamma[8963]=8.4076015169;digamma[8964]=8.4077130929;digamma[8965]=8.4078246564;digamma[8966]=8.4079362076;digamma[8967]=8.4080477462;digamma[8968]=8.4081592725;digamma[8969]=8.4082707863;digamma[8970]=8.4083822876;digamma[8971]=8.4084937766;digamma[8972]=8.4086052531;digamma[8973]=8.4087167172;digamma[8974]=8.4088281688;digamma[8975]=8.4089396080;digamma[8976]=8.4090510349;digamma[8977]=8.4091624493;digamma[8978]=8.4092738513;digamma[8979]=8.4093852408;digamma[8980]=8.4094966180;digamma[8981]=8.4096079828;digamma[8982]=8.4097193352;digamma[8983]=8.4098306752;digamma[8984]=8.4099420027;digamma[8985]=8.4100533179;digamma[8986]=8.4101646207;digamma[8987]=8.4102759111;digamma[8988]=8.4103871892;digamma[8989]=8.4104984548;digamma[8990]=8.4106097081;digamma[8991]=8.4107209490;digamma[8992]=8.4108321775;digamma[8993]=8.4109433936;digamma[8994]=8.4110545974;digamma[8995]=8.4111657888;digamma[8996]=8.4112769679;digamma[8997]=8.4113881346;digamma[8998]=8.4114992889;digamma[8999]=8.4116104309;digamma[9000]=8.4117215605;digamma[9001]=8.4118326778;digamma[9002]=8.4119437828;digamma[9003]=8.4120548753;digamma[9004]=8.4121659556;digamma[9005]=8.4122770235;digamma[9006]=8.4123880791;digamma[9007]=8.4124991224;digamma[9008]=8.4126101533;digamma[9009]=8.4127211719;digamma[9010]=8.4128321781;digamma[9011]=8.4129431721;digamma[9012]=8.4130541537;digamma[9013]=8.4131651230;digamma[9014]=8.4132760800;digamma[9015]=8.4133870247;digamma[9016]=8.4134979571;digamma[9017]=8.4136088772;digamma[9018]=8.4137197850;digamma[9019]=8.4138306805;digamma[9020]=8.4139415637;digamma[9021]=8.4140524345;digamma[9022]=8.4141632931;digamma[9023]=8.4142741395;digamma[9024]=8.4143849735;digamma[9025]=8.4144957952;digamma[9026]=8.4146066047;digamma[9027]=8.4147174019;digamma[9028]=8.4148281868;digamma[9029]=8.4149389594;digamma[9030]=8.4150497198;digamma[9031]=8.4151604679;digamma[9032]=8.4152712037;digamma[9033]=8.4153819273;digamma[9034]=8.4154926386;digamma[9035]=8.4156033377;digamma[9036]=8.4157140245;digamma[9037]=8.4158246991;digamma[9038]=8.4159353614;digamma[9039]=8.4160460115;digamma[9040]=8.4161566493;digamma[9041]=8.4162672749;digamma[9042]=8.4163778882;digamma[9043]=8.4164884893;digamma[9044]=8.4165990782;digamma[9045]=8.4167096549;digamma[9046]=8.4168202193;digamma[9047]=8.4169307715;digamma[9048]=8.4170413115;digamma[9049]=8.4171518393;digamma[9050]=8.4172623548;digamma[9051]=8.4173728582;digamma[9052]=8.4174833493;digamma[9053]=8.4175938282;digamma[9054]=8.4177042949;digamma[9055]=8.4178147495;digamma[9056]=8.4179251918;digamma[9057]=8.4180356219;digamma[9058]=8.4181460398;digamma[9059]=8.4182564456;digamma[9060]=8.4183668391;digamma[9061]=8.4184772205;digamma[9062]=8.4185875897;digamma[9063]=8.4186979467;digamma[9064]=8.4188082915;digamma[9065]=8.4189186242;digamma[9066]=8.4190289447;digamma[9067]=8.4191392530;digamma[9068]=8.4192495491;digamma[9069]=8.4193598331;digamma[9070]=8.4194701049;digamma[9071]=8.4195803646;digamma[9072]=8.4196906121;digamma[9073]=8.4198008474;digamma[9074]=8.4199110706;digamma[9075]=8.4200212817;digamma[9076]=8.4201314806;digamma[9077]=8.4202416674;digamma[9078]=8.4203518420;digamma[9079]=8.4204620045;digamma[9080]=8.4205721548;digamma[9081]=8.4206822931;digamma[9082]=8.4207924192;digamma[9083]=8.4209025331;digamma[9084]=8.4210126350;digamma[9085]=8.4211227247;digamma[9086]=8.4212328023;digamma[9087]=8.4213428678;digamma[9088]=8.4214529212;digamma[9089]=8.4215629624;digamma[9090]=8.4216729916;digamma[9091]=8.4217830086;digamma[9092]=8.4218930136;digamma[9093]=8.4220030064;digamma[9094]=8.4221129872;digamma[9095]=8.4222229558;digamma[9096]=8.4223329124;digamma[9097]=8.4224428569;digamma[9098]=8.4225527893;digamma[9099]=8.4226627096;digamma[9100]=8.4227726178;digamma[9101]=8.4228825140;digamma[9102]=8.4229923980;digamma[9103]=8.4231022700;digamma[9104]=8.4232121300;digamma[9105]=8.4233219778;digamma[9106]=8.4234318136;digamma[9107]=8.4235416373;digamma[9108]=8.4236514490;digamma[9109]=8.4237612486;digamma[9110]=8.4238710362;digamma[9111]=8.4239808117;digamma[9112]=8.4240905752;digamma[9113]=8.4242003266;digamma[9114]=8.4243100659;digamma[9115]=8.4244197933;digamma[9116]=8.4245295086;digamma[9117]=8.4246392118;digamma[9118]=8.4247489030;digamma[9119]=8.4248585822;digamma[9120]=8.4249682494;digamma[9121]=8.4250779045;digamma[9122]=8.4251875476;digamma[9123]=8.4252971787;digamma[9124]=8.4254067978;digamma[9125]=8.4255164048;digamma[9126]=8.4256259999;digamma[9127]=8.4257355829;digamma[9128]=8.4258451540;digamma[9129]=8.4259547130;digamma[9130]=8.4260642600;digamma[9131]=8.4261737950;digamma[9132]=8.4262833181;digamma[9133]=8.4263928291;digamma[9134]=8.4265023281;digamma[9135]=8.4266118152;digamma[9136]=8.4267212902;digamma[9137]=8.4268307533;digamma[9138]=8.4269402044;digamma[9139]=8.4270496436;digamma[9140]=8.4271590707;digamma[9141]=8.4272684859;digamma[9142]=8.4273778891;digamma[9143]=8.4274872803;digamma[9144]=8.4275966596;digamma[9145]=8.4277060269;digamma[9146]=8.4278153823;digamma[9147]=8.4279247257;digamma[9148]=8.4280340571;digamma[9149]=8.4281433766;digamma[9150]=8.4282526841;digamma[9151]=8.4283619797;digamma[9152]=8.4284712633;digamma[9153]=8.4285805350;digamma[9154]=8.4286897948;digamma[9155]=8.4287990426;digamma[9156]=8.4289082785;digamma[9157]=8.4290175025;digamma[9158]=8.4291267145;digamma[9159]=8.4292359146;digamma[9160]=8.4293451028;digamma[9161]=8.4294542791;digamma[9162]=8.4295634434;digamma[9163]=8.4296725959;digamma[9164]=8.4297817364;digamma[9165]=8.4298908650;digamma[9166]=8.4299999817;digamma[9167]=8.4301090865;digamma[9168]=8.4302181794;digamma[9169]=8.4303272604;digamma[9170]=8.4304363295;digamma[9171]=8.4305453867;digamma[9172]=8.4306544320;digamma[9173]=8.4307634654;digamma[9174]=8.4308724869;digamma[9175]=8.4309814966;digamma[9176]=8.4310904943;digamma[9177]=8.4311994802;digamma[9178]=8.4313084542;digamma[9179]=8.4314174164;digamma[9180]=8.4315263666;digamma[9181]=8.4316353050;digamma[9182]=8.4317442316;digamma[9183]=8.4318531462;digamma[9184]=8.4319620490;digamma[9185]=8.4320709400;digamma[9186]=8.4321798191;digamma[9187]=8.4322886863;digamma[9188]=8.4323975417;digamma[9189]=8.4325063852;digamma[9190]=8.4326152169;digamma[9191]=8.4327240368;digamma[9192]=8.4328328448;digamma[9193]=8.4329416409;digamma[9194]=8.4330504253;digamma[9195]=8.4331591978;digamma[9196]=8.4332679584;digamma[9197]=8.4333767073;digamma[9198]=8.4334854443;digamma[9199]=8.4335941695;digamma[9200]=8.4337028829;digamma[9201]=8.4338115844;digamma[9202]=8.4339202742;digamma[9203]=8.4340289521;digamma[9204]=8.4341376182;digamma[9205]=8.4342462726;digamma[9206]=8.4343549151;digamma[9207]=8.4344635458;digamma[9208]=8.4345721647;digamma[9209]=8.4346807718;digamma[9210]=8.4347893671;digamma[9211]=8.4348979507;digamma[9212]=8.4350065224;digamma[9213]=8.4351150823;digamma[9214]=8.4352236305;digamma[9215]=8.4353321669;digamma[9216]=8.4354406915;digamma[9217]=8.4355492043;digamma[9218]=8.4356577054;digamma[9219]=8.4357661947;digamma[9220]=8.4358746722;digamma[9221]=8.4359831380;digamma[9222]=8.4360915919;digamma[9223]=8.4362000342;digamma[9224]=8.4363084646;digamma[9225]=8.4364168833;digamma[9226]=8.4365252903;digamma[9227]=8.4366336855;digamma[9228]=8.4367420690;digamma[9229]=8.4368504407;digamma[9230]=8.4369588007;digamma[9231]=8.4370671489;digamma[9232]=8.4371754854;digamma[9233]=8.4372838101;digamma[9234]=8.4373921232;digamma[9235]=8.4375004245;digamma[9236]=8.4376087140;digamma[9237]=8.4377169919;digamma[9238]=8.4378252580;digamma[9239]=8.4379335124;digamma[9240]=8.4380417551;digamma[9241]=8.4381499860;digamma[9242]=8.4382582053;digamma[9243]=8.4383664128;digamma[9244]=8.4384746087;digamma[9245]=8.4385827928;digamma[9246]=8.4386909652;digamma[9247]=8.4387991259;digamma[9248]=8.4389072750;digamma[9249]=8.4390154123;digamma[9250]=8.4391235379;digamma[9251]=8.4392316519;digamma[9252]=8.4393397542;digamma[9253]=8.4394478447;digamma[9254]=8.4395559236;digamma[9255]=8.4396639909;digamma[9256]=8.4397720464;digamma[9257]=8.4398800903;digamma[9258]=8.4399881225;digamma[9259]=8.4400961430;digamma[9260]=8.4402041518;digamma[9261]=8.4403121490;digamma[9262]=8.4404201346;digamma[9263]=8.4405281084;digamma[9264]=8.4406360706;digamma[9265]=8.4407440212;digamma[9266]=8.4408519601;digamma[9267]=8.4409598874;digamma[9268]=8.4410678030;digamma[9269]=8.4411757069;digamma[9270]=8.4412835993;digamma[9271]=8.4413914799;digamma[9272]=8.4414993490;digamma[9273]=8.4416072064;digamma[9274]=8.4417150522;digamma[9275]=8.4418228863;digamma[9276]=8.4419307089;digamma[9277]=8.4420385198;digamma[9278]=8.4421463190;digamma[9279]=8.4422541067;digamma[9280]=8.4423618827;digamma[9281]=8.4424696472;digamma[9282]=8.4425774000;digamma[9283]=8.4426851412;digamma[9284]=8.4427928708;digamma[9285]=8.4429005888;digamma[9286]=8.4430082952;digamma[9287]=8.4431159900;digamma[9288]=8.4432236731;digamma[9289]=8.4433313447;digamma[9290]=8.4434390048;digamma[9291]=8.4435466532;digamma[9292]=8.4436542900;digamma[9293]=8.4437619153;digamma[9294]=8.4438695289;digamma[9295]=8.4439771310;digamma[9296]=8.4440847215;digamma[9297]=8.4441923005;digamma[9298]=8.4442998678;digamma[9299]=8.4444074236;digamma[9300]=8.4445149678;digamma[9301]=8.4446225005;digamma[9302]=8.4447300216;digamma[9303]=8.4448375312;digamma[9304]=8.4449450291;digamma[9305]=8.4450525156;digamma[9306]=8.4451599904;digamma[9307]=8.4452674538;digamma[9308]=8.4453749055;digamma[9309]=8.4454823458;digamma[9310]=8.4455897745;digamma[9311]=8.4456971916;digamma[9312]=8.4458045973;digamma[9313]=8.4459119913;digamma[9314]=8.4460193739;digamma[9315]=8.4461267449;digamma[9316]=8.4462341044;digamma[9317]=8.4463414524;digamma[9318]=8.4464487888;digamma[9319]=8.4465561137;digamma[9320]=8.4466634271;digamma[9321]=8.4467707290;digamma[9322]=8.4468780194;digamma[9323]=8.4469852983;digamma[9324]=8.4470925657;digamma[9325]=8.4471998215;digamma[9326]=8.4473070659;digamma[9327]=8.4474142987;digamma[9328]=8.4475215201;digamma[9329]=8.4476287299;digamma[9330]=8.4477359283;digamma[9331]=8.4478431152;digamma[9332]=8.4479502906;digamma[9333]=8.4480574545;digamma[9334]=8.4481646069;digamma[9335]=8.4482717479;digamma[9336]=8.4483788773;digamma[9337]=8.4484859953;digamma[9338]=8.4485931018;digamma[9339]=8.4487001969;digamma[9340]=8.4488072805;digamma[9341]=8.4489143526;digamma[9342]=8.4490214132;digamma[9343]=8.4491284624;digamma[9344]=8.4492355001;digamma[9345]=8.4493425264;digamma[9346]=8.4494495412;digamma[9347]=8.4495565446;digamma[9348]=8.4496635365;digamma[9349]=8.4497705170;digamma[9350]=8.4498774860;digamma[9351]=8.4499844436;digamma[9352]=8.4500913898;digamma[9353]=8.4501983245;digamma[9354]=8.4503052478;digamma[9355]=8.4504121596;digamma[9356]=8.4505190601;digamma[9357]=8.4506259490;digamma[9358]=8.4507328266;digamma[9359]=8.4508396928;digamma[9360]=8.4509465475;digamma[9361]=8.4510533908;digamma[9362]=8.4511602227;digamma[9363]=8.4512670432;digamma[9364]=8.4513738523;digamma[9365]=8.4514806500;digamma[9366]=8.4515874362;digamma[9367]=8.4516942111;digamma[9368]=8.4518009745;digamma[9369]=8.4519077266;digamma[9370]=8.4520144673;digamma[9371]=8.4521211966;digamma[9372]=8.4522279145;digamma[9373]=8.4523346210;digamma[9374]=8.4524413161;digamma[9375]=8.4525479998;digamma[9376]=8.4526546722;digamma[9377]=8.4527613332;digamma[9378]=8.4528679828;digamma[9379]=8.4529746210;digamma[9380]=8.4530812478;digamma[9381]=8.4531878633;digamma[9382]=8.4532944675;digamma[9383]=8.4534010602;digamma[9384]=8.4535076416;digamma[9385]=8.4536142117;digamma[9386]=8.4537207704;digamma[9387]=8.4538273177;digamma[9388]=8.4539338537;digamma[9389]=8.4540403783;digamma[9390]=8.4541468916;digamma[9391]=8.4542533935;digamma[9392]=8.4543598841;digamma[9393]=8.4544663634;digamma[9394]=8.4545728313;digamma[9395]=8.4546792879;digamma[9396]=8.4547857332;digamma[9397]=8.4548921671;digamma[9398]=8.4549985897;digamma[9399]=8.4551050010;digamma[9400]=8.4552114009;digamma[9401]=8.4553177896;digamma[9402]=8.4554241669;digamma[9403]=8.4555305329;digamma[9404]=8.4556368876;digamma[9405]=8.4557432310;digamma[9406]=8.4558495631;digamma[9407]=8.4559558838;digamma[9408]=8.4560621933;digamma[9409]=8.4561684915;digamma[9410]=8.4562747783;digamma[9411]=8.4563810539;digamma[9412]=8.4564873182;digamma[9413]=8.4565935712;digamma[9414]=8.4566998129;digamma[9415]=8.4568060433;digamma[9416]=8.4569122624;digamma[9417]=8.4570184703;digamma[9418]=8.4571246668;digamma[9419]=8.4572308521;digamma[9420]=8.4573370261;digamma[9421]=8.4574431889;digamma[9422]=8.4575493404;digamma[9423]=8.4576554806;digamma[9424]=8.4577616095;digamma[9425]=8.4578677272;digamma[9426]=8.4579738336;digamma[9427]=8.4580799288;digamma[9428]=8.4581860127;digamma[9429]=8.4582920854;digamma[9430]=8.4583981468;digamma[9431]=8.4585041969;digamma[9432]=8.4586102359;digamma[9433]=8.4587162635;digamma[9434]=8.4588222800;digamma[9435]=8.4589282852;digamma[9436]=8.4590342791;digamma[9437]=8.4591402618;digamma[9438]=8.4592462333;digamma[9439]=8.4593521936;digamma[9440]=8.4594581426;digamma[9441]=8.4595640804;digamma[9442]=8.4596700070;digamma[9443]=8.4597759224;digamma[9444]=8.4598818266;digamma[9445]=8.4599877195;digamma[9446]=8.4600936012;digamma[9447]=8.4601994718;digamma[9448]=8.4603053311;digamma[9449]=8.4604111792;digamma[9450]=8.4605170161;digamma[9451]=8.4606228418;digamma[9452]=8.4607286563;digamma[9453]=8.4608344596;digamma[9454]=8.4609402517;digamma[9455]=8.4610460327;digamma[9456]=8.4611518024;digamma[9457]=8.4612575609;digamma[9458]=8.4613633083;digamma[9459]=8.4614690445;digamma[9460]=8.4615747695;digamma[9461]=8.4616804833;digamma[9462]=8.4617861860;digamma[9463]=8.4618918775;digamma[9464]=8.4619975578;digamma[9465]=8.4621032270;digamma[9466]=8.4622088849;digamma[9467]=8.4623145318;digamma[9468]=8.4624201674;digamma[9469]=8.4625257919;digamma[9470]=8.4626314053;digamma[9471]=8.4627370075;digamma[9472]=8.4628425985;digamma[9473]=8.4629481784;digamma[9474]=8.4630537472;digamma[9475]=8.4631593048;digamma[9476]=8.4632648512;digamma[9477]=8.4633703866;digamma[9478]=8.4634759108;digamma[9479]=8.4635814238;digamma[9480]=8.4636869257;digamma[9481]=8.4637924165;digamma[9482]=8.4638978962;digamma[9483]=8.4640033648;digamma[9484]=8.4641088222;digamma[9485]=8.4642142685;digamma[9486]=8.4643197037;digamma[9487]=8.4644251277;digamma[9488]=8.4645305407;digamma[9489]=8.4646359425;digamma[9490]=8.4647413333;digamma[9491]=8.4648467129;digamma[9492]=8.4649520814;digamma[9493]=8.4650574388;digamma[9494]=8.4651627852;digamma[9495]=8.4652681204;digamma[9496]=8.4653734445;digamma[9497]=8.4654787576;digamma[9498]=8.4655840595;digamma[9499]=8.4656893504;digamma[9500]=8.4657946302;digamma[9501]=8.4658998989;digamma[9502]=8.4660051565;digamma[9503]=8.4661104030;digamma[9504]=8.4662156385;digamma[9505]=8.4663208629;digamma[9506]=8.4664260762;digamma[9507]=8.4665312785;digamma[9508]=8.4666364696;digamma[9509]=8.4667416498;digamma[9510]=8.4668468188;digamma[9511]=8.4669519768;digamma[9512]=8.4670571238;digamma[9513]=8.4671622597;digamma[9514]=8.4672673845;digamma[9515]=8.4673724983;digamma[9516]=8.4674776010;digamma[9517]=8.4675826927;digamma[9518]=8.4676877734;digamma[9519]=8.4677928430;digamma[9520]=8.4678979015;digamma[9521]=8.4680029491;digamma[9522]=8.4681079856;digamma[9523]=8.4682130110;digamma[9524]=8.4683180255;digamma[9525]=8.4684230289;digamma[9526]=8.4685280213;digamma[9527]=8.4686330026;digamma[9528]=8.4687379730;digamma[9529]=8.4688429323;digamma[9530]=8.4689478806;digamma[9531]=8.4690528179;digamma[9532]=8.4691577442;digamma[9533]=8.4692626595;digamma[9534]=8.4693675638;digamma[9535]=8.4694724570;digamma[9536]=8.4695773393;digamma[9537]=8.4696822106;digamma[9538]=8.4697870709;digamma[9539]=8.4698919201;digamma[9540]=8.4699967584;digamma[9541]=8.4701015857;digamma[9542]=8.4702064020;digamma[9543]=8.4703112073;digamma[9544]=8.4704160017;digamma[9545]=8.4705207850;digamma[9546]=8.4706255574;digamma[9547]=8.4707303188;digamma[9548]=8.4708350693;digamma[9549]=8.4709398087;digamma[9550]=8.4710445372;digamma[9551]=8.4711492547;digamma[9552]=8.4712539613;digamma[9553]=8.4713586569;digamma[9554]=8.4714633415;digamma[9555]=8.4715680152;digamma[9556]=8.4716726779;digamma[9557]=8.4717773297;digamma[9558]=8.4718819705;digamma[9559]=8.4719866004;digamma[9560]=8.4720912193;digamma[9561]=8.4721958273;digamma[9562]=8.4723004243;digamma[9563]=8.4724050104;digamma[9564]=8.4725095856;digamma[9565]=8.4726141498;digamma[9566]=8.4727187031;digamma[9567]=8.4728232455;digamma[9568]=8.4729277769;digamma[9569]=8.4730322975;digamma[9570]=8.4731368070;digamma[9571]=8.4732413057;digamma[9572]=8.4733457935;digamma[9573]=8.4734502703;digamma[9574]=8.4735547362;digamma[9575]=8.4736591912;digamma[9576]=8.4737636353;digamma[9577]=8.4738680685;digamma[9578]=8.4739724908;digamma[9579]=8.4740769022;digamma[9580]=8.4741813026;digamma[9581]=8.4742856922;digamma[9582]=8.4743900709;digamma[9583]=8.4744944387;digamma[9584]=8.4745987956;digamma[9585]=8.4747031416;digamma[9586]=8.4748074767;digamma[9587]=8.4749118010;digamma[9588]=8.4750161143;digamma[9589]=8.4751204168;digamma[9590]=8.4752247084;digamma[9591]=8.4753289891;digamma[9592]=8.4754332590;digamma[9593]=8.4755375180;digamma[9594]=8.4756417661;digamma[9595]=8.4757460033;digamma[9596]=8.4758502297;digamma[9597]=8.4759544452;digamma[9598]=8.4760586499;digamma[9599]=8.4761628437;digamma[9600]=8.4762670266;digamma[9601]=8.4763711987;digamma[9602]=8.4764753599;digamma[9603]=8.4765795103;digamma[9604]=8.4766836499;digamma[9605]=8.4767877786;digamma[9606]=8.4768918964;digamma[9607]=8.4769960035;digamma[9608]=8.4771000997;digamma[9609]=8.4772041850;digamma[9610]=8.4773082595;digamma[9611]=8.4774123232;digamma[9612]=8.4775163761;digamma[9613]=8.4776204181;digamma[9614]=8.4777244493;digamma[9615]=8.4778284697;digamma[9616]=8.4779324793;digamma[9617]=8.4780364780;digamma[9618]=8.4781404660;digamma[9619]=8.4782444431;digamma[9620]=8.4783484094;digamma[9621]=8.4784523649;digamma[9622]=8.4785563096;digamma[9623]=8.4786602435;digamma[9624]=8.4787641666;digamma[9625]=8.4788680789;digamma[9626]=8.4789719804;digamma[9627]=8.4790758711;digamma[9628]=8.4791797510;digamma[9629]=8.4792836201;digamma[9630]=8.4793874785;digamma[9631]=8.4794913260;digamma[9632]=8.4795951628;digamma[9633]=8.4796989888;digamma[9634]=8.4798028040;digamma[9635]=8.4799066084;digamma[9636]=8.4800104021;digamma[9637]=8.4801141850;digamma[9638]=8.4802179571;digamma[9639]=8.4803217184;digamma[9640]=8.4804254690;digamma[9641]=8.4805292088;digamma[9642]=8.4806329379;digamma[9643]=8.4807366562;digamma[9644]=8.4808403637;digamma[9645]=8.4809440605;digamma[9646]=8.4810477466;digamma[9647]=8.4811514219;digamma[9648]=8.4812550864;digamma[9649]=8.4813587402;digamma[9650]=8.4814623833;digamma[9651]=8.4815660156;digamma[9652]=8.4816696371;digamma[9653]=8.4817732480;digamma[9654]=8.4818768481;digamma[9655]=8.4819804374;digamma[9656]=8.4820840161;digamma[9657]=8.4821875840;digamma[9658]=8.4822911412;digamma[9659]=8.4823946877;digamma[9660]=8.4824982234;digamma[9661]=8.4826017484;digamma[9662]=8.4827052627;digamma[9663]=8.4828087663;digamma[9664]=8.4829122592;digamma[9665]=8.4830157414;digamma[9666]=8.4831192129;digamma[9667]=8.4832226736;digamma[9668]=8.4833261237;digamma[9669]=8.4834295630;digamma[9670]=8.4835329917;digamma[9671]=8.4836364097;digamma[9672]=8.4837398169;digamma[9673]=8.4838432135;digamma[9674]=8.4839465994;digamma[9675]=8.4840499746;digamma[9676]=8.4841533391;digamma[9677]=8.4842566930;digamma[9678]=8.4843600361;digamma[9679]=8.4844633686;digamma[9680]=8.4845666904;digamma[9681]=8.4846700015;digamma[9682]=8.4847733019;digamma[9683]=8.4848765917;digamma[9684]=8.4849798708;digamma[9685]=8.4850831393;digamma[9686]=8.4851863971;digamma[9687]=8.4852896442;digamma[9688]=8.4853928806;digamma[9689]=8.4854961064;digamma[9690]=8.4855993216;digamma[9691]=8.4857025261;digamma[9692]=8.4858057199;digamma[9693]=8.4859089032;digamma[9694]=8.4860120757;digamma[9695]=8.4861152376;digamma[9696]=8.4862183889;digamma[9697]=8.4863215295;digamma[9698]=8.4864246595;digamma[9699]=8.4865277789;digamma[9700]=8.4866308876;digamma[9701]=8.4867339857;digamma[9702]=8.4868370732;digamma[9703]=8.4869401500;digamma[9704]=8.4870432162;digamma[9705]=8.4871462718;digamma[9706]=8.4872493168;digamma[9707]=8.4873523512;digamma[9708]=8.4874553749;digamma[9709]=8.4875583881;digamma[9710]=8.4876613906;digamma[9711]=8.4877643825;digamma[9712]=8.4878673638;digamma[9713]=8.4879703345;digamma[9714]=8.4880732946;digamma[9715]=8.4881762441;digamma[9716]=8.4882791830;digamma[9717]=8.4883821113;digamma[9718]=8.4884850290;digamma[9719]=8.4885879362;digamma[9720]=8.4886908327;digamma[9721]=8.4887937187;digamma[9722]=8.4888965940;digamma[9723]=8.4889994588;digamma[9724]=8.4891023130;digamma[9725]=8.4892051566;digamma[9726]=8.4893079897;digamma[9727]=8.4894108122;digamma[9728]=8.4895136241;digamma[9729]=8.4896164254;digamma[9730]=8.4897192162;digamma[9731]=8.4898219964;digamma[9732]=8.4899247660;digamma[9733]=8.4900275251;digamma[9734]=8.4901302736;digamma[9735]=8.4902330116;digamma[9736]=8.4903357390;digamma[9737]=8.4904384559;digamma[9738]=8.4905411622;digamma[9739]=8.4906438579;digamma[9740]=8.4907465432;digamma[9741]=8.4908492178;digamma[9742]=8.4909518820;digamma[9743]=8.4910545356;digamma[9744]=8.4911571786;digamma[9745]=8.4912598111;digamma[9746]=8.4913624331;digamma[9747]=8.4914650446;digamma[9748]=8.4915676455;digamma[9749]=8.4916702359;digamma[9750]=8.4917728158;digamma[9751]=8.4918753852;digamma[9752]=8.4919779440;digamma[9753]=8.4920804924;digamma[9754]=8.4921830302;digamma[9755]=8.4922855575;digamma[9756]=8.4923880742;digamma[9757]=8.4924905805;digamma[9758]=8.4925930763;digamma[9759]=8.4926955616;digamma[9760]=8.4927980363;digamma[9761]=8.4929005006;digamma[9762]=8.4930029544;digamma[9763]=8.4931053976;digamma[9764]=8.4932078304;digamma[9765]=8.4933102527;digamma[9766]=8.4934126645;digamma[9767]=8.4935150658;digamma[9768]=8.4936174566;digamma[9769]=8.4937198370;digamma[9770]=8.4938222068;digamma[9771]=8.4939245662;digamma[9772]=8.4940269151;digamma[9773]=8.4941292536;digamma[9774]=8.4942315815;digamma[9775]=8.4943338990;digamma[9776]=8.4944362060;digamma[9777]=8.4945385026;digamma[9778]=8.4946407887;digamma[9779]=8.4947430643;digamma[9780]=8.4948453295;digamma[9781]=8.4949475842;digamma[9782]=8.4950498285;digamma[9783]=8.4951520623;digamma[9784]=8.4952542856;digamma[9785]=8.4953564985;digamma[9786]=8.4954587010;digamma[9787]=8.4955608930;digamma[9788]=8.4956630746;digamma[9789]=8.4957652457;digamma[9790]=8.4958674064;digamma[9791]=8.4959695567;digamma[9792]=8.4960716965;digamma[9793]=8.4961738259;digamma[9794]=8.4962759449;digamma[9795]=8.4963780534;digamma[9796]=8.4964801516;digamma[9797]=8.4965822392;digamma[9798]=8.4966843165;digamma[9799]=8.4967863834;digamma[9800]=8.4968884398;digamma[9801]=8.4969904858;digamma[9802]=8.4970925214;digamma[9803]=8.4971945466;digamma[9804]=8.4972965614;digamma[9805]=8.4973985658;digamma[9806]=8.4975005598;digamma[9807]=8.4976025434;digamma[9808]=8.4977045166;digamma[9809]=8.4978064793;digamma[9810]=8.4979084317;digamma[9811]=8.4980103737;digamma[9812]=8.4981123053;digamma[9813]=8.4982142265;digamma[9814]=8.4983161374;digamma[9815]=8.4984180378;digamma[9816]=8.4985199279;digamma[9817]=8.4986218076;digamma[9818]=8.4987236769;digamma[9819]=8.4988255358;digamma[9820]=8.4989273843;digamma[9821]=8.4990292225;digamma[9822]=8.4991310503;digamma[9823]=8.4992328678;digamma[9824]=8.4993346748;digamma[9825]=8.4994364716;digamma[9826]=8.4995382579;digamma[9827]=8.4996400339;digamma[9828]=8.4997417995;digamma[9829]=8.4998435548;digamma[9830]=8.4999452997;digamma[9831]=8.5000470343;digamma[9832]=8.5001487585;digamma[9833]=8.5002504724;digamma[9834]=8.5003521759;digamma[9835]=8.5004538691;digamma[9836]=8.5005555520;digamma[9837]=8.5006572245;digamma[9838]=8.5007588867;digamma[9839]=8.5008605385;digamma[9840]=8.5009621800;digamma[9841]=8.5010638112;digamma[9842]=8.5011654321;digamma[9843]=8.5012670426;digamma[9844]=8.5013686428;digamma[9845]=8.5014702327;digamma[9846]=8.5015718122;digamma[9847]=8.5016733815;digamma[9848]=8.5017749404;digamma[9849]=8.5018764890;digamma[9850]=8.5019780273;digamma[9851]=8.5020795553;digamma[9852]=8.5021810730;digamma[9853]=8.5022825804;digamma[9854]=8.5023840775;digamma[9855]=8.5024855643;digamma[9856]=8.5025870407;digamma[9857]=8.5026885069;digamma[9858]=8.5027899628;digamma[9859]=8.5028914084;digamma[9860]=8.5029928437;digamma[9861]=8.5030942688;digamma[9862]=8.5031956835;digamma[9863]=8.5032970879;digamma[9864]=8.5033984821;digamma[9865]=8.5034998660;digamma[9866]=8.5036012396;digamma[9867]=8.5037026029;digamma[9868]=8.5038039560;digamma[9869]=8.5039052988;digamma[9870]=8.5040066313;digamma[9871]=8.5041079536;digamma[9872]=8.5042092656;digamma[9873]=8.5043105673;digamma[9874]=8.5044118588;digamma[9875]=8.5045131400;digamma[9876]=8.5046144109;digamma[9877]=8.5047156716;digamma[9878]=8.5048169221;digamma[9879]=8.5049181622;digamma[9880]=8.5050193922;digamma[9881]=8.5051206119;digamma[9882]=8.5052218213;digamma[9883]=8.5053230206;digamma[9884]=8.5054242095;digamma[9885]=8.5055253883;digamma[9886]=8.5056265568;digamma[9887]=8.5057277150;digamma[9888]=8.5058288630;digamma[9889]=8.5059300008;digamma[9890]=8.5060311284;digamma[9891]=8.5061322458;digamma[9892]=8.5062333529;digamma[9893]=8.5063344498;digamma[9894]=8.5064355365;digamma[9895]=8.5065366129;digamma[9896]=8.5066376792;digamma[9897]=8.5067387352;digamma[9898]=8.5068397810;digamma[9899]=8.5069408167;digamma[9900]=8.5070418421;digamma[9901]=8.5071428573;digamma[9902]=8.5072438623;digamma[9903]=8.5073448571;digamma[9904]=8.5074458417;digamma[9905]=8.5075468161;digamma[9906]=8.5076477803;digamma[9907]=8.5077487343;digamma[9908]=8.5078496781;digamma[9909]=8.5079506117;digamma[9910]=8.5080515352;digamma[9911]=8.5081524485;digamma[9912]=8.5082533515;digamma[9913]=8.5083542444;digamma[9914]=8.5084551272;digamma[9915]=8.5085559997;digamma[9916]=8.5086568621;digamma[9917]=8.5087577143;digamma[9918]=8.5088585563;digamma[9919]=8.5089593882;digamma[9920]=8.5090602099;digamma[9921]=8.5091610214;digamma[9922]=8.5092618228;digamma[9923]=8.5093626140;digamma[9924]=8.5094633950;digamma[9925]=8.5095641659;digamma[9926]=8.5096649267;digamma[9927]=8.5097656773;digamma[9928]=8.5098664177;digamma[9929]=8.5099671480;digamma[9930]=8.5100678682;digamma[9931]=8.5101685782;digamma[9932]=8.5102692780;digamma[9933]=8.5103699678;digamma[9934]=8.5104706473;digamma[9935]=8.5105713168;digamma[9936]=8.5106719761;digamma[9937]=8.5107726253;digamma[9938]=8.5108732644;digamma[9939]=8.5109738933;digamma[9940]=8.5110745121;digamma[9941]=8.5111751208;digamma[9942]=8.5112757193;digamma[9943]=8.5113763078;digamma[9944]=8.5114768861;digamma[9945]=8.5115774543;digamma[9946]=8.5116780124;digamma[9947]=8.5117785604;digamma[9948]=8.5118790983;digamma[9949]=8.5119796260;digamma[9950]=8.5120801437;digamma[9951]=8.5121806513;digamma[9952]=8.5122811487;digamma[9953]=8.5123816361;digamma[9954]=8.5124821134;digamma[9955]=8.5125825805;digamma[9956]=8.5126830376;digamma[9957]=8.5127834846;digamma[9958]=8.5128839215;digamma[9959]=8.5129843483;digamma[9960]=8.5130847651;digamma[9961]=8.5131851717;digamma[9962]=8.5132855683;digamma[9963]=8.5133859548;digamma[9964]=8.5134863312;digamma[9965]=8.5135866975;digamma[9966]=8.5136870538;digamma[9967]=8.5137874000;digamma[9968]=8.5138877361;digamma[9969]=8.5139880621;digamma[9970]=8.5140883781;digamma[9971]=8.5141886841;digamma[9972]=8.5142889799;digamma[9973]=8.5143892658;digamma[9974]=8.5144895415;digamma[9975]=8.5145898072;digamma[9976]=8.5146900629;digamma[9977]=8.5147903085;digamma[9978]=8.5148905440;digamma[9979]=8.5149907695;digamma[9980]=8.5150909850;digamma[9981]=8.5151911904;digamma[9982]=8.5152913858;digamma[9983]=8.5153915711;digamma[9984]=8.5154917464;digamma[9985]=8.5155919117;digamma[9986]=8.5156920670;digamma[9987]=8.5157922122;digamma[9988]=8.5158923474;digamma[9989]=8.5159924725;digamma[9990]=8.5160925876;digamma[9991]=8.5161926928;digamma[9992]=8.5162927878;digamma[9993]=8.5163928729;digamma[9994]=8.5164929480;digamma[9995]=8.5165930130;digamma[9996]=8.5166930680;digamma[9997]=8.5167931131;digamma[9998]=8.5168931481;digamma[9999]=8.5169931731;digamma[10000]=8.5170931881;	
}
