% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shared-methods.R
\name{initialise_dataclass}
\alias{initialise_dataclass}
\title{Initialise a child class of DataClass if it exists}
\usage{
initialise_dataclass(
  class = character(),
  level = "1",
  totals = FALSE,
  localise = TRUE,
  regions,
  verbose = TRUE,
  steps = FALSE,
  get = FALSE,
  type = c("national", "regional"),
  ...
)
}
\arguments{
\item{class}{A character string specifying the \code{DataClass} to initialise.
Not case dependent and matching is based on either the class name or the its
country definition. For a list of options use \code{get_available_datasets()}.}

\item{level}{A character string indicating the target administrative level
of the data with the default being "1". Currently supported options are
level 1 ("1) and level 2 ("2"). Use \code{get_available_datasets()} for supported
options by dataset.}

\item{totals}{Logical, defaults to FALSE. If TRUE, returns totalled
data per region up to today's date. If FALSE, returns the full dataset
stratified by date and region.}

\item{localise}{Logical, defaults to TRUE. Should region names be localised.}

\item{regions}{A character vector of target regions to be assigned to the
\code{target_regions} field and used to filter the returned data.}

\item{verbose}{Logical, defaults to \code{TRUE}. Should verbose processing
messages and warnings be returned.}

\item{steps}{Logical, defaults to FALSE. Should all processing and cleaning
steps be kept and output in a list.}

\item{get}{Logical, defaults to FALSE. Should the class \code{get} method be
called (this will download, clean, and process data at initialisation).}

\item{type}{A character vector indicating the types of data to
return. Current options include "national" (which are datasets at the
national level which inherit from \code{CountryDataClass}) and
"regional" (which are datasets at the regional level which inherit
directly from \code{DataClass}).}

\item{...}{Additional arguments to pass to class specific functionality.}
}
\value{
An initialised version of the target class if available,
e.g. \code{Italy()}
}
\description{
Initialise a child class of DataClass if it exists.
}
\examples{
# Initialise Italian data
italy <- initialise_dataclass("Italy")

# Initialise UK data with a partial name match
uk <- initialise_dataclass("United Kingdom")

# Initialise ECDC data
ecdc <- initialise_dataclass("ecdc")
}
