% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{rename_region_code_column}
\alias{rename_region_code_column}
\title{Helper to rename the region code column in each dataset to the correct code type for each country (e.g. ISO-3166-2).}
\usage{
rename_region_code_column(data, country)
}
\arguments{
\item{data}{a data frame with a region_level_1_code column and optionally a region_level_2_code column}

\item{country}{a string with the country of interest}
}
\value{
a tibble with the column(s) renamed to a sensible name
}
\description{
The package relies on column name 'region_level_1_code' etc. during processing but this often isn't the most
sensible name for the column (e.g. iso-3166-2 makes more sense for US states). This simply renames the column as the final step in
processing before returning data to the user.
}
