% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/covidcast.R
\docType{package}
\name{covidcast-package}
\alias{covidcast}
\alias{covidcast-package}
\title{covidcast: Client for Delphi's COVIDcast API}
\description{
The covidcast package provides access to numerous COVID-19 data streams,
updated daily, covering the United States of America. These include publicly
reported cases and deaths data, along with data the Delphi research group
collects or obtains from partners.
}
\section{Finding data sources and documentation}{


The COVIDcast API includes:
\itemize{
\item publicly reported COVID case and death data
\item insurance claims data reporting on COVID-related doctor's visits and
hospitalizations, obtained from health partners
\item aggregate results from massive COVID symptom surveys conducted by Delphi
\item mobility data aggregated from SafeGraph
\item symptom search trends from Google
}

and numerous other important signals, most available daily at the county
level.

Each data stream is identified by its data source and signal names. These are
documented on the COVIDcast API website:
\url{https://cmu-delphi.github.io/delphi-epidata/api/covidcast_signals.html}

Each data stream has a page giving detailed technical documentation on how
the data is collected, how it is aggregated, and any limitations or known
problems with the data.
}

\section{Getting started}{


We recommend browsing the vignettes, which include numerous examples:
\code{browseVignettes(package = "covidcast")}.

See also \code{covidcast_signal()} for details on how to obtain COVIDcast data as
a data frame.
}

\references{
A. Reinhart et al., An open repository of real-time COVID-19
indicators. Proc. Natl. Acad. Sci. U.S.A. 118, e2111452118 (2021).
\doi{10.1073/pnas.2111452118}
}
\seealso{
Useful links:
\itemize{
  \item \url{https://cmu-delphi.github.io/covidcast/covidcastR/}
  \item \url{https://github.com/cmu-delphi/covidcast}
  \item Report bugs at \url{https://github.com/cmu-delphi/covidcast/issues}
}

}
\author{
\strong{Maintainer}: Alex Reinhart \email{areinhar@stat.cmu.edu} (\href{https://orcid.org/0000-0002-6658-514X}{ORCID})

Authors:
\itemize{
  \item Taylor Arnold
  \item Jacob Bien
  \item Logan Brooks
  \item Sarah Colquhoun
  \item David Farrow
  \item Kathryn Mazaitis
  \item Ryan Tibshirani
}

Other contributors:
\itemize{
  \item Jed Grabman [contributor]
  \item Pedrito Maynard-Zhang [contributor]
}

}
\keyword{internal}
