// This file is part of covafill, a C++ template library for
// local polynomial regression of covariates in state-space models
//
// Copyright (C), Christoffer Moesgaard Albertsen <cmoe@aqua.dtu.dk>
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are
// met:

//     Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.

//     Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in
//     the documentation and/or other materials provided with the
//     distribution.

// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
// "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
// LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
// A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
// HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
// LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

#ifndef _COVAFILL_JAGS_CLASS_
#define _COVAFILL_JAGS_CLASS_


namespace jags {
  namespace covafillJAGS {

    /*! \brief Class that defines the covafill function for local polynomial regression to be used in a JAGS model. 
     *  \ingroup jags
     */
    class covafillJAGS : public ArrayFunction
    {
    public:
      /** \brief Default constructor. */
      covafillJAGS();
      
      /** \brief Evaluates a covafill object. */
      void evaluate(double *value, std::vector<double const *> const &args,
		    std::vector<std::vector<unsigned int> > const &dims) 
	const;

      /** \brief Returns dimension of result. */
      std::vector<unsigned int> 
      dim(std::vector<std::vector<unsigned int> > const &dims,
	  std::vector<double const *> const &values) const;

      /** \brief Function to check parameter dimensions. Currently returns true for any input dimension. */
      bool checkParameterDim(std::vector <std::vector<unsigned int> > const &dims) const;

    };

  }}

#endif
