% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_data.R
\name{get_gages}
\alias{get_gages}
\title{Get all gage site numbers for a county}
\usage{
get_gages(county_cd, start_date, end_date)
}
\arguments{
\item{county_cd}{Character vector with the county FIPS code}

\item{start_date}{Character string with the starting date, using "YYYY-MM-DD"
notation.}

\item{end_date}{Character string with the end date, using "YYYY-MM-DD"
notation.}
}
\value{
A dataframe that gives the following variables for stream gages within
   the county and time range:

\tabular{lll}{
Name \tab Type \tab Description\cr
agency_cd \tab character \tab Agency running the gage (typically will be the USGS)\cr
site_no \tab character \tab USGS gage ID\cr
station_nm \tab character \tab Name of the gage site\cr
site_tp_cd \tab character \tab Type of gage (should always be "ST" for stream)\cr
dec_lat_va \tab numeric \tab Latitude of the gage site, in decimal degrees\cr
dec_long_va \tab numeric \tab Longitude of the gage site, in decimal degrees\cr
county_cd \tab character \tab Five-digit FIPS code of gage county location\cr
DA \tab numeric \tab Drainage area of the gage, in square miles\cr
}

 Note that the returned object is the same as that returned by the \code{whatNWISsites} funtion
 in the \code{dataRetrieval} package, but with county FIPS added for each gage.
}
\description{
Pulls gage numbers of all gages with discharge data within a county and
within the specified date range.
}
\examples{
\dontrun{
get_gages("12086", start_date = "1988-01-01", end_date = "2015-01-01")

va_counties <- get_county_cd("Virginia")
va_gages <- get_gages(va_counties, start_date = "2015-01-01",
                      end_date = "2015-12-31")
# Equivalent with piping
library(dplyr)
va_gages <- get_county_cd("Virginia") \%>\%
   get_gages(start_date = "2015-01-01", end_date = "2015-12-31")
}
}
