% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/corregp.r
\name{summary.corregp}
\alias{summary.corregp}
\title{Summarizing Correspondence Regression}
\usage{
\method{summary}{corregp}(object, parm = NULL, contrib = NULL, nf = NULL,
  add_ci = FALSE, cl = 0.95, nq = TRUE, ...)
}
\arguments{
\item{object}{The outout of a call to \code{\link{corregp}} (i.e. an object of class "corregp").}

\item{parm}{The parameter for which to compute the contributions \code{contrib}. Can be either \code{"y"} for the Y contributions, \code{"x"} for the X contributions, \code{"both"}
which can be abbreviated to \code{"b"}, or a vector of term names in X. Defaults to \code{"b"}.}

\item{contrib}{The type of contributions to be computed: either \emph{from points to axes} (absolute contributions) or \emph{from axes to points} (squared correlations).
The specification can be \code{"pnts_to_axes"} or \code{"axes_to_pnts"}, \code{"pts2axs"} or \code{"axs2pts"}, \code{"p_a"} or \code{"a_p"}, or any other reasonable abbreviation.}

\item{nf}{The number of dimensions to be retained in the reduced space. Defaults to all dimensions (no reduction).}

\item{add_ci}{Logical specifying whether to compute confidence intervals for the eigenvalues (and eigenvalues only). Defaults to \code{FALSE}.}

\item{cl}{The confidence level for the confidence intervals. Defaults to \code{0.95}.}

\item{nq}{Logical specifying whether to use a normal quantile (i.e. apply \code{\link[stats]{qnorm}}) in the computation of the confidence intervals.
Defaults to \code{TRUE}. If \code{FALSE}, then the confidence intervals are computed directly with the \code{\link[stats]{quantile}} function.}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
An object of class "summary.corregp", providing a summary of a correspondence regression, i.e. a list with components:
\item{\code{formula} }{The \code{\link[stats]{formula}} specified to the \code{formula} argument in the call to \code{corregp}.}
\item{\code{data} }{The name of the data frame specified to the \code{data} argument in the call to \code{corregp}.}
\item{\code{part} }{The name of the factor specified to the \code{part} argument in the call to \code{corregp}.}
\item{\code{chi_squared} }{The chi-squared value of the correspondence regression.}
\item{\code{phi_squared} }{The phi-squared value of the correspondence regression, i.e. the chi-squared value divided by \code{N}.}
\item{\code{N} }{The total number of observations.}
\item{\code{eigen} }{Depending on \code{add_ci}: if \code{FALSE}, a matrix of the actual eigenvalues, their percentages and cumulative percentages; if \code{TRUE}, a list of the actual eigenvalues, their percentages and cumulative percentages together with the lower and upper confidence limits for each.}
\item{\code{y} }{If \code{parm} is \code{"y"} or \code{"b"}. A list of components \code{p_a} for the absolute contributions and//or \code{a_p} for the squared correlations, depending on \code{contrib}.}
\item{\code{x} }{If \code{parm} is \code{"y"}, \code{"b"} or any of the term names in X. A list of components \code{p_a} for the absolute contributions and/or \code{a_p} for the squared correlations, depending in \code{contrib}.}
}
\description{
Method to produce a summary of a correspondence regression.
}
\examples{
\donttest{
data(HairEye)
haireye.crg <- corregp(Eye ~ Hair * Sex, data = HairEye, b = 3000)
summary(haireye.crg, add_ci = TRUE)
summary(haireye.crg, parm = "y", contrib = "pts_axs", nf = 2)
}
}
\seealso{
\code{\link{corregp}}, \code{\link{print.summary.corregp}}, \code{\link{anova.corregp}}.
}
