% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/documentation_methods.r
\name{tCorpus$set_levels}
\alias{tCorpus$set_levels}
\alias{tCorpus$set_meta_levels}
\alias{set_levels}
\alias{set_meta_levels}
\title{Change levels of factor columns}
\arguments{
\item{column}{the name of the column}

\item{levels}{The new levels}
}
\description{
For factor columns, the levels can be changed directly (and by reference). This is particularly usefull for fast preprocessing (e.g., making tokens lowercase, )
}
\details{
\strong{Usage:}

## R6 method for class tCorpus. Use as tc$method (where tc is a tCorpus object).

\preformatted{set_levels(column, levels)}
\preformatted{set_meta_levels(column, levels)}
}
\examples{
tc = create_tcorpus(c('Text one first sentence. Text one second sentence', 'Text two'))

## change factor levels of a column in the token data
unique_tokens <- tc$get_levels('token')
tc$set_levels('token', toupper(unique_tokens))
tc$get()
}
