/*
 * Decompiled with CFR 0.152.
 */
package uno.informatics.data.pojo;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import uno.informatics.data.Data;
import uno.informatics.data.Dataset;
import uno.informatics.data.SimpleEntity;
import uno.informatics.data.pojo.DatasetPojo;
import uno.informatics.data.pojo.SimpleEntityPojo;

public class DataPojo
extends SimpleEntityPojo
implements Data {
    public static final String DATASET_PROPERTY = Data.class.getName() + ".dataset";
    private static final String HEADER_ID = "entry%d";
    private static final String HEADER_NAME = "Entry %d";
    private DatasetPojo dataset;
    private SimpleEntity[] headers;
    private Map<String, Integer> id2index;
    private Set<Integer> indices;

    public DataPojo(String name, SimpleEntity[] headers) {
        super(name);
        this.setHeaders(headers);
    }

    public DataPojo(String uniqueIdentifier, String name, SimpleEntity[] headers) {
        super(uniqueIdentifier, name);
        this.setHeaders(headers);
    }

    public DataPojo(Data data) {
        super(data);
        if (data == null) {
            throw new IllegalArgumentException("Data is not optional!");
        }
        this.setDataset(data.getDataset());
        SimpleEntity[] dataHeaders = new SimpleEntity[data.getSize()];
        for (int i = 0; i < dataHeaders.length; ++i) {
            dataHeaders[i] = data.getHeader(i);
        }
        this.setHeaders(dataHeaders);
    }

    @Override
    public Dataset getDataset() {
        return this.dataset;
    }

    public final void setDataset(Dataset dataset) {
        DatasetPojo oldValue = this.dataset;
        this.dataset = null;
        if (dataset != null) {
            this.dataset = new DatasetPojo(dataset);
        }
        this.getPropertyChangeSupport().firePropertyChange(DATASET_PROPERTY, oldValue, this.dataset);
    }

    @Override
    public SimpleEntity getHeader(int id) {
        return this.headers == null ? null : this.headers[id];
    }

    public int indexOf(String uniqueIdentifier) {
        return this.id2index.getOrDefault(uniqueIdentifier, -1);
    }

    public int indexOf(SimpleEntity header) {
        return this.indexOf(header.getUniqueIdentifier());
    }

    @Override
    public int getSize() {
        return this.headers.length;
    }

    @Override
    public Set<Integer> getIDs() {
        return this.indices;
    }

    private void setHeaders(SimpleEntity[] headers) {
        if (headers == null) {
            throw new IllegalArgumentException("Headers not provided!");
        }
        DataPojo.checkHeaders(headers);
        this.headers = Arrays.copyOf(headers, headers.length);
        this.indices = new HashSet<Integer>();
        this.id2index = new HashMap<String, Integer>();
        for (int i = 0; i < headers.length; ++i) {
            this.indices.add(i);
            this.id2index.put(headers[i].getUniqueIdentifier(), i);
        }
        this.indices = Collections.unmodifiableSet(this.indices);
    }

    public static final void checkHeaders(SimpleEntity[] headers) {
        int n = headers.length;
        HashSet<String> identifiers = new HashSet<String>();
        for (int i = 0; i < n; ++i) {
            SimpleEntity header = headers[i];
            if (header == null || header.getUniqueIdentifier() == null) {
                throw new IllegalArgumentException(String.format("No identifier defined for item %d.", i));
            }
            if (identifiers.add(header.getUniqueIdentifier())) continue;
            throw new IllegalArgumentException(String.format("Identifiers are not unique. Duplicate identifier %s for item %d.", header.getUniqueIdentifier(), i));
        }
    }

    public static final SimpleEntity[] updateOrCreateHeaders(SimpleEntity[] headers, int length) {
        return DataPojo.updateOrCreateHeaders(headers, length, HEADER_ID, HEADER_NAME);
    }

    public static final SimpleEntity[] updateOrCreateHeaders(SimpleEntity[] headers, int length, String headerIdFormat, String headerNameFormat) {
        SimpleEntity[] newHeaders = new SimpleEntity[length];
        if (headers != null) {
            int minLength = length < headers.length ? length : headers.length;
            for (int i = 0; i < minLength; ++i) {
                newHeaders[i] = headers[i];
            }
        } else {
            for (int i = 0; i < length; ++i) {
                newHeaders[i] = new SimpleEntityPojo(String.format(headerIdFormat, i + 1), String.format(headerNameFormat, i + 1));
            }
        }
        return newHeaders;
    }
}

