% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wavelength2col.R
\name{wavelength2col}
\alias{wavelength2col}
\title{Convert wavelength to RGB}
\source{
Smoothed implementation of the original Fortran version by Dan Bruton (http://www.physics.sfasu.edu/astro/color/spectra.html) and the R-function by Michael Friendly (https://gist.github.com/friendly).
}
\usage{
wavelength2col(wavelength)
}
\arguments{
\item{wavelength}{wavelength value (or vector), in nanometers.}
}
\value{
Returns a color string or vector of color strings with the same number of elements as \code{wavelength}.
}
\description{
Converts a given wavelength of light to an approximate RGB color value, using black in the invisible range.
}
\examples{
lambda = seq(300,800)
col = matrix(wavelength2col(lambda),nrow=1)
plot(NA,xlim=range(lambda),ylim=c(0,1),xaxs='i',xlab='wavelength [nm]',yaxs='i',yaxt='n',ylab='')
rasterImage(col,min(lambda),0,max(lambda),1)

}
\author{
Danail Obreschkow
}
