% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcchanges.R
\name{calcchanges}
\alias{calcchanges}
\title{Calculates all phenotypic changes that occur on all branches of a phylogeny.}
\usage{
calcchanges(phyl, phendata)
}
\arguments{
\item{phyl}{The phylogeny of interest in phylo format}

\item{phendata}{A matrix of phenotypic data for all tips, with taxa in rows and characters in columns.}
}
\value{
A vector in which each element represents an edge of the phylogeny, and the values are the magnitudes of evolutionary change that occur along those edges.
}
\description{
Calculates the Euclidean distance between all ancestors and descendants on a phylogeny to reconstruct the phenotypic changes that occur along all edges of a phylogeny.
}
\details{
Calculates the Euclidean distance between all ancestors and descendants on a phylogeny to reconstruct the phenotypic changes that occur along all edges of a phylogeny.
}
\examples{

phyl<-rtree(10)
phendata<-fastBM(phyl,nsim=5)
changes<-calcchanges(phyl,phendata)
}
\references{
Paradis, E., J. Claude, and K. Strimmer (2004) APE: Analyses of phylogenetics
and evolution in R langauge. Bioinformatics, 20, 289-290.

Revell, L. J. (2012) phytools: An R package for phylogenetic comparative 
biology (and other things). Methods Ecol. Evol. 3 217-223.
}
