% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/contourLines.R
\name{getContourLines}
\alias{getContourLines}
\title{Get Contour Lines (data.frame)}
\usage{
getContourLines(x, y, z, nlevels = 10, binwidth, levels)
}
\arguments{
\item{x,y}{Numeric data for x and y coordinate, a single matrix or data-frame object can be provided for
\code{x}, which will be used in preference to the y and z arguments. These do \strong{NOT} need to be in any particular order
nor do they need to be regular.}

\item{z}{numeric Data for z coordinate (the coordinate to model)}

\item{nlevels}{An integer number of bins to split the data into \strong{iff} \code{levels} or \code{binwidth}
have not been specified.}

\item{binwidth}{The desired width of the bins, if specified, will override \code{nlevels}.}

\item{levels}{A numeric vector of the explicitly specified levels (z values) to contour, by specifying this argument,
it will override \code{nlevels} and/or \code{binwidth}. If this argument is provided, the stacking order of the
contours will be preserved in the order of first occurence within the supplied vector.}
}
\value{
For the function \code{getContourLines(...)}, the return object is a \code{data.frame} obect
representing the contours, assembled in such way to permit easy use within the \code{ggplot2} paradigm.
Such data frame contains seven (7) columns:
\item{\code{LID}}{A number representing the level}
\item{\code{GID}}{Within each level, a number representing the contour group}
\item{\code{PID}}{Within each group, a number representing the path/segment}
\item{\code{x}}{The x-coordinates of the contour}
\item{\code{y}}{The y-coordinates of the contour}
\item{\code{z}}{The z-coordinates of the contour (ie value of the level)}
\item{\code{Group}}{The unique identifyer for each independent contour path, calculated as being the
interaction between \code{LID} and \code{GID}}
}
\description{
The following routine produces contour lines for a set of non-regular \code{x,y} and \code{z} values.
via utilizing a Deleaunay Mesh strung between the supplied \code{x,y} coordinates in order to produce
iso-contour data representing the third variable, \code{z}. To this end, by using a Deleaunay mesh,
this routine does not require regular \code{x} and \code{y} data, although it can be expected to yield
'better' result, with regular / fine-grained data.
}
\examples{
# Contour Lines for Volcano Data
library(ggplot2)
data(volcano)
x = 1:nrow(volcano)
y = 1:ncol(volcano)
z = expand.grid(x=x,y=y); z$z = apply(z,1,function(xx){ volcano[ xx[1],xx[2] ]} )
df = getContourLines(z)
ggplot(df,aes(x,y,group=Group,colour=z)) + geom_path()

# Contour Lines for a Function
library(ggplot2)
a      = -2; b = 2; n = 75
x  = y = seq(a,b,by=diff(c(a,b))/(n+1))
df     = expand.grid(x=x,y=y)
df$z   = with(df,-x*y*exp(-x^2-y^2))
df.cnt = getContourLines(df)
ggplot(data=df.cnt,aes(x,y,group=Group,colour=z)) + geom_path()
}
\seealso{
\code{\link{contourLinesR}}, \code{\link{getDelaunayMesh}} and \code{\link{getConvexHull}}
This is a wrapper to the \code{C++} interface function, \code{\link{contourWalker}}.
}

