% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readability_indices.R
\name{count_syllables}
\alias{count_syllables}
\title{Count syllables in a word}
\usage{
count_syllables(word)
}
\arguments{
\item{word}{Character string containing a single word}
}
\value{
Integer number of syllables
}
\description{
Estimates the number of syllables in an English word using improved heuristic rules.
}
\details{
Uses a rule-based approach with multiple adjustments:
\itemize{
\item Counts vowel groups (consecutive vowels = 1 syllable)
\item Adjusts for silent 'e' at end of words
\item Handles common suffixes and prefixes
\item Special cases for diphthongs and common patterns
\item Ensures minimum of 1 syllable
}
}
\keyword{internal}
