% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/update.R
\name{update}
\alias{update}
\alias{ref_update}
\alias{update.Container}
\alias{ref_update.Container}
\alias{update.dict.table}
\alias{ref_update.dict.table}
\alias{update.list}
\title{Update Object with Elements from Another Object}
\usage{
ref_update(object, other, ...)

\method{update}{Container}(object, other, ...)

\method{ref_update}{Container}(object, other, ...)

\method{update}{dict.table}(object, other, ...)

\method{ref_update}{dict.table}(object, other, ...)

\method{update}{list}(object, other, ...)
}
\arguments{
\item{object}{any \code{R} object}

\item{other}{any object of the same type as \code{object}}

\item{...}{additional arguments to be passed to or from methods.}
}
\value{
For \code{Container}, an object of class \code{Container} (or one of the
respective derived classes).

For \code{dict.table} an object of class \code{dict.table}.

For \code{list}, an updated object of class \code{list}.
}
\description{
Takes an object and updates it with values from another object
by replacing the values at existing names and adding values at new names of
the other object. A common use case is to update parameter lists.
}
\details{
\code{update} uses copy semantics while \code{ref_update} works by reference,
that is, updates in place.
}
\examples{

d1 = dict(a = 1, b = 2)
d2 = dict(       b = 0, c = 3)
update(d1, d2)  # {a = 1, b = 0, c = 3}
update(d2, d1)  # {a = 1, b = 2, c = 3}

dit1 = dict.table(a = 1:2, b = 3:4)
dit2 = dict.table(         b = 5:6, c = 8:9)
update(d1, d2)
update(d2, d1)

l1 = list(1, b = 2)
l2 = list(   b = 0, c = 3)
update(l1, l2)
update(l2, l1)
}
