% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dict-S3.R
\name{dictS3}
\alias{dictS3}
\alias{dict}
\alias{as.dict}
\alias{is.dict}
\alias{getval}
\alias{keys}
\alias{popitem}
\alias{setval}
\alias{sortkey}
\title{Dict constructors}
\usage{
dict(x = list())

as.dict(x)

is.dict(x)

getval(x, ...)

keys(x)

popitem(x)

setval(x, ...)

sortkey(x, ...)
}
\arguments{
\item{x}{initial elements passed to constructor or object of class
\code{Dict} passed to member methods.}

\item{...}{further arguments}
}
\description{
The \code{dict} resembles Python's dict type, and is implemented
as a specialized associative (or mapping) \code{\link[container]{container}} thus
sharing all \code{\link[container]{container}} methods with some of them being
overriden to account for the associative key-value pair semantic.
}
\section{S3 methods for class \code{Dict}}{

\describe{
 \item{\code{add(dic, key, value)}}{If \code{key} not yet in \code{dic},
     insert \code{value} at \code{key}, otherwise signal an error.}
 \item{\code{discard(dic, key)}}{If \code{key} in \code{dic}, remove it.}
 \item{\code{has(dic, key)}}{TRUE if \code{key} in \code{dic} else FALSE.}
 \item{\code{remove(dic, key)}}{If \code{key} in \code{dic}, remove it,
     otherwise raise an error.}
 \item{\code{getval(dic)}}{If \code{key} in \code{dic}, return value, else
     throw key-error.}
 \item{\code{keys(dic)}}{Return a character vector of all keys.}
 \item{\code{peek(dic, key, default=NULL)}}{Return the value for \code{key} if
     \code{key} is in the \code{dic}, else \code{default}.}
 \item{\code{pop(dic, key)}}{If \code{key} in \code{dic}, return a copy of its
     value and discard it afterwards.}
 \item{\code{popitem(dic)}}{Remove and return an arbitrary (key, value) pair
 from the dictionary. \code{popitem()} is useful to destructively iterate
 over a \code{dic}, as often used in set algorithms.}
 \item{\code{setval(dic, key, value, add=FALSE)}}{Like \code{add} but overwrites
     value if \code{key} is already in the \code{dic}. If \code{key} not in
     \code{dic}, an error is thrown unless \code{add} was set to
     \code{TRUE}.}
 \item{\code{sortkey(dic, decr=FALSE)}}{Sort values in dictionary according to keys.}
 \item{\code{update(dic, other=dict())}}{Adds element(s) of other to the 
     dictionary if the key(s) are not in the dictionary and updates all keys with
     the new value(s) otherwise.}
}
}

\examples{
ages <- dict(c(Peter=24, Lisa=23, Bob=32))
has(ages, "Peter")   # TRUE
ages["Lisa"]         # 23
ages["Mike"]         # NULL
ages["Mike"] <- 18
ages["Mike"]         # 18
keys(ages)
print(ages)

\dontrun{
ages["Peter"] <- 24 + 1     # key 'Peter' already in Dict
dict(c(Peter=24, Peter=20)) # Error: duplicated keys
}
}
\seealso{
\code{\link[container]{container}}, \code{\link[container]{Dict}},
 \code{\link[container]{+.Dict}}, 
 \code{\link[container]{[<-.Dict}},
 \code{\link[container]{[[<-.Dict}},
 \code{\link[container]{[[.Dict}},
 \code{\link[container]{[.Dict}}
}
