% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotGeneral.R
\name{plotItemMap}
\alias{plotItemMap}
\title{plotItemMap}
\usage{
plotItemMap(mySys, myDims = "D1", ginLabs = "short", abilityType = "PV", ...)
}
\arguments{
\item{mySys}{An 'ACER ConQuest' system file object created using
the conquestr::ConQuestSys function.}

\item{myDims}{A string specifying which specific dimensions should be
included. The default is "D1", Specific dimensions are specified by
the label "D1" for dimensions 1 etc.}

\item{ginLabs}{A string specifying whether short or long gin labels should
be used. Default to "short".}

\item{abilityType}{What kind of person ability estimate should be used?
Defaults to plausible values. Alternatively WLE, MLE, EAP.}

\item{...}{Optional arguments, mostly for debugging, e.g., \code{setDebug = TRUE}
will print temporary data frames.}
}
\value{
A ggplot2 object.
}
\description{
Creates a plot (ggplot2 object) of item parameter
estimates and abilities on latent trait. Note this is not for
use with \code{rout} files. See the method method plotRout.itemMap
to the generic function \code{plotRout}
}
\examples{
mySys1 <- ConQuestSys()
myItemMap <- plotItemMap(mySys1)
\dontrun{
# if you run the above example you will have the plot in the object `myItemMap`.
plot(myItemMap)
}
}
