% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/connector.R
\name{Connector}
\alias{Connector}
\alias{connector}
\title{General connector object}
\description{
This R6 class is a general class for all connectors.
It is used to define the methods that all connectors should have.
New connectors should inherit from this class,
and the methods described below should be implemented.
}
\examples{
# Create connector
cnt <- Connector$new()

cnt

# Standard error message if no method is implemented
cnt |>
  read_cnt("fake_data") |>
  try()

# Connection with extra class
cnt_my_class <- Connector$new(extra_class = "my_class")

cnt_my_class

# Custom method for the extra class
read_cnt.my_class <- function(connector_object) "Hello!"
registerS3method("read_cnt", "my_class", "read_cnt.my_class")

cnt_my_class

read_cnt(cnt_my_class)
}
\seealso{
\code{vignette("customize")} on how to create custom connectors and methods,
and concrete examples in \link{ConnectorFS} and \link{ConnectorDBI}.
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Connector-new}{\code{Connector$new()}}
\item \href{#method-Connector-print}{\code{Connector$print()}}
\item \href{#method-Connector-list_content_cnt}{\code{Connector$list_content_cnt()}}
\item \href{#method-Connector-read_cnt}{\code{Connector$read_cnt()}}
\item \href{#method-Connector-write_cnt}{\code{Connector$write_cnt()}}
\item \href{#method-Connector-remove_cnt}{\code{Connector$remove_cnt()}}
\item \href{#method-Connector-clone}{\code{Connector$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Connector-new"></a>}}
\if{latex}{\out{\hypertarget{method-Connector-new}{}}}
\subsection{Method \code{new()}}{
Initialize the connector with the option of adding an extra class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Connector$new(extra_class = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{extra_class}}{\link{character} Extra class to assign to the new connector.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Connector-print"></a>}}
\if{latex}{\out{\hypertarget{method-Connector-print}{}}}
\subsection{Method \code{print()}}{
Print method for a connector showing the registered methods and
specifications from the active bindings.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Connector$print()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\link{invisible} self.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Connector-list_content_cnt"></a>}}
\if{latex}{\out{\hypertarget{method-Connector-list_content_cnt}{}}}
\subsection{Method \code{list_content_cnt()}}{
List available content from the connector. See also \link{list_content_cnt}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Connector$list_content_cnt(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Additional arguments passed to the method for the individual connector.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \link{character} vector of content names
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Connector-read_cnt"></a>}}
\if{latex}{\out{\hypertarget{method-Connector-read_cnt}{}}}
\subsection{Method \code{read_cnt()}}{
Read content from the connector. See also \link{read_cnt}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Connector$read_cnt(name, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{\link{character} Name of the content to read, write, or remove. Typically the table name.}

\item{\code{...}}{Additional arguments passed to the method for the individual connector.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
R object with the content. For rectangular data a \link{data.frame}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Connector-write_cnt"></a>}}
\if{latex}{\out{\hypertarget{method-Connector-write_cnt}{}}}
\subsection{Method \code{write_cnt()}}{
Write content to the connector.See also \link{write_cnt}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Connector$write_cnt(x, name, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{The object to write to the connection}

\item{\code{name}}{\link{character} Name of the content to read, write, or remove. Typically the table name.}

\item{\code{...}}{Additional arguments passed to the method for the individual connector.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\link{invisible} self.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Connector-remove_cnt"></a>}}
\if{latex}{\out{\hypertarget{method-Connector-remove_cnt}{}}}
\subsection{Method \code{remove_cnt()}}{
Remove or delete content from the connector. See also \link{remove_cnt}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Connector$remove_cnt(name, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{\link{character} Name of the content to read, write, or remove. Typically the table name.}

\item{\code{...}}{Additional arguments passed to the method for the individual connector.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\link{invisible} self.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Connector-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Connector-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Connector$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
