% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/content.R
\name{terminate_jobs}
\alias{terminate_jobs}
\title{Terminate Jobs}
\usage{
terminate_jobs(content, keys = NULL)
}
\arguments{
\item{content}{A Content object, as returned by \code{content_item()}}

\item{keys}{Optional. One or more job keys, which can be obtained using
\code{get_jobs(content)}. If no keys are provided, will terminate all active
jobs for the provided content item.}
}
\value{
A data frame with the status of each termination request.
\itemize{
\item \code{app_id}: The content item's identifier.
\item \code{app_guid}: The content item's GUID.
\item \code{job_key}: The job key.
\item \code{job_id}: The job's identifier.
\item \code{result}: The result string returned by Connect.
\item \code{code}: An error code, \code{NA} if the request was successful.
\item \code{error}: An error message, \code{NA} if the result was successful.
}

Note that \code{app_id}, \code{app_guid}, \code{job_id}, and \code{result} are \code{NA} if the
request returns an error.
}
\description{
Register a job kill order for one or more jobs associated with a content
item. Requires Connect 2022.10.0 or newer.
}
\seealso{
Other job functions: 
\code{\link{get_job}()},
\code{\link{get_jobs}()}

Other content functions: 
\code{\link{content_delete}()},
\code{\link{content_item}()},
\code{\link{content_title}()},
\code{\link{content_update}()},
\code{\link{create_random_name}()},
\code{\link{dashboard_url}()},
\code{\link{dashboard_url_chr}()},
\code{\link{delete_thumbnail}()},
\code{\link{delete_vanity_url}()},
\code{\link{deploy_repo}()},
\code{\link{get_bundles}()},
\code{\link{get_environment}()},
\code{\link{get_image}()},
\code{\link{get_job}()},
\code{\link{get_jobs}()},
\code{\link{get_thumbnail}()},
\code{\link{get_vanity_url}()},
\code{\link{git}},
\code{\link{has_thumbnail}()},
\code{\link{permissions}},
\code{\link{set_image_path}()},
\code{\link{set_run_as}()},
\code{\link{set_thumbnail}()},
\code{\link{set_vanity_url}()},
\code{\link{swap_vanity_url}()},
\code{\link{verify_content_name}()}
}
\concept{content functions}
\concept{job functions}
