% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sen_bills_various.R
\name{sen_bills_updates}
\alias{sen_bills_updates}
\title{Downloads and tidies information on bills that have been recently
 updated in the Federal Senate}
\usage{
sen_bills_updates(
  update = NULL,
  year = NULL,
  number = NULL,
  type = NULL,
  days = 5,
  ascii = TRUE
)
}
\arguments{
\item{update}{\code{character}. This is the type of update that can be applied
to a bill. For a dataframe of these, use the \code{sen_bills_update_types()}
 function, and the variable \code{update_name} that is returned.}

\item{year}{\code{character}. Year of the bill, if a specific bill is
requested. Format YYYY.}

\item{number}{bill number.}

\item{type}{type of legislation.}

\item{days}{\code{integer}. The number of days to consider when requesting
information on recent updates. The maximum is 30 and the default is 5.}

\item{ascii}{\code{logical}. If \code{TRUE}, strips Latin characters from
strings.}
}
\value{
A tibble, of classes \code{tbl_df}, \code{tbl} and \code{data.frame}.
}
\description{
Downloads and tidies information on bills that have been recently
 updated in the Federal Senate.
}
\examples{
# Bills from 2014 that have had a "despacho" update in the last 15 days, if
# they exist:
\donttest{
desp_2014 <- sen_bills_updates(update = "Despacho", year = 2014, days = 15)

# PLS bills that have been updated in the last 10 days, if they exist:
pls <- sen_bills_updates(type = "PLS", days = 10)
}
}
\author{
Robert Myles McDonnell, Guilherme Jardim Duarte & Danilo Freire.
}
