% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sen_agenda.R
\name{sen_agenda}
\alias{sen_agenda}
\title{Downloads and tidies data on the agenda in the Federal Senate}
\usage{
sen_agenda(initial_date = NULL, end_date = NULL, house = NULL,
  supervisory = NULL, legislator = NULL, details = FALSE, ascii = TRUE)
}
\arguments{
\item{initial_date}{(\code{character}) start date of the period requested.
This parameter must be in the format YYYYMMDD (Year-Month-Day). A value for
this parameter is necessary, all others are optional.}

\item{end_date}{(\code{character}) final date for period requested. Format
YYYYMMDD.}

\item{house}{(\code{character}). The acronym for the legislative house
for which results are requested. Options are SF (\emph{Senado Federal},
Federal Senate), CN (\emph{Congresso Nacional}, National Congress - joint
meeting of the Senate and Chamber), and CA \code{Camara dos Deputados},
Chamber of Deputies.}

\item{supervisory}{\code{character}. Name of the commission or supervisory body. A
data frame of these can be seen with \code{data("commissions")}.}

\item{legislator}{\code{integer}. The numeric code given to each senator.
A dataframe with these values is returned from the \code{sen_senator_list()}
function.}

\item{details}{(\code{logical}). If details is equal to TRUE, the data returned
is an expanded dataset with additional details. This is not recommended unless
necessary.}

\item{ascii}{\code{logical}. If TRUE, certain strings are converted to ascii
format.}
}
\value{
A tibble, of classes \code{tbl_df}, \code{tbl} and \code{data.frame}.
}
\description{
Downloads and tidies data on the agenda in the Federal Senate.
}
\note{
Requesting data from a long period of time with \code{details = TRUE} will
return a large object in terms of memory. It will also be rather unwieldy, with
many columns.
}
\examples{
\dontrun{
sen_agenda(initial_date = "20161105", end_date = "20161125")
sen_agenda(initial_date = "20161105", end_date = "20161125",
legislator = 4988)
}
}
\author{
Robert Myles McDonnell, Guilherme Jardim Duarte & Danilo Freire.
}
