% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.S2CFA.R
\name{plot.S2CFA}
\alias{plot.S2CFA}
\title{S3 plot for S2CFA}
\usage{
\method{plot}{S2CFA}(
  x,
  type = "ex.fisher.test",
  fill = c("red", "grey"),
  adjalpha = "bonferroni",
  ...
)
}
\arguments{
\item{x}{object of class\code{"S2CFA"}}

\item{type}{character with default \code{type="ex.fisher.test"}, to return wether the observed pattern are 'discriminating Types' or not significant at all based on the respective p-value. Another option for \code{type} is \code{type="pChi"}.}

\item{fill}{a vector of (two) colors defining the coloring of discriminating 'Types' (default "red"), or not discriminating cells (default "grey") in the plot.}

\item{adjalpha}{character with default \code{adjalpha = "bonferroni"}. Selector for the type of alpha adjustment for multiple testing. Possible options are: \code{adjalpha = "none"}, for no adjustment; \code{adjalpha = "bonferroni"}, for bonferroni adjustment (default); \code{adjalpha = "holm"}, for alpha adjustment according to Holm (1979); other options to come ... .}

\item{...}{other parameters passed trough.}
}
\value{
a plot visualizing the results.
}
\description{
S3 plot method for object of class\code{"S2CFA"}
}
\references{
Holm, S. (1979). A simple sequentially rejective multiple test procedure. \emph{Scandinavian Journal of Statistics, 6}(2), 65–70.

Bonferroni, C. E. (1935). Il calcolo delle assicurazioni su gruppi di teste. In S.O. Carboni (Ed.), \emph{Studi in Onore del Professore Salvatore Ortu Carboni} (S. 13–60). Roma, Tipografia del Senato: Bardi.
}
\keyword{methods}
