% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/condor_dir.R
\name{condor_dir}
\alias{condor_dir}
\title{Condor Directories}
\usage{
condor_dir(pattern = "*", top.dir = "condor", local.dir = NULL,
  report = TRUE, session = NULL, ...)
}
\arguments{
\item{pattern}{regular expression identifying which run directories to show.
The default is to show all directories inside \code{top.dir}.}

\item{top.dir}{top directory on submitter machine that contains Condor run
directories.}

\item{local.dir}{local directory to examine instead of \code{top.dir}.}

\item{report}{whether to return a detailed report of the run status in each
directory.}

\item{session}{optional object of class \code{ssh_connect}.}

\item{\dots}{passed to \code{\link{grep}}.}
}
\value{
A data frame containing details about each directory, or if
\code{report = FALSE} a \code{character} vector of directory names.
}
\description{
List Condor run directories, either on submitter machine or on a local drive.
}
\details{
The default value of \code{session = NULL} looks for a \code{session} object
in the user workspace. This allows the user to run Condor functions without
explicitly specifying the \code{session}.
}
\note{
If there are many Condor run directories, the report generation can take
substantial time (one SSH execution per run directory). To quickly return a
vector of directory names, pass \code{report = FALSE}.
}
\examples{
\dontrun{

# General workflow
session <- ssh_connect("servername")

condor_submit()
condor_q()
condor_dir()
condor_download()  # after job has finished

# Alternatively, examine runs on local drive
condor_dir(local.dir="c:/myruns")
}

}
\seealso{
\code{\link{condor_submit}}, \code{\link{condor_q}}, \code{condor_dir}, and
\code{\link{condor_download}} provide the main Condor interface.

\code{\link{condor_log}} and \code{\link{summary.condor_log}} are called to
produce the detailed report if \code{report = TRUE}.

\code{\link{condor-package}} gives an overview of the package.
}
