% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/show_columns.R
\name{show_columns}
\alias{show_columns}
\alias{show_columns_}
\title{Selects the variables to be printed}
\usage{
show_columns(..., col_names)

show_columns_(..., .dots, col_names)
}
\arguments{
\item{...}{Comma separated list of unquoted extensions.}

\item{col_names}{Character vector with the column names for the selected columns}

\item{.dots}{Use \code{select_()} to do standard evaluation. See
\code{vignette("nse")} for details}
}
\value{
A condformat_show_columns object, usually to be added to a condformat_tbl object
}
\description{
Keeps the variables you mention in the printed table.
Compared to \code{\link[dplyr]{select}}, show_columns does not remove the
columns from the data frame, so formatting rules can still depend
on them.
}
\examples{
data(iris)
x <- head(iris)
condformat(x) + show_columns(Sepal.Length, Sepal.Width, Species)
condformat(x) + show_columns(-Petal.Length, -Petal.Width)
condformat(x) + show_columns(starts_with("Petal"), Species)
data(iris)
x <- head(iris)
condformat(x) + show_columns_(.dots = c("Sepal.Length", "Species"))
condformat(x) + show_columns_(.dots = c("Sepal.Length", "Species"),
                              col_names = c("Sepal Length", "Species"))
}
\seealso{
\code{\link[dplyr]{select}}
}

