% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/item-summary.R
\docType{data}
\name{summary_funs}
\alias{summary_funs}
\title{Common item summary functions}
\format{
An object of class \code{list} of length 8.
}
\usage{
summary_funs
}
\description{
List of commonly used functions for summarising competition results.
}
\details{
\code{summary_funs} is a named list of \link[rlang:expr]{expressions}
representing commonly used expressions of summary functions for summarising
competition results with \code{\link[=summarise_item]{summarise_item()}}. Names of the elements will be
used as summary names. It is designed primarily to be used with \link[=longcr]{long format} of competition results. To use them inside \code{summarise_item()}
use \link[rlang:quasiquotation]{unquoting} mechanism from rlang package.

Currently present functions:
\itemize{
\item \strong{min_score} - \code{min(score)}.
\item \strong{max_score} - \code{max(score)}.
\item \strong{mean_score} - \code{mean(score)}.
\item \strong{median_score} - \code{median(score)}.
\item \strong{sd_score} - \code{sd(score)}.
\item \strong{sum_score} - \code{sum(score)}.
\item \strong{num_games} - \code{length(unique(game))}.
\item \strong{num_players} - \code{length(unique(player))}.
}

\strong{Note} that it is generally better to subset \code{summary_funs} using names
rather than indices because the order of elements might change in future
versions.
}
\examples{
ncaa2005 \%>\% summarise_game(!!!summary_funs, .prefix = "game_")

}
\seealso{
\link[=item-summary]{Compute item summary}, \link[=item-summary-join]{Join item summary}
}
\keyword{datasets}
