% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compareMCMCs.R
\name{compareMCMCs}
\alias{compareMCMCs}
\title{run a set of MCMCs for performance comparison}
\usage{
compareMCMCs(
  modelInfo = list(),
  MCMCcontrol = list(niter = 10000, thin = 1, burnin = 2000),
  MCMCs = "nimble",
  monitors = character(),
  nimbleMCMCdefs = list(),
  externalMCMCinfo = list(),
  metrics = c("mean", "median", "sd", "CI95_low", "CI95_upp", "efficiency_coda"),
  metricOptions = list(),
  conversions = list(),
  seed = NULL,
  needRmodel,
  verbose = TRUE,
  sessionInfo = TRUE
)
}
\arguments{
\item{modelInfo}{A list of nimble model-specification information
(which may be relevant for JAGS, WinBUGS and/or OpenBUGS as
well) and/or a nimble model itself. To provide information
for a different MCMC engine, see
argument \code{externalMCMCinfo}.  Named elements in
\code{modelInfo} can include \code{code} (model code as returned from
\code{nimbleCode}), \code{data} (a list with data), \code{constants} (a list
with data and/or constants), \code{inits} (a list of initial
values), and/or \code{model} (an object returned from \code{nimbleModel}).
If \code{model} is not provided, and if an R model will be needed, then
\code{nimbleModel} will be called to create one using \code{code}, \code{data}, and/or \code{inits}.
See \code{nimbleModel} in package nimble for for information
on these arguments.  For JAGS, WinBUGS and OpenBUGS, many models
can be run from the same specification since they use nearly the
same model language.  If \code{model} is provided, the other elements
will not be needed if only nimble MCMCs are used but will be needed if JAGS,
WinBUGS or OpenBUGS will be used..}

\item{MCMCcontrol}{A list with fields \code{niter} (number of
iterations), \code{thin} (thinning interval), and \code{burnin} (number
of iterations to discard from the beginning of the MCMC
sample).}

\item{MCMCs}{A character vector of MCMC cases to run.  This can
include "nimble" (default nimble samplers), "jags", "stan", one
of several nimble special cases (see details below), custom
nimble sampler configurations provided via argument
\code{nimbleMCMCdefs}, and external MCMC engines registered via
\code{\link{registerMCMCengine}}.  See \link{builtin_MCMCs} for
information on "jags" and "stan".  Support for OpenBUGS and
WinBUGS is pending.}

\item{monitors}{A character vector of variable names to monitor
(record in MCMC output).  If missing, this will be determined
from the nimble model as all top-level parameter names
(e.g. hyper-parameters).}

\item{nimbleMCMCdefs}{A list of information for custom sampler
configurations in nimble.  See package vignette for details.}

\item{externalMCMCinfo}{A list of arbitrary information for
external MCMC engines, named by engine names.  If there is an
external MCMC engine named "myMCMC", then a list element \code{myMCMC}
of \code{externalMCMCinfo} will be passed to the engine as its
\code{MCMCinfo} argument.}

\item{metrics}{Either a character vector of registered metric names
to apply to each sample, or a list of elements with either
metric names or metric functions to apply to each sample.  See
\code{\link{addMetrics}} for more information.  A useful set of
default metrics is provided.}

\item{metricOptions}{Optional named list of individual metric
options passed as the third argument ("\code{options}") of
\code{addMetrics} when MCMC metrics are calculated.}

\item{conversions}{List of parameter conversion (transformation)
specifications, useful when different MCMCs use different
parameterizations.}

\item{seed}{An (arbitrary) numeric value passed to \code{set.seed} to
set the random-number generator seed before calling each MCMC
engine.  If NULL, no seed is set.  To obtain identical results
from one call of \code{compareMCMCs} to the next, use identical \code{seed}
values.}

\item{needRmodel}{If \code{TRUE}, a \code{nimble} model object should definitely be created
(if necessary, or obtained from \code{modelInfo$model} if provided) and
used, for example to determine variable names.  If missing, \code{needRmodel}
will be set
\code{TRUE} if \code{MCMCs} includes "nimble", "jags", "openbugs", or
"winbugs".}

\item{verbose}{If \code{TRUE}, more verbose output may be generated.}

\item{sessionInfo}{If \code{TRUE}, record the results of
\code{sessionInfo()}, run before calling each MCMC, with each MCMC
result.}
}
\value{
A list of \code{MCMCresult} objects.
}
\description{
run one or more MCMC engines for one model specification, with
timing and performance metrics calculated.
}
\details{
The special cases provided for the \code{MCMCs} argument
include:
\itemize{
\item "nimble_noConj": use adaptive random-walk
Metropolis-Hastings (ARWMH) samplers in place of Gibbs
(conjugate) samplers.
\item "nimble_RW": use all adaptive random-walk Metropolis-Hastings samplers.
\item "nimble_slice": use all slice samplers.
}

See package vignette for more details and examples.
}
