context("ICD-9 codes for the Charlson score are properly identified")

test_that("Charlson, ami, 410", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "410"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$ami, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Charlson, ami, 412", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "412"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$ami, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})

test_that("Charlson, chf, 39891", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "39891"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$chf, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Charlson, chf, 39891", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "39891"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$chf, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Charlson, chf, 39891", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "39891"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$chf, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Charlson, chf, 40201", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "40201"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$chf, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Charlson, chf, 40211", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "40211"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$chf, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Charlson, chf, 40291", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "40291"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$chf, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Charlson, chf, 40401", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "40401"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$chf, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Charlson, chf, 40403", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "40403"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$chf, expected = 1)
  expect_equal(object = cs$score, expected = 2)
})
test_that("Charlson, chf, 40411", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "40411"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$chf, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Charlson, chf, 40413", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "40413"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$chf, expected = 1)
  expect_equal(object = cs$score, expected = 2)
})
test_that("Charlson, chf, 40491", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "40491"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$chf, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Charlson, chf, 40493", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "40493"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$chf, expected = 1)
  expect_equal(object = cs$score, expected = 2)
})
test_that("Charlson, chf, 4254-4259", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "4254"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$chf, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "4255"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$chf, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "4256"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$chf, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "4257"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$chf, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "4258"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$chf, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "4259"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$chf, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})

test_that("Charlson, pvd, 0930", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "0930"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$pvd, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Charlson, pvd, 0930", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "0930"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$pvd, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Charlson, pvd, 4373", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "4373"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$pvd, expected = 1)
  expect_equal(object = cs$score, expected = 2)
})
test_that("Charlson, pvd, 440", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "440"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$pvd, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Charlson, pvd, 441", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "441"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$pvd, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Charlson, pvd, 4431-4439", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "4431"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$pvd, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "4431"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$pvd, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "4433"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$pvd, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "4434"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$pvd, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "4435"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$pvd, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "4436"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$pvd, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "4437"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$pvd, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "4438"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$pvd, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "4439"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$pvd, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Charlson, pvd, 4471", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "4471"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$pvd, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Charlson, pvd, 5571", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "5571"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$pvd, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Charlson, pvd, 5579", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "5579"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$pvd, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Charlson, pvd, V434", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "V434"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$pvd, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})

test_that("Charlson, cevd, 36234", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "36234"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$cevd, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Charlson, cevd, 430-438", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "430"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$cevd, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "431"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$cevd, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "432"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$cevd, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "433"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$cevd, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "434"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$cevd, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "435"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$cevd, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "436"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$cevd, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "437"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$cevd, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "438"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$cevd, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})

test_that("Charlson, dementia, 290", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "290"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$dementia, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Charlson, dementia, 2941", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "2941"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$dementia, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Charlson, dementia, 3312", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "3312"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$dementia, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})

test_that("Charlson, copd, 4168", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "4168"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$copd, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Charlson, copd, 4169", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "4169"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$copd, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Charlson, copd, 490-505", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "490"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$copd, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "491"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$copd, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "492"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$copd, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "493"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$copd, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "494"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$copd, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "495"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$copd, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "496"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$copd, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "497"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$copd, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "498"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$copd, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "499"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$copd, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "500"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$copd, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "501"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$copd, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "502"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$copd, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "503"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$copd, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "504"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$copd, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "505"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$copd, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Charlson, copd, 5064", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "5064"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$copd, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Charlson, copd, 5081", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "5081"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$copd, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Charlson, copd, 5088", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "5088"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$copd, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})

test_that("Charlson, rheumd, 4465", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "4465"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$rheumd, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Charlson, rheumd, 7100-7104", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "7100"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$rheumd, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "7101"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$rheumd, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "7102"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$rheumd, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "7103"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$rheumd, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "7104"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$rheumd, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Charlson, rheumd, 7140-7142", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "7140"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$rheumd, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "7141"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$rheumd, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "7142"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$rheumd, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Charlson, rheumd, 7148", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "7148"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$rheumd, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Charlson, rheumd, 725", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "725"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$rheumd, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})

test_that("Charlson, pud, 531-534", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "531"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$pud, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "532"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$pud, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "533"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$pud, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "534"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$pud, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})

test_that("Charlson, mld, 07022", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "07022"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$mld, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Charlson, mld, 07023", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "07023"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$mld, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Charlson, mld, 07032", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "07032"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$mld, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Charlson, mld, 07033", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "07033"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$mld, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Charlson, mld, 07044", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "07044"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$mld, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Charlson, mld, 07054", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "07054"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$mld, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Charlson, mld, 0706", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "0706"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$mld, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Charlson, mld, 0709", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "0709"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$mld, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Charlson, mld, 570", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "570"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$mld, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Charlson, mld, 571", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "571"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$mld, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Charlson, mld, 5733", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "5733"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$mld, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Charlson, mld, 5734", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "5734"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$mld, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Charlson, mld, 5738", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "5738"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$mld, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Charlson, mld, 5739", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "5739"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$mld, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Charlson, mld, V427", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "V427"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$mld, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})

test_that("Charlson, diab, 2500-2503", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "2500"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$diab, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "2501"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$diab, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "2502"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$diab, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "2503"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$diab, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Charlson, diab, 2508", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "2508"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$diab, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Charlson, diab, 2509", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "2509"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$diab, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})

test_that("Charlson, diabwc, 2504-2507", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "2504"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$diabwc, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "2505"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$diabwc, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "2506"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$diabwc, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "2507"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$diabwc, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})

test_that("Charlson, hp, 3341", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "3341"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$hp, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Charlson, hp, 342", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "342"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$hp, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Charlson, hp, 343", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "343"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$hp, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Charlson, hp, 3440-3446", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "3440"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$hp, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "3441"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$hp, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "3442"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$hp, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "3443"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$hp, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "3444"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$hp, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "3445"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$hp, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "3446"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$hp, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Charlson, hp, 3449", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "3449"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$hp, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})

test_that("Charlson, rend, 40301", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "40301"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$rend, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Charlson, rend, 40311", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "40311"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$rend, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Charlson, rend, 40391", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "40391"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$rend, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Charlson, rend, 40402", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "40402"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$rend, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Charlson, rend, 40403", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "40403"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$rend, expected = 1)
  expect_equal(object = cs$score, expected = 2)
})
test_that("Charlson, rend, 40412", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "40412"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$rend, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Charlson, rend, 40413", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "40413"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$rend, expected = 1)
  expect_equal(object = cs$score, expected = 2)
})
test_that("Charlson, rend, 40492", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "40492"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$rend, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Charlson, rend, 40493", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "40493"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$rend, expected = 1)
  expect_equal(object = cs$score, expected = 2)
})
test_that("Charlson, rend, 582", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "582"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$rend, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Charlson, rend, 5830-5837", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "5830"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$rend, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "5831"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$rend, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "5832"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$rend, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "5833"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$rend, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "5834"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$rend, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "5835"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$rend, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "5836"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$rend, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "5837"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$rend, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Charlson, rend, 585", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "585"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$rend, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Charlson, rend, 586", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "586"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$rend, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Charlson, rend, 5880", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "5880"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$rend, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Charlson, rend, V420", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "V420"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$rend, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Charlson, rend, V451", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "V451"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$rend, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Charlson, rend, V56", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "V56"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$rend, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Charlson, rend, 40301", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "40301"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$rend, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})

test_that("Charlson, canc, 140-172", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "140"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$canc, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "141"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$canc, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "142"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$canc, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "143"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$canc, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "144"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$canc, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "145"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$canc, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "146"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$canc, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "147"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$canc, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "148"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$canc, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "149"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$canc, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "150"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$canc, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "151"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$canc, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "152"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$canc, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "153"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$canc, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "154"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$canc, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "155"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$canc, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "156"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$canc, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "157"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$canc, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "158"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$canc, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "159"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$canc, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "160"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$canc, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "161"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$canc, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "162"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$canc, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "163"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$canc, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "164"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$canc, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "165"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$canc, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "166"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$canc, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "167"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$canc, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "168"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$canc, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "169"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$canc, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "170"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$canc, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "171"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$canc, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "172"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$canc, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Charlson, canc, 174-195", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "174"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$canc, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "175"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$canc, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "176"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$canc, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "177"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$canc, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "178"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$canc, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "179"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$canc, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "180"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$canc, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "181"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$canc, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "182"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$canc, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "183"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$canc, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "184"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$canc, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "185"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$canc, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "186"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$canc, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "187"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$canc, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "188"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$canc, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "189"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$canc, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "190"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$canc, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "191"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$canc, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "192"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$canc, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "193"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$canc, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "194"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$canc, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "195"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$canc, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Charlson, canc, 200-208", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "200"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$canc, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "201"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$canc, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "202"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$canc, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "203"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$canc, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "204"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$canc, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "205"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$canc, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "206"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$canc, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "207"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$canc, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "208"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$canc, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Charlson, canc, 2386", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "2386"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$canc, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})

test_that("Charlson, msld, 4560-4562", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "4560"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$msld, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "4561"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$msld, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "4562"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$msld, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Charlson, msld, 5722-5728", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "5722"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$msld, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "5723"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$msld, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "5724"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$msld, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "5725"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$msld, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "5726"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$msld, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "5727"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$msld, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "5728"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$msld, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})

test_that("Charlson, metacanc, 196-199", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "196"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$metacanc, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "197"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$metacanc, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "198"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$metacanc, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "199"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$metacanc, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})

test_that("Charlson, aids, 042-044", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "042"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$aids, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "043"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$aids, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "044"), id = "id", code = "code", score = "charlson", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$aids, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
